' Program 25XXXX.INC
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Allow Reading and Writing of the 25XXX series of SPI serial eeproms

' To WRITE to the eeprom:-
' The 16-bit address is loaded into the variable "ADDR"
' The byte to write is loaded into the variable "E_BYTEOUT"
' And a call is made to the subroutine "EWRITE"

' To READ from the eeprom:-
' The 16-bit address is loaded into the variable "ADDR"
' And a call is made to the subroutine "EREAD"
' The byte at the specified address is returned in the variable "E_BYTEIN"

' NOTE: The main program must assign the Interface lines to the relevent PIC pins,
' Before the Include file is loaded. 
' i.e. 	
'	CS		Var	PortB.0		' Assign the CS line to PortB.0
'	SCK    		Var     PortB.1         ' Assign the SCK line to PortB.1
'	SI    		Var     PortB.2         ' Assign the SI line to PortB.2
'
'	Include "25XXXX.INC"

' The SO line is automatically assigned the same pin as the SI line.

' ** Declare the Variables **
	SO		Var	SI		' Assign to the same pin as SI
	Addr    	Var     Word	SYSTEM  ' Memory address within the eeprom (0-511)
	E_Byteout	Var	Byte	SYSTEM	' Byte to be placed into the eeprom
	E_Bytein	Var	Byte	SYSTEM	' Byte read from the eeprom

' ** Define the eeprom's op-codes **
	WRSR		Con	1		' Write to STATUS REGISTER op-code
	EWR		Con	2		' WRITE op-code 
	ERD		Con	3		' READ op-code 
	WRDI		Con	4		' DISABLE WRITES op-code
	RDSR		Con	5		' Read the STATUS REGISTER op-code
	EWEN		Con	6		' ENABLE WRITES op-code 

Goto Over_SPI_EEPROM				' Jump over the subroutines
' Read a single byte from the Eeprom
' The address is held in the variable "ADDR"
' The byte read is returned in the variable "E_BYTEIN"
Eread: 	Low CS                          	' Enable the eeprom
        Shiftout SI,SCK,MSBFIRST,[ERD,Addr.highbyte,Addr.lowbyte]' Send READ COMMAND and address
        Shiftin SO,SCK,MSBPRE,[E_Bytein]   	' Read data
        High CS                          	' Disable the eeprom
        Return

' Write a single byte to the Eeprom
' The address is held in the variable "ADDR"
' The byte to be written is held in the variable "E_BYTEOUT"
Ewrite: Low CS                         		' Enable the eeprom
        Shiftout SI,SCK,MSBFIRST,[EWEN]       	' Send WRITE ENABLE command
        High CS                          	' Disable the eeprom, to execute the command
        Low CS                          	' Re-enable the eeprom
        Shiftout SI,SCK,MSBFIRST,[EWR,Addr.highbyte,Addr.lowbyte,E_Byteout]' Send address and data
        High CS                          	' Disable the eeprom
	Pause 5                			' Allow the eeprom to allocate the byte
        Return

Over_SPI_EEPROM:

