' Program 25LC640.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Write to the first 11 locations of a MICROCHIP 25LC640 SPI serial eeprom
' Then Read the 11 locations back and display them on a serial LCD
' The configuration is 8192 words x 8-bits

' To WRITE to the eeprom:-
' The 16-bit address is loaded into the variable "ADDR"
' The byte to write is loaded into the variable "E_BYTEOUT"
' And a call is made to the subroutine "EWRITE"

' To READ from the eeprom:-
' The 16-bit address is loaded into the variable "ADDR"
' And a call is made to the subroutine "EREAD"
' The byte at the specified address is returned in the variable "E_BYTEIN"

	Include "Modedefs.Bas"

' ** Setup the Crystal Frequency, in Mhz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Set Debug Defines **

	Define	DEBUG_REG	PortA		' Debug PORT ?
	Define	DEBUG_BIT	0		' *** Debug pin Bit ? ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 1=Inverted
	Define	DEBUG_PACING	300		' Delay 'in uS' between characters sent

' ** Define LCD Constants **

	I		Con	254		' Control Byte
	Clr		Con	1		' Clear the display
	Line1		Con	128		' Point to beginning of line 1
	Line2		Con	192		' Point to beginning of line 2
	Line3		Con	148		' Point to beginning of line 3
	Line4		Con	212		' Point to beginning of line 4

' ** Define the Pin assignments **
	CS      	Var     PortB.0         ' Chip select pin
	SCK     	Var     PortB.1         ' Clock pin
	SI      	Var     PortB.2         ' Data in pin
	SO      	Var     PortB.2         ' Data out pin

' ** Declare the Variables **
	Addr    	var     Word            ' Memory address within the eeprom (0-511)
	E_Byteout	Var	Byte		' Byte to be placed into the eeprom
	E_Bytein	Var	Byte		' Byte read from the eeprom

' ** Define the eeprom's op-codes **
	WRSR		Con	1		' Write to STATUS REGISTER op-code
	EWR		Con	2		' WRITE op-code 
	ERD		Con	3		' READ op-code 
	WRDI		Con	4		' DISABLE WRITES op-code
	RDSR		Con	5		' Read the STATUS REGISTER op-code
	EWEN		Con	6		' ENABLE WRITES op-code 

' ** THE MAIN PROGRAM STARTS HERE **

' Write the string, "HELLO WORLD" into the first 11 address's of the Eeprom

        For Addr=0 To 10                	' Create a loop of 11
	Lookup Addr,["H","E","L","L","O"," ","W","O","R","L","D"],E_ByteOut' Build up the string
	Gosub EWrite				' Write the byte to the Eeprom
        Next					' Close the Loop

' Read the first 11 address's within the Eeprom and display them on the LCD

Again:  Debug I,Clr:Pause 30			' Clear the LCD
	Pause 500				' Pause for drama
	For Addr=0 To 10        		' Create a loop of 11
	Gosub ERead				' Read the byte from the Eeprom
        Debug E_ByteIn  			' Display the characters read in from the eeprom
	Pause 300				' Pause between characters being displayed
        Next					' Close the loop
        Goto Again				' Do it forever

' Read a single byte from the Eeprom
' The address is held in the variable "ADDR"
' The byte read is returned in the variable "E_BYTEIN"
Eread: 	Low CS                          	' Enable the eeprom
        Shiftout SI,SCK,MSBFIRST,[ERD,Addr.highbyte,Addr.lowbyte]' Send READ COMMAND and address
        Shiftin SO,SCK,MSBPRE,[E_Bytein]   	' Read data
        High CS                          	' Disable the eeprom
        Return

' Write a single byte to the Eeprom
' The address is held in the variable "ADDR"
' The byte to be written is held in the variable "E_BYTEOUT"
Ewrite: Low CS                         		' Enable the eeprom
        Shiftout SI,SCK,MSBFIRST,[EWEN]       	' Send WRITE ENABLE command
        High CS                          	' Disable the eeprom, to execute the command
        Low CS                          	' Re-enable the eeprom
        Shiftout SI,SCK,MSBFIRST,[EWR,Addr.highbyte,Addr.lowbyte,E_Byteout]' Send address and data
        High CS                          	' Disable the eeprom
	Pause 5                			' Allow the eeprom to allocate the byte
        Return

