' Program 93XXX.INC
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Allow Reading and Writing of the 93XXX series of microwire serial eeproms

' NOTE, the ORG pin of the eeprom (6), must be connected to ground,
' this configures it for 512 bytes x 8-bits

' To ENABLE the eeprom for writing,
' Make call to the subroutine EWRITE_EN

' To WRITE PROTECT the eeprom,
' Make a call to EWRITE_DS

' To WRITE to the eeprom:-
' The 16-bit address is loaded into the variable "ADDR"
' The byte to write is loaded into the variable "E_BYTEOUT"
' And a call is made to the subroutine "EWRITE"

' To READ from the eeprom:-
' The 16-bit address is loaded into the variable "ADDR"
' And a call is made to the subroutine "EREAD"
' The byte at the specified address is returned in the variable "E_BYTEIN"

' NOTE: The main program must assign the Interface lines to the relevent PIC pins,
' Before the Include file is loaded. 
' i.e. 	
'	CS		Var	PortB.0		' Assign the CS line to PortB.0
'	SK    		Var     PortB.1         ' Assign the SK line to PortB.1
'	DI    		Var     PortB.2         ' Assign the DI line to PortB.2
'
'	Include "93XXX.INC"

' ** The DO line is automatically assigned to the same pin as the DI line. **

' ** Declare the Variables **
	DO      	Var     DI         	' Assign to the same pin as DI
	Addr    	var     Word            ' Memory address within the eeprom (0-511)
	E_Byteout	Var	Byte		' Byte to be placed into the eeprom
	E_Bytein	Var	Byte		' Byte read from the eeprom

' ** Define the eeprom's op-codes **
	EWEN		Con	%10011		' ENABLE WRITES op-code (5-bits)
	EWDS		Con	%10000		' DISABLE WRITES op-code (5-bits)
	ERAL		Con	%10010		' ERASE ALL op-code (5-bits)
	WRAL		Con	%10001		' WRITE ALL op-code (5-bits)
	ERD		Con	%1100		' READ op-code (4-bits)
	EWR		Con	%1010		' WRITE op-code (4-bits)
	ERASE		Con	%1110		' ERASE op-code (4-bits)

	Goto Over_Microwire_Subs		' Jump over the subroutines
' Read a single byte from the Eeprom
' The address is held in the variable "ADDR"
' The byte read is returned in the variable "E_BYTEIN"
Eread: 	High CS                          	' Enable the eeprom
        Shiftout DI,SK,MSBFIRST,[ERD\4,Addr] ' Send READ command and ADDRESS
        Shiftin DO,SK,MSBPOST,[E_Bytein]  	' Read in the data to E_BYTEIN
        Low CS                          	' Disable the eeprom
        Return

' Write a single byte to the Eeprom
' The address is held in the variable "ADDR"
' The byte to be written is held in the variable "E_BYTEOUT"
Ewrite: High CS                         	' Enable the eeprom
        Shiftout DI,SK,MSBFIRST,[EWR\4,Addr,E_Byteout] ' Send WRITE command, ADDRESS and DATA
        Low CS                          	' Disable the eeprom
	Pause 10                		' Allow the eeprom to allocate the byte
        Return

' Enable writes to the eeprom
EWrite_EN: 
	High CS                       		' Enable the eeprom
        Shiftout DI,SK,MSBFIRST,[EWEN\5,0\7] 	' Send WRITE ENABLE command and dummy clocks
        Low CS                          	' Disable the eeprom
        Return

' Disable writes to the eeprom
EWrite_DS:
	High CS                       		' Enable the eeprom
        Shiftout DI,SK,MSBFIRST,[EWDS\5,0\7] 	' Send WRITE DISABLE command and dummy clocks
        Low CS                          	' Disable the eeprom
        Return

Over_Microwire_Subs:
