' Program 93C66.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Write to the first 11 locations of an ATMEL 93C66 Microwire serial eeprom
' Then Read the 11 locations back and display them on a serial LCD
' NOTE, the ORG pin of the eeprom (6), must be connected to ground,
' this configures it for 512 bytes x 8-bits

' To ENABLE the eeprom for writing,
' Make call to the subroutine EWRITE_EN

' To WRITE PROTECT the eeprom,
' Make a call to EWRITE_DS

' To WRITE to the eeprom:-
' The 16-bit address is loaded into the variable "ADDR"
' The byte to write is loaded into the variable "E_BYTEOUT"
' And a call is made to the subroutine "EWRITE"

' To READ from the eeprom:-
' The 16-bit address is loaded into the variable "ADDR"
' And a call is made to the subroutine "EREAD"
' The byte at the specified address is returned in the variable "E_BYTEIN"

	Include "Modedefs.Bas"

' ** Setup the Crystal Frequency, in Mhz **

	Define 	OSC		20		' Set Xtal Frequency

' ** Set Debug Defines **

	Define	DEBUG_REG	PortA		' Debug PORT ?
	Define	DEBUG_BIT	0		' *** Debug pin Bit ? ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 1=Inverted
	Define	DEBUG_PACING	300		' Delay 'in uS' between characters sent

' ** Define LCD Constants **

	I		Con	254		' Control Byte
	Clr		Con	1		' Clear the display
	Line1		Con	128		' Point to beginning of line 1
	Line2		Con	192		' Point to beginning of line 2
	Line3		Con	148		' Point to beginning of line 3
	Line4		Con	212		' Point to beginning of line 4

' ** Define the Pin assignments **
	CS      	Var     PortB.0         ' Chip select pin
	SK     		Var     PortB.1         ' Clock pin
	DI      	Var     PortB.2         ' Data in pin
	DO      	Var     PortB.2         ' Data out pin

' ** Declare the Variables **
	Addr    	var     Word            ' Memory address within the eeprom (0-511)
	E_Byteout	Var	Byte		' Byte to be placed into the eeprom
	E_Bytein	Var	Byte		' Byte read from the eeprom

' ** Define the eeprom's op-codes **
	EWEN		Con	%10011		' ENABLE WRITES op-code (5-bits)
	EWDS		Con	%10000		' DISABLE WRITES op-code (5-bits)
	ERAL		Con	%10010		' ERASE ALL op-code (5-bits)
	WRAL		Con	%10001		' WRITE ALL op-code (5-bits)
	ERD		Con	%1100		' READ op-code (4-bits)
	EWR		Con	%1010		' WRITE op-code (4-bits)
	ERASE		Con	%1110		' ERASE op-code (4-bits)

' ** THE MAIN PROGRAM STARTS HERE **

        Gosub EWrite_EN                 	' Enable the eeprom for writing

' Write the string, "HELLO WORLD" into the first 11 address's of the Eeprom

        For Addr=0 To 10                	' Create a loop of 11
	Lookup Addr,["H","E","L","L","O"," ","W","O","R","L","D"],E_ByteOut' Build up the string
	Gosub EWrite				' Write the byte to the Eeprom
        Next					' Close the Loop

' Read the first 11 address's within the Eeprom and display them on the LCD

Again:  Debug I,Clr:Pause 30			' Clear the LCD
	Pause 500				' Pause for drama
	For Addr=0 To 10        		' Create a loop of 11
	Gosub ERead				' Read the byte from the Eeprom
        Debug E_ByteIn  			' Display the characters read in from the eeprom
	Pause 300				' Pause inbetween characters being displayed
        Next					' Close the loop
        Goto Again				' Do it forever

' Read a single byte from the Eeprom
' The address is held in the variable "ADDR"
' The byte read is returned in the variable "E_BYTEIN"
Eread: 	High CS                          	' Enable the eeprom
        Shiftout DI,SK,MSBFIRST,[ERD\4,Addr] ' Send READ command and ADDRESS
        Shiftin DO,SK,MSBPOST,[E_Bytein]  	' Read in the data to E_BYTEIN
        Low CS                          	' Disable the eeprom
        Return

' Write a single byte to the Eeprom
' The address is held in the variable "ADDR"
' The byte to be written is held in the variable "E_BYTEOUT"
Ewrite: High CS                         	' Enable the eeprom
        Shiftout DI,SK,MSBFIRST,[EWR\4,Addr,E_Byteout] ' Send WRITE command, ADDRESS and DATA
        Low CS                          	' Disable the eeprom
	Pause 10                		' Allow the eeprom to allocate the byte
        Return

' Enable writes to the eeprom
EWrite_EN: 
	High CS                       		' Enable the eeprom
        Shiftout DI,SK,MSBFIRST,[EWEN\5,0\7] 	' Send WRITE ENABLE command and dummy clocks
        Low CS                          	' Disable the eeprom
        Return

' Disable writes to the eeprom
EWrite_DS:
	High CS                       		' Enable the eeprom
        Shiftout DI,SK,MSBFIRST,[EWDS\5,0\7] 	' Send WRITE DISABLE command and dummy clocks
        Low CS                          	' Disable the eeprom
        Return
