' Program HW_24C32.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Write to the first 11 address's of a 24C32 serial eeprom.
' Using the Master Synchronous Serial Port (MSSP).
' Configured as an I2C master.
' The Eread and Ewrite subroutines, as well as the individual I2C conditions,
' are written in assembler for more efficiency.

	Include "Modedefs.Bas"
	Include "SSP_24XX.INC"			' Load the SSP I2C subroutines

' ** Setup the Crystal Frequency, in Mhz **

	Define 	OSC		20		' Set Xtal Frequency

' ** Setup the Debug Defines **

	Define	DEBUG_REG	PortA		' Debug PortA
	Define	DEBUG_BIT	0		' *** Debug pin Bit-0 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 0=True, 1=Inverted
	Define	DEBUG_PACING	300		' Delay 'in Us' between characters sent

' ** Declare the variables **

	Byte_Sent	Var	Byte	SYSTEM
	Byte_Received	Var	Byte	SYSTEM
	Address		Var	Word	SYSTEM

' ** Define LCD Constants **

	I		Con	254		' Control Byte
	Clr		Con	1		' Clear the display
	Line1		Con	128		' Point to beginning of line 1
	Line2		Con	192		' Point to beginning of line 2
	Line3		Con	148		' Point to beginning of line 3
	Line4		Con	212		' Point to beginning of line 4

' ** THE MAIN PROGRAM STARTS HERE **

	Debug I,Clr:Pause 30			' Clear the LCD

' Write to the first 11 address's of the Eeprom, using the Gosub method
	Slave_Addr=0				' Point to the eeprom with address 000
        For Addr=0 To 10                	' Create a loop of 11
	E_Byteout=Addr				' Place the byte to be transmitted into E_Byteout
	Gosub EWrite				' Write the byte to the Eeprom
	Debug I,Line1,"Data Written ",#addr,"  "
	Pause 200
        Next					' Close the Loop

' Read the first 11 address's within the Eeprom, using the Gosub method	
' and display them on the LCD
Again:  Debug I,Clr:Pause 30			' Clear the LCD
	For Addr=0 To 10        		' Create a loop of 11
	Gosub Eread				' Receive the byte from the eeprom
	Debug I,Line1,"Address   ",#Addr,"   " 
        Debug I,Line2,"Data Read ",#E_ByteIn,"  "  ' Print the value read in from the eeprom
	Pause 400				' Pause between displays, for drama
        Next					' Close the loop
        Goto Again				' Do it forever

' Alternatively. Two new pseudo commands may be used.
' These are EREAD and EWRITE

' Write to the first 11 address's of the Eeprom using the pseudo command, EWRITE
'        For Address=0 To 10                	' Create a loop of 11
'	Byte_Sent=Address			' Place the byte to be transmitted into Byte_Sent
'@	Ewrite 0,Address,Byte_Sent		' Write the byte to the eeprom
'	Debug I,Line1,"Data Written ",#Byte_Sent,"  "
'	Pause 200
'        Next					' Close the Loop

' Read the first 11 address's within the Eeprom, using the pseudo command EREAD	
' and display them on the LCD
'Again:  Debug I,Clr:Pause 30			' Clear the LCD
'	For Address=0 To 10        		' Create a loop of 11
'@	Eread 0,Address,Byte_Received		' Receive the byte from the eeprom
'	Debug I,Line1,"Address   ",#Address,"   " 
'        Debug I,Line2,"Data Read ",#Byte_Received,"  "  ' Print the value read in from the eeprom
'	Pause 400				' Pause between displays, for drama
'        Next					' Close the loop
'        Goto Again				' Do it forever
