' Program HW_24C32.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Write to the first 11 addres's of a 24C32 serial eeprom.
' Using the Master Synchronous Serial Port (MSSP).
' Configured as an I2C master.

' ** Disable the watchdog timer **
@        device  wdt_off

	Include "Modedefs.Bas"

' ** Setup the Crystal Frequency, in Mhz **

	Define 	OSC		8		' Set Xtal Frequency

' ** Setup the Debug Defines **

	Define	DEBUG_REG	PortA		' Debug PortA
	Define	DEBUG_BIT	0		' *** Debug pin Bit-0 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 0=True, 1=Inverted
	Define	DEBUG_PACING	500		' Delay 'in Us' between characters sent

' ** Define LCD Control Constants **

	I		Con	254			' Control Byte
	Clr		Con	1			' Clear the display
	Line1		Con	128			' Point to beginning of line 1
	Line2		Con	192			' Point to beginning of line 2
	Line3		Con	148			' Point to beginning of line 3
	Line4		Con	212			' Point to beginning of line 4
	Cgram		Con	64			' Point to Cgram within LCD

' ** Declare the Variables **

	SSPM0		Var	SSPCON.0	' SSP mode bit-0
	SSPM1		Var	SSPCON.1	' SSP mode bit-1
	SSPM2		Var	SSPCON.2	' SSP mode bit-2
	SSPM3		Var	SSPCON.3	' SSP mode bit-3
	SSPEN		Var	SSPCON.5	' SSP enable bit

	SEN		Var	SSPCON2.0	' Start condition enable bit
	RSEN		Var	SSPCON2.1	' Repeate Start condition bit
	PEN		Var	SSPCON2.2	' Stop condition enable bit
	RCEN		Var	SSPCON2.3	' Receive enable bit
	ACKEN		Var	SSPCON2.4	' Acknowledge sequence enable bit
	ACKDT		Var	SSPCON2.5	' Acknowledge data dit
	ACKSTAT		Var	SSPCON2.6	' Acknowledge status bit

	BF		Var	SSPSTAT.0	' Buffer full status bit
	RW		Var	SSPSTAT.2	' Read/Write information bit
	S		Var	SSPSTAT.3	' Start bit status
	P		Var	SSPSTAT.4	' Stop bit status
	CKE		Var	SSPSTAT.6	' Input level select bit
	SMP		Var	SSPSTAT.7	' Slew rate control

	SSPIF		Var	PIR1.7		' SSP Interrupt flag

	Addr		Var	Word		' 16-bit address of eeprom
	E_Byteout	Var	Byte		' Byte to output to eeprom
	E_Bytein	Var	Byte		' Byte read from eeprom
	O_Byte		Var	Byte		' Byte outputted within the READ and WRITE subroutines



' ** MAIN PROGRAM STARTS HERE **

	Debug I,Clr:Pause 30			' Clear the LCD

' Configure the SSP for master I2C mode

	TrisC.3=1				' Make Portc.3 and input (SCL)
	TrisC.4=1				' Make Portc.4 and input (SDA)
	SMP=1					' Disable the slew rate for normal 100khz operation
	CKE=0					' Set the input levels to conform to I2C specs
' Set I2C bus Speed. The formula is:
' SSPADD value = (OSC /(BUS SPEED * 4)) -1
' Where OSC is in Mhz, and BUS SPEED is in Khz
Asm
BRG  Equ	((OSC*1000)/(100*4))-1		; Calculate the Baud rate value for SSPADD

	Bsf STATUS,5				; Point to register Page1
	Movlw BRG				; Get the value calculated from above
	Movwf SSPADD				; Place it in the SSPADD register
	Bcf STATUS,5				; Point back to register Page0
Endasm
	SSPM3=1					' I2C master mode selected
	SSPM2=0
	SSPM1=0
	SSPM0=0
	SSPEN=1					' Enable the SSP

' Write to the first 11 address's of the Eeprom

        For Addr=0 To 10                	' Create a loop of 11
	E_Byteout=Addr				' Place the byte to be transmitted into E_Byteout
	Gosub EWrite				' Write the byte to the Eeprom
	Debug I,Line1,"Data Written ",#E_Byteout,"  "
	Pause 200
        Next					' Close the Loop
	Pause 500

' Read the first 11 address's within the Eeprom,	
' and display them on the LCD
Again:  Debug I,Clr:Pause 30			' Clear the LCD
	For Addr=0 To 10        		' Create a loop of 11
	Gosub Eread				' Receive the byte from the eeprom
	Debug I,Line1,"Address   ",#Addr,"   " 
        Debug I,Line2,"Data Read ",#E_ByteIn,"  "  ' Print the value read in from the eeprom
	Pause 400				' Pause between displays, for drama
        Next					' Close the loop
        Goto Again				' Do it forever

' ** SUBROUTINES **

' Write a single byte to the Eeprom
' The address is held in the variable "ADDR"
' The byte to be written is held in the variable "E_BYTEOUT"
EWrite:
	Gosub I2C_START				' Send a start command
	O_Byte=%10100000
	Gosub Out_Byte				' Send the device slave address+ WRITE bit
	O_Byte=Addr.highbyte
	Gosub Out_Byte				' Send the highbyte of the 16-bit address
	O_Byte=Addr.lowbyte
	Gosub Out_byte 				' Send the lowbyte of the 16-bit address
	O_Byte=E_Byteout			
	Gosub Out_Byte				' Send the byte to be placed within the eeprom
	Gosub I2C_Stop				' Send a stop command
	Pause 10				' Wait for the byte to be placed into the eeprom
	Return

' Read a single byte from the Eeprom
' The address is held in the variable "ADDR"
' The byte read is returned in the variable "E_BYTEIN"
ERead:
	Gosub I2C_Start				' Send a start command
	O_Byte=%10100000
	Gosub Out_Byte				' Send the device slave address+ WRITE bit
	O_Byte=Addr.highbyte
	Gosub Out_Byte				' Send the highbyte of the 16-bit address
	O_Byte=Addr.lowbyte			
	Gosub Out_byte				' Send the lowbyte of the 16-bit address
	Gosub I2C_Repeat_Start			' Send a Restart command
	O_Byte=%10100001
	Gosub Out_Byte				' Send the device slave address+ READ bit
	Gosub In_Byte				' Read the byte from the eeprom (returned in E_BYTEIN)
	Gosub I2C_Stop				' Send a stop command
	Return
	
'************************** 
'* Generate an I2C START  * 
'************************** 
I2C_Start:
	SEN=1					' Send a Start condition
	While SEN=1:Wend			' Check if we are in idle mode
	Return
'*************************** 
'* Generate an I2C RESTART * 
'***************************
I2C_Repeat_Start:
	RSEN=1					' Sent a repeat start condition
	While RSEN=1:Wend			' Check if we are in idle mode
	Return
'************************** 
'* Generate an I2C STOP   * 
'**************************
I2C_Stop:
	PEN=1					' Send a stop condition
	While PEN=1:Wend			' Check if we are in idle mode
	Return
'*********************** 
'* Send a byte via I2C * 
'*********************** 
Out_Byte:	
	SSPBUF=O_Byte				' Place the byte to output into the buffer
	While BF=1:Wend				' Check if data transmit is complete
	While ACKSTAT=1:Wend			' Check if acknowledge received
	Return
'************************** 
'* Receive a byte via I2C * 
'**************************
In_Byte:
	RCEN=1					' Send Receive condition
	While BF=0:Wend				' Wait for buffer to fill up
	E_Bytein=SSPBUF				' Place the contents of the buffer into EBYTEIN
	Return
	
