' Program HW_24C32.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Write to the first 11 address's of a 24C32 serial eeprom.
' Using the Master Synchronous Serial Port (MSSP).
' Configured as an I2C master.
' The Eread and Ewrite subroutines, as well as the individual I2C conditions,
' are written in assembler for more efficiency.

@        device  wdt_off

	Include "Modedefs.Bas"

' ** Setup the Crystal Frequency, in Mhz **

	Define 	OSC		20		' Set Xtal Frequency

' ** Setup the Debug Defines **

	Define	DEBUG_REG	PortA		' Debug PortA
	Define	DEBUG_BIT	0		' *** Debug pin Bit-0 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 0=True, 1=Inverted
	Define	DEBUG_PACING	300		' Delay 'in Us' between characters sent

' ** Define LCD Control Constants **

	I		Con	254			' Control Byte
	Clr		Con	1			' Clear the display
	Line1		Con	128			' Point to beginning of line 1
	Line2		Con	192			' Point to beginning of line 2
	Line3		Con	148			' Point to beginning of line 3
	Line4		Con	212			' Point to beginning of line 4
	Cgram		Con	64			' Point to Cgram within LCD

' ** Declare the Variables **

	CKE		Var	SSPSTAT.6	' Input level select bit
	SMP		Var	SSPSTAT.7	' Slew rate control
	Addr		Var	Word	BANK0	SYSTEM	' 16-bit address of eeprom
	Slave_Addr	Var	Byte	BANK0	SYSTEM	' 8-bit Slave address
	E_Byteout	Var	Byte	BANK0	SYSTEM	' Byte to output to eeprom
	E_Bytein	Var	Byte	BANK0	SYSTEM	' Byte read from eeprom

' Configure the SSP for master I2C mode
Asm
#Define	Page1	Bsf STATUS,RP0			; Point to Page1
#Define Page0	Bcf STATUS,RP0			; Point to Page0

BRG  Equ	((OSC*1000)/(100*4))-1		; Calculate the Baud rate value for SSPADD

	Page1					; Point to register Page1
	Bsf PortC.3				; Make Portc.3 and input (SCL)
	Bsf PortC.4				; Make Portc.4 and input (SDA)
	Bsf SSPSTAT,SMP				; Disable the slew rate for normal 100khz operation
	Bcf SSPSTAT,CKE				; Set the input levels to conform to I2C specs
; Set I2C bus Speed. The formula is:
; SSPADD value = (OSC /(BUS SPEED * 4)) -1
; Where OSC is in Mhz, and BUS SPEED is in Khz
	Movlw BRG				; Get the value calculated from above
	Movwf SSPADD				; Place it in the SSPADD register
	Page0					; Point back to register Page0
	Movlw 00101000b
	Movwf SSPCON				; I2C master mode selected and Enable the SSP
Endasm

	Goto Over_SSP_Subs			' Jump over rhe subroutines

' ** ASSEMBLER SUBROUTINES **

Asm

;************************** 
;* Generate an I2C START  * 
;************************** 
Send_Start 
	Page1					; Point to register Page1
	Bsf SSPCON2,SEN				; Send a start condition
	Btfsc SSPCON2,SEN			; Wait for the Start condition to end
	Goto $-1
	Page0					; Point back to register Page0
	Return
;************************** 
;* Generate an I2C STOP   * 
;**************************
Send_Stop
	Page1					; Point to register Page1
	Bsf SSPCON2,PEN				; Send a start condition
	Btfsc SSPCON2,PEN			; Wait for the Stop condition to end
	Goto $-1
	Page0					; Point back to register Page0
	Return
;*************************** 
;* Generate an I2C RESTART * 
;***************************
Send_Restart
	Page1					; Point to register Page1
	Bsf SSPCON2,RSEN			; Send a repeat start condition
	Btfsc SSPCON2,RSEN			; Wait for the Resrart condition to end
	Goto $-1
	Page0					; Point back to register Page0
	Return
;*************************** 
;* Generate an I2C NACK    * 
;***************************
Send_NACK
	Page1					; Point to register Page1
	Bsf SSPCON2,ACKDT			; Sent the NACK condition
	Bsf SSPCON2,ACKEN
	Btfsc SSPCON2,ACKEN			; Check if we are in idle mode
	Goto $-1
	Page0					; Point back to register Page0
	Return
;*********************** 
;* Send a byte via I2C * 
;*  Send the contents  *
;*     of the W reg    *
;*********************** 
Out_Byte
	Movwf SSPBUF				; Place the byte to output into the buffer
	Page1					; Point to register Page1
	Btfsc SSPSTAT,R_W			; Check if data transmit is complete
	Goto $-1
	Btfsc SSPCON2,ACKSTAT			; Check if acknowledge was received
	Goto $-1
	Page0					; Point back to register Page0
	Return
;************************** 
;* Receive a byte via I2C * 
;*  The byte received is  *
;*   held in the W reg    *
;**************************
In_Byte
	Page1					; Point to register Page1
	Bsf SSPCON2,RCEN			; Send Receive condition
	Btfsc SSPCON2,RCEN
	Goto $-1
	Btfss SSPSTAT,BF			; Wait for buffer to fill up
	Goto $-1
	Page0					; Point back to register Page0
	Movf SSPBUF,w				; Place the buffer into W	
	Return
;*********************** 
;* Send the 16-bit     *
;* address via I2C     * 
;*********************** 	
Send_Address
	Call Send_Start				; Send a START condition
	Bcf Slave_Addr,0			; Set the R/W bit to WRITE
	Movf Slave_Addr,w			; Send the device+slave address+ WRITE bit
	Call Out_Byte
	Movf Addr+1,w				; Send the highbyte of the 16-bit address
	Call Out_Byte
	Movf Addr,w				; Send the lowbyte of the 16-bit address
	Call Out_Byte
	Return
Endasm	

' Write a single byte to the Eeprom
' The address is held in the variable "ADDR"
' The byte to be written is held in the variable "E_BYTEOUT"
EWrite:
Asm
	Call Send_Address			; Send the Start, slave address, and memory address
	Movf E_Byteout,w			; Send the byte to be placed within the eeprom
	Call Out_Byte
	Call Send_Stop				; Send a STOP condition
Endasm
	Pause 10				' Wait for the byte to be placed into the eeprom
	Return					' Basic RETURN command

' Read a single byte from the Eeprom
' The address is held in the variable "ADDR"
' The byte read is returned in the variable "E_BYTEIN"
ERead:
@	Call Send_Address			; Send the Start, slave address, and memory address
@	Call Send_Restart			; Send a Restart condition
@	Bsf Slave_addr,0			; Set the R/W bit to READ	
@	Movf Slave_Addr,w
@	Call Out_Byte				; Send the device+slave address+ READ bit
@	Call In_Byte				; Read the byte from the eeprom (returned in E_BYTEIN)
@	Movwf E_Bytein				; Place the buffer into E_Bytein
@	Call Send_NACK				; Send a NACK condition (to release the SDA line)
@	Call Send_Stop				; Send a STOP condition
	Return

Over_SSP_Subs:
' ** MAIN PROGRAM STARTS HERE **

	Debug I,Clr:Pause 30			' Clear the LCD



' Write to the first 11 address's of the Eeprom

	Slave_Addr=%10100000			' Device is an eeprom, with an address of 000
        For Addr=0 To 10                	' Create a loop of 11
	E_Byteout=Addr				' Place the byte to be transmitted into E_Byteout
	Gosub EWrite				' Write the byte to the Eeprom
	Debug I,Line1,"Data Written ",#E_Byteout,"  "
	Pause 200
        Next					' Close the Loop
	Pause 500

' Read the first 11 address's within the Eeprom,	
' and display them on the LCD
Again:  Debug I,Clr:Pause 30			' Clear the LCD
	For Addr=0 To 10        		' Create a loop of 11
	Gosub Eread				' Receive the byte from the eeprom
	Debug I,Line1,"Address   ",#Addr,"   " 
        Debug I,Line2,"Data Read ",#E_ByteIn,"  "  ' Print the value read in from the eeprom
	Pause 400				' Pause between displays, for drama
        Next					' Close the loop
        Goto Again				' Do it forever






		
