' Program SSP_24XX.INC
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' INCLUDE file for using the Master Synchronous Serial Port (MSSP).
' Configured as an I2C master.
' The Eread and Ewrite subroutines, as well as the individual I2C conditions,
' are written in assembler for more efficiency.

' To READ a single byte from the Eeprom
' The address is loaded into the variable "ADDR"
' The slave address is loaded into the variable "SLAVE_ADDR" (0-7)
' Then a call is made to EREAD
' The byte read is returned in the variable "E_BYTEIN"

' To WRITE a single byte to the Eeprom
' The address is loaded into the variable "ADDR"
' The slave address is loaded into the variable "SLAVE_ADDR" (0-7)
' The byte to be written is loded into the variable "E_BYTEOUT"
' Then a call is made to EWRITE

	Addr		Var	Word	BANK0	SYSTEM	' 16-bit address of eeprom
	Slave_Addr	Var	Byte	BANK0	SYSTEM	' 8-bit Slave address
	E_Byteout	Var	Byte	BANK0	SYSTEM	' Byte to output to eeprom
	E_Bytein	Var	Byte	BANK0	SYSTEM	' Byte read from eeprom

' Configure the SSP for master I2C mode,
' Before the MAIN program is started
Asm
#Define	Page1	Bsf STATUS,RP0			; Point to Page1
#Define Page0	Bcf STATUS,RP0			; Point to Page0

BRG  Equ	((OSC*1000)/(100*4))-1		; Calculate the Baud rate value for SSPADD

	Page1					; Point to register Page1
	Bsf PortC.3				; Make Portc.3 and input (SCL)
	Bsf PortC.4				; Make Portc.4 and input (SDA)
	Bsf SSPSTAT,SMP				; Disable the slew rate for normal 100khz operation
	Bcf SSPSTAT,CKE				; Set the input levels to conform to I2C specs
; Set I2C bus Speed. The formula is:
; SSPADD value = (OSC /(BUS SPEED * 4)) -1
; Where OSC is in Mhz, and BUS SPEED is in Khz
	Movlw BRG				; Get the value calculated from above
	Movwf SSPADD				; Place it in the SSPADD register
	Page0					; Point back to register Page0
	Movlw 00101000b
	Movwf SSPCON				; I2C master mode selected and Enable the SSP
Endasm
	Goto Over_SSP_Subs			' Jump over rhe subroutines

' ** ASSEMBLER SUBROUTINES **

Asm
;************************** 
;* Generate an I2C START  * 
;************************** 
Send_Start 
	Page1					; Point to register Page1
	Bsf SSPCON2,SEN				; Send a start condition
	Clrwdt					; Walk the dog
	Btfsc SSPCON2,SEN			; Wait for the Start condition to end
	Goto $-2
	Page0					; Point back to register Page0
	Return
;************************** 
;* Generate an I2C STOP   * 
;**************************
Send_Stop
	Page1					; Point to register Page1
	Bsf SSPCON2,PEN				; Send a start condition
	Clrwdt					; Walk the dog
	Btfsc SSPCON2,PEN			; Wait for the Stop condition to end
	Goto $-2
	Page0					; Point back to register Page0
	Return
;*************************** 
;* Generate an I2C RESTART * 
;***************************
Send_Restart
	Page1					; Point to register Page1
	Bsf SSPCON2,RSEN			; Send a repeat start condition
	Clrwdt					; Walk the dog
	Btfsc SSPCON2,RSEN			; Wait for the Resrart condition to end
	Goto $-2
	Page0					; Point back to register Page0
	Return
;*************************** 
;* Generate an I2C NACK    * 
;***************************
Send_NACK
	Page1					; Point to register Page1
	Bsf SSPCON2,ACKDT			; Sent the NACK condition
	Bsf SSPCON2,ACKEN
	Clrwdt					; Walk the dog
	Btfsc SSPCON2,ACKEN			; Check if we are in idle mode
	Goto $-2
	Page0					; Point back to register Page0
	Return
;*********************** 
;* Send a byte via I2C * 
;*  Send the contents  *
;*     of the W reg    *
;*********************** 
Out_Byte
	Movwf SSPBUF				; Place the byte to output into the buffer
	Page1					; Point to register Page1
	Clrwdt					; Walk the dog
	Btfsc SSPSTAT,R_W			; Check if data transmit is complete
	Goto $-2
	Clrwdt					; Walk the dog
	Btfsc SSPCON2,ACKSTAT			; Check if acknowledge was received
	Goto $-2
	Page0					; Point back to register Page0
	Return
;************************** 
;* Receive a byte via I2C * 
;*  The byte received is  *
;*   held in the W reg    *
;**************************
In_Byte
	Page1					; Point to register Page1
	Bsf SSPCON2,RCEN			; Send Receive condition
	Clrwdt					; Walk the dog
	Btfsc SSPCON2,RCEN			; Check if receive condition finished
	Goto $-2
	Clrwdt					; Walk the dog
	Btfss SSPSTAT,BF			; Wait for buffer to fill up
	Goto $-2
	Page0					; Point back to register Page0
	Movf SSPBUF,w				; Place the buffer into W	
	Return
;*********************** 
;* Send the 16-bit     *
;* address via I2C     * 
;*********************** 	
Send_Address
	Call Send_Start				; Send a START condition
	Clc					; Clear the carry flag, prior to the rotation
	Rlf Slave_Addr,f			; Move the slave address 1 bit left
	Movlw 10100000b				; Place device address and RW bit into W
	Iorwf Slave_Addr,w			; Superimpose the slave address into W
	Clc					; Clear the carry flag, prior to the rotation
	Rrf Slave_Addr,f			; Move the slave address back to its original state
	Call Out_Byte				; Send the device+slave address+ WRITE bit
	Movf Addr+1,w				; Send the highbyte of the 16-bit address
	Call Out_Byte
	Movf Addr,w				; Send the lowbyte of the 16-bit address
	Call Out_Byte
	Return
Endasm	
' Read a single byte from the Eeprom
' The address is held in the variable "ADDR"
' The slave address is held in the variable "SLAVE_ADDR"
' The byte read is returned in the variable "E_BYTEIN"
ERead:
Asm
	Call Send_Address			; Send the Start, slave address, and memory address
	Call Send_Restart			; Send a Restart condition
	Clc					; Clear the carry flag, prior to the rotation
	Rlf Slave_Addr,f			; Move the slave address 1 bit left
	Movlw 10100001b				; Place device address and RW bit into W
	Iorwf Slave_Addr,w			; Superimpose the slave address into W
	Clc					; Clear the carry flag, prior to the rotation
	Rrf Slave_Addr,f			; Move the slave address back to its original state
	Call Out_Byte				; Send the device+slave address+ READ bit
	Call In_Byte				; Read the byte from the eeprom (returned in E_BYTEIN)
	Movwf E_Bytein				; Place the buffer into E_Bytein
	Call Send_NACK				; Send a NACK condition (to release the SDA line)
	Call Send_Stop				; Send a STOP condition
Endasm
	Return					' Basic RETURN command
' Write a single byte to the Eeprom
' The address is held in the variable "ADDR"
' The slave address is held in he variable "SLAVE_ADDR"
' The byte to be written is held in the variable "E_BYTEOUT"
EWrite:
Asm
	Call Send_Address			; Send the Start, slave address, and memory address
	Movf E_Byteout,w			; Send the byte to be placed within the eeprom
	Call Out_Byte
	Call Send_Stop				; Send a STOP condition
Endasm
	Pause 10				' Wait for the byte to be placed into the eeprom
	Return					' Basic RETURN command

' Define the MACROS' for the EREAD and EWRITE pseudo commands
Asm
EREAD	Macro SL_ADDR , ADR , VAR

	Movlw SL_ADDR
	Movwf Slave_Addr
	Movf  Adr+1,w
	Movwf Addr+1
	Movf Adr,w
	Movwf Addr
Endasm
	Gosub EREAD
Asm
	Movf E_Bytein,w
	Movwf Var
	Endm
EWRITE	Macro SL_ADDR , ADR , VAR

	Movlw SL_ADDR
	Movwf Slave_Addr
	Movf  Adr+1,w
	Movwf Addr+1
	Movf Adr,w
	Movwf Addr
	Movf Var,w
	Movwf E_Byteout
Endasm
	Gosub EWRITE
Asm
	Endm

Endasm		
Over_SSP_Subs:
