' Program 24X_Tst.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Write to the first 11 locations of a 24C32 I2C serial EEPROM
' Then Read the 11 locations back and display them on a serial LCD
' Using the Include file 24XXX.INC

' To write to the eeprom:-
' The 16-bit address is loaded into the variable "ADDR"
' The data to write is loaded into the variable "E_BYTEOUT"
' And a call is made to the subroutine "EWRITE"

' To read from the eeprom:-
' The 16-bit address is loaded into the variable "ADDR"
' And a call is made to the subroutine "EREAD"
' The data at the specified address is returned in the variable "E_BYTEIN"



' NOTE: The main program must assign the SCL and SDA lines to the relevent PIC pins,
' Before the Include file is loaded. 
' ** Also the variables "E_BYTEIN" and E_BYTEOUT" must be declared **
' This allows an 8-or 16-bit write or read.
' If the variables are declared as WORD types, then 16-bits will be read or written
' If the variables are declared as BYTE types, then 8-bits will be read or written
' i.e. 	
'	E_Bytein	Var	BYTE or WORD	' Declare the data in variable
'	E_Byteout	Var	BYTE or WORD	' Declare the data out variable
'	SCL    		Var     PortB.0         ' Assign the SCL line to PortB.0
'	SDA    		Var     PortB.1         ' Assign the SDA line to PortB.0

'	Include "24XXXX.INC"


' A 10k pullup resistor must be placed on the SDA pin.
'*---------------------------------------------------------------------------------------------*
	Include "Modedefs.Bas"

' ** Setup the Crystal Frequency, in Mhz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Setup the Debug Defines **

	Define	DEBUG_REG	PortA		' Debug PortA
	Define	DEBUG_BIT	0		' *** Debug pin Bit-0 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 1=Inverted
	Define	DEBUG_PACING	300		' Delay 'in uS' between characters sent

' ** Define LCD Constants **

	I		Con	254		' Control Byte
	Clr		Con	1		' Clear the display
	Line1		Con	128		' Point to beginning of line 1
	Line2		Con	192		' Point to beginning of line 2
	Line3		Con	148		' Point to beginning of line 3
	Line4		Con	212		' Point to beginning of line 4

' ** Declare the Pin assignments for the I2C bus **

	SCL    		Var     PortB.0         ' Assign the I2C data (SCL) pin
	SDA    		Var     PortB.1         ' Assign the I2C clock (SDA) pin
	E_Bytein	Var	BYTE 		' Allow 8-bit reads (change to WORD if 16-bits)
	E_Byteout	Var	BYTE 		' Allow 8-bit writes (change to WORD if 16-bits)
	Include "24XXX.INC"			' Load the Eeprom subroutines


' ** The MAIN program starts here **

' Write the string, "HELLO WORLD" into the first 11 address's of the Eeprom

        For Addr=0 To 10                	' Create a loop of 11
	Lookup Addr,["H","E","L","L","O"," ","W","O","R","L","D"],E_ByteOut' Build up the string
	Gosub EWrite				' Write the byte to the Eeprom
        Next					' Close the Loop

' Read the first 11 address's within the Eeprom and display them on the LCD

Again:  Debug I,Clr:Pause 30			' Clear the LCD
	Pause 500				' Pause for drama
	For Addr=0 To 10        		' Create a loop of 11
	Gosub ERead				' Read the byte from the Eeprom
        Debug E_Bytein  			' Print the characters read in from the eeprom
	Pause 400				' Pause between displaying the characters
        Next					' Close the loop
        Goto Again				' Do it forever
