' Program 24XXX.INC
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Allow Reading and Writing of the 24XXXX series of serial eeproms

' To write to the eeprom:-
' The 16-bit address is loaded into the variable "ADDR"
' The 8 or 16-bit data to write is loaded into the variable "E_BYTEOUT"
' And a call is made to the subroutine "EWRITE"

' To read from the eeprom:-
' The 16-bit address is loaded into the variable "ADDR"
' And a call is made to the subroutine "EREAD" 
' The data at the specified address is returned in the variable "E_BYTEIN"


' NOTE: The main program must assign the SCL and SDA lines to the relevent PIC pins,
' Before the Include file is loaded. 
' ** Also the variables "E_BYTEIN" and E_BYTEOUT" must be declared **
' This allows an 8-or 16-bit write or read.
' If the variables are declared as WORD types, then 16-bits will be read or written
' If the variables are declared as BYTE types, then 8-bits will be read or written
' i.e. 	
'	E_Bytein	Var	BYTE or WORD	' Declare the data in variable
'	E_Byteout	Var	BYTE or WORD	' Declare the data out variable
'	SCL    		Var     PortB.0         ' Assign the SCL line to PortB.0
'	SDA    		Var     PortB.1         ' Assign the SDA line to PortB.0

'	Include "24XXXX.INC"


' A 10k pullup resistor must be placed on the SDA pin.
'*---------------------------------------------------------------------------------------------*

' ** Setup the I2C configuration **

	Define	I2C_SCLOUT	1		' No need for the pullup resistor on the SCL pin

' ** Declare the Variable used within the include file **
	Addr      	Var     Word		' 16-bit memory address within the Eeprom

Goto OVER_24XXX_Sub				' Jump over the subroutines and macro definitions

' Write 8 or 16-bits or data to the Eeprom, Depending on the declaration of "E_BYTEOUT"
' The address is held in the variable "ADDR"
' The data to be written is held in the variable "E_BYTEOUT"
EWrite:
        I2CWRITE SDA,SCL,%10100000,Addr,[E_Byteout]  	' Write the 8 or 16-bit data
	Pause 10				    	' Delay 10ms after each write
	Return

' Read the 8 or 16-bit data from the Eeprom, Depending on the declaration of "E_BYTEIN"
' The address is held in the variable "ADDR"
' The data read is returned in the variable "E_DATAIN"
ERead:
  	I2CREAD SDA,SCL,%10100000,Addr,[E_Bytein]   	' Read in the 8 or 16-bits from the eeprom
	Return
OVER_24XXX_Sub:
	