' Program 24C32.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Write to the first 11 locations of a 24C32 serial EEPROM
' Read the first 11 locations back and display them on a serial LCD

	Include "Modedefs.Bas"

' ** Setup the Crystal Frequency, in Mhz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Setup the I2C configuration **

	Define	I2C_SCLOUT	1		' No need for the pullup resistor on the SCL pin

' ** Setup the Debug Defines **

	Define	DEBUG_REG	PortA		' Debug PortA
	Define	DEBUG_BIT	0		' *** Debug pin Bit-0 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 1=Inverted
	Define	DEBUG_PACING	300		' Delay 'in uS' between characters sent

' ** Define LCD Constants **

	I		Con	254		' Control Byte
	Clr		Con	1		' Clear the display
	Line1		Con	128		' Point to beginning of line 1
	Line2		Con	192		' Point to beginning of line 2
	Line3		Con	148		' Point to beginning of line 3
	Line4		Con	212		' Point to beginning of line 4

' ** Declare the Variables **

	SCL    		Var     PortB.0         ' I2C data pin
	SDA    		Var     PortB.1         ' I2C clock pin
	Addr      	Var     Word		' 16-bit memory address within the Eeprom
	E_ByteOut      	Var     Byte		' Data byte to be written to the Eeprom
	E_ByteIn	Var	Byte		' Data byte read from the Eeprom

' ** The main program starts here **

' Write the string, "HELLO WORLD" into the first 11 address's of the Eeprom

        For Addr=0 To 10                	' Create a loop of 11
	Lookup Addr,["H","E","L","L","O"," ","W","O","R","L","D"],E_ByteOut' Build up the string
	Gosub EWrite				' Write the byte to the Eeprom
        Next					' Close the Loop

' Read the first 11 address's within the Eeprom,	
' and display them on the LCD

Again:  Debug I,Clr:Pause 30			' Clear the LCD
	Pause 500				' Pause for drama
	For Addr=0 To 10        		' Create a loop of 11
	Gosub ERead				' Read the byte from the Eeprom
        Debug E_ByteIn  			' Print the characters read in from the eeprom
	Pause 400				' Pause inbetween displays, for drama
        Next					' Close the loop
        Goto Again				' Do it forever

' ** SUBROUTINES **

' Write a single byte to the Eeprom
' The address is held in the variable "ADDR"
' The byte to be written is held in the variable "E_BYTEOUT"
EWrite:
        I2CWRITE SDA,SCL,%10100000,Addr,[E_ByteOut]  ' Write out the byte
        Pause 10                		' Delay 10ms after each write
	Return
' Read a single byte from the Eeprom
' The address is held in the variable "ADDR"
' The byte read is returned in the variable "E_BYTEIN"
ERead:
        I2CREAD SDA,SCL,%10100000,Addr,[E_ByteIn]   ' Read in the byte
	Return
	