' Program SER_LCD.BAS
' ***********************************************************************
' Simple Serial LCD Controller
' ***********************************************************************

	Include "Modedefs.bas"
        
	DEFINE OSC		   4		' Set the Xtal frequency to 4mHz

' ** Declare LCDOUT Defines **

	DEFINE	LCD_DREG	PortB			' Set Data to PortB
	DEFINE 	LCD_DBIT	0			' Set starting Data to Bit0
	DEFINE 	LCD_RSREG     	PortA			' Set Register Select to PortA
	DEFINE 	LCD_RSBIT       2			' Set RS line to PORTA.2
	DEFINE 	LCD_EREG	PortA			' Set Enable to PortA
	DEFINE 	LCD_EBIT  	3			' Set Enable line to PortA.3
	DEFINE 	LCD_BITS	8			' Set for 8 bit Bus
	DEFINE 	LCD_LINES	2			' Set number of lines to 2

' ** Define LCD Control Constants **

	I		Con	254			' Control Byte
	Clr		Con	1			' Clear the display
	Line1		Con	128			' Point to beginning of line 1
	Line2		Con	192			' Point to beginning of line 2
	Line3		Con	148			' Point to beginning of line 3
	Line4		Con	212			' Point to beginning of line 4
	Cgram		Con	64			' Point to Cgram within LCD
	Shift_L		Con	24			' Shift display left
	Shift_R		Con	28			' Shift display right

' ** Declare Variables **

	SO		Var	PortA.0			' Serial In Inverted
	VDD		Var	PortA.1			' LCD VDD pin
	SO2		Var	PortA.4			' Serial In True
	P_Test 	Var	PortB.4				' Pin for polarity setting
	Rcvbyte	Var	Byte				' The byte received 

Main:
	Low VDD						' Turn Off LCD
	Pause 	500					' Wait for Pic to Initialise
	High VDD					' Turn On LCD
	Pause 50					' Wait for LCD to Initialize 

' ** Check for Polarity Setting **

	TrisB=255					' Set PortB to Input
	If P_Test=1 then Goto True_Pol			' PortB.4 HI then True Polarity
	If P_Test=0 then Goto Inv_Pol			' PortB.4 LO then Inverted Polarity
			
	Goto Main					' Just In case it Missed the settings

 
' ** Receive characters serially with True polarity **

True_Pol:
	Gosub Clr_It					' Initialize the LCD	
	Lcdout I,Line2," T9600 Baud OK!"		' Print message			

Start_T9600:
	Serin SO,T9600,Rcvbyte				' Get Serial Data in
	Lcdout Rcvbyte					' Send send straight out to LCD
	Goto Start_T9600				' Loop back forever

' ** Receive characters serially with Inverted polarity **

Inv_Pol:
	Gosub Clr_It					' Initialize the LCD	
	Lcdout I,Line2," N9600 Baud OK!"		' Print message			

Start_N9600:
	Serin SO,N9600,Rcvbyte				' Get Serial Data in
	Lcdout Rcvbyte					' Send straight out to LCD
	Goto Start_N9600				' Loop back forever

' Initialize LCD ready to print
Clr_It:
	High	VDD				' Switch On LCD VDD
	TrisB=0					' Set Port to Output
	Pause 	100				' Wait for LCD to Initialise
	Lcdout I,Clr:Pause 30			' Clear the LCD	
	Lcdout I,Line1," LCD Serializer"
	Return
