' Program MultiLCD2.Bas
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Multi baud serial LCD controller
' Demonstrate the operation of a 2x16 LCD in 8-bit mode via serial input
' 300, 600, 1200, 2400, 4800, 9600 and 19200 Inverted and Non-Inverted Serial Input.
' Uses a PIC16F873 with a 12mHz Xtal

' *** Connections ***
' LCD		PIC
'-------------------
' VSS (1)	Gnd
' VDD (2)	PortB.5
' VO  (3)	Gnd
' RS  (4)	PortB.6
' R/W (5)	Gnd
' EN  (6)	PortB.7
' DB0 (7)	PortC.0
' DB1 (8)	PortC.1
' DB2 (9)	PortC.2
' DB3 (10)	PortC.3
' DB4 (11)	PortC.4
' DB5 (12)	PortC.5
' DB6 (13)	PortC.6
' DB7 (14)	PortC.7
'

' Serial Data In PortA.5

' PortB.4 Low Selects Inverted Polarity (*******************************
' PortB.4 High Selects True Polarity	(***************************
' ***********************************************************************

        Include "Modedefs.bas"
        
	DEFINE OSC		12		' Set the Xtal Frequency to 12 mHz

' ** Setup LCDOUT Defines **

	DEFINE LCD_DREG		PortC		' Set LCD Data to PortC
	DEFINE LCD_DBIT		0		' Set starting Data to Bit0
	DEFINE LCD_EREG		PortB		' Set LCD Enable to PortB
	DEFINE LCD_EBIT  	7		' Set LCD Enable line to PortB.7
	DEFINE LCD_RSREG 	PortB		' Set LCD Register Select to PortB
	DEFINE LCD_RSBIT 	6		' Set LCD RS line to PORTB.6
	DEFINE LCD_BITS		8		' Set for a 8 bit Bus
	DEFINE LCD_LINES 	4		' Set number of lines to 2

' ** Define LCD Constants **

	I		Con	254		' Control Byte
	Clr		Con	1		' Clear the display
	Line1		Con	128		' Point to beginning of line 1
	Line2		Con	192		' Point to beginning of line 2
	Line3		Con	148		' Point to beginning of line 3
	Line4		Con	212		' Point to beginning of line 4
	Cgram		Con	64		' Point to Cgram within LCD
	Shift_L		Con	24		' Shift display left
	Shift_R		Con	28		' Shift display right

' ** Declare the Variables **

	SI		Var	PortA.5		' Serial data In 
	VDD		Var	PortB.5		' LCD VDD pin
	P_Test		Var	PortB.4		' Pin for testing polarity
	Rcvbyte		Var	Byte		' The received byte	
	RcvByte2 	Var	Byte		' The Second byte received
	Bar_Pos 	Var	Byte		' The bargraph position byte received
	B_Test		Var	Byte		' Holds the value of decimal switch	
	Baud		Var	Word		' Holds the value of Baud rate
	Mode		Var	Byte		' This is used to display the Serial Mode
	P_Baud		Var	Byte		' This is used to display the baud rate	

Main:	Low VDD					' Turn Off LCD
	Pause 500				' Wait for Pic to Initialise
        ADCON1 = 7                      	' Set PORTA to digital
	High VDD				' Turn On LCD
	Pause 100				' Wait for LCD to Initialize

	Include "Bargraf2.inc"			' Load in the 2x16 bargraph routine

' Initialize LCD, ready to print
Clr_It:
	Lcdout I,Clr:Pause 30			' Clear the LCD	
	Lcdout I,Line1," LCD Serializer"

' Read the Rotary decimal switch to determine the baud rate
AGN:	Option_Reg.7=0			  	' Enable internal PortB pullup resistors
	TrisB=%00001111				' Make the lowest nibble of PortB, an input
	B_Test=PortB&%00001111			' Mask the value of PortB to the lowest nibble only
	Option_Reg.7=1			  	' Disable internal PortB pullup resistors

' The lookup table selects the Baud rate/100. ANd selects 9600 if DIL switch missing
	Lookup B_Test,[96,12,24,3,48,96,6,96,192,96,96,96,96,96,96,96,96],Baud
	P_Baud=Baud				' Variable used for the display
	Baud=(10000/Baud)-20			' Calculate the baud rate for Serout2

' Test for the Polarity Setting on PortB.4
	TrisB.4=1				' Set PortB.4 to Input
	If P_Test=1 then 			' If P_Test is high then Set for True Polarity
	Baud.14=0				' Reset bit-14 (Mode bit, reset for True)				
	Mode="T"				' Variable used for the display
	Else					' Else Set for Inverted Polarity 
	Baud.14=1				' Set bit-14 (Mode bit, set for Inverted)				
	Mode="N"				' Variable used for the display
	Endif
	TrisB.4=0				' Turn PortB.4 back to an output

' Display the Mode and Baudrate i.e. "N9600 Baud"
	Lcdout I,Line2,"   ",Mode,#(P_Baud*100)," Baud"

' This is the main program loop.
' When the mode and the baud are calculated, 
' this routine continuously looks for serial data and displays it.

Loop:	Serin2 SI,Baud,[RcvByte]		' Receive the serial byte
	If RcvByte=254 then Control		' Trap the control byte
	Lcdout RcvByte				' Else display it on the LCD
	Goto Loop				' Keep on looking

Control:
	Serin2 SI,Baud,[RcvByte2]		' Receive the second serial byte
	If RcvByte2=253 then goto Bar		' Trap the Bargraph byte	
	Lcdout RcvByte,Rcvbyte2			' If not then send out the two bytes
	Goto Loop				' Look again 

Bar:	
	Serin2 SI,Baud,[Bar_Pos,Bar_Val]	' Receive the Third and fourth serial byte
	Lcdout	I,Bar_Pos			' Position of bargraph
	Gosub Bargraph				' Display the bargraph
	Goto Loop				' Look again 

