' Program Bargraf2.Inc
' This Include file generates a horizontal bargraph 
' with the PicBasic Pro compiler and a 2x16 Intelligent LCD Display.

' The original bargragh code was written by Scott Edwards.
' However it would not compiler using the PICBASIC PRO
' Therefore, it has been modified.

' ** Declare Variables **
	Bar_Val	Var	Word			' Value to be graphed. 
	Bars	Var	Byte			' Number of full ||| bars to draw.
	Balance	Var	Byte			' Balance left after all |||s are drawn.
	Padding	Var	Byte			' Number of spaces to fill width.
	Balf	Var	Byte			' Is a 'Balance' character needed? (1=yes, 0=no).
' Duplicate variable definitions
	B_Cnt	Var 	Bars			' Counter (0-15) for EEPROM/bit pat load. 
	B_Row	Var	Balance			' Row of bit pattern. 
	B_Chr	Var 	Padding			' Bit pattern read from EEPROM. 

' ** Declare Constants **
	B_Wdth	Con	16			' Max width in characters of bar.
	Maxbar	Con	B_Wdth * 3		' Max bar counts. 
	Fullbar	Con	3			' ASCII value of ||| bar. 
	Basebar	Con	0			' ASCII value of 0 bar (blank).
	I	Con	254
	Cgram	Con	64

' Transfer the bit patterns that make up the bars into the LCD's CGRAM.
' The vertical bars are made up of 8 identical bit patterns  
' A | bar consists of 5 times %10000,
' A || bar consists of 5 times %10100
' A ||| bar consists of 5 times %10101
' We repeat each pattern from a lookup table 8 times. 
 
	Lcdout I,Cgram				' Point to character-generator RAM. 
	For B_Cnt = 0 to 3 
  	Lookup B_Cnt,[0,%10000,%10100,%10101],B_Chr ' Get the bit pattern.  
	Lcdout 0
  	For B_Row = 1 to 6
    	Lcdout B_Chr				' Write the pattern to LCD CG RAM. 
  	Next					' Next row
	Lcdout 0
	Next					' Next Character pattern

	Goto Over_Bargraph			' Jump over the subroutine

' The value in 'Bar_Val' is displayed as a horizontal bar graph 
' from the current cursor location with a total width (in characters) set by the WIDTH constant. 
' Each character position can represent a maximum value of 3 using the Fullbar character |||. 
' The routine calculates how many full bars to use by dividing by 3. 
' If there is a remainder after dividing by 3, the routine joins on a partial-bar character
' ( | or ||) to represent the balance.
' Then it pads out the remainder of the bar width with spaces to erase any leftover bars 
Bargraph:
  	Bars = (Bar_Val min Maxbar)/3		' One full bar for each 3 graph units.
  	Balance = (Bar_Val min Maxbar) // 3	' Balance is the remainder after a division by 3. 
	Balf = Balance min 1			
  	Padding = B_Wdth-(Bars+Balf)		' Number of spaces to fill bar width.
	LCDOut Rep Fullbar\Bars,Rep (Balance+Basebar)\Balf,Rep " " \Padding
	Return

Over_Bargraph: