' Program LCD_TEST.BAS
' ***********************************************************************
' This simple program will demonstrate the Bargraph display mode
' ***********************************************************************

	Include "Modedefs.Bas"

' ** Setup Crystal Frequency in mHz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Setup Debug Defines **

	Define	DEBUG_REG	PortA		' Debug Port ?
	Define	DEBUG_BIT	0		' *** Debug pin Bit ? ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 0=True, 1=Inverted
	Define	DEBUG_PACING	500		' Delay 'in Us' between characters sent


' ** Declare Variables **

	Counter		Var	Byte
	Baud		Var	Word

' ** Define LCD Control Constants **

	I		Con	254		' Control Byte
	Clr		Con	1		' Clear the display
	Line1		Con	128		' Point to beginning of line 1
	Line2		Con	192		' Point to beginning of line 2
	Line3		Con	148		' Point to beginning of line 3
	Line4		Con	212		' Point to beginning of line 4
	Cgram		Con	64		' Point to Cgram within LCD
	Shift_L		Con	24		' Shift display left
	Shift_R		Con	28		' Shift display right
	Bar		Con	253		' Bargraph control byte

	Pause 300

	Debug I,Clr:Pause 30			' Clear the LCD

Main:
	For Counter=0 to 47			' Change this to 47 for the 16x2 controller
	Debug I,Line1,#Counter,"  "		' Display the value of counter
	Debug I,Bar,Line2,Counter:pause 1	' Display the bargraph
	Pause 20
	Next
	Goto Main
