' Program: MAX7219.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' This Program demonstrates the basic functions of the MAX7219
' 
	Include "Modedefs.bas"

' ** Set Xtal Value in Mhz **
	Define	OSC	4		' Set Xtal Frequency

' ** Declare Pins Used **
	Clk     Var	PortB.0		' Data is clocked on rising edge of this pin
	Din  	Var	PortB.1		' Bits are shifted out of this pin
	Load    Var	PortB.2		' Transfers data to LEDs when Pulsed

' ** Declare Constants **
	Decode_Reg 	Con	9	' Decode register, a 1 turns on BCD decoding for each digit. 
	Lum_Reg		Con	10	' Intensity register.
	Scan_Reg	Con	11	' Scan-limit register.
	Switch_Reg	Con	12	' On/Off Register.
	Test_Reg	Con	15	' Test mode register (all digits on, 100% bright)

'	Max_Digit	Con	5	' Amount of LED Displays being used.

' ** Declare Variables **
  	Counter		Var	Word	' Variable used for the Counting routine
	Max_Disp	Var	Word	' 16 bit value to be displayed by the MAX7219
	Register	Var	Byte	' Pointer to the Internal Registers of the MAX7219
	Value		Var	Byte	' Data placed in Each Register
	Digit		Var	Byte	' Position of individual numbers within MAX_Disp (0-3)
	Position	Var	Byte	' Position of each LED display (1-4)

' ** Initialize the MAX7219 ** 
' Each register address is sent along with its setting data, 
' because the MAX7219 expects to see a packet of 16 bits, then the LOAD pin is pulsed
' First set the scan limit to 3 (4 digits, numbered 0-3)
' then set the Brightness to 5
' BCD decoding to all digits (just in case more displays are added later)
' Turn Off test mode
' Switch the display on. 

	Register=Scan_Reg		' Point to the Scan Register
	Value=3				' send 3, (Four LED Displays 0-3)
	Gosub Transfer			' Transfer this 16-bit Word to the MAX7219

	Register=Lum_Reg		' Point to the Luminance Register
	Value=3				' Send 5, (Value for Brightness)
	Gosub Transfer			' Transfer this 16-bit Word to the MAX7219

	Register=Decode_Reg		' Point to BCD Decode Register
	Value=%11111111			' Decode all the digits (just in case more are added later)
	Gosub Transfer			' Transfer this 16-bit Word to the MAX7219

	Register=Test_Reg		' Point to the Test Register
	Value=0				' Reset to Zero, (turns off Test mode)
	Gosub Transfer			' Transfer this 16-bit Word to the MAX7219

	Register=Switch_Reg		' Point to the Switch Register 
	Value=1				' Set to One, (switches the display ON)
	Gosub Transfer			' Transfer this 16-bit Word to the MAX7219




' 		***** MAIN PROGRAM *****
' This loop, increments, and then decrements a 16-bit number held in "COUNTER" 
' And displays it on Four led Displays
' The value to be displayed is placed in the variable "MAX_DISP"

Again:	For Counter=1 to 9999		' Increment Counter
	Max_Disp=Counter		' Load Max_Disp with Value of Counter
	Gosub Display			' Display the Value of Counter
	Pause 50			' Delay, so we can see whats happening
	Next				' Close the Loop

	For Counter=9999 to 1 step -1	' Decrement Counter
	Max_Disp=Counter		' Load Max_Disp with Value of Counter
	Gosub Display			' Display the Value of Counter
	Pause 50			' Delay, so we can see whats happening
	Next				' Close the Loop		
	Goto Again			' Do it Indefinately


' ** Subroutines **
' Display the Value held in the Variable "Max_Disp" on the four LED's
' With zero supression

Display:
	Digit=0						' Start at Digit 0 of Max_Disp Variable
	For Position=4 to 1 step -1			' Start at Farthest Right led Display 		
	Register=Position				' Place the Position into Register
	Value=Max_Disp Dig Digit			' Extract the individual numbers from Max_Disp			
	If Max_Disp<10 and Position=3 then Value=15	' Zero Suppression for the second digit
	If Max_Disp<100 and Position=2 then Value=15	' Zero Suppression for the Third digit
	If Max_Disp<1000 and Position=1 then Value=15	' Zero Suppression for the Forth digit
	If Max_Disp<10000 and Position=0 then Value=15	' Zero Suppression for the Fifth digit
	Gosub Transfer					' Transfer the 16-bit Word to the MAX7219
	If Digit>=3 then Digit=0			' We only need the first four digits
	Digit=Digit+1					' Point to next Digit within Max_Disp
	Next Position					' Close the Loop
	Return						' Exit from subroutine

' Send a 16-bit word to the MAX7219 and then pulse the Load pin
Transfer:
  	Shiftout Din,Clk,msbfirst,[Register,Value] ' Shift Out the Register first, then the data
	High Load				' The data is now acted upon
@	Nop
@	Nop					' A small delay to ensure correct clocking times
	Low Load				' Disable the MAX7219 
	Return					' Exit from Subroutine