' Program 5CC_DISP.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Common Cathode seven segment display multiplexer
' Displays the contents of the variable D_NUMBER on five common cathode displays
' using a TMR0 interrupt every 1.6ms (assuming a 20mHz oscillator)
' ***********************************************************************

	Include "Modedefs.Bas"

' ** Setup the Crystal Frequency, in mHz **

	Define 	OSC		20		' Set Xtal Frequency

' ** Declare the Variables **
	LEDS		Var	Byte		' The amount of LEDs in the display
	O_C		Var	Byte		' Used by the interrupt for time sharing
	Counter		Var	Word		' General purpose counter
	Del		Var	Word		' General purpose delay loop variable
	D_Number	Var	Word		' The number to display on the LEDS
	DP		Var	Byte		' Position of the decimal point
	Disp_Patt	Var	Byte		' Pattern to output to PortC
	Num		Var	Byte[5]		' Array to hold each digits value
	Digit0		Var	PortB.0		' Controls the first DIGIT on the LED
	Digit1		Var	PortB.1		' Controls the second DIGIT on the LED
	Digit2		Var	PortB.2		' Controls the third DIGIT on the LED
	Digit3		Var	PortB.3		' Controls the fourth DIGIT on the LED
	Digit4		Var	PortB.4		' Controls the fifth DIGIT on the LED


' ** Declare the bits and flags of the various registers **

	T0IE		Var	INTCON.5	' Timer0 Overflow Interrupt Enable
	T0IF		Var	INTCON.2	' Timer0 Overflow Interrupt Flag
	GIE		Var	INTCON.7	' Global Interrupt Enable
	PS0		Var	OPTION_REG.0	' Prescaler division bit-0
	PS1		Var	OPTION_REG.1	' Prescaler division bit-1
	PS2		Var	OPTION_REG.2	' Prescaler division bit-2
	PSA		Var	OPTION_REG.3	' Prescaler Assignment (1= assigned to WDT)
						'		       (0= assigned to oscillator)
	T0CS		Var	OPTION_REG.5	' Timer0 Clock Source Select (0=Internal clock) 
						'			     (1=External PORTA.4)
' ** THE MAIN PROGRAM STARTS HERE **

' Set TMR0 to interrupt
	GIE=0					' Turn off global interrupts
	While GIE=1:GIE=0:Wend			' Make sure they are off
	PSA=0					' Assign the prescaler to external oscillator
	PS0=1					' Set the prescaler
	PS1=0					' to increment TMR0
	PS2=0					' every 32nd instruction cycle
	T0CS=0					' Assign TMR0 clock to internal source
	TMR0=0					' Clear TMR0 initially
	T0IE=1					' Enable TMR0 overflow interrupt
	GIE=1					' Enable global interrupts

        On Interrupt Goto Mult_Int		' Point to the interrupt handler

	TrisC=0:TrisB=0				' Make PortB and PortC outputs
	PortC=0:PortB=0				' Clear PortB and PortC
	O_C=0					' Clear the time share variable 

Main:	For Counter=0 to 65535			' Count upto 65535
	D_Number=Counter			' Place the value to display into D_NUMBER
	DP=0					' Disable the decimal point
	Gosub Display				' Display the value
	 For Del=0 to 100			' Pause 10ms
	 Pauseus 100				' using smaller delays
	 Next
	Next
Inf:	Goto Main				' Do it forever

' Build up the seperate digits of variable D_NUMBER
' into the array NUM. Each LED is assigned to each array variable.
' LED-0 (right) displays the value of NUM[0]
' LED-1 (middle) displays the value of NUM[1]
' LED-2 (lef) displays the value of NUM[2]
' The decimal point is placed by loading the variable DP
' with the LED of choice to place the point (0..5). where 1 is the farthest right LED
' and 0 disables the decimal point.
Display:
	For LEDS=4 to 0 step -1 			' Loop for 5 digits (0-65535)
	Disable						' Disable the interrupt while we calculate
	Num[LEDS]=D_Number dig LEDS 			' Extract the seperate digits into the array
	If D_Number<10 and LEDS=1 then Num[LEDS]=10	' Zero Suppression for the second digit
	If D_Number<100 and LEDS=2 then Num[LEDS]=10	' Zero Suppression for the Third digit
	If D_Number<1000 and LEDS=3 then Num[LEDS]=10	' Zero Suppression for the Forth digit
	If D_Number<10000 and LEDS=4 then Num[LEDS]=10	' Zero Suppression for the Fifth digit
	Enable						' Re-enable the interrupt
	Next	


' INTERRUPT HANDLER 
' Multiplexes the 5-digits
' 
        Disable         			' Disable all interupts during the interrupt handler
Mult_Int: 
	Lookup Num[O_C],[63,6,91,79,102,109,124,7,127,103,0],Disp_Patt ' Decode the segments for the LED
' Process the first display (farthest right)
	If O_C=0 then				' If it is our turn then
	Digit4=0				' Turn OFF the fifth LED
	PortC=Disp_Patt				' Place the digit pattern on portC
	If DP=1 then PortC.7=1			' Check the value of DP and Turn ON the decimal point
	Digit0=1				' Turn ON the first LED
	Endif
' Process the second display
	If O_C=1 then				' If it is our turn then
	Digit0=0				' Turn OFF the first LED
	PortC=Disp_Patt				' Place the digit pattern on portC
	If DP=2 then PortC.7=1			' Check the value of DP and Turn ON the decimal point
	Digit1=1				' Turn ON the second LED
	Endif
' Process the third display
	If O_C=2 then				' If it is our turn then
	Digit1=0				' Turn OFF the second LED
	PortC=Disp_Patt				' Place the digit pattern on portC
	If DP=3 then PortC.7=1			' Check the value of DP and Turn ON the decimal point
	Digit2=1				' Turn ON the third LED
	Endif
' Process the fourth display
	If O_C=3 then				' If it is our turn then
	Digit2=0				' Turn OFF the third LED
	PortC=Disp_Patt				' Place the digit pattern on portC
	If DP=4 then PortC.7=1			' Check the value of DP and Turn ON the decimal point
	Digit3=1				' Turn ON the fourth LED
	Endif
' Process the fifth display (leftmost display)
	If O_C=4 then				' If it is our turn then
	Digit3=0				' Turn OFF the fourth LED
	PortC=Disp_Patt				' Place the digit pattern on portC
	If DP=5 then PortC.7=1			' Check the value of DP and Turn ON the decimal point
	Digit4=1				' Turn ON the fifth LED
	Endif

	O_C=O_C+1				' Increment the time share counter
	If O_C>=5 then O_C=0			' If it reaches 5 or over then clear it

	T0IF=0    				' Reset TMR0 interrupt flag
        Resume					' Exit the interrupt
	Enable					' Allow more interrupts