' Program DISP_TST.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Demonstrate the use of the 7-segment display multiplexing include files.
'
' Upon the programs start a TMR0 interrupt is automatically started
' using the compilers ON INTERRUPT command
' To display a value on the leds,
' Place the value to display into the variable D_NUMBER
' and the decimal point location into the variable DP.
' A value of 0 in DP will disable the decimal point
' ***********************************************************************

	Include "Modedefs.Bas"
'	Include "2CA_Disp.Inc"			' Load the 2-digit display multiplexor
'	Include "3CA_Disp.Inc"			' Load the 3-digit display multiplexor
'	Include "4CA_Disp.Inc"			' Load the 4-digit display multiplexor
	Include "5CA_Disp.Inc"			' Load the 5-digit display multiplexor

' ** Setup the Crystal Frequency, in mhz **

	Define 	OSC		20		' Set Xtal Frequency

' ** Declare the Variables **

	Counter		Var	Word		' General purpose counter
	Del		Var	Word		' General purpose delay loop variable

' ** THE MAIN PROGRAM STARTS HERE **

Main:	For Counter=0 to 65535			' Count upto 65535
	D_Number=Counter			' Place the value to display into D_NUMBER
	DP=0					' Disable the decimal point
	Gosub Display				' Display the value
	 For Del=0 to 1000			' Pause 10ms
	 Pauseus 100				' using smaller delays
	 Next
	Next
Inf:	Goto Main				' Do it forever
