' Program 3CA.DISP.INC
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Common Anode seven segment display multiplexer Include file
' Displays the contents of the variable D_NUMBER on TWO common Anode displays
' using a TMR0 interrupt every 13ms (assuming a 20Mhz oscillator)
' ***********************************************************************

' ** Declare the Variables **
	LEDS		Var	Byte		' The amount of LEDs in the display
	O_C		Var	Byte		' Used by the interrupt for time sharing
	D_Number	Var	Byte		' The number to display on the LEDS
	DP		Var	Byte		' Position of the decimal point
	Disp_Patt	Var	Byte		' Pattern to output to PortC
	Num		Var	Byte[2]		' Array to hold each digits value
	Digit0		Var	PortB.0		' Controls the first DIGIT on the LED
	Digit1		Var	PortB.1		' Controls the second DIGIT on the LED

' ** Declare the bits and flags of the various registers **

	T0IE		Var	INTCON.5	' Timer0 Overflow Interrupt Enable
	T0IF		Var	INTCON.2	' Timer0 Overflow Interrupt Flag
	GIE		Var	INTCON.7	' Global Interrupt Enable
	PS0		Var	OPTION_REG.0	' Prescaler division bit-0
	PS1		Var	OPTION_REG.1	' Prescaler division bit-0
	PS2		Var	OPTION_REG.2	' Prescaler division bit-0
	PSA		Var	OPTION_REG.3	' Prescaler Assignment (1= assigned to WDT)
						'		       (0= assigned to oscillator)
	T0CS		Var	OPTION_REG.5	' Timer0 Clock Source Select (0=Internal clock) 
						'			     (1=External PORTA.4)
' ** THE MAIN PROGRAM STARTS HERE **

' Set TMR0 to interrupt
	GIE=0					' Turn off global interrupts
	While GIE=1:GIE=0:Wend			' Make sure they are off
	PSA=0					' Assign the prescaler to external oscillator
	PS0=1					' Set the prescaler
	PS1=1					' to increment TMR0
	PS2=1					' every 256th instruction cycle
	T0CS=0					' Assign TMR0 clock to internal source
	TMR0=0					' Clear TMR0 initially
	T0IE=1					' Enable TMR0 overflow interrupt
	GIE=1					' Enable global interrupts

        On Interrupt Goto Mult_Int		' Point to the interrupt handler

	TrisC=0					' Make PortC outputs
	TrisB.0=0:TrisB.1=0			' Make only the specific bits of PortB outputs					
	PortC=0:PortB=0				' Clear PortB and PortC
	O_C=0					' Clear the time share variable 

	Goto Over_MULTIPLEXER			' Jump over the subroutines

' Build up the seperate digits of variable D_NUMBER
' into the array NUM. Each LED is assigned to each array variable.
' LED-0 (right) displays the value of NUM[0]
' LED-1 (middle) displays the value of NUM[1]
' LED-2 (lef) displays the value of NUM[2]
' The decimal point is placed by loading the variable DP
' with the LED of choice to place the point (0..2). where 1 is the farthest right LED,
' and 0 disables the decimal point.
Display:
	For LEDS=1 to 0 step -1 			' Loop for 2 digits (0-99)
	Disable						' Disable the interrupt while we calculate
	Num[LEDS]=D_Number dig LEDS 			' Extract the seperate digits into the array
	If D_Number<10 and LEDS=1 then Num[LEDS]=10	' Zero Suppression for the second digit
	Enable						' Re-enable the interrupt
	Next	
	Return

' INTERRUPT HANDLER 
' Multiplexes the 2-digits
' 
        Disable         			' Disable all interupts during the interrupt handler
Mult_Int: 
	Lookup Num[O_C],[192,249,164,176,153,146,131,248,128,152,255],Disp_Patt ' Decode the segments for the LED
' Process the first display (farthest right)
	If O_C=0 then				' If it is our turn then
	Digit1=0				' Turn OFF the second LED
	PortC=Disp_Patt				' Place the digit pattern on portC
	If DP=1 then PortC.7=0			' Check the value of DP and Turn ON the decimal point
	Digit0=1				' Turn ON the first LED
	Endif
' Process the second display
	If O_C=1 then				' If it is our turn then
	Digit0=0				' Turn OFF the first LED
	PortC=Disp_Patt				' Place the digit pattern on portC
	If DP=2 then PortC.7=0			' Check the value of DP and Turn ON the decimal point
	Digit1=1				' Turn ON the second LED
	Endif

	O_C=O_C+1				' Increment the time share counter
	If O_C>=2 then O_C=0			' If it reaches 3 or over then clear it

	T0IF=0    				' Reset TMR0 interrupt flag
        Resume					' Exit the interrupt
	Enable					' Allow more interrupts

Over_MULTIPLEXER:
