' Program R2R.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Demonstrate the R-2R digital to analog convertsion technique.
' The output voltage required is place into "VOUT"
' Then a Gosub is made to R2R, this will calculate the value to be placed on portB
' and output the correct binary pattern.
' ***********************************************************************

	Include "Modedefs.Bas"

' ** Setup Crystal Frequency in mhz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Declare Variables **

	Vout		Var	Word		' The voltage required*100 i.e 2.5V is 250
	Bval		Var	Byte		' The binary value to place onto portB

' ** Declare the Constants **

	Quanta		Con	196		' Quanta level, based on an 8-bit 5Volt scale

' ** The Main program starts here **

Main:
	PortB=0					' Clear PortB
	TrisB=0					' Make PortB all outputs

	Vout=350				' 3.5Volts required on the Output	
	Gosub R2R				' Calculate Bval and place the result on portB
Inf:	Goto Inf				' Infinite loop


' Calculate "BVAL" for a given voltage, and present it to portB

R2R:	Bval=(Vout*100)/quanta			' Calculate the Duty for the given voltage
	PortB=Bval				' Output the voltage
	Return

