' Program HPWM2.INC
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Using the hardware PWM on the 16F8XX range of pics
' using an include file.
' The include file should be placed at the top of the program
' It automatically sets up the TMR2 registers.
' The Voltage output should be loaded into the Variable "VOUT"
' The individual PWM modules can be turned ON or OFF
' By placing different values in the variable CCP
' CCP = 0, will turn CCP1 and CCP2 modules OFF
' CCP = 1, will turn CCP1 module ON 
' CCP = 2, will turn CCP1 module OFF
' CCP = 3, will turn CCP2 module ON
' CCP = 4, will turn CCP2 module OFF
' CCP = 5, will turn CCP1 and CCP2 modules ON
' A Gosub to HPWM will switch on or off the selected module with the desired voltage output.
' All the variables used within the include file are pre-declared.
' ***********************************************************************

' ** Declare the Variables **

	HPWM_X		Var	Word
	HPWM_Duty	Var	Word
	Vout		Var	Word	SYSTEM
	CCP		Var	Byte
	ON_OFF		Var	Byte
	CCP1		Var	Bit
	CCP2		Var	Bit

PWM_INIT:
	T2CON = %00000100 		' Set prescaler to 1:1 and turn TMR2 on
	PR2 = 255			' Set output period for 3.9khz and 10-bits resolution
	CCP1CON = %00000000 		' Clear the CCP1CON register, turning off PWM module 1
	CCP2CON = %00000000		' Clear the CCP2CON register, turning off PWM module 2
	Goto Over_HPWM			' Jump Over the HPWM subroutine

HPWM:	
' Turn OFF PWM modules CCP1 and CCP2
	If CCP=0 then 
	TrisC.1=1
	TrisC.2=1			' Make the CCP modules Inputs, thus disconnecting them
	CCP1CON=0			' Turn OFF PWM module CCP1
	CCP2CON=0			' Turn OFF PWM module CCP2
	Endif

' Turn ON PWM module CCP1
	If CCP=1 then			
	Gosub Calc_Duty			' Calculate the Duty value
	Gosub DO_CCP1			' Output the voltage from CCP1
	Endif

' Turn OFF PWM module CCP1
	If CCP=2 then 
	TrisC.2=1			' Disconnect CCP1's pin
	CCP1CON=0			' Turn OFF PWM module CCP1		
	Endif	

' Turn ON PWM module 2
	If CCP=3 then 			
	Gosub Calc_Duty			' Calculate the Duty value
	Gosub DO_CCP2			' Output the voltage from CCP2
	Endif

' Turn OFF PWM module CCP2
	If CCP=4 then 
	TrisC.1=1			' Disconnect CCP2's pin
	CCP2CON=0			' Turn OFF PWM module CCP2
	Endif		

' Turn on both CCP1 and CCP2
	If CCP=5 then			
	Gosub Calc_Duty			' Calculate the Duty value
	Gosub DO_CCP1			' Output the voltage from CCP1
	GOSUB DO_CCP2			' Output the voltage from CCP2
	Endif
	Return

' Output the voltage from CCP module 1
DO_CCP1:
	HPWM_Duty=HPWM_X		' Transfer the duty variable
	Trisc.2=0 			' Enable PortC.2 (CCP1) as output
	CCP1CON=%00001100		' Turn ON PWM module 1
	CCP1CON.4=HPWM_Duty.0		' Place bit-0 of the duty in the LSB register(bit-4)
	CCP1CON.5=HPWM_Duty.1		' Place bit-1 of the duty in the LSB register(bit-5)
	HPWM_Duty=HPWM_Duty >>2		' Shift the duty value down 2 places 
	CCPR1L = HPWM_Duty 		' MSB of the 10-bit duty value 
	Return

' Output the voltage from CCP module 2
DO_CCP2:
	HPWM_Duty=HPWM_X		' Transfer the Duty variable
	TrisC.1=0			' Enable PortC.1 (CCP2) as an output
	CCP2CON=%00001100		' Turn ON PWM module 2
	CCP2CON.4=HPWM_Duty.0		' Place bit-0 of the duty in the LSB register(bit-4)
	CCP2CON.5=HPWM_Duty.1		' Place bit-1 of the duty in the LSB register(bit-5)
	HPWM_Duty=HPWM_Duty >>2		' Shift the duty value down 2 places 
	CCPR2L = HPWM_Duty		' Load duty into CCPR2L
	Return

' Calculate the duty required for a specified Voltage, held in VOUT
Calc_Duty:
	HPWM_X=(Vout*100)/49		' Calculate the duty for a given voltage
	Return

'****************************************************************************************
'*  Define the HPWM macro 								*
'*  Usage: -   HPWM CCP? (1-2) , Voltage out , 1-0 (ON/OFF) , PR2 , TMR2 Prescaler	*
'*  CCP may be a constant or a variable, this points to the CCP module of interest.	*
'*  Voltage Out must always be an 8 or 16-bit variable.					*
'*  ON_OFF may be a constant or a variable, this turns on the specified CCP module.	*
'*  PR2 must always be a variable and may be ommited 					*
'*  TRMR2 prescaler must be a constant with the value of 1, 4, or 16 and may be ommited	*
'****************************************************************************************
Asm
HPWM	Macro Con1,Var1,Con2,Var2,Con3

	if (Con1 == 1 | Con1 == 2)		;' Check if parameter1 is a constant 
	Movlw Con1				;' Place the constant into W
	Else					;' Else it must be a variable
	Movf Con1,w				;' Therefore, place the variable into W
	Endif
	Movwf _CCP				;' Place W into variable CCP

	Movf Low Var1,w				;' Place the LOW byte of Var1
	Movwf Vout				;' Into the lowbyte of Vout
	Movf High Var1,w			;' Place the High byte of Var1
	Movwf Vout+1				;' Into the highbyte of Vout, which is Vout+1

	if (Con2 == 0 | Con2 == 1)		;' Check if parameter3 is a constant 
	Movlw Con2				;' Place the constant into W
	Else					;' Else it must be a variable
	Movf Con2,w				;' Therfore, place the variable into W
	Endif
	Movwf _ON_OFF				;' Place W into variable ON_OFF

	Ifnb Var2				;' Check if parameter, Var2 is present, PR2 value
	Movf Var2,w				;' Load its value into W
	Movwf PR2				;' Place W into PR2
	endif
 	
	Ifnb Con3				;' Check if parameter, Con3 is present, TMR2 prescaler value
	if (Con3 == 1)				;' If its 1!
	Bcf T2CON,0				;' Place %00 in the first two bits of T2CON
	Bcf T2CON,1				;' Making the prescaler 1:1
	endif
	if (Con3 == 4)				;' If its 4!
	Bsf T2CON,0				;' Place %01 in the first two bits of T2CON
	Bcf T2CON,1				;' Making the prescaler 1:4
	endif
	if (Con3 == 16)				;' If its 16!
	Bcf T2CON,0				;' Place %10 in the first two bits of T2CON
	Bsf T2CON,1				;' Making the prescaler 1:16
	endif	
	endif
Endasm	
	Gosub HPWM				' Do the PWM subroutine
Asm
	Endm
Endasm
'****************************************************************************************
Over_HPWM:
