' Program 8BIT_PWM.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Demonstrate the use of the PWM command.
' Also calculate the duty value needed for a given voltage output.
' Duty=(Vout*100)/quanta
' With an unbuffered R/C network consisting of a 10k ohm resistor and a 1uF capacitor
' Connected to PORTB.0
' Also with an Op-amp buffer connected
' The LED attached to the PWM output will flash without the op-amp connected, 
' as too much current is drawn by the led
' And will stay steady with the op-amp connected
' Note, with a normal op-amp such as the LM358 there is a limited voltage swing of 1.4 to 3.8v 
' ***********************************************************************

	Include "Modedefs.Bas"

' ** Setup Crystal Frequency in mHz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Declare the Variables **

	Pwm_Pin		Var	PortB.0		' Port & Pin to output the voltage from
	Vout		Var	Word		' The voltage required*100 i.e 2.5V is 250
	Duty		Var	Byte		' The duty cycle variable, used by the PWM command

' ** Declare the Constants **
' ** Calculate the Cycle time depending on the R/C network and Xtal frequency used **
	Charge_Time	Con	4*10*1		' 4 * resistor * capacitor (4 * 10k * 1uf)
	PWM_Cycle	Con	20/4		' 20 / Crystal frequency used
	Cycle		Con	Charge_Time/PWM_Cycle ' Cycle time to put into the PWM command

	Quanta		Con	196		' Quanta level, based on an 8-bit 5Volt scale

' ** The Main program starts here **

Main:	Vout=300				' 3Volts required on the Output	
	Duty=(Vout*100)/quanta			' Calculate the Duty for the given voltage
	Pwm Pwm_Pin,Duty,Cycle			' Output the voltage for 40ms (using a 4mHz Xtal)
	Pause 100				' Wait, required by demonstration circuits
	Goto Main				' Do it forever





