' Program MAX5352R.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' This demonstrates the use of the MAX5352 D/A converter
' using a VREF of 3.6 volts.
' The required output voltage is loaded into "VOUT" and a call to MAX_OUT is made.
' ***********************************************************************

	Include "Modedefs.Bas"

' ** Setup Crystal Frequency in Mhz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Declare Variables **
	
	CS		Var	PortB.0		' Enable/Disable pin of the MAX5352
	Din		Var	PortB.1		' Serial data pin of the MAX5352
	Sclk		Var	PortB.2		' Serial clock pin of the MAX5352
	Vout		Var	Word		' The output voltage required

' ** The main program starts here **

	Vout=300				' Place the voltage into Vout (3 volts)
	Gosub Max_Out				' Send out the voltage 
Inf:	Goto Inf				' Infinite Loop.

' Send out the value held in "VOUT" to the MAX5352 D/A

Max_Out:
	Vout=Vout*10				' Bring Vout upto the correct value
	If Vout>=3600 then Vout=3600		' Make sure result doesn't go over 3600
	Vout=Vout<<1				' Bit-0 of the 12-bits sent needs to be zero.
	Vout.15=0				' And so does bit-15,
	Vout.14=0				' Bit-14,
	Vout.13=0				' and bit-13.
	Low CS					' Enable the MAX5352.
	Shiftout Din,Sclk,Msbfirst,[Vout\16]	' Shift out the 16-bit value
	High CS					' Now disable the chip
	Return					' Exit the subroutine.