' Program MAX5352.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' This demonstrates the use of the MAX5352 12-bit digital to analog converter,
' using a 2.5Volt VREF, generated by a TLE2425 precision virtual ground IC.
' The output voltage required is loaded into the variable "Vout",
' and then a call is made to the subroutine "MAX_OUT"
' ***********************************************************************

	Include "Modedefs.Bas"

' ** Setup Crystal Frequency in Mhz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Declare Variables **
	
	CS		Var	PortB.0		' MAX5352 enable/disable pin
	Din		Var	PortB.1		' MAX5352 serial data pin
	Sclk		Var	PortB.2		' MAX5352 serial clock pin
	Vout		Var	Word		' Output voltage required
	Max_X		Var	Word		' temporary variable used in "MAX_OUT" subroutine

	Quanta		Con	122		' The quanta level for 5Volts and 12-bits

' ** The main program starts here **

Main:	Vout=380				' Place the output voltage required into "Vout"
	Gosub Max_Out				' Send out the voltage 
	Pause 150				' Wait a while
Inf:	Goto Inf				' Infinite Loop

' Calculate the value of the 12-bit binary word to send to the MAX5352,
' and alter the control bits accordingly.
Max_Out:
	Max_X=((Vout*100)/quanta)*10		' Calculate the 12-bit value for a given voltage
	Vout = ((Vout*100)//quanta)/10		' Resolve the remainder of the calculation
	Vout = Vout+Max_X 			' Add the remainder to the Initial division result
	If Vout>=4096 then Vout=4095		' Make sure result doesn't go over 4095
	Vout=Vout<<1				' Bit 0 of the 12-bits sent needs to be zero
	Vout.15=0				' And so do bits-15,
	Vout.14=0				' Bit-14,
	Vout.13=0				' and bit-13.
	Low CS					' Enable the MAX5352
	Shiftout Din,Sclk,Msbfirst,[Vout\16]	' Shift out the 16-bit value
	High CS					' Now disable the chip
	Return					' Exit the subroutine