' Program AD840X.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Interface to the Analog devices AD840X series of dual digital potentiometer.
' It is configured as a potential divider.
' Which operates as a DAC
' ***********************************************************************

	Include "Modedefs.Bas"

' ** Setup the Crystal Frequency, in Mhz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Setup the Debug Defines **

	Define	DEBUG_REG	PortB		' Debug PortB
	Define	DEBUG_BIT	7		' *** Debug pin Bit-7 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 1=Inverted
	Define	DEBUG_PACING	300		' Delay 'in Us' between characters sent

' ** Define LCD Control Constants **

	I		Con	254		' Control Byte
	Clr		Con	1		' Clear the display
	Line1		Con	128		' Point to beginning of line 1
	Line2		Con	192		' Point to beginning of line 2
	Line3		Con	148		' Point to beginning of line 3
	Line4		Con	212		' Point to beginning of line 4
	Cgram		Con	64		' Point to Cgram within LCD

' ** Declare the Variables **

	Vout		Var	Word		' The voltage to output
	V_Output	Var	Word		' Temporary variable used in RDACout
	A1		Var	V_Output.9	' Address bit A1
	A0		Var	V_Output.8	' Address bit A0
	RDAC		Var	Byte		' Pointer to the internal RDAC's of the AD8402
	CLK		Var	PortB.0		' Serial clock pin of the AD8402
	SDI		Var	PortB.1		' Serial data pin of the AD8402
	CS		Var	PortB.2		' Enable/Disable pin of the AD8402
	SW1		Var	PortB.3		' Voltage Down Switch
	SW2		Var	PortB.4		' Voltage Up Switch

' ** Define LCD Constants **

	I		Con	254		' Control Byte
	Clr		Con	1		' Clear the display
	Line1		Con	128		' Point to beginning of line 1
	Line2		Con	192		' Point to beginning of line 2
	Line3		Con	148		' Point to beginning of line 3
	Line4		Con	212		' Point to beginning of line 4

' ** The main program starts here **

	Debug I,Clr:Pause 30			' Clear the LCD

	Vout=250				' Set the voltage out to 2.5v initially
Main:	Option_Reg.7=0				' Enable Internal PortB Pullup Resistors

	If SW1=0 then				' Check the voltage down switch (SW1)
	If Vout >0 then Vout=Vout-1		' If all is OK then lower the output Voltage	
	Goto Display				' Display and output the Voltage level
	Endif

	If SW2=0 then				' Check the voltage up switch (SW2)
	If Vout <500 then Vout=Vout+1		' If all is OK then increase the output Voltage
	Goto Display				' Display and output the Voltage level
	Endif

Display:
	RDAC=1					' Point to RDAC 1 
	GoSub RDACout				' Output the voltage
	Debug I,Line1,dec1(Vout/100),".",dec2(Vout//100)," Volts  " ' Display the output voltage level
	Pause 200				' Debounce the switch
	Goto Main				' Go back to the start of the program	

' Calculate the value to place into the RDAC,s latch and the Address bits
' and shift out the 10-bits of data 
' The RDAC of interest is held in RDAC (1..4)
RDACout: 
	V_Output=(Vout*100)/196			' Calculate the output voltage

	If RDAC=1 then 				' Point to RDAC 1, by,
	A1=0:A0=0				' clearing A0 and A1
	Endif					
	If RDAC=2 then 				' Point to RDAC 2, by,
	A1=0:A0=1				' setting A0 and clearing A1 
	Endif
	If RDAC=3 then				' Point to RDAC 3, by, 
	A1=1:A0=0				' clearing A0 and setting A1
	Endif
	If RDAC=4 then				' Point to RDAC 4, by, 
	A1=1:A0=1				' setting A0 and A1
	Endif
	Low CS					' Enable the AD8402.
	Shiftout SDI,CLK,Msbfirst,[V_Output\10]	' Shift out the 10-bit word
	High CS					' Now disable the chip
	Return					' Exit the subroutine.