' Program ISD_CNT.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
' Demonstration of the ISD1416 chipcorder device
' Speak any number from 0 to 65535
' Does not speak the leading zeroes and is capable of speaking the words
' 'POINT' and 'DEGREES' by using the 12 previously recorded messages
' The messages are also displayed on a serial LCD
' ***********************************************************************

	Include "Modedefs.Bas"

' ** Setup the Crystal Frequency, in mHz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Setup the Debug Defines **

	Define	DEBUG_REG	PortA		' Debug PortA
	Define	DEBUG_BIT	0		' *** Debug pin Bit-0 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 0=True, 1=Inverted
	Define	DEBUG_PACING	300		' Delay 'in Us' between characters sent

' ** Define LCD Constants **

	I		Con	254		' Control Byte
	Clr		Con	1		' Clear the display
	Line1		Con	128		' Point to beginning of line 1
	Line2		Con	192		' Point to beginning of line 2
	Line3		Con	148		' Point to beginning of line 3
	Line4		Con	212		' Point to beginning of line 4
	Cgram		Con	64		' Point to Cgram within LCD


' ** Assign the ISD1416 pins **
	STROBE		Var	PortA.1		' End of message pulse
	PLAYE		Var	PortA.2		' Pull low to play message, bring high to end
	PLAYL		Var	PortA.3		' Pulse to play complete message

' ** Declare the Variables **
	Counter		Var	Word		' General purpose counter
	S_Digit		Var	Byte		' Build up the seperate digits, loop
	S_Num		Var	Word		' The number to say is loaded into here
	SN		Var	Word		' Used in the sayit subroutine

' ** Declare Constants **
	S_Point		Con	131
	S_Degrees	Con	144
	
' ** THE MAIN PROGRAM STARTS HERE **
	Debug I,Clr:Pause 30			' Clear the LCD

	TrisB=0					' Make PortB an output
	TrisA.3=1				' Disconnect the PLAYE line

Again:	For Counter=0 to 99			' Count up to 100
	S_Num=Counter				' Place the counter into S_NUM
	Debug I,Line1,dec2 S_Num,"."
	Gosub Sayit				' Say the number held in S_NUM	
	Gosub Say_Point				' Say the word 'POINT'
Another:
	Random S_Num
	If S_Num> 99 then Another
	Debug I,Line1+3,#S_Num," Degrees   "
	Gosub Sayit
	Gosub Say_Degrees
	Pause 300				' Pause after the number is spoken
	Next
	Goto Again


Sayit:	For S_Digit=4 to 0 step-1			' Loop for 5 digits (0-65535)
	SN=S_Num dig S_Digit 				' Extract the seperate digits
	If S_Num<10 and S_Digit>0 then Over		' Zero supression for 0-10
	If S_Num<100 and S_Digit>1 then Over		' Zero supression for 10-100
	If S_Num<1000 and S_Digit>2 then Over		' Zero supression for 100-1000
	If S_Num<10000 and S_Digit>3 then Over		' Zero supression for 1000-10000
	Lookup SN,[0,14,27,40,53,66,79,92,105,118],SN 	' Find the address of the message	
	PortB=SN					' Place it on the ISD's address line
	Gosub Play					' Say the number
Over:	Next						' Close the loop
	Return

' ** Say the word 'POINT' **
Say_Point:
	PortB=S_Point
	Gosub Play
	Return

' ** Say the word 'DEGREES' **
Say_Degrees:
	PortB=S_Degrees
	Gosub Play
	Return

Play:
	Pause 50				' Give the ISD time to process its address lines
	High PLAYL				' Bring the PLAYL line high initially
@	Nop					' Wait 1us at 4mHz
	Low PLAYL				' Bring the PLAYL line low to trigger the ISD chip 
	While STROBE=1:Wend			' Wait for the message to finish
						' By polling for the low pulse from the REC_LED
						' pin of the ISD1416
	Return