' Program 4_MESGE.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Demonstration of the ISD1416 chipcorder device
' By speaking the 4 messages previously recorded.
' The messages are also displayed on a serial LCD
' ***********************************************************************

	Include "Modedefs.Bas"

' ** Setup the Crystal Frequency, in Mhz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Setup the Debug Defines **

	Define	DEBUG_REG	PortA		' Debug PortA
	Define	DEBUG_BIT	0		' *** Debug pin Bit-0 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 0=True, 1=Inverted
	Define	DEBUG_PACING	300		' Delay 'in Us' between characters sent

' ** Define LCD Constants **

	I		Con	254			' Control Byte
	Clr		Con	1			' Clear the display
	Line1		Con	128			' Point to beginning of line 1
	Line2		Con	192			' Point to beginning of line 2
	Line3		Con	148			' Point to beginning of line 3
	Line4		Con	212			' Point to beginning of line 4
	Cgram		Con	64			' Point to Cgram within LCD


' ** Assign the ISD1416 pins **
	STROBE		Var	PortA.1		' End of message line
	PLAYE		Var	PortA.2		' Pull low to play message, bring high to end
	PLAYL		Var	PortA.3		' Pulse to play complete message

' ** THE MAIN PROGRAM STARTS HERE **
	TrisB=0					' Make PortB an output
	TrisA.3=1				' Disconnect the PLAYE line

Main:	Debug I,Clr:Pause 30			' Clear the LCD
	PortB=0					' Clear PortB to point to message 1
	Debug I,Line1," Message 1"		' Display the message number
	Gosub Sayit				' Playback the message pointed to by PortB

	PortB=40				' Set PortB to point to message 2
	Debug I,Line1," Message 2"		' Display the message number
	Gosub Sayit				' Playback the message pointed to by PortB

	PortB=80				' Set PortB to point to message 3
	Debug I,Line1," Message 3"		' Display the message number
	Gosub Sayit				' Playback the message pointed to by PortB

	PortB=120				' Set PortB to point to message 4
	Debug I,Line1," Message 4"		' Display the message number
	Gosub Sayit				' Playback the message pointed to by PortB

	Pause 200
	Debug I,Line1," Finished "
	Pause 500
	Goto Main

Sayit:
	Pause 50				' Give the ISD time to process its address lines
	High PLAYL				' Bring the PLAYL line high initially
@	Nop					' Wait 1us at 4Mhz
	Low PLAYL				' Bring the PLAYL line low to trigger the ISD chip 
	While STROBE=1:Wend			' Wait for the message to finish
						' By polling for the low pulse from the REC_LED
						' pin of the ISD1416
	Return