' Program AD8402.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Interface to an AD8402 dual digital potentiometer.

' SW1	Controls Bass Down....PortB.3
' SW2	Controls Bass Up......PortB.4
' SW3	Controls Treble Down..PortB.5
' SW4	Controls Treble Up....PortB.6

' A serial LCD is connected to PortB.7 to display the Bass and Treble levels.
' ***********************************************************************

	Include "Modedefs.Bas"

' ** Setup the Crystal Frequency, in Mhz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Setup the Debug Defines **

	Define	DEBUG_REG	PortB		' Debug PortB
	Define	DEBUG_BIT	7		' *** Debug pin Bit-7 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 1=Inverted
	Define	DEBUG_PACING	300		' Delay 'in Us' between characters sent

' ** Declare the Variables **

	Percent		Var	Word		' The percent of the resistance
	P_Output	Var	Word		' Temporary variable used in POTOUT
	A1		Var	P_Output.9	' Address bit A1
	A0		Var	P_Output.8	' Address bit A0
	RDAC		Var	Byte		' Pointer to the internal RDAC's of the AD8402
	Treble		Var	Byte		' Holds the Treble level
	Bass		Var	Byte		' Holds the Bass level
	CLK		Var	PortB.0		' Serial clock pin of the AD8402
	SDI		Var	PortB.1		' Serial data pin of the AD8402
	CS		Var	PortB.2		' Enable/Disable pin of the AD8402
	SW1		Var	PortB.3		' Bass Down Switch
	SW2		Var	PortB.4		' Bass Up Switch
	SW3		Var	PortB.5		' Treble Down switch
	SW4		Var	PortB.6		' Treble Up switch

' ** Define LCD Constants **

	I		Con	254			' Control Byte
	Clr		Con	1			' Clear the display
	Line1		Con	128			' Point to beginning of line 1
	Line2		Con	192			' Point to beginning of line 2
	Line3		Con	148			' Point to beginning of line 3
	Line4		Con	212			' Point to beginning of line 4

' ** The main program starts here **

	Debug I,Clr:Pause 30			' Clear the LCD
	Debug I,Line1,"Treble  %",I,Line2,"Bass    %"
	Treble=50:Bass=50			' Set bass and treble to mid positions

Main:	Option_Reg.7=0				' Enable Internal PortB Pullup Resistors

	If SW1=0 then				' Check the Bass down switch
	If Bass >0 then Bass=Bass-1		' If all is OK then lower the Bass	
	Goto Disp_Bass				' Display and output the bass level
	Endif

	If SW2=0 then				' Check the Bass up switch
	If Bass <100 then Bass=Bass+1		' If all is OK then increase the Bass
	Goto Disp_Bass				' Display and output the bass level
	Endif

	If SW3=0 then				' Check the Treble down switch 
	If Treble >0 then Treble=Treble-1	' If all is OK then lower the Treble	
	Goto Disp_Treble			' Display and output the treble level
	Endif

	If SW4=0 then				' Check the Treble up switch
	If Treble <100 then Treble=Treble+1	' If all is OK then increase the Treble
	Goto Disp_Treble			' Display and output the treble level
	Endif
	Goto Main				' Go back to the start of the program

Disp_Treble:
	RDAC=2					' Point to RDAC 2 (Treble)
	Percent=Treble				' Place the treble level into percent
	Gosub Potout				' Output the Treble level
	Debug I,Line1+9,#Treble,"  " 		' Display the TREBLE level as a percentage
	Pause 200				' Debounce the switch
	Goto Main				' Go back to the start of the program

Disp_Bass:
	RDAC=1					' Point to RDAC 1 (Bass)
	Percent=Bass				' Place the bass level into percent
	Gosub Potout				' Output the Bass level
	Debug I,Line2+9,#Bass,"  " 		' Display the BASS level as a percentage
	Pause 200				' Debounce the switch
	Goto Main				' Go back to the start of the program

' Shift out the resistance percentage to the specified RDAC.
' The resistor percentage is held in PERCENT (0..100)
' The RDAC of interest is held in RDAC (1..4)
Potout: 
	P_Output=(Percent*255)/100		' Calculate the Percentage of 255

	If RDAC=1 then 				' Point to RDAC 1, by,
	A1=0:A0=0				' clearing A0 and A1
	Endif					
	If RDAC=2 then 				' Point to RDAC 2, by,
	A1=0:A0=1				' setting A0 and clearing A1 
	Endif
	If RDAC=3 then				' Point to RDAC 3, by, 
	A1=1:A0=0				' clearing A0 and setting A1
	Endif
	If RDAC=4 then				' Point to RDAC 4, by, 
	A1=1:A0=1				' setting A0 and A1
	Endif
	Low CS					' Enable the AD8402.
	Shiftout SDI,CLK,Msbfirst,[P_Output\10]	' Shift out the 10-bit word
	High CS					' Now disable the chip
	Return					' Exit the subroutine.