' Program AD8400.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
' Interface to an AD8400 digital potentiometer.
' Three buttons control the gain of an op-amp.

' SW1	Controls Gain Down....PortB.0
' SW2	Controls Gain Up......PortB.1
' SW3	Stores the current gain level in the internal Eeprom at location 0
' A serial LCD is connected to PortB.7 to display the Gain level.
' ***********************************************************************

	Include "Modedefs.Bas"

' ** Setup the Crystal Frequency, in Mhz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Setup the Debug Defines **

	Define	DEBUG_REG	PortB		' Debug PortB
	Define	DEBUG_BIT	7		' *** Debug pin Bit-7 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 1=Inverted
	Define	DEBUG_PACING	300		' Delay 'in Us' between characters sent

' ** Declare the Variables **

	CS		Var	PortB.5		' Enable/Disable pin of the AD8400
	Sdi		Var	PortB.4		' Serial data pin of the AD8400
	Clk		Var	PortB.3		' Serial clock pin of the AD8400
	SW1		Var	PortB.0		' Gain Down Switch
	SW2		Var	PortB.1		' Gain Up Switch
	SW3		Var	PortB.2		' Gain store switch
	Percent		Var	Word		' The percent of the resistance
	P_Output	Var	Word		' Temporary variable used in POTOUT

' ** The main program starts here **

	Debug I,Clr:Pause 30			' Clear the LCD
	Data 10					' Place the Gain value in Eeprom at location 0

	Read 0,Percent				' Initially read the value of percent (Gain)
Main:	Option_Reg.7=0				' Enable Internal PortB Pullup Resistors
	If SW1=0 and Percent >0 then		' Check the Gain down switch and if percent is in range
	Percent=Percent-1			' If all is OK then lower the Gain	
	Pause 150				' Debounce the switch
	Endif
	If SW2=0 and Percent <100 then		' Check the Gain up switch and if percent is in range
	Percent=Percent+1			' If all is OK then increase the Gain
	Pause 150				' Debounce the switch
	Endif
	If SW3=0 then				' Check the STORE switch
	Write 0,Percent				' If pressed then store the current value of percent in Eeprom
	Debug I,Line1,"Value Stored  "		' And display that you have	
	Pause 400				' Pause to enable the user to see that it has been stored
	Endif
	Debug I,Line1,"Percent %",#Percent,"    " ' Display the Gain level as a percentage
	Gosub Potout				' Output the Gain level
	Goto Main

Potout: 
	P_Output=(Percent*255)/100		' Calculate the Percentage of 255
	P_Output.8=0				' Clear the address bit A0
	P_Output.9=0				' Clear the address bit A1
	Low CS					' Enable the AD8400.
	Shiftout Sdi,Clk,Msbfirst,[P_Output\10]	' Shift out the 10-bit value
	High CS					' Now disable the chip
	Return					' Exit the subroutine.