' Program SAMPLING.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Ironing out the results of a noisy ADC conversion.
' By taking 10 results and averaging them out.

' For use only with the PIC16F87X range of PIC's

	Include "Modedefs.Bas"

' ** Setup the Crystal Frequency, in Mhz **

	Define 	OSC		20		' Set Xtal Frequency

' ** Setup the DEBUG Defines **

	Define	DEBUG_REG	PortC		' Debug PortC
	Define	DEBUG_BIT	7		' *** Debug pin Bit-7 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 1=Inverted
	Define	DEBUG_PACING	300		' Delay 'in Us' between characters sent

' ** Setup the ADCIN Defines **

	Define	ADC_BITS	10		' Set resolution of conversion
	Define	ADC_CLOCK	2		' Set clock source (x/FOSC or FRC)
	Define	ADC_SAMPLEUS	50		' Set sampling time (in uS)

' ** Define LCD Control Constants **

	I		Con	254		' Control Byte
	Clr		Con	1		' Clear the display
	Line1		Con	128		' Point to beginning of line 1
	Line2		Con	192		' Point to beginning of line 2
	Line3		Con	148		' Point to beginning of line 3
	Line4		Con	212		' Point to beginning of line 4
	Cgram		Con	64		' Point to Cgram within LCD

' ** Declare the Variables **

	AD_Raw		Var	Word		' 10-bit result of A/D conversion
	AD_Result	Var	Word		' Quantasized ADC result
	Average		Var	Word		' Variable for building up the average result
	Samples		Var	Byte		' Amount of samples taken
	Volts		Var	Byte		' Holds the Volts part of the result (only for display purposes)
	Millivolts	Var	Word		' Holds the Millivolts part of the result (only for display purposes)
	
'	quanta level = (5/1024) * 256 == 1250
	Quanta		Con	1250


' ** Define the bits within the ADCON1 register **

	ADFM		Var	ADCON1.7	' ADC result fotmat select bit
	PCFG3		Var	ADCON1.3	' ADC port configuration bit
	PCFG2		Var	ADCON1.2	' ADC port configuration bit
	PCFG1		Var	ADCON1.1	' ADC port configuration bit
	PCFG0		Var	ADCON1.0	' ADC port configuration bit

' ** THE MAIN PROGRAM STARTS HERE **

	Debug I,Clr:Pause 30			' Clear the LCD

	PCFG0=0
	PCFG1=1
	PCFG2=1
	PCFG3=1					' Configure for AN0 as analogue input

	ADFM=1					' Right justified result in ADRESL and ADRESH


Again:	Average=0				' Clear the Average variable befor use
	For Samples=0 to 9			' We will take 10 samples of the ADC
	ADCIN 0,AD_Raw				' Place the conversion of channel0 into AD_RAW
	Average=Average+AD_Raw			' Build up the Average result	
	Next					' Close the loop
	Average=Average/10			' Calculate the average by dividing by the number of samples taken
	AD_Result=(Average) */ Quanta		' Quantasize the result
	Debug I,Line1,#AD_Raw,"    "		' Display the RAW ADC result
	Volts= AD_Result/1000			' Calculate the Volts part of the result
	Millivolts=AD_Result//1000		' Calculate the Millivolts part of the result
	Debug I,Line2,#Volts,".",#Millivolts," Volts   " ' Display the actual voltage result
	Pause 200				' A small delay
	Goto Again				' Do it forever