' Program SLP_ADC.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
' Sample the On-Board ADC while the PIC is asleep.

' Disable the WatchDog Timer
@        Device wdt_off

	Include "Modedefs.Bas"

' ** Setup the Crystal Frequency, in Mhz **

	Define 	OSC		20		' Set Xtal Frequency

' ** Setup the DEBUG Defines **

	Define	DEBUG_REG	PortC		' Debug PortC
	Define	DEBUG_BIT	7		' *** Debug pin Bit-7 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 0=True, 1=Inverted
	Define	DEBUG_PACING	300		' Delay 'in Us' between characters sent

' ** Define LCD Control Constants **

	I		Con	254		' Control Byte
	Clr		Con	1		' Clear the display
	Line1		Con	128		' Point to beginning of line 1
	Line2		Con	192		' Point to beginning of line 2
	Line3		Con	148		' Point to beginning of line 3
	Line4		Con	212		' Point to beginning of line 4

' ** Declare the Variables **

	AD_Result	Var	Word		' 16-bit result of A/D conversion

' ** Define the bits within the ADCON0 register **
	ADCS1		Var	ADCON0.7	' ADC conversion clock select bit
	ADCS0		Var	ADCON0.6	' ADC conversion clock select bit
	CHS2		Var	ADCON0.5	' ADC channel select bit
	CHS1		Var	ADCON0.4	' ADC channel select bit
	CHS0		Var	ADCON0.3	' ADC channel select bit
	GO_DONE		Var	ADCON0.2	' ADC Conversion status/ plus enable conversion-bit
	ADON		Var	ADCON0.0	' ADC Enable bit: 1=enabled, 0=disabled.

' ** Define the bits within the ADCON1 register **
	ADFM		Var	ADCON1.7	' ADC result format select bit
	PCFG3		Var	ADCON1.3	' ADC port configuration bit
	PCFG2		Var	ADCON1.2	' ADC port configuration bit
	PCFG1		Var	ADCON1.1	' ADC port configuration bit
	PCFG0		Var	ADCON1.0	' ADC port configuration bit

	ADIE		Var	PIE1.6		' ADC interrupt enable/disable
	ADIF		Var	PIR1.6		' ADC interrupt flag
	PEIE		Var	INTCON.6	' Peripheral interrupt enable/disable
	GIE		Var	INTCON.7	' Global interrupt enable/disable

' ** THE MAIN PROGRAM STARTS HERE **

	Debug I,Clr:Pause 30			' Clear the LCD

	GIE=0					' Turn OFF global interrupts
	While GIE=1:GIE=0:Wend			' And make sure they are off

	PCFG0=0
	PCFG1=1
	PCFG2=1
	PCFG3=1					' Configure for AN0 as analogue input

	ADFM=1					' Right justified result in ADRESL and ADRESH

	CHS2=0
	CHS1=0
	CHS0=0					' Select AN0 for sampling

	ADCS1=1
	ADCS0=1					' Select FRC internal clock source

	ADON=1					' Enable the ADC module
	PEIE=1					' Enable peripheral interrupts
	ADIE=1					' Enable the ADC interrupt


Inf:	Pauseus 5              			' Wait for sample/hold capacitors to charge
	GO_DONE=1				' Start the conversion
@	Sleep  					' Low power mode        			
	AD_Result .lowbyte=ADRESL		' Place the LSB of result in lowbyte of AD_RESULT
	AD_Result .highbyte=ADRESH		' Place the MSB of result in highbyte of AD_RESULT
	Debug I,Line1,#AD_Result,"    "		' Display the result
	Pause 200				' A small delay
	Goto Inf				' Do it forever