' Program ADCIN.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Read a sample from the on-board ADC
' Using the compilers ADCIN command

	Include "Modedefs.Bas"

' ** Setup the Crystal Frequency, in mhz **

	Define 	OSC		20		' Set Xtal Frequency

' ** Setup the DEBUG Defines **

	Define	DEBUG_REG	PortC		' Debug PortC
	Define	DEBUG_BIT	7		' *** Debug pin Bit-7 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 0=True, 1=Inverted
	Define	DEBUG_PACING	300		' Delay 'in Us' between characters sent

' ** Setup the ADCIN Defines **

	Define	ADC_BITS	10		' Set resolution of conversion
	Define	ADC_CLOCK	2		' Set clock source (x/FOSC)
	Define	ADC_SAMPLEUS	10		' Set sampling time (in uS)

' ** Define LCD Control Constants **

	I		Con	254		' Control Byte
	Clr		Con	1		' Clear the display
	Line1		Con	128		' Point to beginning of line 1
	Line2		Con	192		' Point to beginning of line 2
	Line3		Con	148		' Point to beginning of line 3
	Line4		Con	212		' Point to beginning of line 4
	Cgram		Con	64		' Point to Cgram within LCD

' ** Declare the Variables **

	AD_Result	Var	Word		' 10-bit result of A/D conversion

' ** Define the bits within the ADCON1 register **

	ADFM		Var	ADCON1.7	' ADC result format select bit
	PCFG3		Var	ADCON1.3	' ADC port configuration bit
	PCFG2		Var	ADCON1.2	' ADC port configuration bit
	PCFG1		Var	ADCON1.1	' ADC port configuration bit
	PCFG0		Var	ADCON1.0	' ADC port configuration bit

' ** THE MAIN PROGRAM STARTS HERE **

	Debug I,Clr:Pause 30			' Clear the LCD

	PCFG0=0
	PCFG1=1
	PCFG2=1
	PCFG3=1					' Configure for AN0 as analogue input

	ADFM=1					' Right justified result in ADRESL and ADRESH


Inf:	ADCIN 0,AD_Result			' Place the conversion of channel0 into AD_RESULT
	Debug I,Line1,#AD_Result,"    "		' Display the result
	Pause 200				' A small delay
	Goto Inf				' Do it forever