' Program MAX187I.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Read a voltage  on a MAX187 A/D converter using its internal VREF (0 to 4.096Volts)
' and display the result on a serial LCD set for Inverted 9600 baud
' This program uses a 3 wire interface with the MAX187

' The Demonstration circuit has a 10K pot from Vdd to Gnd 
' with the centre Wiper going to the input of the MAX187.

' MAX187 pin connections: -

' DOUT  (Serial data out,   PORTB.2)
' CS    (Active-low select, PORTB.1)
' SCLK  (Serial clock line, PORTB.0)
' ***********************************************************************

	Include "Modedefs.Bas"

' ** Setup Crystal Frequency in mhz **

	Define 	OSC		4			' Set Xtal Frequency

' ** Setup Debug Defines **

	Define	DEBUG_REG	PortA			' Debug PortA
	Define	DEBUG_BIT	0			' *** Debug pin Bit-0 ***
	Define	DEBUG_BAUD	9600			' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1			' Set Serial Mode Inverted
	Define	DEBUG_PACING	500			' Delay 'in Us' between characters sent

' ** Declare the variables **

	Max_Val		Var	Word			' 12 bit ADC result
	Volts     	Var 	Byte			' Volts variable
	Millivolts     	Var 	Word			' Millivolts variable
	Sclk  		Var 	PortB.0			' MAX187 serial clock input
	Cs    		Var 	PortB.1			' MAX187 chip select line
	Dout   		Var 	PortB.2			' MAX187 serial data output

' ** Declare Constants **

	I		Con	254	  		' Control byte for LCD
	Clr		Con	1	  		' Code to clear the LCD
	Line1		Con	128	  		' Point to Line 1 of the LCD
	Line2		Con	192	  		' Point to Line 2 of the LCD

' ** The Main program starts here **

	Pause 500					' Wait for Pic to Initialize
	Debug I,Clr:Pause 30				' Clear the LCD

Main:	Gosub MAX187_In					' Go and do a sample
	Volts= Max_Val/1000				' Split off the volts 
	Millivolts= Max_Val //1000				' Split off the millivots 
	Debug I,Line1,dec1 Volts,".",dec3 Millivolts," Volts"	' Display the Volts.Millivolts
	Goto Main						' Do it forever

' This subroutine aquires a sample from the MAX187.
' And returns with the voltage in the variable "MAX_VAL" 
MAX187_In:
	Max_Val=0
	Low Cs						' Activate the MAX187
	Shiftin Dout,Sclk,Msbpost,[Max_Val\12]		' Clock 12 bits into "Max_Val"
	High Cs						' Deactivate the MAX187
	Return						' Exit the subroutine



