' Program MAX187E.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Read a voltage a MAX187 A/D converter using an external VREF connected to Vdd (5Volts)
' and display the result on a serial LCD set for Inverted 9600 baud
' This program uses a 3 wire interface with the MAX187

' The Demonstration circuit has a 10K pot from Vdd to Gnd 
' with the centre Wiper going to the input of the MAX187.

' MAX187 pin connections: -

' DOUT  (Serial data out,   PORTB.2)
' CS    (Active-low select, PORTB.1)
' SCLK  (Serial clock line, PORTB.0)
' ***********************************************************************

	Include "Modedefs.Bas"

' ** Setup Crystal Frequency in mhz **

	Define 	OSC		4			' Set Xtal Frequency

' ** Setup Debug Defines **

	Define	DEBUG_REG	PortA			' Debug PortA
	Define	DEBUG_BIT	0			' *** Debug pin Bit-0 ***
	Define	DEBUG_BAUD	9600			' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1			' Set Serial Mode Inverted
	Define	DEBUG_PACING	500			' Delay 'in Us' between characters sent

' ** Declare the variables **

	Max_Val		Var	Word			' 12 bit ADC result
	Volts     	Var 	Byte			' Volts variable
	Millivolts     	Var 	Word			' Millivolts variable
	Sclk  		Var 	PortB.0			' MAX187 serial clock input
	Cs    		Var 	PortB.1			' MAX187 chip select line
	Dout   		Var 	PortB.2			' MAX187 serial data output

' ** Declare the constants **

	I		Con	254	  		' Control byte for LCD
	Clr		Con	1	  		' Code to clear the LCD
	Line1		Con	128	  		' Point to Line 1 of the LCD
	Line2		Con	192	  		' Point to Line 2 of the LCD
	Quanta		Con	123	 		' Quanta level for 5 volts into 12-bits

' ** The Main program starts here **

	Pause 500					' Wait for Pic to Initialize
	Debug I,Clr:Pause 30				' Clear the LCD

Main:	Gosub MAX187_In					' Go and do a sample
	Volts= Max_Val/10000				' Split off the volts
	Millivolts= Max_Val //10000				' Split off the millivolts
	Debug I,Line1,dec1 Volts,".",dec4 Millivolts," Volts"	' Display the Volts.Millivolts
	Goto Main						' Do it forever

' This subroutine aquires a sample from the MAX187.
' And returns with the voltage in the variable "MAX_VAL" 
MAX187_In:
	Max_Val=0
	Low Cs						' Activate the MAX187
	Shiftin Dout,Sclk,Msbpost,[Max_Val\12]		' Clock the 12 bits into "Max_Val"
	High Cs						' Deactivate the MAX187

' Take your 0 to 5 volts, and divide it by 4096, this is the quanta level.
' 5 / 4096 = .0012207 round it up and multiply it by 100000 to 123
' take what ever your A-D RESULT value is, divide it by 10 and multiply by 123
' A/D "RESULT" value of 102 * 123 = 12648 / 10000 = 1.2648 volts
' We need to calculate with the biggest numbers that the compiler can handle
' This will give more accuracy.

	Max_Val=(Max_Val/10)*Quanta
	Return						' Exit the subroutine



