' Program MAX186I.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Read a voltage from any of the inputs from a MAX186 A/D converter
' and display the result on a serial LCD set for Inverted 9600 baud

' The Demonstration circuit has a 10K pot from Vdd to Gnd with the centre Wiper going to CH0.
' MAX186 pin connections: -

' DOUT  (AD conversion serial output, PORTB.3)
' SSTRB (Conversion status flag, Optional Connection)
' DIN   (Command serial input, PORTB.2)
' CS    (Active-low select, PORTB.1)
' SCLK  (Serial clock line, PORTB.0)
' ***********************************************************************

	Include "Modedefs.Bas"

' ** Setup Crystal Frequency in Mhz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Setup Debug Defines **

	Define	DEBUG_REG	PortA		' Debug PortA
	Define	DEBUG_BIT	0		' *** Debug pin Bit-0 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode Inverted
	Define	DEBUG_PACING	500		' Delay 'in Us' between characters sent

' ** Declare the variables **

	Max_Val		Var	Word			' 12 bit ADC result
	Cntrl		Var	Byte			' Control byte for MAX186
	Max_Ch		Var	Byte			' Analog input channel
	Max_Temp	Var	Byte			' Temporary variable used by the MAX186 subroutine
	V     		Var 	Byte			' Volts variable
	Mv     		Var 	Word			' Millivolts variable

	Sclk  		Var 	PortB.0			' MAX186 serial clock input
	Cs    		Var 	PortB.1			' MAX186 chip select line
	Din   		Var 	PortB.2			' MAX186 serial data input
	Dout  		Var 	PortB.3			' MAX186 serial data
	SSTRB		Var	PortB.4			' MAX186 conversion status flag,(OPTIONAL)

' ** Define LCD Constants **

	I		Con	254			' Control Byte
	Clr		Con	1			' Clear the display
	Line1		Con	128			' Point to beginning of line 1
	Line2		Con	192			' Point to beginning of line 2
	Line3		Con	148			' Point to beginning of line 3
	Line4		Con	212			' Point to beginning of line 4
	Cgram		Con	64			' Point to Cgram within LCD
	Shift_L		Con	24			' Shift display left
	Shift_R		Con	28			' Shift display right

' ** The Main program starts here **

	Pause 500					' Wait for Pic to Initialize
	Debug I,Clr:Pause 30				' Clear the LCD
Main:
	Max_Ch=0					' Point to Channel 0 of the MAX186
	Gosub Max186_In					' Go and do a sample
	V= Max_Val/1000					' Split off the volts by dividing by 1000
	Mv= Max_Val //1000				' Split off the millivots by dividing by 1000
	Debug I,Line1,"Max_Val= ",#Max_Val,"   "
	Debug I,Line2,#V,".",dec3 Mv," Volts"		' Display the Volts.Millivolts
	Goto Main					' Do it forever

' This subroutine returns the value of the voltage on any of the 7 inputs of the MAX186.
' Before calling, Tha channel to read from is loaded into "MAX_CH".
' "MAX_VAL" returns with the voltage  
Max186_In:
	Max_Val=0
	Max_Temp=Max_Ch					' Save the Value of "Max_Ch"
	Lookup Max_Ch,[0,64,16,80,32,96,48,112],Max_Ch
	Cntrl=%10001110 | Max_Ch			' "OR" in the Channel bits
	Low Cs						' Activate the MAX186
	Shiftout Din,Sclk,Msbfirst,[Cntrl\8]		' Clock out the Control byte
' ** The next line is optional **, if the SSTRB pin is used, then Uncomment the line
'Eoc:	If SSTRB=0 then Eoc				' Wait for end of conversion
	Shiftin Dout,Sclk,Msbpost,[Max_Val\12]		' Clock 12 bits into "Max_Val"
	High Cs						' Deactivate the MAX186
	Max_Ch=Max_Temp					' Restore the value of "Max_Ch"
	Return						' Exit the subroutine



