' Program MAX186E.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Read the voltage on any of the inputs of a MAX186 A/D converter
' With an external VREF
' and display the result on a serial LCD set for Inverted 9600 baud
' The Demonstration circuit had a 10K pot from Vdd to Gnd with the centre Wiper going to CH0.
' MAX186 pin connections for this program.
' SHDN  (Shutdown input, tied to Vdd)
' DOUT  (AD conversion serial output, PORTB.3)
' SSTRB (Conversion status flag, Optional Connection)
' DIN   (Command serial input, PORTB.2)
' CS    (Active-low select, PORTB.1)
' SCLK  (Serial clock line, PORTB.0)
' ***********************************************************************

	Include "Modedefs.Bas"

' ** Setup Crystal Frequency in mhz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Setup Debug Defines **

	Define	DEBUG_REG	PortA		' Debug PortA
	Define	DEBUG_BIT	0		' *** Debug pin Bit-0 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode Inverted
	Define	DEBUG_PACING	500		' Delay 'in Us' between characters sent

' ** Declare Variables **

	Max_Val		Var	Word			' 12 bit ADC result
	Cntrl		Var	Byte			' Control byte for MAX186
	Max_Ch		Var	Byte			' Analog input channel
	Max_Temp	Var	Byte			' Temporary variable used by the MAX186 subroutine
	V     		Var 	Byte			' Volts variable
	MV     		Var 	Word			' Millivolts variable

	Sclk  		Var 	PortB.0			' MAX186 serial clock input
	Cs    		Var 	PortB.1			' MAX186 chip select line
	Dta   		Var 	PortB.2			' MAX186 serial data input

' ** Define LCD Constants **

	I		Con	254			' Control Byte
	Clr		Con	1			' Clear the display
	Line1		Con	128			' Point to beginning of line 1
	Line2		Con	192			' Point to beginning of line 2
	Line3		Con	148			' Point to beginning of line 3
	Line4		Con	212			' Point to beginning of line 4
	Cgram		Con	64			' Point to Cgram within LCD
	Shift_L		Con	24			' Shift display left
	Shift_R		Con	28			' Shift display right

' ** The Main program starts here **

	Pause 500					' Wait for Pic to Initialize
	Debug I,Clr:Pause 30				' Clear the LCD
Main:
	Max_Ch=0					' Point to Channel 0 of the MAX186
	Gosub Max186_In					' Go and do a sample
	V= Max_Val/10000				' Split off the volts by dividing by 10000
	Max_Val=Max_Val/10				' Make it more manageable
	Mv= Max_Val //1000				' Split off the millivots by dividing by 1000
	Debug I,Line1,#V,".",dec3 Mv," Volts"		' Display the Volts.Millivolts
	Goto Main					' Do it forever

Max186_In:
	Max_Val=0
	Max_Temp=Max_Ch					' Save the Value of "Channel"
	Lookup Max_Ch,[0,64,16,80,32,96,48,112],Max_Ch
	Cntrl=%10001110 | Max_Ch			' "OR" in the Channel bits
	Low Cs						' Activate the MAX186
	Shiftout Dta,Sclk,Msbfirst,[Cntrl\8]		' Clock out the Control byte
	Shiftin Dta,Sclk,Msbpost,[Max_Val\12]		' Clock 12 bits into "Result"
	High Cs						' Deactivate the MAX186
	Max_Ch=Max_Temp					' Restore the value of "Channel"
' Take your 0 to 5 volts, and divide it by 4096
' 5 / 4096 = .0012207 round it up and multiply it by 100000 to 123
' take what ever your A-D RESULT value is, divide it by 10 and multiply by 12
' A/D "RESULT" value of 102 * 123 = 12648 / 10000 = 1.2648 volts
' We need to calculate with the biggest numbers that the compiler can handle
' This will give more accuracy.

	Max_Val=(Max_Val/10)*123
	Return						' Exit the subroutine



