' Program MAX186-2.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' This program uses a different calculation for the Quanta level.

' The Demonstration circuit had a 10K pot from Vdd to Gnd with the centre Wiper going to CH0.
' MAX186 pin connections for this program.
' SHDN  (Shutdown input, tied to Vdd)
' DOUT  (AD conversion serial output, PORTB.3)
' SSTRB (Conversion status flag, Optional Connection)
' DIN   (Command serial input, PORTB.2)
' CS    (Active-low select, PORTB.1)
' SCLK  (Serial clock line, PORTB.0)
' ***********************************************************************

	Include "Modedefs.Bas"

' ** Setup Crystal Frequency in mhz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Setup Debug Defines **

	Define	DEBUG_REG	PortA		' Debug PortA
	Define	DEBUG_BIT	0		' *** Debug pin Bit-0 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode Inverted
	Define	DEBUG_PACING	500		' Delay 'in Us' between characters sent

' ** Declare Variables **

	Result		Var	Word			' 12 bit ADC result
	Control		Var	Byte			' Control byte for MAX186
	Channel		Var	Byte			' Analog input channel
	Max_Temp	Var	Byte			' Temporary variable used by the MAX186 subroutine
	V     		Var 	Byte			' Volts variable
	MV     		Var 	Byte			' Millivolts variable
	V2		Var	Word
	V3		Var	byte

	Sclk  		Var 	PortB.0			' MAX186 serial clock input
	Cs    		Var 	PortB.1			' MAX186 chip select line
	Dta   		Var 	PortB.2			' MAX186 serial data input

' ** Define LCD Constants **

	I		Con	254			' Control Byte
	Clr		Con	1			' Clear the display
	Line1		Con	128			' Point to beginning of line 1
	Line2		Con	192			' Point to beginning of line 2
	Line3		Con	148			' Point to beginning of line 3
	Line4		Con	212			' Point to beginning of line 4
	Cgram		Con	64			' Point to Cgram within LCD
	Shift_L		Con	24			' Shift display left
	Shift_R		Con	28			' Shift display right

' ** The Main program starts here **

	Pause 500					' Wait for Pic to Initialize
	Debug I,Clr:Pause 30				' Clear the LCD
Main:
	Channel=0					' Point to Channel 0 of the MAX186
	Gosub Max186					' Go and do a sample
	Debug I,Line2,#(V*1000)+(Mv*10)
	Debug I,Line1,#V,".",dec2 Mv'," Volts     "	' Display the Volts.Millivolts
	Goto Main					' Do it forever

Max186:
	Result=0
	Max_Temp=Channel				' Save the Value of "Channel"
	Lookup Channel,[0,64,16,80,32,96,48,112],Channel
	Control=%10001110 | Channel			' "OR" in the Channel bits
	Low Cs						' Activate the MAX186
	Shiftout Dta,Sclk,Msbfirst,[Control\8]		' Clock out the Control byte
	Shiftin Dta,Sclk,Msbpost,[Result\12]		' Clock 12 bits into "Result"
	High Cs						' Deactivate the MAX186
	Channel=Max_Temp				' Restore the value of "Channel"
	V=(Result*5)/4096
	V2=(Result*5)//4096

	Mv=(10*V2)/410
	V2=(10*V2)//410
	V2=(v2*100)/410
	If V2>5 then Mv=Mv+1 
	If Mv<100 then Return
	V=V+1
	Mv=0
	Return						' Exit the subroutine



