' Program MAX127_5.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Read the 0 to 5v voltage on any of the inputs of a MAX127 A/D converter
' The channel of interest is first loaded into the variable "MAX_CH",
' then a call is made to the subroutine "MAX127_IN"
' this returns with the voltage (in mv) held in the variable "MAX_VAL"
' The Demonstration circuit had a 10K pot from Vdd to Gnd with the centre Wiper going to CH0.
' MAX127 pin connections for this program.
' SHDN  (Shutdown input, tied to Vdd)
' SCL   (Clock line for the I2C bus, PORTB.0)
' SDA   (Data line for the I2C bus, PORTB.1)
' ***********************************************************************

	Include "Modedefs.Bas"

' ** Setup Crystal Frequency in mHz **

	Define 	OSC		4			' Set Xtal Frequency

' ** Setup Debug Defines **

	Define	DEBUG_REG	PortA			' Debug PortA
	Define	DEBUG_BIT	0			' *** Debug pin Bit-1 ***
	Define	DEBUG_BAUD	9600			' *** Debug Baud Rate 9600***
	Define	DEBUG_MODE	1			' Set Serial Mode Inverted
	Define	DEBUG_PACING	500			' Delay 'in Us' between characters sent

	Define	I2C_SCLOUT	1			' No need for the pullup resistor on SCL pin

' ** Declare the Variables **

	Scl 		Var 	Portb.0			' Clock Line for the I2C bus
	Sda 		Var 	Portb.1			' Data Line for the I2C bus
	Max_Val		Var	Word			' 12 bit ADC result
	Max_Ch		Var	Byte			' Analog input channel
	Max_Temp	Var	Byte			' Temporary variable used by the MAX127_In.
	V     		Var 	Byte			' Volts variable
	Mv     		Var 	Word			' Millivolts variable

' ** Declare the constants **

	Sl_Addr		Con	%01010000		' Chip address on the I2C bus
	I		Con	254	  		' Control byte for LCD
	Clr		Con	1	  		' Code to clear the LCD
	Line1		Con	128	  		' Point to Line 1 of the LCD
	Line2		Con	192	  		' Point to Line 2 of the LCD
	Quanta		Con	123	 		' Quanta level for 5 volts full scale


' ** The Main Program starts here **

	Debug I,Clr:Pause 30				' Clear the LCD
Loop:	Max_Ch=0					' Point to Channel 0 of the MAX127
	Gosub Max127_In					' Go and do a sample
	V= Max_Val/10000				' Split off the volts
	Mv= Max_Val //10000				' Split off the millivots
	Debug I,Line1,dec1 V,".",dec4 Mv," Volts"	' Display the Volts.Millivolts
	Goto Loop					' Do it forever

' This subroutine aquires a sample from the MAX127.
' The channel of interest is first loaded into the variable "MAX_CH" (0-7)
' The subroutine returns with the voltage in the variable "MAX_VAL" 
Max127_In:
	Max_Val=0
	Max_Temp=Max_Ch					' Save the value of Max_Ch
	Max_Ch=(Max_Ch << 4)				' Place the channel SEL-bits into position
	Max_Ch.7=1					' Set the Start bit of the control byte
	I2cwrite Sda,Scl,Sl_Addr,[Max_Ch] 		' Send the control byte and start conversion
	I2Cread Sda,Scl,Sl_Addr,[Max_Val]		' Read in the 12-bit voltage
 	Max_Val = Max_Val >> 4				' Shift data to the right 4 places
	Max_Val=(Max_Val/10)*Quanta			' Calculate the actual voltage
	Max_Ch=Max_Temp					' Restore Max_Ch 
	Return