' This program demonstrates how to generate horizontal bar
' graphs with the PicBasic Pro compiler and a Serial LCD Display.
' Connect the display SER input to PortA Bit 0.
' Set Baud switch on the display for N9600-baud operation. 
'
' The original bargragh code was written by Scott Edwards.
' However it would not compiler using the PICBASIC PRO
' Therefore, it has been modified.

' ** Declare Variables **
	Bar_Val	Var	Word			' Value to be graphed. 
	Bars	Var	Byte			' Number of full ||| bars to draw.
	Bal	Var	Byte			' Balance left after all |||s drawn.
	Pad	Var	Byte			' Number of spaces to pad to fill width.
	Balf	Var	Byte			' Is a 'bal' character needed? (1=yes, 0=no).

' These variables are never used in the main program, 
' they are defined as aliases of the main variables. 
' This prevents wasting 3 bytes of RAM. 

	B_Cnt	Var 	Bars			' Counter (0-15) for EEPROM/bit pat load. 
	B_Row	Var	Bal			' Row of bit pattern. 
	B_Chr	Var 	Pad			' Bit pattern read from EEPROM. 

' ** Declare Constants **
	B_Wdth	Con	16			' Max width in characters of bar.
	Maxbar	Con	B_Wdth * 3		' Max bar counts. 
	Fulbar	Con	3			' ASCII value of ||| bar. 
	Basbar	Con	0			' ASCII value of 0 bar (blank).
	I	Con	254
	Cgram	Con	64

' Transfer the bit patterns that make up the bars. Since
' vertical bars are made up of 8 identical bit patterns (e.g., 
' a | bar consists of %10000, %10000, %10000...%10000), we save 
' some program memory by repeating each pattern from a lookup table 8 times. 
 
	Debug I,Cgram				' Point to character-generator RAM. 
	For B_Cnt = 0 to 3 
  	Lookup B_Cnt,[0,%10000,%10100,%10101],B_Chr ' Get the bit pattern.  
  	For B_Row = 0 to 7
    	Debug B_Chr				' Write the pattern to LCD CG RAM. 
  	Next					' ..row
	Next					' ..Chr pattern

	Goto Over_Bargraph			' Jump over the subroutine

' BARGRAPH: Take the value in 'Bar_Val' and present it as a 
' horizontal bar graph from the current cursor location with a 
' total width (in characters) set by the WIDTH constant. Each 
' character position can represent a maximum value of 3 using 
' the FULBAR character |||. The routine calculates how many full 
' bars to use by dividing by 3. If there's a remainder after 
' dividing by 3, the routine tacks on a partial-bar character
' ( | or ||) to represent the balance('bal'). Finally, it pads  
' the remainder of the bar width with blank spaces in order to 
' erase any leftovers from previous graphs. 
Bargraph:
  	Bars = (Bar_Val min Maxbar)/3		' One full bar for each 3 graph units.
  	Bal = (Bar_Val min Maxbar) // 3		' Bal is remainder after division by 3. 
	Balf = Bal min 1			' If bal <> 0 then balF=1. 
  	Pad = B_Wdth-(Bars+Balf)		' Number of spaces to fill bar width.
	Debug Rep Fulbar\Bars,Rep (Bal+Basbar)\Balf,Rep " " \Pad
	Return

Over_Bargraph: