'***************************************************************************
'*  Name    : AM2302_LIB.BAS                                               *
'*  Author  : Ken Buckner & Malcolm Crabbe                                 *
'*  Notice  :                                                              *
'*  Date    : 4/18/2015                                                    *
'*  Version : 0.24 (Branch from v0.14 : v0.22)                             *
'*  Notes   : Library for communicating with the AM2302(DHT22)             *
'*          :  Humidity/Temperature sensor using the PBP "PulsIn" command. *
'*          :                                                              *
'*          : Autocalculates the correct target pulsewidth counts for      *
'*          :  Sensor Initialization sequence timeout and                  *
'*          :  Humidity/Temperature reading values for binary data.        *
'*          :  Uses "DEFINE OSC" statement in the user's main PBP program  *
'*          :  to calculate pulswidth counts for all PBP OSC values.       *
'*          :                                                              *
'*          :                                                              *
'*          :                                                              *
'*          :                                                              *
'*  Usage   : Include this file with "include AM2302_LIB.BAS" statement.   *
'*          : Use the "gosub AM2302_Read" statement in your main           *
'*          : program.                                                     *
'*          :   e.g.                                                       *
'*          :     AM2302_Sensor_Num = 1 'Select Sensor 1                   *
'*          :     gosub AM2302_Read                                        *
'*          :                                                              *
'*  Inputs  : AM2302_Sensor_Num - Sensor number 1 to 4 which selects an    *
'*          :   Alias from your MAIN program that points to a              *
'*          :   PIC pin attached to a AM2302 sensor data pin.              *
'*          :                                                              *
'*  Outputs : AM2302_Err       (byte) - Sensor error codes                 *
'*          :                                                              *
'*          : AM_2302_Hum      (word) - Humidity Integral & decimal place  *
'*          :                   e.g. 652 ($028C) = 65.2% RH                *
'*          :                                                              *
'*          : AM_2302_Temp     (word) - Temperature Integral & decimal place
'*          :                   e.g. 351 ($015F) = 35.1 degC               *
'*          :                                                              *
'*          : AM_2302_Checksum (byte) - Sensor data payload checksum       *
'*          :                                                              *
'***************************************************************************

'---------------------------------------------------------------------------
'-- Place a copy of these variables/constants/defines in your Main program -
'-- BEFORE YOUR "INCLUDE AM2302_LIB.BAS" STATEMENT                        --
'--   Do Not un-comment these lines in the "AM2302_LIB.BAS" file.         --
'---------------------------------------------------------------------------
'-- In your Main program, uncomment and Assign the correct port alias     --
'--  to each of the "AM2302_Sensor_x" lines below.                        --
'--                                                                       --
'AM2302_Sensor_1 var PORTA.1 ' Assign Sensor #1 Alias
'AM2302_Sensor_2 var PORTA.1 ' Assign Sensor #2 Alias
'AM2302_Sensor_3 var PORTA.1 ' Assign Sensor #3 Alias
'AM2302_Sensor_4 var PORTA.1 ' Assign Sensor #4 Alias

'-- In your Main program, uncomment and Assign the correct value to       --
'--  the AM_2302_MAX_SENSORS constant below.                              --
'AM2302_MAX_SENSORS CON 4    ' Number of Sensors Configured

'-- In your Main program, uncomment and Assign the correct value to       --
'--  the DEFINE OSC statement below.                                      --
'DEFINE OSC 40                ' **CHANGE TO CORRECT OSC FREQUENCY**
                         ' ** "DEFINE OSC" IS CASE SENSITIVE (UPPERCASE) **

'-- In your Main program, uncomment the correct DEFINE PULSIN_MAX line    --
'--  below for your OSC value.                                            --
'DEFINE PULSIN_MAX 45   ' 3Mhz OSC
'DEFINE PULSIN_MAX 50   ' 4Mhz OSC 
'DEFINE PULSIN_MAX 100  ' 8Mhz OSC 
'DEFINE PULSIN_MAX 125  ' 10Mhz OSC 
'DEFINE PULSIN_MAX 150  ' 12Mhz OSC 
'DEFINE PULSIN_MAX 200  ' 16Mhz OSC 
'DEFINE PULSIN_MAX 250  ' 20Mhz OSC 
'DEFINE PULSIN_MAX 300  ' 24Mhz OSC 
'DEFINE PULSIN_MAX 313  ' 25Mhz OSC 
'DEFINE PULSIN_MAX 400  ' 32Mhz OSC 
'DEFINE PULSIN_MAX 413  ' 33Mhz OSC 
'DEFINE PULSIN_MAX 500  ' 40Mhz OSC 
'DEFINE PULSIN_MAX 600  ' 48Mhz OSC 
'DEFINE PULSIN_MAX 800  ' 64Mhz OSC 
'---------------------------------------------------------------------------

'---------------------------------------------------------------------------
'-- INSTRUCTIONS                                                          --
'-- To REMOVE SENSORS perform the following:                              --
'--   1. Change the "AM2302_MAX_SENSORS" constant to the correct number.  --
'--   2. Comment out the appropriate "AM2302_Sensor_x" Alias lines.       --
'--   3. In the "AM2302_Read" subroutine in the library file,             --
'--      edit the "select case AM2302_Sensor_Num" block, comment out the  --
'--      "Case x" portion for the sensor number you want to remove.       --
'--   4. Comment out the entire "AM_Readx" subroutine at the end          --
'--      of this library file for the sensor you want to remove.          --
'--                                                                       --
'-- To ADD SENSORS perform the following:                                 --
'--   1. Change the "AM2302_MAX_SENSORS" constant to the correct number   --
'--   2. Add a New "AM2302_Sensor_x" Alias line below where the           --
'--         "_x" portion is a new number.                                 --
'--   3. In the "AM2302_Read" subroutine in the library file,             --
'--      edit the "select case AM2302_Sensor_Num" block, add a new        --
'--      "Case x" portion for the sensor number you want to add.          --
'--   4. Add a New "AM_Readx" subroutine at the end of this library file  --
'--         for the new sensor.                                           --
'--                                                                       --
'---------------------------------------------------------------------------
                             
                             
AM2302_Sensor_Num  var byte     ' Variable to select which Sensor to read
AM2302_Init_Data   var byte     ' Holds Init response pulse counts
AM2302_Data        var byte[40] ' Byte array to hold data from sensor
AM2302_Hum         var word     ' Humidity value, integral & decimal place
AM2302_Temp        var word     ' Temperature value, integral & decimal place degC    
AM2302_Checksum    var byte     ' Checksum of payload data from sensor
AM_Tchk            var byte     ' Test Checksum
AM2302_Err         var byte     ' Bitfield to hold AM2302 Read Errors
                                    ' b7 = unused
                                    ' b6 = Checksum Timeout Error
                                    ' b5 = Invalid Sensor Number
                                    ' b4 = Checksum Error
                                    ' b3 = Temperature Read Error
                                    ' b2 = Humidity Read Error
                                    ' b1 = Initialization Error
                                    ' b0 = Timeout Error
                            

                            ' AM2302_Init_TO & AM2302_Val1 are automatically
                            '  calculated at compile time.  Calculations are
                            '  based upon "DEFINE OSC" command in main program.
AM2302_Init_TO CON EXT      ' Timeout Count from PulsIn for Init sequence
AM2302_Val1    CON EXT      ' Count from PulsIn to recognize a "1"
PulsinCountMax con EXT      ' Used for debugging
MyFreq         con EXT      ' Used for debugging

Init_High_1    con 20
Init_Low_1     con 20
Init_High_2    con 40
                            
j              var byte     ' Generic counter
k              var byte     ' Generic counter

'** Aliases**
AM_TIMEOUT_ERROR    var AM2302_Err.0
AM_INIT_ERROR       var AM2302_Err.1
AM_HUM_ERROR        var AM2302_Err.2
AM_TEMP_ERROR       var AM2302_Err.3
AM_CHK_ERROR        var AM2302_Err.4
AM_SENSORNUM_ERROR  var AM2302_Err.5
AM_CHK_TO_ERROR     var AM2302_Err.6    
    

'**Assembly statements to calculate Init Timeout and "1" values**
   ' AM2302_Init_TO Count calculated for target 20us
   ' AM2302_Val1 Count calculated for target 36us
   ' PULSIN_MAX calculated for ~500us
asm
#DEFINE ENABLE_AM_MSG 1
    IF OSC == 3
AM2302_Init_TO = 2
AM2302_Val1 = 3
    EndIF    
    IF OSC == 4
AM2302_Init_TO = 2
AM2302_Val1 = 4
    EndIF    
    IF OSC == 8
AM2302_Init_TO = 4
AM2302_Val1 = 7
    EndIF    
    IF OSC == 10
AM2302_Init_TO = 5
AM2302_Val1 = 9
    EndIF    
    IF OSC == 12
AM2302_Init_TO = 6
AM2302_Val1 = 11
    EndIF    
    IF OSC == 16
AM2302_Init_TO = 8
AM2302_Val1 = 14
    EndIF    
    IF OSC == 20
AM2302_Init_TO = 10
AM2302_Val1 = 18
    EndIF    
    IF OSC == 24
AM2302_Init_TO = 12
AM2302_Val1 = 22
    EndIF    
    IF OSC == 25
AM2302_Init_TO = 13
AM2302_Val1 = 23
    EndIF    
    IF OSC == 32
AM2302_Init_TO = 16
AM2302_Val1 = 29
    EndIF    
    IF OSC == 33
AM2302_Init_TO = 17
AM2302_Val1 = 30
    EndIF    
    IF OSC == 40
AM2302_Init_TO = 20
AM2302_Val1 = 36
    EndIF    
    IF OSC == 48
AM2302_Init_TO = 24
AM2302_Val1 = 43
    EndIF    
    IF OSC == 64
AM2302_Init_TO = 32
AM2302_Val1 = 58
    EndIF
PulsinCountMax = PULSIN_MAX
MyFreq = OSC
    IF (ENABLE_AM_MSG == 1)
        messg PulsIn Settings set to "OSC" #v(OSC) values
        messg "AM2302_Init_TO":#v(AM2302_Init_TO), "AM2302_Val1":#v(AM2302_Val1), "PULSIN_MAX":#v(PULSIN_MAX)
    ENDIF
endasm


goto overAM2302

  '*****************************
  '**Start of Library Routines**
  '*****************************

AM2302_Read:
    AM2302_Init_Data = 0    ' Clear the Init response byte
    AM2302_Err = 0          ' Clear all errors
    AM2302_Hum = 0          ' Clear the Humidity value
    AM2302_Temp = 0         ' Clear the Temperature value
    AM2302_Checksum = 0     ' Clear the Checksum value
    AM_Tchk = 0             ' Clear the Temp checksum value
    for j = 0 to 39
        AM2302_Data[j] = 0  ' Clear the Raw Sensor data array    
    next j
    
'  '  if AM2302_Sensor_Num = 0 or AM2302_Sensor_Num > AM2302_MAX_SENSORS then
'        AM_SENSORNUM_Error = 1  ' Not a valid sensor number
'       return  ' Return to Main Program  
'    endif
       
'****************************************************************************
'*** EDIT THIS SELECT CASE BLOCK TO ADD/REMOVE SENSORS (see instructions) ***
'****************************************************************************
    select case AM2302_Sensor_Num
        case 1           'Sensor #1      
            gosub Read_AM1
'        case 2           'Sensor #2
'            gosub Read_AM2
'        case 3           'Sensor #2
'            gosub Read_AM3
'        case 4           'Sensor #2
'            gosub Read_AM4
    end select 
'****************************************************************************
'****************************************************************************

'**************************
'** Bad Comms Abort Test **
    if AM_INIT_ERROR = 1 then return    'Intialization error, abort the read
'**************************
  
''** Check Initialization Response from Sensor**
'    if AM2302_Init_Data = 0 then       'Timeout occured
'        AM_TIMEOUT_ERROR = 1           'Set Timeout Error
'        AM_INIT_ERROR = 1              'Set Intit Error 
'        return      'No need to go any further, Return to Main Program
'    endif
'    if AM2302_Init_Data < AM2302_Init_TO then  'Not a good signal, maybe noise?    
'        AM_INIT_ERROR = 1              'Set Init Error
'        return      'No need to go any further, Return to Main Program
'    endif

 
  '**Convert the Humidity byte array to a 16bit word variable
    AM2302_Hum = 0 'Clear word variable which holds the final 
                    '16bit humidity value
    
    k = 15  'Used to select the correct bit in the word variable
    for j = 0 to 15 step 1   'Read the 16 bytes for humidity in the 
                              'byte array (humidity pulsewidth values)
        If AM2302_Data(j) = 0 then  'Timeout occured
            AM_HUM_ERROR = 1        'Set Humidity Read Error    
        endif
        if AM2302_Data(j) >= AM2302_Val1 then AM2302_Hum.0[k] = 1 
        'If the pulsewidth is => 36us then the value is a "1".
        'otherwise, the value is a "0", so we do not need to do anything
        k = k - 1    
    next j
  '**End Humidity Conversion**
    
  '**Convert the Temperature byte array to a 16bit word variable
    AM2302_Temp = 0   'Clear word variable which holds the final 
                       '16bit temperature value
    
    k = 15  'Used to select the correct bit in the word variable
    for j = 16 to 31 step 1   'Read the 16 bytes for temperature in the 
                               'byte array (temperature pulsewidth values)
        
        If AM2302_Data(j) = 0 then  'Timeout Occured
            AM_TEMP_ERROR = 1       'Set Temperature Read Error    
        endif
        if AM2302_Data(j) >= AM2302_Val1 then AM2302_Temp.0[k] = 1 
        'If the pulsewidth is => 36us then the value is a "1".
        'otherwise, the value is a "0", so we do not need to do anything
        k = k - 1    
    next j
  '**End Temperature Conversion**
    
  '**Convert the Checksum byte array to a 16bit word variable
    AM2302_Checksum = 0   'Clear word variable which holds the final 
                           '8bit checksum value
    
    k = 7  'Used to select the correct bit in the word variable
    for j = 32 to 39 step 1   'Read the 8 bytes for checksum in the 
                               'byte array (checksum pulsewidth values)
        If AM2302_Data(j) = 0 then  'Timeout Occured
            AM_CHK_TO_ERROR = 1     'Set Timeout Error    
        endif
        if AM2302_Data(j) >= AM2302_Val1 then AM2302_Checksum.0[k] = 1 
        'If the pulsewidth is => 36us then the value is a "1".
        'otherwise, the value is a "0", so we do not need to do anything
        k = k - 1    
    next j
  '**End Checksum Conversion**
    
  '**Test the checksum**
    AM_TCHK = AM2302_Hum.byte1 + AM2302_Hum.byte0 + AM2302_Temp.byte1 + AM2302_Temp.byte0
    if AM2302_Checksum <> AM_TCHK then 
        AM_CHK_ERROR = 1    'Set Checksum Error
    endif
  '**End Checksum Test**
  
    return  ' Return to Main Program


'****************************************************************************
'*** EDIT THESE SUBROUTINES TO ADD/REMOVE SENSORS (see instructions)      ***
'****************************************************************************

Read_AM1:

    '** You may want to disable interrupts from here to the end of the 
    '**  AM2302 communication sequence (see below)
    '**  If using DT_INTS then this would be "@ INT_DISABLE xxxxx" where xxxxx is
    '**  the name of the interrupt.    
    ' @ INT_DISABLE xxxx

    '**Intialization sequence to sensor**
    high AM2302_Sensor_1
''   '250ms High on data pin to sensor
    pause Init_High_1
    
    low AM2302_Sensor_1
    pause Init_Low_1          
    
    high AM2302_Sensor_1
''    '40us High on data pin to sensor
    pauseus Init_High_2
    
    'Read the sensor's acknowledgment of init sequence
    'Read a High pulse from the sensor 
    PulsIn AM2302_Sensor_1, 1, AM2302_Init_Data
    '**End of Intialization sequence to sensor**

    '** Check Initialization Response from Sensor**
    if AM2302_Init_Data = 0 then       'Timeout occured
        AM_TIMEOUT_ERROR = 1           'Set Timeout Error
        AM_INIT_ERROR = 1              'Set Intit Error 
        return      'Abort the communications, Sensor did not respond
    endif
    if AM2302_Init_Data < AM2302_Init_TO then  'Not a good signal, maybe noise?    
        AM_INIT_ERROR = 1              'Set Init Error
        return      'Abort the communications, Sensor did not respond
    endif

    '**Load data from sensor into the byte array
    for j = 0 to 39 step 1
        ' Read data High pulses (bits) from the sensor and store them as 
        ' pulsewidth counts in individual bytes in the byte array.

        PulsIn AM2302_Sensor_1, 1, AM2302_Data[j]
    next j
    '**End of Load Data**

'** Re-enable interrupts if they were previously disabled
'  '@ INT_ENABLE xxxxx

    return  ' Return to calling routine
    
'Read_AM2:
'    '** You may want to disable interrupts from here to the end of the 
'    '**  AM2302 communication sequence (see below)
'    '**  If using DT_INTS then this would be "@ INT_DISABLE xxxxx" where xxxxx is
'    '**  the name of the interrupt.    
'    ' @ INT_DISABLE xxxx

'    '**Intialization sequence to sensor**
'    high AM2302_Sensor_2
'''   '250ms High on data pin to sensor
'    pause Init_High_1 '250
    
'    low AM2302_Sensor_2
'    pause Init_Low_1          
    
'    high AM2302_Sensor_2
'''    '40us High on data pin to sensor
'    pauseus Init_High_2
    
'    'Read the sensor's acknowledgment of init sequence
'    'Read a High pulse from the sensor 
'    PulsIn AM2302_Sensor_2, 1, AM2302_Init_Data
'    '**End of Intialization sequence to sensor**

'    '** Check Initialization Response from Sensor**
'    if AM2302_Init_Data = 0 then       'Timeout occured
'        AM_TIMEOUT_ERROR = 1           'Set Timeout Error
'        AM_INIT_ERROR = 1              'Set Intit Error 
'        return      'Abort the communications, Sensor did not respond
'    endif
'    if AM2302_Init_Data < AM2302_Init_TO then  'Not a good signal, maybe noise?    
'        AM_INIT_ERROR = 1              'Set Init Error
'        return      'Abort the communications, Sensor did not respond
'    endif

'    '**Load data from sensor into the byte array
'    for j = 0 to 39 step 1
'        ' Read data High pulses (bits) from the sensor and store them as 
'        ' pulsewidth counts in individual bytes in the byte array.

'        PulsIn AM2302_Sensor_2, 1, AM2302_Data[j]
'    next j
'    '**End of Load Data**

''** Re-enable interrupts if they were previously disabled
''  '@ INT_ENABLE xxxxx

'    return  ' Return to calling routine
    
'Read_AM3:
'    '** You may want to disable interrupts from here to the end of the 
'    '**  AM2302 communication sequence (see below)
'    '**  If using DT_INTS then this would be "@ INT_DISABLE xxxxx" where xxxxx is
'    '**  the name of the interrupt.    
'    ' @ INT_DISABLE xxxx

'    '**Intialization sequence to sensor**
'    high AM2302_Sensor_3
'''   '250ms High on data pin to sensor
'    pause Init_High_1
    
'    low AM2302_Sensor_3
'    pause Init_Low_1          
    
'    high AM2302_Sensor_3
'''    '40us High on data pin to sensor
'    pauseus Init_High_2
    
'    'Read the sensor's acknowledgment of init sequence
'    'Read a High pulse from the sensor 
'    PulsIn AM2302_Sensor_3, 1, AM2302_Init_Data
'    '**End of Intialization sequence to sensor**

'    '** Check Initialization Response from Sensor**
'    if AM2302_Init_Data = 0 then       'Timeout occured
'        AM_TIMEOUT_ERROR = 1           'Set Timeout Error
'        AM_INIT_ERROR = 1              'Set Intit Error 
'        return      'Abort the communications, Sensor did not respond
'    endif
'    if AM2302_Init_Data < AM2302_Init_TO then  'Not a good signal, maybe noise?    
'        AM_INIT_ERROR = 1              'Set Init Error
'        return      'Abort the communications, Sensor did not respond
'    endif

'    '**Load data from sensor into the byte array
'    for j = 0 to 39 step 1
'        ' Read data High pulses (bits) from the sensor and store them as 
'        ' pulsewidth counts in individual bytes in the byte array.

'        PulsIn AM2302_Sensor_3, 1, AM2302_Data[j]
'    next j
'    '**End of Load Data**

''** Re-enable interrupts if they were previously disabled
''  '@ INT_ENABLE xxxxx

'    return  ' Return to calling routine
    
'Read_AM4:
'    '** You may want to disable interrupts from here to the end of the 
'    '**  AM2302 communication sequence (see below)
'    '**  If using DT_INTS then this would be "@ INT_DISABLE xxxxx" where xxxxx is
'    '**  the name of the interrupt.    
'    ' @ INT_DISABLE xxxx

'    '**Intialization sequence to sensor**
'    high AM2302_Sensor_4
'''   '250ms High on data pin to sensor
'    pause Init_High_1
    
'    low AM2302_Sensor_4
'    pause Init_Low_1          
    
'    high AM2302_Sensor_4
'''    '40us High on data pin to sensor
'    pauseus Init_High_2
    
'    'Read the sensor's acknowledgment of init sequence
'    'Read a High pulse from the sensor 
'    PulsIn AM2302_Sensor_4, 1, AM2302_Init_Data
'    '**End of Intialization sequence to sensor**

'    '** Check Initialization Response from Sensor**
'    if AM2302_Init_Data = 0 then       'Timeout occured
'        AM_TIMEOUT_ERROR = 1           'Set Timeout Error
'        AM_INIT_ERROR = 1              'Set Intit Error 
'        return      'Abort the communications, Sensor did not respond
'    endif
'    if AM2302_Init_Data < AM2302_Init_TO then  'Not a good signal, maybe noise?    
'        AM_INIT_ERROR = 1              'Set Init Error
'        return      'Abort the communications, Sensor did not respond
'    endif

'    '**Load data from sensor into the byte array
'    for j = 0 to 39 step 1
'        ' Read data High pulses (bits) from the sensor and store them as 
'        ' pulsewidth counts in individual bytes in the byte array.

'        PulsIn AM2302_Sensor_4, 1, AM2302_Data[j]
'    next j
'    '**End of Load Data**

''** Re-enable interrupts if they were previously disabled
''  '@ INT_ENABLE xxxxx

'    return  ' Return to calling routine

''****************************************************************************
'****************************************************************************

  '*****************************
  '**End of Library Routines  **
  '*****************************


overAM2302:



