'---------------------------------------------------------------------------------------------------
'
'		GLCD_NOKIA.PBP
'		==============
'		Release: 1.0
'		Date: July 27, 2011
'		Author: Steve Monfette AKA Mister_e
'		Credits & inspirations: In no specific order
'				  						scalerobotics, 
'				  						Skimask, 
'				  						SKOLS1, 
'				 						Darrel Taylor,
'				  						Fratello, 
'				  						NavMicroSystems, 
'				  						BitManiac,
'				  						and everyone at the following PICBASIC forum thread
'				  						http://www.picbasic.co.uk/forum/showthread.php?t=327
'
'---------------------------------------------------------------------------------------------------
'
'       Description
'       ===========
'       PICBASIC PRO Driver/Wrapper to use with Nokia 3310,5110 GLCD, or any other 84x48 GLCD based 
'       on PCD8544 controller.
'
'       It is based on many other example I found on www.picbasic.co.uk forum, so I have no merit at
'       all.  However, many user had trouble to make it work with smaller or more limited device 
'       such as 12F629, 16F628 and few more.  Reason is simple, most example were based on READCODE
'       to retrieve the string from the codespace.  As many PIC can't read their own codespace I had
'       to find a method to work with all PIC.  But erm, many PIC, many different method.  Even if 
'       you can read from your codespace on a 16F, the method is slightly different on 18Fs.
'       I could be wrong, but I found there's 3 different method
'           1) can't read codespace (most 12F, some 16F)
'              - MPASM DT and PEEKCODE table thing
'           2) can read codespace with READCODE on many 16F
'              MPASM DA & MPASM DT
'           3) can read codespace with READCODE on many/all 18F, 
'              MPASM DATA... and no odd address allowed... 
'
'       Thanks to conditional compilation; it makes it possible to do it on the same include file,  
'       the decision of wich routine to use will be done at compile time.  Yay!
'
'       Other reasons why I've decide to create this file, appart personnal challenge: 
'           1) add flexibility
'           2) provide user configurable settings
'           3) reduce the codespace usage
'
'        So here we are.  With the actual version you can:
'           1) decide where to store your string 
'           2) decide where to store the lookuptable for the fonts/character
'           3) define your own custom character(s) - (up to 31)
'           4) include only the characters you want/need to use to free to codes/EEPROM space
'           5) decide the I/O to use in a convenient DEFINE way
'           6) have a blast of features/macro set.  
'              All the details are in the Readme.txt file located in the Documentation folder
'           7) use it with all PIC with decent RAM, EEPROM, CodeSpace available without having
'              to care about the method to use to read/store strings and lookupchar tables. 
'           8) choose regular 5x8 or 6x8 fonts.  6x8 are handy for full graphics or specific 
'              custom character 
'           9) no 9 yet
'
'       Several code example are providen, look at them, it's easier to use than you think.
'
'       Enjoy!
'       
'       Steve AKA Mister_e
'                   
'---------------------------------------------------------------------------------------------------
'
'       Software Constants
'       ==================
	    CharLUTStart    CON EXT
	    CharLUTEnd      CON EXT
		TABLEC			CON EXT
		CHARRANGE     	CON EXT
        LUTStep         CON EXT
        EEPROM_START    CON EXT
        ASM
        ;
        ;		Character Aliases
        ;		-----------------
CHR_QUOTE = 39
CHR_DOUBLE_QUOTE = 34
CHR_BACKSLASH = 92
		;
		;		Custom Character Aliases
		;		------------------------
		VARIABLE A = 0	; Lazy way to define 
		WHILE A<32		;	CHR_CUSTOM_0
CHR_CUSTOM_#V(A)= #V(A)	;	   until
A++						;	CHR_CUSTOM_31
		ENDW			;
		;
		;		ADDCHAR magic numbers
		;		---------------------
CHR_ALL = 512
CHR_SYMBOLS = 513 
CHR_NUMBERS = 514
CHR_LETTERUP = 515
CHR_LETTERLOW = 516
CHR_SPACE_DEFINED = 0
		;
 		;
        ;       GLCD related
        ;       ------------
        		;	Function set
        		;	command
        		;	bit aliases
        		;   *** Please refer to the datasheet providen @ page 14 for more details
				;
_CLS = 0		;    
_POWER_DOWN = 0x0024
_VERTICAL = 0x0022
_EXTENDED_INSTRUCTION_SET = 0x0021
_BASIC_INSTRUCTION_SET = 0x0020
_WRITE_DATA = 0x0100
                ;       H = 0
                ;       -----
                ;       DISPLAY_CONTROL = 0x08 
_BLANK = 0x0008 ;            	;
_NORMAL = 0x000C;            	;
_ALL_SEGMENT_ON = 0x0009    	;
_INVERSE_VIDEO = 0x000D     	;
                ;				;                
_SET_Y = 0x0040 ;				; Y<2:0> 0 <= Y <= 5
_SET_X = 0x0080 ;      			; X<6:0> 0 <= Y <= 83
                ;        	
                ;       H = 1
                ;       -----         
_SET_TEMPERATURE_COEFFICIENT = 0x8004 ; Temperature Coefficient (0-3)
_SET_BIAS = 0x8010                    ; 0 - 7
_SET_CONTRAST = 0x8080  
; Bellow some the user can define
;	GLCD_CONTRAST -----------------	(Default = 65)
;	GLCD_TEMPERATURE_COEFFICIENT --	(Default = 2)
;	GLCD_BIAS ---------------------	(Default = 3)
        ;
        ;       Internal        
        ;       --------
PIC_TYPE = 0					;
PIC18 = 1                   	;
CODE_SPACE_READABLE = 2     	;
CODE_SPACE_NOT_READABLE =  3	;
LastStringEnd = 0				; Store the last Address of a String (EEPROM)

        ENDASM
'
'       Software variables
'       ==================
        Addr            VAR WORD BANK0  ' Address of string
        LUTAddr         VAR WORD BANK0	' Address of Character (lookupTable)
        TwoChars        VAR WORD BANK0  ' 14 bit ASCII char packet (12F, 16F)
        Char            VAR BYTE BANK0  ' single character

        PosX            VAR BYTE BANK0  ' GLCD X coordinate
        PosY            VAR BYTE BANK0  ' GLCD Y coordinate
        ToSend          VAR BYTE BANK0	' The Character to Send to the GLCD
        GLCDControl     VAR WORD BANK0   
        GLCDData        VAR GLCDcontrol.LowByte  ' Character or parameter of a GLCD command
        GLCDCmd         VAR GLCDcontrol.HighByte
        IsCmdExtended   VAR GLCDCmd.7
    	
    	Val2Dec         VAR TwoCHARS
        CharCounter     VAR BYTE BANK0
        GLCDCounter     VAR BYTE BANK0
        BitCounter      VAR BYTE BANK0
        GLCDFlags       VAR BYTE BANK0  '
        IsInit          VAR GLCDFlags.0 '
        GotLeadingZero	VAR	GLCDFlags.1 '
        IsExtended      VAR GLCDFlags.2 '
        GLCDFlags = 0   

        POSX=POSX*6    	' Force PBP to include MUL?BCB MACRO
		
'
'		Publicly Available Hardware Assignement
'		=======================================
        GLCDSdo    	VAR  BIT    EXT
@       #UNDEFINE   GLCDSdo
@       #DEFINE     GLCDSdo    GLCD_SDO

        ASM
;
;		Assembler & compilation time settings
;		=====================================
		ERRORLEVEL -306 ; supress code boundary message
		
		IFDEF PM_USED
                ERROR "Sorry, you must use MPASM to use this code"
            ENDIF
            
        ;
        ; Let's determine the type of PIC
        ; This will be usefull to know which table write/read method to use
        ; to store/retrieve the user text strings.
        IFDEF BSR
PIC_TYPE = PIC18
                #define GLCD_STRING	DATA
                #define GLCD_LUT    DATA
LUTStep = 2
            ELSE
                IFDEF EEDATH 
PIC_TYPE = CODE_SPACE_READABLE
                        #define GLCD_STRING	DA
                        #define GLCD_LUT    DT
                        #DEFINE RLCF  RLF
LUTStep = 1
                    ELSE
PIC_TYPE = CODE_SPACE_NOT_READABLE
                        #define GLCD_STRING	DT
                        #define GLCD_LUT    DT
                        #DEFINE RLCF  RLF
LUTStep = 1
                    ENDIF
            ENDIF
        
        IFDEF GLCD_CHAR_IN_EEPROM
                #undefine 	GLCD_LUT
                #define 	GLCD_LUT DE
        	ENDIF
        
        IFDEF GLCD_STRING_IN_EEPROM
                #undefine 	GLCD_STRING
                #define 	GLCD_STRING DE
        	ENDIF
        
        IFDEF GLCD_CHAR_6X8
CHARRANGE = 5
				IF (PIC_TYPE == PIC18)
TABLEC	= 8
TABLEJ 	= 6
					ELSE
TABLEC	= 7
TABLEJ 	= 6
					ENDIF						
			ELSE
TABLEC	= 6
TABLEJ	= 6 
CHARRANGE = 4        	
        	ENDIF
        ENDASM
        
        ASM
        ;
        ;
        ;       Default Setting
        ;       ===============
    
        IFNDEF  GLCD_CONTRAST
GLCD_CONTRAST = 65
                ENDIF
                
        IFNDEF  GLCD_TEMPERATURE_COEFFICIENT                
GLCD_TEMPERATURE_COEFFICIENT = 2
                ENDIF
                
         IFNDEF GLCD_BIAS       
GLCD_BIAS = 3
                ENDIF
        
        IFNDEF  GLCD_SCE
                #DEFINE GLCD_SCE PORTB,0
                ENDIF    
                
        IFNDEF  GLCD_RES
                #DEFINE GLCD_RES PORTB,1
                ENDIF            

        IFNDEF  GLCD_DC
                #DEFINE GLCD_DC PORTB,2
                ENDIF            

        IFNDEF  GLCD_SDO
                #DEFINE GLCD_SDO PORTB,3
                ENDIF            

        IFNDEF  GLCD_CLK
                #DEFINE GLCD_CLK PORTB,4
                ENDIF
        ENDASM
		
		GOTO    OverNokiaGLCD
'  
'		GLCD Relatedc Macros
'		====================
		'
       	ASM 
        ;-----< GLCDGETXY >-------------------------------------------------------------------------
        ;		
	    ;       Allow the user to use constants AND/OR Byte Variable
	    ;       for x, y coordinates (column, row)
	    		;	
GLCDGETXY MACRO x, y
        		;                             
	            ; 
	            ;  Screen is 84 pixels wide, 
                ;  Our font + gap = 6 pixels 
	            ;  84/6= 14 columns, from 0 to 13
        IF (x<14)
                ; x is a constant                         
                MOVE?CB x, _PosX    
	    	ELSE
                ; x is a variable.. or crazy constant input
	            MOVE?BB x, _PosX    
	    	ENDIF 
                ;
	            ;  Same magic here...  Screen is 48 pixels high, 
                ;  Our font + gap = 8 pixels 
	            ;  48/8 = 6 lines, from 0 to 5
	    IF (y<6);    
                ; y is a constant
                MOVE?CB  y, _PosY           
			ELSE
                ; y is a variable.. or you know.
	            MOVE?BB  y, _PosY
	    	ENDIF 
	    MUL?BCB    _PosX, 6, _PosX
        ENDM
        ;  
        ;-----< GLCDOUT_AT?STR >--------------------------------------------------------------------
		;
        ;       Display your text string on the GLCD onto a specific x (Column), y (line) 
        ;               ex: GLCDOUT_AT?STR 0,0, "Some text" 
        ;                   GLCDOUT_AT?STR ByteVarX, ByteVarY, "Some text"   
        ;      
GLCDOUT_AT?STR MACRO x, y, Str
        GLCDGETXY x,y
        GLCDOUT?STR Str
        ENDM
        ;
		;-----< GLCDOUT?STR >-----------------------------------------------------------------------
		;	
		;		Display your string at the current x,y position
		;				ex: GLCDOUT?STR "String!"
		;		
GLCDOUT?STR MACRO Str        
		LOCAL StringStart, StringEnd
        IFNDEF GLCD_STRING_IN_EEPROM	; Store string in EEPROM?
            L?GOTO StringEnd			; - No, Jump over the string
            ELSE						; --- YES!
INITIAL_ORG = $							;     Store current program ORG, so we can go back there 
										;     once the string is stored to the EEPROM
										;			
            IFDEF GLCD_CHAR_IN_EEPROM	; Are the Character are also stored into the EEPROM?
                    ORG EEPROM_START + LastStringEnd + CharLUTEnd + TABLEJ
            							; - Yes, let's move to the last used EEPROM Address
            							;   after the Character Lookup Table & the Last String 
                ELSE            		;   we saved... if any
                    ORG EEPROM_START + LastStringEnd 
										; --- NO, let's move to the last used EEPROM Address
										;     after the the Last String we saved... if any
                ENDIF					;
            ENDIF 						;
StringStart 							; Store the String using the user defined method (EEPROM)
        GLCD_STRING Str,0				; OR the one established by PIC_TYPE variable
StringEnd								; *** See 'Assembler & compilation time settings' section
										;
		IFDEF GLCD_STRING_IN_EEPROM		; Is the current string saved into EEPROM?
LastStringEnd = StringEnd				; - Yes, Save Current EEPROM location for testing purpose
		;	NOTE:
        ;	For some reasons, PBP do not always define the EEPROM_END address
        ;	In case we have it, use it to prompt the user in case he overflow it.
        ;	Case we don't have it, the user may/will experiment odd results... Not MY problem ;)								
        IFDEF EEPROM_END
            IF (LastStringEnd>EEPROM_END)					; EEPROM OverFlow?
                ERROR "Too much strings to fit the EEPROM"	; Yes, Blame User!
                ENDIF
            ENDIF
            
        IFDEF GLCD_CHAR_IN_EEPROM		; is the Character Lookup Table stored in the EEPROM?
LastStringEnd = StringEnd - (EEPROM_START + CharLUTEnd + TABLEJ)
										; - Yes, Set next EEPROM string location after  
				ELSE					;   the Character Lookuptable AND the current string
LastStringEnd = StringEnd - EEPROM_START;
										; --- NO, Set next EEPROM string location after 
				ENDIF					;     the current string
										;
                ORG INITIAL_ORG			; Go back to the main program ORG
            ENDIF
        MOVE?CW	StringStart, _Addr    	; Save string start Address
	    L?CALL  _ShowIt    				; do I need to explain?
        ENDM
		;
		;-----<	GLCDOUT_AT?CHR >--------------------------------------------------------------------
		;		
		;		Display a single Character to a specific x,y coordinate
		;				ex: GLCDOUT_AT?CHR 0,0, "C"
		;					GLCDOUT_AT?CHR 0,0, CHR_BACKSLASH
		;
GLCDOUT_AT?CHR MACRO x, y, Chr
        GLCDGETXY x,y
        GLCDOUT?CHR Chr
        ENDM        
        ;
        ;-----< GLCDOUT?CHR >-----------------------------------------------------------------------
        ;
        ;		Display a single character to the current x,y coordinate
        ;				ex: GLCDOUT?CHR "C"
        ;					GLCDOUT?CHR CHR_BACKSLASH
        ;
GLCDOUT?CHR MACRO Chr
        MOVE?CB Chr, _Char
        L?CALL _SendSingleChar
        ENDM   
        ENDASM
        '
        ASM 
		;
		;-----<	GLCDOUT_2DEC_AT?B >-----------------------------------------------------------------
		;		
		;		Display the decimal representationm of a BYTE variable to a specific x,y coordinate
		;				ex: GLCDOUT_2DEC_AT?B 0,0, _YourByteVar
		;
GLCDOUT_2DEC_AT?B MACRO x, y, VarIn
        GLCDGETXY x,y
		GLCDOUT_2DEC?B VarIn
        ENDM  
		;
		;-----<	GLCDOUT_2DEC?B >--------------------------------------------------------------------
		;		
		;		Display the decimal representation of a BYTE variable to the current x,y coordinate
		;				ex: GLCDOUT_2DEC?B _YourByteVar
		;
GLCDOUT_2DEC?B MACRO VarIn
        MOVE?BW VarIn, _Val2Dec
        IFNDEF GLCD_2DEC_USED
        		ERROR "Seems you forgot to add DEFINE GLCD_2DEC_USED to your code..."
        		ENDIF
        L?CALL _GLCDOUT_Val2Dec
        ENDM   
		;
		;-----<	GLCDOUT_2DEC_AT?W >-----------------------------------------------------------------
		;		
		;		Display the decimal representationm of a WORD variable to a specific x,y coordinate
		;				ex: GLCDOUT_2DEC_AT?W 0,0, _YourWordVar
		;
GLCDOUT_2DEC_AT?W MACRO x, y, VarIn
        GLCDGETXY x,y
		GLCDOUT_2DEC?W VarIn
        ENDM  
		;
		;-----<	GLCDOUT_2DEC?W >--------------------------------------------------------------------
		;		
		;		Display the decimal representationm of a WORD variable to the current x,y coordinate
		;				ex: GLCDOUT_2DEC?W _YourWordVar
		;
GLCDOUT_2DEC?W MACRO VarIn
        MOVE?WW VarIn, _Val2Dec
        IFNDEF GLCD_2DEC_USED
        		ERROR "Seems you forgot to add DEFINE GLCD_2DEC_USED to your code..."
        		ENDIF
        L?CALL _GLCDOUT_Val2Dec
        ENDM   
		;
		;-----<	GLCDOUT_2DEC_AT?C >-----------------------------------------------------------------
		;		
		;		Display the decimal representationm of a CONSTANT to a specific x,y coordinate
		;				ex: GLCDOUT_2DEC_AT?C 0,0, 1234
		;					GLCDOUT_2DEC_AT?C 0,0, Constant
		;
GLCDOUT_2DEC_AT?C MACRO x, y, VarIn
        GLCDGETXY x,y
		GLCDOUT_2DEC?C VarIn
        ENDM  
		;
		;-----<	GLCDOUT_2DEC?C  >-------------------------------------------------------------------
		;		
		;		Display the decimal representationm of a CONSTANT to the current x,y coordinate
		;				ex: GLCDOUT_2DEC?C 1234
		;					GLCDOUT_2DEC?C Constant
		;
GLCDOUT_2DEC?C MACRO VarIn
        MOVE?CW VarIn, _Val2Dec
        IFNDEF GLCD_2DEC_USED
        		ERROR "Seems you forgot to add DEFINE GLCD_2DEC_USED to your code..."
        		ENDIF
        L?CALL _GLCDOUT_Val2Dec
        ENDM  
  		ENDASM
  		'
  		ASM
        ;
        ;-----< GLCDOUT_CMD?C >---------------------------------------------------------------------
        ;
        ;		Send a specific command to the GLCD
        ;       		ex: GLCDOUT_CMD?C   (_SET_CONTRAST + GLCD_CONTRAST)
        ;
        ;		*** refer to 'GLCD Related' section
        ;
GLCDOUT_CMD?C MACRO Cin
        IF (Cin==_CLS)
                GLCD_CLS
            ELSE
                MOVE?CW Cin, _GLCDControl 
                L?CALL _GLCDSendByte
            ENDIF
        ENDM
		;
		;-----< GLCDOUT_CMD?CB >--------------------------------------------------------------------
		;
		;		Send a specific command to the GLCD
		;		Almost the same as GLCDOUT_CMD?C but have 2 parameters
		;			Command:   Must be a Constant (ex _SET_CONTRAST)
		;			Parameter: Must be a Byte variable
		;			ex:  GLCDOUT_CMD?CB _SET_CONTRAST, _ByteVariable
		;
GLCDOUT_CMD?CB MACRO Command, Parameter
        MOVE?CW Command, _GLCDControl 
        MOVE?BA Parameter
        CHK?RP _GLCDControl 
        IORWF _GLCDControl , F
        L?CALL _GLCDSendByte
        ENDM
		;
		;-----< GLCD_CLS >--------------------------------------------------------------------------
		;
		;		Clear the whole GLCD screen and initialise it case he's not already
		;
GLCD_CLS MACRO
        L?CALL _GLCDClear
        ENDM
		;
		;-----< GLCD_INIT >-------------------------------------------------------------------------
		;
		;     Initialize the GLCD
		;
GLCD_INIT MACRO
        L?CALL _GLCDInit
        ENDM
        ;
		;-----< GLCD_GOTOXY >-----------------------------------------------------------------------
		;
		;		Move to a specific x,y coordinate
		;
GLCD_GOTOXY MACRO x,y
        IF (x<14)
                MOVE?CW  x, _PosX          ; x is a CONSTANT
                GLCDOUT_CMD?CB _SET_X, _PosX
            ELSE
                GLCDOUT_CMD?CB _SET_X , x  ; x is a BYTE
            ENDIF 
        IF (y<5)
                MOVE?CW  y, _PosY          ; y is a CONSTANT
                GLCDOUT_CMD?CB _SET_Y, _PosY
            ELSE
                GLCDOUT_CMD?CB _SET_Y , y  ; y is a BYTE
            ENDIF
        ENDM
        ENDASM
'
'		Character/Font/Custom Character lookup table related MACROs
'		===========================================================
		'
		ASM
  		;
  		;-----< TABLE_SYMBOLS >---------------------------------------------------------------------
  		;
  		;		Define ASCII Symbols
  		;
TABLE_SYMBOLS MACRO CHR
        IF CHR==' '     ;32   
            IF (CHR_SPACE_DEFINED == 0)  					; is space already defined?           
                GLCD_LUT CHR, 0x00, 0x00, 0x00, 0x00, 0x00 	; - NO, define it
CHR_SPACE_DEFINED = 1                						;   But avoid to do it twice
                ENDIF										;   this character is needed to clear 
                EXITM										;   the GLCD screen.
                ENDIF
                
        IF CHR=='!'     ;33                   
                GLCD_LUT CHR, 0x00, 0x00, 0x4f, 0x00, 0x00 
                EXITM
                ENDIF
                
        IF CHR=='\"'    ;34 
                GLCD_LUT CHR, 0x00, 0x07, 0x00, 0x07, 0x00 
                EXITM
                ENDIF
                
        IF CHR=='#'    ;35                   
                GLCD_LUT CHR, 0x14, 0x7f, 0x14, 0x7f, 0x14 
                EXITM
                ENDIF
                
        IF CHR=='$'    ;36                   
                GLCD_LUT CHR, 0x24, 0x2a, 0x7f, 0x2a, 0x12 
                EXITM
                ENDIF
                
        IF CHR=='%'    ;37                   
                GLCD_LUT CHR, 0xc4, 0xc8, 0x10, 0x26, 0x46 
                EXITM
                ENDIF
                
        IF CHR=='&'    ;38                   
                GLCD_LUT CHR, 0x36, 0x49, 0x55, 0x22, 0x50 
                EXITM
                ENDIF
                
        IF CHR=='\''   ;39                   
                GLCD_LUT CHR, 0x00, 0x05, 0x03, 0x00, 0x00 
                EXITM
                ENDIF
        IF CHR=='('    ;40                   
                GLCD_LUT CHR, 0x00, 0x1c, 0x22, 0x41, 0x00 
                EXITM
                ENDIF
                
        IF CHR==')'    ;41                   
                GLCD_LUT CHR, 0x00, 0x41, 0x22, 0x1c, 0x00 
                ;EXITM
                ENDIF
                
        IF CHR=='*'    ;42                   
                GLCD_LUT CHR, 0x14, 0x08, 0x3E, 0x08, 0x14 
                EXITM
                ENDIF
                
        IF CHR=='+'    ;43                   
                GLCD_LUT CHR, 0x08, 0x08, 0x3E, 0x08, 0x08 
                EXITM
                ENDIF
                
        IF CHR==','    ;44                   
                GLCD_LUT CHR, 0x00, 0x00, 0x50, 0x30, 0x00 
                EXITM
                ENDIF
                
        IF CHR=='-'    ;45                   
                GLCD_LUT CHR, 0x10, 0x10, 0x10, 0x10, 0x10 
                EXITM
                ENDIF
                
        IF CHR=='.'    ;46                   
                GLCD_LUT CHR, 0x00, 0x60, 0x60, 0x00, 0x00 
                EXITM
                ENDIF
                
        IF CHR=='/'    ;47                   
                GLCD_LUT CHR, 0x20, 0x10, 0x08, 0x04, 0x02 
                EXITM
                ENDIF
                
        IF CHR==':'    ;58                   
                GLCD_LUT CHR, 0x00, 0x36, 0x36, 0x00, 0x00 
                EXITM
                ENDIF
                
        IF CHR==';'    ;59                   
                GLCD_LUT CHR, 0x00, 0x56, 0x36, 0x00, 0x00 
                EXITM
                ENDIF
                
        IF CHR=='<'    ;60                   
                GLCD_LUT CHR, 0x08, 0x14, 0x22, 0x41, 0x00 
                EXITM
                ENDIF
                
        IF CHR=='='    ;61                   
                GLCD_LUT CHR, 0x14, 0x14, 0x14, 0x14, 0x14 
                EXITM
                ENDIF
                
        IF CHR=='>'    ;62                   
                GLCD_LUT CHR, 0x00, 0x41, 0x22, 0x14, 0x08 
                EXITM
                ENDIF

        IF CHR=='?'    ;63                   
                GLCD_LUT CHR, 0x02, 0x01, 0x51, 0x09, 0x06 
                EXITM
                ENDIF
                
        IF CHR=='@'    ;64                   
                GLCD_LUT CHR, 0x32, 0x49, 0x59, 0x51, 0x3E 
                EXITM
                ENDIF
          
        IF CHR=='['    ;91   
                GLCD_LUT CHR, 0x00, 0x7F, 0x41, 0x41, 0x00 
                EXITM
                ENDIF
                
        IF CHR=='\\'   ;92                   
                GLCD_LUT CHR, 0x02, 0x04, 0x08, 0x10, 0x20 
                EXITM
                ENDIF
                
        IF CHR==']'    ;93                   
                GLCD_LUT CHR, 0x00, 0x41, 0x41, 0x7F, 0x00 
                EXITM
                ENDIF
                
        IF CHR=='^'    ;94                   
                GLCD_LUT CHR, 0x04, 0x02, 0x01, 0x02, 0x04 
                EXITM
                ENDIF

        IF CHR=='_'    ;95
                GLCD_LUT CHR, 0x40, 0x40, 0x40, 0x40, 0x40 
                EXITM
                ENDIF
                
        IF CHR=='`'    ;96                   
                GLCD_LUT CHR, 0x00, 0x01, 0x02, 0x04, 0x00 
                EXITM
                ENDIF

        IF CHR=='{'    ;123
                GLCD_LUT CHR, 0x00, 0x08, 0x36, 0x41, 0x00
                EXITM
                ENDIF
                
        IF CHR=='|'    ;124
                GLCD_LUT CHR, 0x00, 0x00, 0x7F, 0x00, 0x00
                EXITM
                ENDIF
                
        IF CHR=='}'    ;125
                GLCD_LUT CHR, 0x00, 0x41, 0x36, 0x08, 0x00
                EXITM
                ENDIF
                
        IF CHR=='~'    ;126
                GLCD_LUT CHR, 0x10, 0x08, 0x08, 0x10, 0x08
                EXITM
                ENDIF                
		ENDM
		ENDASM
		'
		ASM
  		;
  		;-----< TABLE_NUMBERS >---------------------------------------------------------------------
  		;
  		;		Define ASCII Numbers
  		;		
TABLE_NUMBERS MACRO CHR 
        IF CHR=='0'    ;48                   
                GLCD_LUT CHR, 0x3E, 0x51, 0x49, 0x45, 0x3E 
                EXITM
                ENDIF
                
        IF CHR=='1'    ;49                   
                GLCD_LUT CHR, 0x00, 0x42, 0x7F, 0x40, 0x00 
                EXITM
                ENDIF
                
        IF CHR=='2'    ;50                   
                GLCD_LUT CHR, 0x42, 0x61, 0x51, 0x49, 0x46 
                EXITM
                ENDIF
                
        IF CHR=='3'    ;51                   
                GLCD_LUT CHR, 0x21, 0x41, 0x45, 0x4B, 0x31 
                EXITM
                ENDIF
                
        IF CHR=='4'    ;52                   
                GLCD_LUT CHR, 0x18, 0x14, 0x12, 0x7F, 0x10 
                EXITM
                ENDIF
                
        IF CHR=='5'    ;53                   
                GLCD_LUT CHR, 0x27, 0x45, 0x45, 0x45, 0x39 
                EXITM
                ENDIF
                
        IF CHR=='6'    ;54                   
                GLCD_LUT CHR, 0x3C, 0x4A, 0x49, 0x49, 0x30 
                EXITM
                ENDIF
                
        IF CHR=='7'    ;55                   
                GLCD_LUT CHR, 0x01, 0x71, 0x09, 0x05, 0x03 
                EXITM
                ENDIF
                
        IF CHR=='8'    ;56                   
                GLCD_LUT CHR, 0x36, 0x49, 0x49, 0x49, 0x36 
                EXITM
                ENDIF
                
        IF CHR=='9'    ;57                   
                GLCD_LUT CHR, 0x06, 0x49, 0x49, 0x29, 0x1E 
                EXITM
                ENDIF
		ENDM
		ENDASM
		'
		ASM 
  		;
  		;-----< TABLE_LETTERUP >--------------------------------------------------------------------
  		;
  		;		Define ASCII Uppercase Letters
  		; 
TABLE_LETTERUP MACRO CHR   
        IF CHR=='A'    ;65                   
                GLCD_LUT CHR, 0x7E, 0x11, 0x11, 0x11, 0x7E 
                EXITM
                ENDIF
                
        IF CHR=='B'    ;66                   
                GLCD_LUT CHR, 0x7F, 0x49, 0x49, 0x49, 0x36 
                EXITM
                ENDIF
                
        IF CHR=='C'    ;67                   
                GLCD_LUT CHR, 0x3E, 0x41, 0x41, 0x41, 0x22 
                EXITM
                ENDIF
                
        IF CHR=='D'    ;68                   
                GLCD_LUT CHR, 0x7F, 0x41, 0x41, 0x22, 0x1C 
                EXITM
                ENDIF
                
        IF CHR=='E'    ;69                   
                GLCD_LUT CHR, 0x7F, 0x49, 0x49, 0x49, 0x41 
                EXITM
                ENDIF
                
        IF CHR=='F'    ;70                   
                GLCD_LUT CHR, 0x7F, 0x09, 0x09, 0x09, 0x01 
                EXITM
                ENDIF
                
        IF CHR=='G'    ;71                   
                GLCD_LUT CHR, 0x3E, 0x41, 0x49, 0x49, 0x7A 
                EXITM
                ENDIF
                
        IF CHR=='H'    ;72                   
                GLCD_LUT CHR, 0x7F, 0x08, 0x08, 0x08, 0x7F 
                EXITM
                ENDIF
                
        IF CHR=='I'    ;73                   
                GLCD_LUT CHR, 0x00, 0x41, 0x7F, 0x41, 0x00 
                EXITM
                ENDIF

        IF CHR=='J'    ;74                   
                GLCD_LUT CHR, 0x20, 0x40, 0x41, 0x3F, 0x01 
                EXITM
                ENDIF     
                
                
        IF CHR=='K'    ;75                   
                GLCD_LUT CHR, 0x7F, 0x08, 0x14, 0x22, 0x41 
                EXITM
                ENDIF
                
        IF CHR=='L'    ;76                   
                GLCD_LUT CHR, 0x7F, 0x40, 0x40, 0x40, 0x40 
                EXITM
                ENDIF
                
        IF CHR=='M'    ;77                   
                GLCD_LUT CHR, 0x7F, 0x02, 0x0C, 0x02, 0x7F 
                EXITM
                ENDIF
                
        IF CHR=='N'    ;78                   
                GLCD_LUT CHR, 0x7F, 0x04, 0x08, 0x10, 0x7F 
                EXITM
                ENDIF
                
        IF CHR=='O'    ;79                   
                GLCD_LUT CHR, 0x3E, 0x41, 0x41, 0x41, 0x3E 
                EXITM
                ENDIF
                
        IF CHR=='P'    ;80                   
                GLCD_LUT CHR, 0x7F, 0x09, 0x09, 0x09, 0x06 
                EXITM
                ENDIF
                
        IF CHR=='Q'    ;81                   
                GLCD_LUT CHR, 0x3E, 0x41, 0x51, 0x21, 0x5E 
                EXITM
                ENDIF
                
        IF CHR=='R'    ;82                   
                GLCD_LUT CHR, 0x7F, 0x09, 0x19, 0x29, 0x46 
                EXITM
                ENDIF
                
        IF CHR=='S'    ;83                   
                GLCD_LUT CHR, 0x46, 0x49, 0x49, 0x49, 0x31 
                EXITM
                ENDIF
                
        IF CHR=='T'    ;84                   
                GLCD_LUT CHR, 0x01, 0x01, 0x7F, 0x01, 0x01 
                EXITM
                ENDIF
                
        IF CHR=='U'    ;85                   
                GLCD_LUT CHR, 0x3F, 0x40, 0x40, 0x40, 0x3F 
                EXITM
                ENDIF
                
        IF CHR=='V'    ;86                   
                GLCD_LUT CHR, 0x1F, 0x20, 0x40, 0x20, 0x1F 
                EXITM
                ENDIF
                
        IF CHR=='W'    ;87                   
                GLCD_LUT CHR, 0x3F, 0x40, 0x38, 0x40, 0x3F 
                EXITM
                ENDIF
                
        IF CHR=='X'    ;88                   
                GLCD_LUT CHR, 0x63, 0x14, 0x08, 0x14, 0x63 
                EXITM
                ENDIF
                
        IF CHR=='Y'    ;89                   
                GLCD_LUT CHR, 0x07, 0x08, 0x70, 0x08, 0x07 
                EXITM
                ENDIF
                
        IF CHR=='Z'    ;90                   
                GLCD_LUT CHR, 0x61, 0x51, 0x49, 0x45, 0x43 
                EXITM
                ENDIF                  
        ENDM
        ENDASM
        '
        ASM 
  		;
  		;-----< TABLE_LETTERLOW >-------------------------------------------------------------------
  		;
  		;		Define ASCII Lowercase Letters
  		; 
TABLE_LETTERLOW MACRO CHR
        IF CHR=='a'    ;97                   
                GLCD_LUT CHR, 0x20, 0x54, 0x54, 0x54, 0x78 
                EXITM
                ENDIF
                
        IF CHR=='b'    ;98                   
                GLCD_LUT CHR, 0x7F, 0x48, 0x44, 0x44, 0x38 
                EXITM
                ENDIF
                
        IF CHR=='c'    ;99                   
                GLCD_LUT CHR, 0x38, 0x44, 0x44, 0x44, 0x20 
                EXITM
                ENDIF
                
        IF CHR=='d'    ;100                   
                GLCD_LUT CHR, 0x38, 0x44, 0x44, 0x48, 0x7F 
                EXITM
                ENDIF
                
        IF CHR=='e'    ;101                   
                GLCD_LUT CHR, 0x38, 0x54, 0x54, 0x54, 0x18 
                EXITM
                ENDIF
                
        IF CHR=='f'    ;102                   
                GLCD_LUT CHR, 0x08, 0x7E, 0x09, 0x01, 0x02 
                EXITM
                ENDIF
                
        IF CHR=='g'    ;103                   
                GLCD_LUT CHR, 0x0C, 0x52, 0x52, 0x52, 0x3E 
                EXITM
                ENDIF
                
        IF CHR=='h'    ;104                   
                GLCD_LUT CHR, 0x7F, 0x08, 0x04, 0x04, 0x78 
                EXITM
                ENDIF
                
        IF CHR=='i'    ;105                   
                GLCD_LUT CHR, 0x00, 0x44, 0x7D, 0x40, 0x00 
                EXITM
                ENDIF
                
        IF CHR=='j'    ;106                   
                GLCD_LUT CHR, 0x20, 0x40, 0x44, 0x3D, 0x00 
                EXITM
                ENDIF
                
        IF CHR=='k'    ;107                   
                GLCD_LUT CHR, 0x7F, 0x10, 0x28, 0x44, 0x00 
                EXITM
                ENDIF
                
        IF CHR=='l'    ;108                   
                GLCD_LUT CHR, 0x00, 0x41, 0x7F, 0x40, 0x00 
                EXITM
                ENDIF
                
        IF CHR=='m'    ;109                   
                GLCD_LUT CHR, 0x7C, 0x04, 0x18, 0x04, 0x78 
                EXITM
                ENDIF
                
        IF CHR=='n'    ;110                   
                GLCD_LUT CHR, 0x7C, 0x08, 0x04, 0x04, 0x78 
                EXITM
                ENDIF
                
        IF CHR=='o'    ;111                   
                GLCD_LUT CHR, 0x38, 0x44, 0x44, 0x44, 0x38 
                EXITM
                ENDIF
                
        IF CHR=='p'    ;112                   
                GLCD_LUT CHR, 0x7C, 0x14, 0x14, 0x14, 0x08 
                EXITM
                ENDIF
                
        IF CHR=='q'    ;113                   
                GLCD_LUT CHR, 0x08, 0x14, 0x14, 0x18, 0x7C 
                EXITM
                ENDIF
                
        IF CHR=='r'    ;114                   
                GLCD_LUT CHR, 0x7C, 0x08, 0x04, 0x04, 0x08 
                EXITM
                ENDIF
                
        IF CHR=='s'    ;115                   
                GLCD_LUT CHR, 0x48, 0x54, 0x54, 0x54, 0x20 
                EXITM
                ENDIF
                
        IF CHR=='t'    ;116                   
                GLCD_LUT CHR, 0x04, 0x3F, 0x44, 0x40, 0x20 
                EXITM
                ENDIF
                
        IF CHR=='u'    ;117                   
                GLCD_LUT CHR, 0x3C, 0x40, 0x40, 0x20, 0x7C 
                EXITM
                ENDIF
                
        IF CHR=='v'    ;118                   
                GLCD_LUT CHR, 0x1C, 0x20, 0x40, 0x20, 0x1C 
                EXITM
                ENDIF
                
        IF CHR=='w'    ;119                   
                GLCD_LUT CHR, 0x3C, 0x40, 0x30, 0x40, 0x3C 
                EXITM
                ENDIF
                
        IF CHR=='x'    ;120                    
                GLCD_LUT CHR, 0x44, 0x28, 0x10, 0x28, 0x44 
                EXITM
                ENDIF
                
        IF CHR=='y'    ;121                    
                GLCD_LUT CHR, 0x0C, 0x50, 0x50, 0x50, 0x3C 
                EXITM
                ENDIF
                
        IF CHR=='z'    ;122                    
                GLCD_LUT CHR, 0x44, 0x64, 0x54, 0x4C, 0x44 
                EXITM
                ENDIF
        ENDM
        ENDASM
        '
        ASM 
  		;
  		;-----< ADDCHAR >---------------------------------------------------------------------------
  		;
  		;		Add single or range of ASCII character to the character Lookup Table
  		;          
ADDCHAR MACRO CHR
    	IF CHR == CHR_ALL
            ADDRANGE 32,126
    		EXITM
    	    ENDIF
    	    
		IF CHR == CHR_NUMBERS
			ADDRANGE '0','9'
			EXITM
			ENDIF
			
		IF CHR == CHR_LETTERUP
			ADDRANGE 'A','Z'
			EXITM
			ENDIF
			
		IF CHR == CHR_LETTERLOW
			ADDRANGE 'a','z'
			EXITM
			ENDIF
		IF CHR == CHR_SYMBOLS
            ADDRANGE ' ', '/'
            ADDRANGE ':', '@'
            ADDRANGE '[','`'
            ADDRANGE '{','~'	
            EXITM
            ENDIF
        TABLE_SYMBOLS CHR    
        TABLE_NUMBERS CHR    	
        TABLE_LETTERUP CHR
        TABLE_LETTERLOW CHR
        IFDEF GLCD_CHAR_6X8
        	IF (PIC_TYPE==PIC18)
        			GLCD_LUT 0,0 ; Can't be odd address for PIC18
        		ELSE
        			GLCD_LUT 0
        		ENDIF
        	ENDIF	
		ENDM
		ENDASM
		'
		ASM
		;
		;-----< ADDCUSTOMCHAR >---------------------------------------------------------------------
		;
		;		Define user custom character
		; 
		IFDEF GLCD_CHAR_6X8
ADDCUSTOMCHAR   MACRO ChrNum, a,b,c,d,e,f
		        IF ChrNum>31 
		            ERROR "Custom Character number must be between 0 and 31"
		            ENDIF
		        IF (PIC_TYPE==PIC18)
		        		GLCD_LUT (0+ChrNum), a,b,c,d,e,f,0x00 ; NO Odd address allowed
		        	ELSE
		        		GLCD_LUT (0+ChrNum), a,b,c,d,e,f
		        	ENDIF
		        ENDM
			ELSE
ADDCUSTOMCHAR   MACRO ChrNum, a,b,c,d,e
		        IF ChrNum>31 
		            ERROR "Custom Character number must be between 0 and 31"
		            ENDIF
		        GLCD_LUT (0+ChrNum), a,b,c,d,e
		        ENDM        
        	ENDIF
        ;
        ;-----< ADDRANGE >--------------------------------------------------------------------------
        ;		
        ;		Used to add a range of ASCII Character to the Character LookupTable
        ;
ADDRANGE MACRO RSTART, REND	
				VARIABLE A
A=RSTART
			WHILE A<=REND
			ADDCHAR A
A++
			ENDW
		ENDM
    	ENDASM
		'-------------------------------------------------------------------------------------------------------------------------------------
		ASM
        ;
        ;-----< CHARTABLESTART >--------------------------------------------------------------------
        ;
        ;		Used to define the Start Address of the Character LookupTable
        ;      
CHARTABLESTART MACRO
		IFNDEF GLCD_CHAR_IN_EEPROM	; Save Lookup to the EEPROM?
        		L?GOTO CharLUTEndZ	; - NO, jump over the Lookuptable
CharLUTStart						;   StartAddress Label (will be a constant in Main code)
        	ELSE					;
INITIAL_ORG = $						; --- YES, save current ORG,so we can jump back after saving
									;	  all crispy info into the EEPROM		
CharLUTStart = 0					;     AND start at EEPROM location 0
        		ORG EEPROM_START   	;     Teleportation to the EEPROM... check.
        	ENDIF
    	ENDM
		;
		;-----< CHARTABLEEND >----------------------------------------------------------------------
		;
		;		Used to define the End Address of the Character LookupTable
		;
CHARTABLEEND MACRO
	    IFDEF GLCD_USE_SPECIFIC_CHARACTER	; The user want to use some specific character?
		        ADDCHAR ' ' 				; - YES, let's add the space character... for CLS
			ENDIF

	    IFDEF GLCD_CHAR_IN_EEPROM 			; Lookup table saved in EEPROM?
CharLUTEnd = $								; - YES, Save Current EEPROM loacation, for testing purpose
				;	NOTE:					;
		        ;	For some reasons, PBP do not always define the EEPROM_END address
		        ;	In case we have it, use it to prompt the user in case he overflow it.
		        ;	Case we don't have it, the user may/will experiment odd results... Not MY problem ;)        		
        		IFDEF EEPROM_END			;
            			IF (CharLUTEnd>EEPROM_END)		; EEPROM Overflow?
                				ERROR "Character/font Table too large to fit the EEPROM"
                							;			; YES, Blame the user :D
                			ENDIF			;
            		ENDIF					;   
CharLUTEnd= $ - EEPROM_START - TABLEJ   	; -----	Set End address to the current one -LENGTH 
											; -----	so we will read only the Character... and 
											; -----	avoid to jump in the LaLaLand... true story.			
        		ORG  INITIAL_ORG			; -----	Return to reality
        									;
        	ELSE							; - Lookup table is not saved in EEPROM
CharLUTEndZ									;   LookupTable end Label
CharLUTEnd = CharLUTEndZ - (TABLEJ*LUTStep)	;	Set the End Address
        	ENDIF
        ENDASM
'---------------------------------------------------------------------------------------------------
'
		Main_Code:
'		=========
		'
		'-----< GLCDClear >-------------------------------------------------------------------------
		'
		'		Clear the GLCD Screen by sending Space Character all over the place
		'
GLCDClear:                                              
        IF !IsInit THEN GOSUB GLCDInit	' If the GLCD is not already Initialised, then do it                    
        GOSUB GLCDHome					' Begin at 0,0
        GLCDData= " "					' assign Space character
        FOR GLCDCounter= 1 TO 84  		'
                GOSUB GLCDSendChar		'
                NEXT                    '                       
        GoTO GLCDHome					' Return @ 0,0
		'
		'-----< GLCDInit >--------------------------------------------------------------------------
		'
		'		Initialize the GLCD
		'
GLCDInit:                                                
        ASM
        MOVE?CT 0,  GLCD_RES  	; Reset the GLCD
        MOVE?CT 0,  GLCD_CLK	; 
        MOVE?CT 0,  GLCD_SDO	;
        MOVE?CT 1,  GLCD_RES  	; Release Reset
								;
        MOVE?CT 0,  GLCD_DC   	; Let's send some Command
        						; and use the Default OR User defined Values
        GLCDOUT_CMD?C (_SET_CONTRAST + GLCD_CONTRAST)
        GLCDOUT_CMD?C (_SET_TEMPERATURE_COEFFICIENT + GLCD_TEMPERATURE_COEFFICIENT) 
        GLCDOUT_CMD?C (_SET_BIAS + GLCD_BIAS)    
        						;
        GLCDOUT_CMD?C _BLANK	; Blank Mode
        GLCDOUT_CMD?C _NORMAL 	; Normal Mode 
          
        MOVE?CT 1,  _IsInit     ; Job done, let's make it public   
        ENDASM     
        Return
		'
		'-----< GLCDHome >-------------------------------------------------------------------------- 
		'
		'		Goto 0,0 coordinate       
GLCDHome:                                               
        PosX=0 : PosY=0
		'
		'-----< GLCDGotoXY >------------------------------------------------------------------------
		'
		'		Goto x,y Coordinate
		'
GLCDGotoXY:                                             
@       GLCD_GOTOXY _PosX, _PosY
        Return
		'
		'-----<	ShowIt >----------------------------------------------------------------------------
		'	
		' 		Self Explanatory, but this will 
		' 			1) read a single character from the user string
		' 			2) Call the Display routine, so it shows on the GLCD
		'			3) Wash & Rinse untill the end of the String
		'	
		' 		Not a load of comment in here, code is readable enough.
ShowIt: 
CheckCurrentChar:
		ASM
        IFDEF GLCD_STRING_IN_EEPROM
                ENDASM
                READ ADDR, CHAR
                IF !CHAR THEN RETURN
        		GOSUB SendSingleChar    '
                GOTO CheckCurrentChar   ' 
                ASM
            ELSE             
                IF (PIC_TYPE == PIC18)
                        ENDASM                  '
                        Readcode Addr, Char     '   
        				IF !Char THEN RETURN    '
                		GOSUB SendSingleChar    '
                        GOTO CheckCurrentChar   '               
                        ASM
                	ELSE
                        IF (PIC_TYPE == CODE_SPACE_READABLE)
                                ENDASM
                                Readcode Addr, TwoChars     ' Get the 14 bit packed characters
        		                Char = (TwoChars >> 7)      ' Get first char
        						IF !Char THEN RETURN        '
        		        		GOSUB SendSingleChar        '
        		        		'                           '
                 	            Char = TwoChars & $7F       ' Get second char
                   				IF !Char THEN RETURN        '
        		        		GOSUB SendSingleChar        '
                                Addr=Addr-1                 '
                                GOTO CheckCurrentChar       '
                                ASM
                        	ELSE            
                                IF (PIC_TYPE == CODE_SPACE_NOT_READABLE)
        		           				ENDASM     
                                        PEEKCODE Addr, Char                 ;
        		           				IF !Char THEN RETURN  ' If End of string, Getout of here
        				        		GOSUB SendSingleChar  ' Not end of string, show it
                                        GOTO CheckCurrentChar ' Wash & rinse
                                        ASM                   
                                    ENDIF
                            ENDIF 
                    ENDIF
            ENDIF
        ENDASM
		'
		'-----< SendSingleChar >--------------------------------------------------------------------
		'
		'		1) Set X,Y coordinate
		'		2) Display current character specified in Char variable	
		'		3) Increment Addr pointer
		'		4) Increment X coordinate by 6 (one Character width)
		'
SendSingleChar:
       	GOSUB GLCDGotoXY        '
       	GLCDData = Char 
       	GOSUB GLCDSendChar      ' puttext
       	Addr = Addr + 1         ' Point to next character
       	PosX = PosX + 6         '
        RETURN	
       	'
		'-----< Val2DecOut >------------------------------------------------------------------------
		'  
		'       This convert the Value of a user variable to the right numeric character
		'       This will 
        '           1) remove the leading zeros
        '           2) case the value passed is 0?  duh... will display it anyway
        '
        '       Value is read from Val2Dec Word variable.. an alias of TwoChars variable.
        '  
GLCDOUT_Val2Dec:
		@   IFDEF GLCD_2DEC_USED
		GotLeadingZero = 0                
        FOR GLCDCounter= 4 to 0 step -1   ' scroll all digits
                GOSUB GLCDGotoXY          ' goto x,y coordinate	
                IF !Val2Dec THEN          ' Value to display=0 ?  Yeah, we want to see it
                		GotLeadingZero = 1' --- Says it's a valid number
                		GLCDCounter= 0    ' --- says to get out after displaying it
                		ENDIF
                		
                GLCDData = (Val2Dec DIG GLCDCounter) ' get the number
                IF (GLCDData | GotLeadingZero) THEN  ' Is this a Number>0 OR a none leading 0?  
	                	GLCDData = GLCDData + 48     ' YES, convert to ASCII character
	                	GOSUB GLCDSendChar           ' ---  show it
	                	PosX = PosX + 6              ' ---  goto to next GLCD position
	                	GotLeadingZero = 1           ' ---  Says we got a first valid number
	                	ENDIF         
        		NEXT 
		RETURN
		@   ENDIF     
        '
		'-----< GLCDSendByte >----------------------------------------------------------------------
		'
		'		Use to send Command to the GLCD (Contrast & such)
		'		Used by GLCDOUT_CMD?CB & GLCDOUT_CMD?C macros
		'
GLCDSendByte:                                      
        IF IsCmdExtended THEN
                IF !IsEXTENDED THEN
                    IsExtended = 1
                    ToSend = $21
                    GOSUB ShiftThisOut
                    ENDIF
                ELSE
                IF IsExtended THEN
                    IsExtended = 0
                    ToSend= $20
                    GOSUB ShiftThisOut
                    ENDIF
                ENDIF     
        ToSend=GLCDData           
        GOSUB ShiftThisOut
        Return
		'
		'-----< GLCDSendChar >----------------------------------------------------------------------
		'
		'		Used to show a single character to the GLCD
		'		Called by various macro but user may also call it anytime by doing the following
		'			1) Assign a Character to GLCDData variable
		'			2) Gosub GLCDSendByte
		'			Easy...
		'
		'		Not a load of comments in here either, but code should be readable enough
		'
GLCDSendChar:   
@       IFDEF GLCD_CHAR_IN_EEPROM
                FOR LUTAddr = CharLUTStart TO CharLUTEnd STEP TABLEC
						READ LUTAddr, Char
						IF Char = GLCDData THEN
								@ MOVE?CT 1, GLCD_DC   
								LUTAddr = LUTAddr + 1
								FOR CharCounter = 0 TO CHARRANGE
										READ (LUTAddr + CharCounter), ToSend
										GOSUB ShiftThisOut
										NEXT
								ToSend = 0
								GOSUB ShiftThisOut                    
								@ MOVE?CT 0, GLCD_DC                        
								LUTAddr=CharLUTEnd
								ENDIF
                    	NEXT
@           ELSE
                FOR LUTAddr = CharLUTStart TO CharLUTEnd STEP (TABLEC * LUTStep)
@               		IF (PIC_TYPE == PIC18) || (PIC_TYPE == CODE_SPACE_READABLE)
@                           IF (PIC_TYPE == PIC18)
								READCODE LUTAddr, Char
@                               ELSE
								PEEKCODE LUTAddr, Char
@                               ENDIF
								IF Char = GLCDData THEN 
										@ MOVE?CT 1, GLCD_DC   
										LUTAddr = LUTAddr + LUTStep
										FOR CharCounter = 0 TO CHARRANGE
@                                           IF (PIC_TYPE == PIC18)
								                READCODE (LUTAddr + (CharCounter * LUTStep)), ToSend
@                                               ELSE
								                PEEKCODE (LUTAddr + (CharCounter * LUTStep)), ToSend
@                                               ENDIF
												GOSUB ShiftThisOut
												NEXT
										ToSend = 0
										GOSUB ShiftThisOut                    
										@ MOVE?CT 0, GLCD_DC                        
										LUTAddr = CharLUTEnd
										ENDIF
@                       	ELSE
	                            PEEKCODE LUTAddr, CHAR
	                            IF Char = GLCDData THEN
		                                @   MOVE?CT 1, GLCD_DC
		                                FOR CharCounter = 0 TO CHARRANGE
			                                    LUTAddr = LUTAddr + 1
			                                    PEEKCODE LUTAddr, ToSend
                                                GOSUB ShiftThisOut
			                                    NEXT
		                                ToSend = 0
		                                GOSUB ShiftThisOut                    
		                                @ MOVE?CT 0, GLCD_DC                        
		                                LUTAddr=CharLUTEnd
		                                ENDIF
@                       	ENDIF 
                NEXT
@               ENDIF
        RETURN
		'
		'-----< ShiftThisOut >----------------------------------------------------------------------
		'
		'		Really simple & tight home made SPI routine.
		'		Shift the data to the GLCD
		'        
ShiftThisOut:                
        ASM
        IFNDEF GLCD_OVERRIDE_CE
            MOVE?CT 0, GLCD_SCE      ; Enable Chip Select
            ENDIF

        MOVE?CB 8, _BitCounter       ; 8 Bits to shift out
ShiftBit                             ;
        MOVE?CT 0, GLCD_CLK          ; CLK pin low
        MOVE?TT _ToSend,7, GLCD_SDO  ; MSB bit first
        CHK?RP _ToSend               ;
        RLCF _ToSend, F
        MOVE?CT 1, GLCD_CLK          ; CLK pin high
        CHK?RP _BitCounter           ; 
        DECFSZ  _BitCounter, F       ; Done?
        GOTO ShiftBit                ; NO, Shift again
        MOVE?CT 0, GLCD_CLK          ; Yes, CLK pin idle low

        IFNDEF GLCD_OVERRIDE_CE
            MOVE?CT 1, GLCD_SCE      ; Disable Chip Select
            ENDIF
        ENDASM
        RETURN
        '
        '-------------------------------------------------------------------------------------------
        '
OverNokiaGLCD: 
        asm                                
        ENDM        ; End of CharTableEnd  Macro
        ;        
        ;-------< User code begin here >------------------------------------------------------------  
        ;
        IFNDEF GLCD_USE_SPECIFIC_CHARACTER
				CHARTABLESTART
				ADDCHAR CHR_ALL
				CHARTABLEEND
				ENDIF
        ENDASM
