'*****************************************************************************
'*  Name    : PBP_DHT_LIB.BAS                                                *
'*  Author  : Ken Buckner & Malcolm Crabbe                                   *
'*  Date    : 4/23/2015                                                      *
'*  Version : 0.04 (Branch from v0.02)                                       *
'*          :                                                                *
'*  Notice  : !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!    *
'*          : !!    THIS LIBRARY DOES NOT WORK WITH OSC BELOW 8 MHz    !!    *
'*          : !!    USE THE "PBP_DHT_LIB_4M.BAS" LIBRARY INSTEAD       !!    *
'*          : !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!    *
'*          :                                                                *
'*  Tested  : Tested on a PIC 18F4580 with DHT11/22(AM2302) Sensors          *
'*          :   With OSC Values of: 8,10,12,16,20,24,32,40,48 MHz            *
'*          :                                                                *
'*  Notes   : Library for communicating with the DHT(AM) series              *
'*          :  Humidity/Temperature sensors using the PBP "PulsIn" command.  *
'*          :                                                                *
'*          : Autocalculates the correct target pulsewidth counts for        *
'*          :  Sensor Initialization sequence timeout and                    *
'*          :  Humidity/Temperature reading values for binary data.          *
'*          :  Uses "DEFINE OSC" statement in the user's main PBP program    *
'*          :  to calculate pulswidth counts for most all PBP OSC values.    *
'*          :                                                                *
'*  Main    :  DHT_Read                                                      *
'*  Call    :                                                                *
'*          :                                                                *
'*  Usage   : Include this file with "include PBP_DHT_LIB.BAS" statement.    *
'*          :                                                                *
'*          : For each call to the DHT_Read routine, perform the following   *
'*          :   1. Set the Sensor Type                                       *
'*          :   2. Set the Sensor Number to read                             *
'*          :   3. Call the DHT_Read routine                                 *
'*          :                                                                *
'*          :   e.g.                                                         *
'*          :     DHT_Sensor_Type = AM2302                                   *
'*          :     DHT_Sensor_Num = 1 'Select Sensor 1                        *
'*          :     gosub DHT_Read                                             *
'*          :                                                                *
'*          : !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!     *
'*          :    CAUTION: If using mixed sensor types within the same        *
'*          :             program, you MUST set the "DHT_Sensor_Type"        *
'*          :             BEFORE EACH CALL to the DHT_Read routine.          *
'*          : !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!     *
'*          :                                                                *
'*          :                                                                *
'*Parameters: DHT_Sensor_Type - (con) DHT(AM) Sensor type used.              *
'*          :   DHT11, DHT21, DHT22, AM2302                                  *
'*          :                                                                *
'*          : DHT_Sensor_Num  - (byte) Sensor number 1 to 4 which selects    *
'*          :   an Alias from your MAIN program that points to a             *
'*          :   PIC pin attached to a DHT(AM) sensor data pin.               *
'*          :                                                                *
'*          :                                                                *
'*  Returns : DHT_Humidity   - (word) - Humidity Integral & decimal place    *
'*          :                   e.g. 652 ($028C) = 65.2% RH                  *
'*          :                                                                *
'*          : DHT_Temperture - (word) - Temperature Integral & decimal place *
'*          :                   e.g. 351 ($015F) = 35.1 degC                 *
'*          :                                                                *
'*          : DHT_Checksum   - (byte) - Sensor data payload checksum         *
'*          :                                                                *
'*          : DHT_Error      - (byte) - Routine/Sensor error codes           *
'*          :                                                                *
'*****************************************************************************

'-----------------------------------------------------------------------------
'-- Place a copy of these variables/constants/defines in your Main program  --
'-- BEFORE YOUR "INCLUDE PBP_DHT_LIB.BAS" STATEMENT                         --
'--   Do Not un-comment these lines in the "PBP_DHT_LIB.BAS" file.          --
'-----------------------------------------------------------------------------
'-- In your Main program, uncomment and Assign the CORRECT port alias       --
'--  to each of the "DHT_Sensor_x" lines below.                             --
'--                                                                         --
'--  !!MAKE SURE YOUR PORT PINS ARE SET FOR DIGITAL TO CONNECT TO SENSORS!! --
'--                                                                         --
'DHT_Sensor_1 var PORTA.1 ' Assign Sensor #1 Alias
'DHT_Sensor_2 var PORTA.1 ' Assign Sensor #2 Alias
'DHT_Sensor_3 var PORTA.1 ' Assign Sensor #3 Alias
'DHT_Sensor_4 var PORTA.1 ' Assign Sensor #4 Alias

'-- In your Main program, uncomment and Assign the correct value to         --
'--  the "DHT_MAX_SENSORS" constant below.                                  --
'DHT_MAX_SENSORS CON 4    ' Number of Sensors Configured

'-- In your Main program, uncomment and Assign the correct value to         --
'--  the "DEFINE OSC x" statement below.                                    --
'DEFINE OSC 8         ' ** CHANGE TO CORRECT OSC FREQUENCY **
                     ' ** "DEFINE OSC" IS CASE SENSITIVE (UPPERCASE) **

'-- In your Main program, uncomment the correct "DEFINE PULSIN_MAX" line    --
'--  below for your OSC value.                                              --
'--  Sets the PULSIN Timeout & maximum-pulse count value.  
'--  This DEFINE also affects RCTIME in the same manner.
'DEFINE PULSIN_MAX 100  ' 8Mhz OSC    
'DEFINE PULSIN_MAX 125  ' 10Mhz OSC 
'DEFINE PULSIN_MAX 150  ' 12Mhz OSC 
'DEFINE PULSIN_MAX 200  ' 16Mhz OSC 
'DEFINE PULSIN_MAX 250  ' 20Mhz OSC 
'DEFINE PULSIN_MAX 300  ' 24Mhz OSC 
'DEFINE PULSIN_MAX 313  ' 25Mhz OSC 
'DEFINE PULSIN_MAX 400  ' 32Mhz OSC 
'DEFINE PULSIN_MAX 413  ' 33Mhz OSC 
'DEFINE PULSIN_MAX 500  ' 40Mhz OSC 
'DEFINE PULSIN_MAX 600  ' 48Mhz OSC 
'DEFINE PULSIN_MAX 800  ' 64Mhz OSC 
'---------------------------------------------------------------------------

'---------------------------------------------------------------------------
'-- INSTRUCTIONS                                                          --
'-- To REMOVE SENSORS, perform the following:                             --
'--   1. Change the "DHT_MAX_SENSORS" constant to the correct number.     --
'--   2. Comment out the appropriate "DHT_Sensor_x" Alias lines.          --
'--   3. In the "DHT_Read" subroutine in the library file,                --
'--      edit the "select case DHT_Sensor_Num" block, comment out the     --
'--      "Case x" portion for the sensor number you want to remove.       --
'--   4. Comment out the entire "Read_DHT_x" subroutine at the end        --
'--      of this library file for the sensor you want to remove.          --
'--                                                                       --
'-- To ADD SENSORS, perform the following:                                --
'--   1. Change the "DHT_MAX_SENSORS" constant to the correct number      --
'--   2. Add a New "DHT_Sensor_x" Alias line below where the              --
'--         "_x" portion is a new number.                                 --
'--   3. In the "DHT_Read" subroutine in the library file,                --
'--      edit the "select case DHT_Sensor_Num" block, add a new           --
'--      "Case x" portion for the sensor number you want to add.          --
'--   4. Add a New "Read_DHT_x" subroutine at the end of this library     --
'--         file for the new sensor.                                      --
'--                                                                       --
'---------------------------------------------------------------------------
                             
'** Constants **
                            ' DHT_Init_TO & DHT_Val1 are automatically
                            '  calculated at compile time.  Calculations are
                            '  based upon "DEFINE OSC" command in main program.
DHT_Init_TO    CON EXT      ' Timeout Count from PulsIn for Init sequence
DHT_Val1       CON EXT      ' Count from PulsIn to recognize a "1"
PulsinCountMax con EXT      ' ASM Messages
''MyFreq         con EXT      ' FOR DEBUG ONLY 

DHT11          con 11       ' Constant for  DHT11 type sensor
DHT21          con 21       ' Constant for  DHT21 type sensor
DHT22          con 22       ' Constant for  DHT22 type sensor
AM2302         con 22       ' Constant for AM2302 type sensor

Init_High_1    con 20       ' Duration of High
Init_Low_1     con 20       ' Duration of Low
Init_High_2    con 40       ' Duration of High
'** End of Constants **

'** Variables **
''** Used by calling program **
DHT_Sensor_Type var byte     ' Variable to select the Sensor Type
DHT_Sensor_Num  var byte     ' Variable to select which Sensor to read
DHT_Humidity    var word     ' Humidity value, integral & decimal place
DHT_Temperature var word     ' Temperature value, integral & decimal place degC    
DHT_Checksum    var byte     ' Checksum of payload data from sensor
DHT_Error       var byte     ' Bitfield to hold AM2302 Read Errors
                                    ' b7 = Invalid Sensor Number
                                    ' b6 = Invalid Sensor Type
                                    ' b5 = Checksum Timeout Error
                                    ' b4 = Checksum Error
                                    ' b3 = Temperature Read Error
                                    ' b2 = Humidity Read Error
                                    ' b1 = Initialization Error
                                    ' b0 = Timeout Error

''** FOR DEBUGGING ONLY ***************************************************
''DHT_Raw_Hum     var word     ' FOR DEBUGGING ONLY
''DHT_Raw_Temp    var word     ' FOR DEBUGGING ONLY
''*************************************************************************

''** Used internally by Library **
DHT_Init_Data   var byte     ' Holds Init response pulse counts
DHT_Data        var byte[40] ' Byte array to hold data from sensor
DHT_Tchk        var byte     ' Test Checksum
                                                        
j              var byte     ' Generic counter
k              var byte     ' Generic counter
'** End of Variables **

'** Aliases **
DHT_TIMEOUT_ERROR    var DHT_Error.0
DHT_INIT_ERROR       var DHT_Error.1
DHT_HUM_ERROR        var DHT_Error.2
DHT_TEMP_ERROR       var DHT_Error.3
DHT_CHK_ERROR        var DHT_Error.4
DHT_CHK_TO_ERROR     var DHT_Error.5    
DHT_SENSORTYPE_ERROR var DHT_Error.6    
DHT_SENSORNUM_ERROR  var DHT_Error.7
'** End of Aliases **

'** Assembly statements to calculate Init Timeout and "1" values **
   ' DHT_Init_TO Count calculated for target 20us
   ' DHT_Val1 Count calculated for target 36us
   ' PULSIN_MAX calculated for ~500us
asm
#DEFINE ENABLE_AM_MSG 1     ; Change to 0 to supress Compile messages
    variable myOSC = 8
    
    IF OSC < 8
    ERROR This library is for 8MHz "OSC" values or higher!! Use the "PBP_DHT_LIB_4M.BAS" library instead.

; Set the default to 8MHz OSC values
DHT_Init_TO = 4
DHT_Val1 = 7
    ENDIF

; Check for OSC value and configure settings
    IF OSC == 8     ;  8MHz
myOSC = OSC
DHT_Init_TO = 4
DHT_Val1 = 7
    EndIF    
    IF OSC == 10    ; 10MHz
myOSC = OSC
DHT_Init_TO = 5
DHT_Val1 = 9
    EndIF    
    IF OSC == 12    ; 12MHz
myOSC = OSC
DHT_Init_TO = 6
DHT_Val1 = 11
    EndIF    
    IF OSC == 16    ; 16MHz
myOSC = OSC
DHT_Init_TO = 8
DHT_Val1 = 14
    EndIF    
    IF OSC == 20    ; 20MHz
myOSC = OSC
DHT_Init_TO = 10
DHT_Val1 = 18
    EndIF    
    IF OSC == 24    ; 24MHz
myOSC = OSC
DHT_Init_TO = 12
DHT_Val1 = 22
    EndIF    
    IF OSC == 25    ; 25MHz
myOSC = OSC
DHT_Init_TO = 13
DHT_Val1 = 23
    EndIF    
    IF OSC == 32    ; 32MHz
myOSC = OSC
DHT_Init_TO = 16
DHT_Val1 = 29
    EndIF    
    IF OSC == 33    ; 33MHz
myOSC = OSC
DHT_Init_TO = 17
DHT_Val1 = 30
    EndIF    
    IF OSC == 40    ; 40MHz
myOSC = OSC
DHT_Init_TO = 20
DHT_Val1 = 36
    EndIF    
    IF OSC == 48    ; 48MHz
myOSC = OSC
DHT_Init_TO = 24
DHT_Val1 = 43
    EndIF    
    IF OSC == 64    ; 64MHz
myOSC = OSC
DHT_Init_TO = 32
DHT_Val1 = 58
    EndIF
    
PulsinCountMax = PULSIN_MAX
;;MyFreq = myOSC ; FOR DEBUG ONLY

    IF (ENABLE_AM_MSG == 1)
        messg PulsIn Parameters set to #v(myOSC)MHz Oscillator values 
        messg "DHT_Init_TO":#v(DHT_Init_TO), "DHT_Val1":#v(DHT_Val1), "PULSIN_MAX":#v(PULSIN_MAX)
        messg "DHT_MAX_SENSORS":#v(_DHT_MAX_SENSORS) 
        ifdef _DHT_Sensor_1
            messg Sensor_1 Enabled
        endif
        ifdef _DHT_Sensor_2
            messg Sensor_2 Enabled
        endif
        ifdef _DHT_Sensor_3
            messg Sensor_3 Enabled
        endif
        ifdef _DHT_Sensor_4
            messg Sensor_4 Enabled
        endif
    ENDIF
    

#UNDEFINE ENABLE_AM_MSG 
endasm
'** END of Assembly statements **


goto overDHT    '' Skip to end of the Library

'*****************************************************************************

  '*****************************
  '**Start of Library Routines**
  '*****************************

DHT_Read:
    DHT_Init_Data   = 0    ' Clear the Init response byte
    DHT_Error       = 0    ' Clear all errors
    DHT_Humidity    = 0    ' Clear the Humidity value
    DHT_Temperature = 0    ' Clear the Temperature value
    DHT_Checksum    = 0    ' Clear the Checksum value
    DHT_Tchk        = 0    ' Clear the Temp checksum value
    
    for j = 0 to 39
        DHT_Data[j] = 0  ' Clear the Raw Sensor data array    
    next j
    
    ' Check Sensor Number
    if DHT_Sensor_Num = 0 or DHT_Sensor_Num > DHT_MAX_SENSORS then
        DHT_SENSORNUM_ERROR = 1  ' Not a valid sensor number
        return  ' Return to Main Program    
    endif
    
    'Check Sensor Type
    select case DHT_Sensor_Type
        case DHT11
        case DHT21
        case DHT22  'Includes AM2302 type sensor
        case else
            ' Set Sensor Type Error
            DHT_SENSORTYPE_ERROR = 1
            return  ' Return to Main program
    end select
    
    
  
'****************************************************************************
'*** EDIT THIS SELECT CASE BLOCK TO ADD/REMOVE SENSORS (see instructions) ***
'****************************************************************************
    select case DHT_Sensor_Num
        case 1           'Sensor #1      
            gosub Read_DHT_1
        case 2           'Sensor #2
            gosub Read_DHT_2
        case 3           'Sensor #2
            gosub Read_DHT_3
        case 4           'Sensor #2
            gosub Read_DHT_4
    end select 
'****************************************************************************
'****************************************************************************

'*********************************
'** Bad Sensor-Comms Abort Test **
    if DHT_INIT_ERROR = 1 then return    'Intialization error, abort the read
'*********************************
  
 
  '**Convert the Humidity byte array to a 16bit word variable
    DHT_Humidity = 0 'Clear word variable which holds the final 
                      '16bit humidity value
    
    k = 15  'Used to select the correct bit in the word variable
    for j = 0 to 15 step 1          'Read the 16 bytes for humidity in the 
                                     'byte array (humidity pulsewidth values)
        If DHT_Data(j) = 0 then     'Timeout occured during pulsin
            DHT_HUM_ERROR = 1       'Set Humidity Read Error    
        endif
        if DHT_Data(j) >= DHT_Val1 then DHT_Humidity.0[k] = 1 
        'If the pulsewidth is => 36us then the value is a "1".
        'otherwise, the value is a "0", so we do not need to do anything
        k = k - 1    
    next j
  '**End Humidity Conversion**
    
  '**Convert the Temperature byte array to a 16bit word variable
    DHT_Temperature = 0   'Clear word variable which holds the final 
                            '16bit temperature value
    
    k = 15  'Used to select the correct bit in the word variable
    for j = 16 to 31 step 1         'Read the 16 bytes for temperature in the 
                                     'byte array (temperature pulsewidth values)
        
        If DHT_Data(j) = 0 then     'Timeout Occured during pulsin
            DHT_TEMP_ERROR = 1      'Set Temperature Read Error    
        endif
        if DHT_Data(j) >= DHT_Val1 then DHT_Temperature.0[k] = 1 
        'If the pulsewidth is => 36us then the value is a "1".
        'otherwise, the value is a "0", so we do not need to do anything
        k = k - 1    
    next j
  '**End Temperature Conversion**
    
  '**Convert the Checksum byte array to a 16bit word variable
    DHT_Checksum = 0   'Clear word variable which holds the final 
                           '8bit checksum value
    
    k = 7  'Used to select the correct bit in the word variable
    for j = 32 to 39 step 1         'Read the 8 bytes for checksum in the 
                                     'byte array (checksum pulsewidth values)
        If DHT_Data(j) = 0 then     'Timeout Occured during pulsin
            DHT_CHK_TO_ERROR = 1    'Set Timeout Error    
        endif
        if DHT_Data(j) >= DHT_Val1 then DHT_Checksum.0[k] = 1 
        'If the pulsewidth is => 36us then the value is a "1".
        'otherwise, the value is a "0", so we do not need to do anything
        k = k - 1    
    next j
  '**End Checksum Conversion**
    
  '**Test the checksum**
    DHT_Tchk = DHT_Humidity.byte1 + DHT_Humidity.byte0 + _
               DHT_Temperature.byte1 + DHT_Temperature.byte0
    if DHT_Checksum <> DHT_Tchk then 
        DHT_CHK_ERROR = 1    'Set Checksum Error
    endif
  '**End Checksum Test**
  
  '**Change return value for the DHT11 Sensor to a Word like the DHT21/22 
  if DHT_Sensor_Type = DHT11 then
    DHT_Humidity = (DHT_Humidity >> 8) * 10
    DHT_Temperature = (DHT_Temperature >> 8) * 10
  endif
  
''**********************************************************
''  DHT_Raw_Hum = DHT_Humidity        ' For Debugging ONLY
''  DHT_Raw_Temp = DHT_Temperature    ' For Debugging ONLY
''**********************************************************

    return  ' Return to Main Program


'****************************************************************************
'*** EDIT THESE SUBROUTINES TO ADD/REMOVE SENSORS (see instructions)      ***
'****************************************************************************

Read_DHT_1:

    '** You may want to disable interrupts from here to the end of the 
    '**  DHT communication sequence (see below)
    '**  If using DT_INTS then this would be "@ INT_DISABLE xxxxx" where xxxxx is
    '**  the name of the interrupt.    
    ' @ INT_DISABLE xxxx for DT_INT or disable interrupts for PBP interrupts

    '**Intialization sequence to sensor**
    high DHT_Sensor_1
''   '250ms High on data pin to sensor
    pause Init_High_1
    
    low DHT_Sensor_1
    pause Init_Low_1          
    
    high DHT_Sensor_1
''    '40us High on data pin to sensor
    pauseus Init_High_2
    
    'Read the sensor's acknowledgment of init sequence
    'Read a High pulse from the sensor 
    PulsIn DHT_Sensor_1, 1, DHT_Init_Data
    '**End of Intialization sequence to sensor**

    '** Check Initialization Response from Sensor**
    if DHT_Init_Data = 0 then           'Timeout occured
        DHT_TIMEOUT_ERROR = 1           'Set Timeout Error
        DHT_INIT_ERROR = 1              'Set Intit Error 
        return      'Abort the communications, Sensor did not respond
    endif
    if DHT_Init_Data < DHT_Init_TO then  'Not a good signal, maybe noise?    
        DHT_INIT_ERROR = 1               'Set Init Error
        return      'Abort the communications, Sensor did not respond
    endif

    '**Load data from sensor into the byte array
    for j = 0 to 39 step 1
        ' Read data High pulses (bits) from the sensor and store them as 
        ' pulsewidth counts in individual bytes in the byte array.

        PulsIn DHT_Sensor_1, 1, DHT_Data[j]
    next j
    '**End of Load Data**

'** Re-enable interrupts if they were previously disabled
'  '@ INT_ENABLE xxxxx for DT_INT or enable interrupts for PBP interrupts

    return  ' Return to calling routine
    
Read_DHT_2:
    '** You may want to disable interrupts from here to the end of the 
    '**  DHT communication sequence (see below)
    '**  If using DT_INTS then this would be "@ INT_DISABLE xxxxx" where xxxxx is
    '**  the name of the interrupt.    
    ' @ INT_DISABLE xxxx for DT_INT or disable interrupts for PBP interrupts

    '**Intialization sequence to sensor**
    high DHT_Sensor_2
''   '250ms High on data pin to sensor
    pause Init_High_1 '250
    
    low DHT_Sensor_2
    pause Init_Low_1          
    
    high DHT_Sensor_2
''    '40us High on data pin to sensor
    pauseus Init_High_2
    
    'Read the sensor's acknowledgment of init sequence
    'Read a High pulse from the sensor 
    PulsIn DHT_Sensor_2, 1, DHT_Init_Data
    '**End of Intialization sequence to sensor**

    '** Check Initialization Response from Sensor**
    if DHT_Init_Data = 0 then           'Timeout occured
        DHT_TIMEOUT_ERROR = 1           'Set Timeout Error
        DHT_INIT_ERROR = 1              'Set Intit Error 
        return      'Abort the communications, Sensor did not respond
    endif
    if DHT_Init_Data < DHT_Init_TO then  'Not a good signal, maybe noise?    
        DHT_INIT_ERROR = 1               'Set Init Error
        return      'Abort the communications, Sensor did not respond
    endif

    '**Load data from sensor into the byte array
    for j = 0 to 39 step 1
        ' Read data High pulses (bits) from the sensor and store them as 
        ' pulsewidth counts in individual bytes in the byte array.

        PulsIn DHT_Sensor_2, 1, DHT_Data[j]
    next j
    '**End of Load Data**

'** Re-enable interrupts if they were previously disabled
'  '@ INT_ENABLE xxxxx for DT_INT or enable interrupts for PBP interrupts

    return  ' Return to calling routine
    
Read_DHT_3:
    '** You may want to disable interrupts from here to the end of the 
    '**  DHT communication sequence (see below)
    '**  If using DT_INTS then this would be "@ INT_DISABLE xxxxx" where xxxxx is
    '**  the name of the interrupt.    
    ' @ INT_DISABLE xxxx for DT_INT or dissable interrupts for PBP interrupts

    '**Intialization sequence to sensor**
    high DHT_Sensor_3
''   '250ms High on data pin to sensor
    pause Init_High_1
    
    low DHT_Sensor_3
    pause Init_Low_1          
    
    high DHT_Sensor_3
''    '40us High on data pin to sensor
    pauseus Init_High_2
    
    'Read the sensor's acknowledgment of init sequence
    'Read a High pulse from the sensor 
    PulsIn DHT_Sensor_3, 1, DHT_Init_Data
    '**End of Intialization sequence to sensor**

    '** Check Initialization Response from Sensor**
    if DHT_Init_Data = 0 then           'Timeout occured
        DHT_TIMEOUT_ERROR = 1           'Set Timeout Error
        DHT_INIT_ERROR = 1              'Set Intit Error 
        return      'Abort the communications, Sensor did not respond
    endif
    if DHT_Init_Data < DHT_Init_TO then  'Not a good signal, maybe noise?    
        DHT_INIT_ERROR = 1               'Set Init Error
        return      'Abort the communications, Sensor did not respond
    endif

    '**Load data from sensor into the byte array
    for j = 0 to 39 step 1
        ' Read data High pulses (bits) from the sensor and store them as 
        ' pulsewidth counts in individual bytes in the byte array.

        PulsIn DHT_Sensor_3, 1, DHT_Data[j]
    next j
    '**End of Load Data**

'** Re-enable interrupts if they were previously disabled
'  '@ INT_ENABLE xxxxx for DT_INT or enable interrupts for PBP interrupts

    return  ' Return to calling routine
    
Read_DHT_4:
    '** You may want to disable interrupts from here to the end of the 
    '**  DHT communication sequence (see below)
    '**  If using DT_INTS then this would be "@ INT_DISABLE xxxxx" where xxxxx is
    '**  the name of the interrupt.    
    ' @ INT_DISABLE xxxx for DT_INT or disable interrupts for PBP interrupts

    '**Intialization sequence to sensor**
    high DHT_Sensor_4
''   '250ms High on data pin to sensor
    pause Init_High_1
    
    low DHT_Sensor_4
    pause Init_Low_1          
    
    high DHT_Sensor_4
''    '40us High on data pin to sensor
    pauseus Init_High_2
    
    'Read the sensor's acknowledgment of init sequence
    'Read a High pulse from the sensor 
    PulsIn DHT_Sensor_4, 1, DHT_Init_Data
    '**End of Intialization sequence to sensor**

    '** Check Initialization Response from Sensor**
    if DHT_Init_Data = 0 then           'Timeout occured
        DHT_TIMEOUT_ERROR = 1           'Set Timeout Error
        DHT_INIT_ERROR = 1              'Set Intit Error 
        return      'Abort the communications, Sensor did not respond
    endif
    if DHT_Init_Data < DHT_Init_TO then  'Not a good signal, maybe noise?    
        DHT_INIT_ERROR = 1               'Set Init Error
        return      'Abort the communications, Sensor did not respond
    endif

    '**Load data from sensor into the byte array
    for j = 0 to 39 step 1
        ' Read data High pulses (bits) from the sensor and store them as 
        ' pulsewidth counts in individual bytes in the byte array.

        PulsIn DHT_Sensor_4, 1, DHT_Data[j]
    next j
    '**End of Load Data**

'** Re-enable interrupts if they were previously disabled
'  '@ INT_ENABLE xxxxx for DT_INT or enable interrupts for PBP interrupts

    return  ' Return to calling routine

'****************************************************************************
'****************************************************************************

  '*****************************
  '**End of Library Routines  **
  '*****************************


overDHT:



