'****************************************************************
'*  Name    : DHT_Test.BAS                                      *
'*  Author  : TABsoft                                           *
'*  Notice  : Copyright (c) 2015 TABSoft                        *
'*          : All Rights Reserved                               *
'*  Date    : 4/28/2015                                         *
'*  Version : 1.0                                               *
'*  Notes   :                                                   *
'*          :                                                   *
'****************************************************************

''PIC 18F4580
;#CONFIG    ; For PBP3
ASM         ;For PBP v2  
  __CONFIG    _CONFIG1H, _OSC_HSPLL_1H
  __CONFIG    _CONFIG2L, _PWRT_ON_2L  
  __CONFIG    _CONFIG2H, _WDT_ON_2H & _WDTPS_512_2H
  __CONFIG    _CONFIG3H, _PBADEN_OFF_3H
  __CONFIG    _CONFIG4L, _LVP_OFF_4L & _XINST_OFF_4L
ENDASM      ; For PBP v2
;#ENDCONFIG ; For PBP3


'-----------------------------------------------------------------------------
'-- Place a copy of these variables/constants/defines in your Main program  --
'-- BEFORE YOUR "INCLUDE PBP_DHT_LIB.BAS" STATEMENT                         --
'--   Do Not un-comment these lines in the "PBP_DHT_LIB.BAS" file.          --
'-----------------------------------------------------------------------------
'-- In your Main program, uncomment and Assign the CORRECT port alias       --
'--  to each of the "DHT_Sensor_x" lines below.                             --
'--                                                                         --
'--  !!MAKE SURE YOUR PORT PINS ARE SET FOR DIGITAL TO CONNECT TO SENSORS!! --
'--                                                                         --
DHT_Sensor_1 var PORTA.1 ' Assign Sensor #1 Alias
DHT_Sensor_2 var PORTA.1 ' Assign Sensor #2 Alias
DHT_Sensor_3 var PORTA.1 ' Assign Sensor #3 Alias
DHT_Sensor_4 var PORTA.1 ' Assign Sensor #4 Alias

'-- In your Main program, uncomment and Assign the correct value to         --
'--  the "DHT_MAX_SENSORS" constant below.                                  --
DHT_MAX_SENSORS CON 4    ' Number of Sensors Configured

'-- In your Main program, uncomment and Assign the correct value to         --
'--  the "DEFINE OSC x" statement below.                                    --
'DEFINE OSC 8         ' ** CHANGE TO CORRECT OSC FREQUENCY **
                     ' ** "DEFINE OSC" IS CASE SENSITIVE (UPPERCASE) **

'-- In your Main program, uncomment the correct "DEFINE PULSIN_MAX" line    --
'--  below for your OSC value.                                              --
'--  Sets the PULSIN Timeout & maximum-pulse count value.  
'--  This DEFINE also affects RCTIME in the same manner.
'DEFINE PULSIN_MAX 100  ' 8Mhz OSC    
'DEFINE PULSIN_MAX 125  ' 10Mhz OSC 
'DEFINE PULSIN_MAX 150  ' 12Mhz OSC 
'DEFINE PULSIN_MAX 200  ' 16Mhz OSC 
'DEFINE PULSIN_MAX 250  ' 20Mhz OSC 
'DEFINE PULSIN_MAX 300  ' 24Mhz OSC 
'DEFINE PULSIN_MAX 313  ' 25Mhz OSC 
'DEFINE PULSIN_MAX 400  ' 32Mhz OSC 
'DEFINE PULSIN_MAX 413  ' 33Mhz OSC 
DEFINE PULSIN_MAX 500  ' 40Mhz OSC 
'DEFINE PULSIN_MAX 600  ' 48Mhz OSC 
'DEFINE PULSIN_MAX 800  ' 64Mhz OSC 
'---------------------------------------------------------------------------

DEFINE  OSC 40

include "PBP_DHT_LIB.BAS"


DEFINE LCD_DREG  PORTB           ' LCD Data port
DEFINE LCD_DBIT  0               ' starting Data bit (0 or 4)
DEFINE LCD_EREG  PORTB           ' LCD Enable port
DEFINE LCD_EBIT  5               '     Enable bit  (on EasyPIC 5 LCD)
DEFINE LCD_RSREG PORTB           ' LCD Register Select port
DEFINE LCD_RSBIT 4               '     Register Select bit   (on EasyPIC 5 LCD)
DEFINE LCD_BITS  4               ' LCD bus size (4 or 8 bits)
DEFINE LCD_LINES 4               ' number of lines on LCD
DEFINE LCD_COMMANDUS 2000        ' Command delay time in us 
DEFINE LCD_DATAUS 50             ' Data delay time in us 

CMCON = 7                                       ' disable Comparators
    ADCON0.0 = 0  ' A/D Converter module is disabled   
    ADCON1 = $0F  ' %0000 1111 AN2=VSS, AN3=VDD, AN12-0 = Digital 
    ADCON2 = $00  ' %0000 0000

loopcount var byte

main:
    for loopcount = 1 to 4
        lcdout $FE,1
        lcdout $FE, $80, "# ", dec loopcount, ":"
        DHT_Sensor_Type = DHT22
        DHT_Sensor_Num = loopcount
        gosub DHT_Read
        lcdout $FE, $80+4, dec DHT_Humidity/10, ".",dec DHT_Humidity//10,"% ", _
          dec DHT_Temperature/10, ".", dec DHT_Temperature//10," C"
        lcdout $FE, $C0, "Err: ", Ibin8 DHT_Error, " CK: ", IHex2 DHT_Checksum
        pause 3000
    next loopcount
    pause 3000
goto main 
