VERSION 5.00
Begin VB.Form MainForm 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "USB VB6 Template"
   ClientHeight    =   4032
   ClientLeft      =   5496
   ClientTop       =   4080
   ClientWidth     =   4764
   Icon            =   "FormMain.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4032
   ScaleWidth      =   4764
   ShowInTaskbar   =   0   'False
   StartUpPosition =   2  'CenterScreen
   Begin VB.CheckBox Send2 
      Caption         =   "Array 2"
      Height          =   204
      Left            =   2256
      TabIndex        =   9
      Top             =   1488
      Width           =   204
   End
   Begin VB.CheckBox Send1 
      Caption         =   "Array 1"
      Height          =   204
      Left            =   2256
      TabIndex        =   8
      Top             =   1200
      Width           =   204
   End
   Begin VB.CommandButton cClearUSBRx 
      Caption         =   "Clear RX"
      Height          =   252
      Left            =   2832
      TabIndex        =   6
      Top             =   3648
      Width           =   1116
   End
   Begin VB.TextBox tUSBRx 
      CausesValidation=   0   'False
      Height          =   1452
      Left            =   2304
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   0
      TabStop         =   0   'False
      Text            =   "FormMain.frx":030A
      Top             =   2112
      Width           =   2316
   End
   Begin VB.Label lblInfo3 
      Caption         =   "Values will also be sent at application start-up and MCLR"
      Height          =   876
      Left            =   768
      TabIndex        =   16
      Top             =   2688
      Width           =   1428
   End
   Begin VB.Label lblInfo2 
      Caption         =   "Values are returned here"
      Height          =   444
      Left            =   768
      TabIndex        =   15
      Top             =   2160
      Width           =   1428
   End
   Begin VB.Label lblStep2 
      Caption         =   "Step 2:"
      Height          =   204
      Left            =   144
      TabIndex        =   14
      Top             =   2160
      Width           =   564
   End
   Begin VB.Label lblInfo1 
      Caption         =   "Toggle these"
      Height          =   444
      Left            =   768
      TabIndex        =   13
      Top             =   1152
      Width           =   1428
   End
   Begin VB.Label lblStep1 
      Caption         =   "Step 1:"
      Height          =   204
      Left            =   144
      TabIndex        =   12
      Top             =   1152
      Width           =   564
   End
   Begin VB.Label Label2 
      Caption         =   "Send array 2"
      Height          =   204
      Left            =   2544
      TabIndex        =   11
      Top             =   1488
      Width           =   1692
   End
   Begin VB.Label Label1 
      Caption         =   "Send array 1"
      Height          =   204
      Left            =   2544
      TabIndex        =   10
      Top             =   1200
      Width           =   1692
   End
   Begin VB.Label lUSBTx 
      Alignment       =   2  'Center
      Appearance      =   0  'Flat
      BackColor       =   &H0000C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "USB data to the PIC"
      ForeColor       =   &H80000008&
      Height          =   252
      Left            =   120
      TabIndex        =   7
      Top             =   840
      Width           =   4296
   End
   Begin VB.Label lUSBRx 
      Alignment       =   2  'Center
      Appearance      =   0  'Flat
      BackColor       =   &H0000C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "USB data from the PIC"
      ForeColor       =   &H80000008&
      Height          =   252
      Left            =   120
      TabIndex        =   5
      Top             =   1824
      Width           =   4296
   End
   Begin VB.Label lProductName 
      Caption         =   "lProductName"
      Height          =   252
      Left            =   1992
      TabIndex        =   4
      Top             =   360
      Width           =   2124
   End
   Begin VB.Label lVendorName 
      Caption         =   "lVendorName"
      Height          =   252
      Left            =   1992
      TabIndex        =   3
      Top             =   120
      Width           =   2124
   End
   Begin VB.Label lpn 
      Caption         =   "ProductName:"
      Height          =   252
      Left            =   792
      TabIndex        =   2
      Top             =   360
      Width           =   1092
   End
   Begin VB.Label lvn 
      Caption         =   "VendorName:"
      Height          =   252
      Left            =   792
      TabIndex        =   1
      Top             =   120
      Width           =   1092
   End
   Begin VB.Image imgON 
      Height          =   336
      Left            =   192
      Picture         =   "FormMain.frx":0313
      Top             =   120
      Width           =   336
   End
   Begin VB.Image imgOFF 
      Height          =   336
      Left            =   192
      Picture         =   "FormMain.frx":047A
      Top             =   120
      Width           =   336
   End
End
Attribute VB_Name = "MainForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
    '
    '   USBDemo
    '   =======
    '
    '   File name  : USBDemon1.vbp
    '   Programmer : Demon
    '   Date       : April 2015
    '
    '
    '   Simplified version of Mister E's USBDemo.
    '
    '   The interface allow:
    '       1. Send data using check boxes
    '       2. Display incoming text string
    '       3. Display VendorName and ProductName of the target USB device
    '       4. Display the status of the target USB device (online or not) with fake LED
    '
    '   Enjoy!
    '
    '
    Option Explicit
    '
    '   vendor and product IDs
    '   ======================
    Private Const VendorID = 6017
    Private Const ProductID = 2000
    '
    '   In and Out buffers
    '   ==================
    Private Const BufferInSize = 16     '(8, 16, 32, or 64)
    Private Const BufferOutSize = 8
    Dim BufferIn(0 To BufferInSize) As Byte
    Dim BufferOut(0 To BufferOutSize) As Byte

Private Sub cClearUSBRx_Click()
    tUSBRx.Text = ""    ' Clear RX Text box content
End Sub

Private Sub Send1_Click()
    '
    '   Send data to USB bus.  Result is store in BufferOut(1)
    '
    BufferOut(1) = Send1.Value
    WriteSomeData
End Sub

Private Sub Send2_Click()
    '
    '   Send data to USB bus.  Result is store in BufferOut(2)
    '
    BufferOut(2) = Send2.Value
    WriteSomeData
End Sub

Private Sub Form_Load()
    ConnectToHID (Me.hwnd)          ' connect to HID
    '
    '   Clear labels and Text boxes
    '   ===========================
    lVendorName.Caption = ""
    lProductName.Caption = ""
    tUSBRx.Text = ""
    '
    '   Set initial status
    '   ==================
    imgON.Visible = False       ' Connect/Disconnect LED
    Send1.Value = 0
    Send2.Value = 0
    '
    '   Clear BufferOut and send initial data to the USB device
    '   =======================================================
    Dim index As Byte
    For index = 0 To BufferOutSize
        BufferOut(index) = 0    ' set all array to '0'
    Next                        '
        
    WriteSomeData               ' Send initial data
End Sub

Private Sub Form_Unload(Cancel As Integer)
    DisconnectFromHID   ' disconnect from the HID controller...
End Sub

Public Sub OnPlugged(ByVal pHandle As Long)
    '
    '   A HID device has been plugged in,
    '   check if it's the right one, and enable the form LED (top left)
    '
    Dim DeviceHandle As Long
    Dim VendorName As String * 15
    Dim ProductName As String * 15
    
    If hidGetVendorID(pHandle) = VendorID And hidGetProductID(pHandle) = ProductID Then ' Good one?
        '
        '   get the device handle
        '   =====================
        DeviceHandle = hidGetHandle(VendorID, ProductID)
        '
        '   Get the vendor and product name from the handle
        '   ===============================================
        hidGetVendorName DeviceHandle, VendorName, 255
        hidGetProductName DeviceHandle, ProductName, 255
        '
        '   Set initial status
        '   ==================
        imgON.Visible = True
        lVendorName.Caption = VendorName
        lProductName.Caption = ProductName
        Send1.Value = 0
        Send2.Value = 0
        
        Dim index As Byte
        
        For index = 1 To BufferOutSize  ' clear the array
                                        '   but skip (0)
            BufferOut(index) = 0
        Next
        
        WriteSomeData               ' send data
    End If
End Sub

Public Sub OnUnplugged(ByVal pHandle As Long)
    '
    '   A HID device has been unplugged,
    '   check if it's the right one and clear all related LEDs, Labels, ProgressBar..etc
    '
    If hidGetVendorID(pHandle) = VendorID And hidGetProductID(pHandle) = ProductID Then ' good one?
        lVendorName.Caption = ""
        lProductName.Caption = ""
        imgON.Visible = False
    End If
End Sub

Public Sub OnChanged()
    '
    '   Controller changed notification - called
    '   after ALL HID devices are plugged or unplugged
    '
    '   Get the handle of the device we are interested in, then set
    '   its read notify flag to true - this ensures you get a read
    '   notification message when there is some data to read...
    '
    Dim DeviceHandle As Long
    DeviceHandle = hidGetHandle(VendorID, ProductID)
    hidSetReadNotify DeviceHandle, True
End Sub

Public Sub OnRead(ByVal pHandle As Long)
    '
    '   Incomming data
    '
    '   Don't forget Bufferin(0) is the ReportID
    '
    Dim index As Byte
        
    If hidRead(pHandle, BufferIn(0)) Then           ' valid ReportID?
        For index = 1 To BufferInSize               ' pass the whole array, skip the ReportID
            tUSBRx.Text = tUSBRx.Text & Chr(BufferIn(index))
        Next
        tUSBRx.Text = (tUSBRx.Text) & vbCr & vbLf   ' point to the next line
        tUSBRx.SelStart = Len(tUSBRx.Text)          ' point to the end... better effect
                                                    '      and avoid to scroll all the time.
    End If
End Sub

Public Sub WriteSomeData()
    '
    '   Use to send data to the USB bus.
    '   data must be stored in BufferOut array
    '
    BufferOut(0) = 0   ' first byte is always the report ID

    hidWriteEx VendorID, ProductID, BufferOut(0)    ' send it
End Sub
