
; PICBASIC PRO(TM) Compiler 3.0.6.4, (c) 1998, 2012 microEngineering Labs, Inc. All Rights Reserved. 
MPASMWIN_USED			EQU	1

#define	PBP_PATH	C:\PBP3\




        NOLIST
    ifdef PM_USED
        LIST
        "Error: PM does not support this device.  Use MPASM."
        NOLIST
    else
        LIST
        LIST p = 18F4550, r = dec, w = -311, w = -230, f = inhx32
        INCLUDE "P18F4550.INC"	; MPASM  Header
        NOLIST
    endif
        LIST
EEPROM_START	EQU	0F00000h
BLOCK_SIZE	EQU	32


PBP_HARDWAREDEF  macro
  endm


        __CONFIG    _CONFIG1L, _PLLDIV_5_1L & _CPUDIV_OSC1_PLL2_1L & _USBDIV_2_1L
        __CONFIG    _CONFIG1H, _FOSC_HSPLL_HS_1H & _FCMEN_OFF_1H & _IESO_OFF_1H
        __CONFIG    _CONFIG2L, _PWRT_OFF_2L & _BOR_ON_2L & _BORV_3_2L & _VREGEN_ON_2L
        __CONFIG    _CONFIG2H, _WDT_ON_2H & _WDTPS_512_2H
        __CONFIG    _CONFIG3H, _CCP2MX_ON_3H & _PBADEN_OFF_3H & _LPT1OSC_OFF_3H & _MCLRE_ON_3H
        __CONFIG    _CONFIG4L, _STVREN_ON_4L & _LVP_OFF_4L & _ICPRT_OFF_4L & _XINST_OFF_4L



; Define statements.
; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00100	DEFINE OSC 48
#define		OSC		 48
; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00101	DEFINE LOADER_USED 1
#define		LOADER_USED		 1
; C:\PBP3\DT_INTS-18.BAS   	00020	DEFINE  INTHAND       INT_ENTRY_H  ' Context saving for High Priority Ints
#define		INTHAND		       INT_ENTRY_H  
; C:\PBP3\DT_INTS-18.BAS   	00021	DEFINE  INTLHAND      INT_ENTRY_L  ' Context saving for Low Priority Ints
#define		INTLHAND		      INT_ENTRY_L  
; C:\PBP3\REENTERPBP-18.BAS	00022	DEFINE   ReEnterHPused  1
#define		ReEnterHPused		  1

RAM_START       		EQU	00000h
RAM_END         		EQU	007FFh
RAM_BANKS       		EQU	00008h
BANK0_START     		EQU	00060h
BANK0_END       		EQU	000FFh
BANK1_START     		EQU	00100h
BANK1_END       		EQU	001FFh
BANK2_START     		EQU	00200h
BANK2_END       		EQU	002FFh
BANK3_START     		EQU	00300h
BANK3_END       		EQU	003FFh
BANK4_START     		EQU	00400h
BANK4_END       		EQU	004FFh
BANK5_START     		EQU	00500h
BANK5_END       		EQU	005FFh
BANK6_START     		EQU	00600h
BANK6_END       		EQU	006FFh
BANK7_START     		EQU	00700h
BANK7_END       		EQU	007FFh
BANKA_START     		EQU	00000h
BANKA_END       		EQU	0005Fh

; C:\PBP3\PBPPIC18.RAM     	00028	A00000	FLAGS   VAR     BYTE BANKA SYSTEM       ' Static flags
FLAGS           		EQU	RAM_START + 000h
; C:\PBP3\PBPPIC18.RAM     	00027	A00001	GOP     VAR     BYTE BANKA SYSTEM       ' Gen Op Parameter
GOP             		EQU	RAM_START + 001h
; C:\PBP3\PBPPIC18.RAM     	00012	A00002	R0      VAR     WORD BANKA SYSTEM       ' System Register
R0              		EQU	RAM_START + 002h
; C:\PBP3\PBPPIC18.RAM     	00013	A00004	R1      VAR     WORD BANKA SYSTEM       ' System Register
R1              		EQU	RAM_START + 004h
; C:\PBP3\PBPPIC18.RAM     	00014	A00006	R2      VAR     WORD BANKA SYSTEM       ' System Register
R2              		EQU	RAM_START + 006h
; C:\PBP3\PBPPIC18.RAM     	00015	A00008	R3      VAR     WORD BANKA SYSTEM       ' System Register
R3              		EQU	RAM_START + 008h
; C:\PBP3\PBPPIC18.RAM     	00016	A0000A	R4      VAR     WORD BANKA SYSTEM       ' System Register
R4              		EQU	RAM_START + 00Ah
; C:\PBP3\PBPPIC18.RAM     	00017	A0000C	R5      VAR     WORD BANKA SYSTEM       ' System Register
R5              		EQU	RAM_START + 00Ch
; C:\PBP3\PBPPIC18.RAM     	00018	A0000E	R6      VAR     WORD BANKA SYSTEM       ' System Register
R6              		EQU	RAM_START + 00Eh
; C:\PBP3\PBPPIC18.RAM     	00019	A00010	R7      VAR     WORD BANKA SYSTEM       ' System Register
R7              		EQU	RAM_START + 010h
; C:\PBP3\PBPPIC18.RAM     	00020	A00012	R8      VAR     WORD BANKA SYSTEM       ' System Register
R8              		EQU	RAM_START + 012h
; C:\PBP3\DT_INTS-18.BAS   	00038	A00014	INT_Flags   VAR BYTE  BANKA  SYSTEM
INT_Flags       		EQU	RAM_START + 014h
; C:\PBP3\PBPPIC18.RAM     	00023	A00015	RM1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Mask
RM1             		EQU	RAM_START + 015h
; C:\PBP3\PBPPIC18.RAM     	00026	A00016	RM2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Mask
RM2             		EQU	RAM_START + 016h
; C:\PBP3\PBPPIC18.RAM     	00021	A00017	RR1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Register
RR1             		EQU	RAM_START + 017h
; C:\PBP3\PBPPIC18.RAM     	00024	A00018	RR2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Register
RR2             		EQU	RAM_START + 018h
; C:\PBP3\PBPPIC18.RAM     	00022	A00019	RS1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Bank
RS1             		EQU	RAM_START + 019h
; C:\PBP3\PBPPIC18.RAM     	00025	A0001A	RS2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Bank
RS2             		EQU	RAM_START + 01Ah
; C:\PBP3\DT_INTS-18.BAS   	00023	A0001B	wsave       var byte  BANKA  SYSTEM   ' location for WREG
wsave           		EQU	RAM_START + 01Bh
; C:\PBP3\DT_INTS-18.BAS   	00036	A0001C	RetAddrH    VAR BYTE[3]  BANKA  SYSTEM  ' 21-bit return address Hi Pri.
RetAddrH        		EQU	RAM_START + 01Ch
; C:\PBP3\DT_INTS-18.BAS   	00037	A0001F	RetAddrL    VAR BYTE[3]  BANKA  SYSTEM  '                       Lo Pri.
RetAddrL        		EQU	RAM_START + 01Fh
; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00001	A00022	' ************************************************************
PB01            		EQU	RAM_START + 022h
; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00125	A00023	Key	   Var Byte
_Key             		EQU	RAM_START + 023h
; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00123	A00024	keyold var byte
_keyold          		EQU	RAM_START + 024h
; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00122	A00025	keyout var byte
_keyout          		EQU	RAM_START + 025h
; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00128	A00026	keysend var byte
_keysend         		EQU	RAM_START + 026h
; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00119	A00027	ModKey   var byte
_ModKey          		EQU	RAM_START + 027h
; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00118	A00028	pKey    var byte
_pKey            		EQU	RAM_START + 028h
; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00121	A00029	shift  var byte
_shift           		EQU	RAM_START + 029h
; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00112	A0002A	USBBufferCount   Var Byte 
_USBBufferCount  		EQU	RAM_START + 02Ah
; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00111	A0002B	USBBuffer        Var Byte[USBBufferSizeMax] 
_USBBuffer       		EQU	RAM_START + 02Bh
; C:\PBP3\DT_INTS-18.BAS   	00030	A00060	fsave0H     var WORD  BANK0  SYSTEM   ' locations for FSR registers
fsave0H         		EQU	RAM_START + 060h
; C:\PBP3\DT_INTS-18.BAS   	00033	A00062	fsave0L     var WORD  BANK0  SYSTEM   ' low priority FSR locations
fsave0L         		EQU	RAM_START + 062h
; C:\PBP3\DT_INTS-18.BAS   	00031	A00064	fsave1H     var WORD  BANK0  SYSTEM
fsave1H         		EQU	RAM_START + 064h
; C:\PBP3\DT_INTS-18.BAS   	00034	A00066	fsave1L     var WORD  BANK0  SYSTEM
fsave1L         		EQU	RAM_START + 066h
; C:\PBP3\DT_INTS-18.BAS   	00032	A00068	fsave2H     var WORD  BANK0  SYSTEM
fsave2H         		EQU	RAM_START + 068h
; C:\PBP3\DT_INTS-18.BAS   	00035	A0006A	fsave2L     var WORD  BANK0  SYSTEM
fsave2L         		EQU	RAM_START + 06Ah
; C:\PBP3\DT_INTS-18.BAS   	00025	A0006C	bsave       var byte  BANK0  SYSTEM   ' location for BSR register
bsave           		EQU	RAM_START + 06Ch
; C:\PBP3\DT_INTS-18.BAS   	00028	A0006D	psaveH      VAR BYTE  BANK0  SYSTEM   ' PCLATH Hi Pri.
psaveH          		EQU	RAM_START + 06Dh
; C:\PBP3\DT_INTS-18.BAS   	00029	A0006E	psaveL      VAR BYTE  BANK0  SYSTEM   '        Lo Pri.
psaveL          		EQU	RAM_START + 06Eh
; C:\PBP3\DT_INTS-18.BAS   	00026	A0006F	psaveUH     VAR BYTE  BANK0  SYSTEM   ' PCLATU Hi Pri.
psaveUH         		EQU	RAM_START + 06Fh
; C:\PBP3\DT_INTS-18.BAS   	00027	A00070	psaveUL     VAR BYTE  BANK0  SYSTEM   '        Lo Pri.
psaveUL         		EQU	RAM_START + 070h
; C:\PBP3\DT_INTS-18.BAS   	00024	A00071	ssave       var byte  BANK0  SYSTEM   ' location for STATUS register
ssave           		EQU	RAM_START + 071h
; C:\PBP3\REENTERPBP-18.BAS	00029	A00072	HP_Vars  VAR  WORD[34]        ; group vars together for less banking
_HP_Vars         		EQU	RAM_START + 072h
; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\DESCCDU_KEYBOARD.BAS	00005	A00400	USBReservedMemory Var Byte[USBMEMORYSIZE] USBMEMORYADDRESS	' Reserve memory used by USB assembler code
_USBReservedMemory		EQU	RAM_START + 00400h
; C:\PBP3\REENTERPBP-18.BAS	00030	    R0_SaveH      VAR HP_Vars[0]
_R0_SaveH        		EQU	_HP_Vars
; C:\PBP3\REENTERPBP-18.BAS	00031	    R1_SaveH      VAR HP_Vars[2]
_R1_SaveH        		EQU	_HP_Vars + 004h
; C:\PBP3\REENTERPBP-18.BAS	00032	    R2_SaveH      VAR HP_Vars[4]
_R2_SaveH        		EQU	_HP_Vars + 008h
; C:\PBP3\REENTERPBP-18.BAS	00033	    R3_SaveH      VAR HP_Vars[6]
_R3_SaveH        		EQU	_HP_Vars + 00Ch
; C:\PBP3\REENTERPBP-18.BAS	00034	    R4_SaveH      VAR HP_Vars[8]
_R4_SaveH        		EQU	_HP_Vars + 010h
; C:\PBP3\REENTERPBP-18.BAS	00035	    R5_SaveH      VAR HP_Vars[9]
_R5_SaveH        		EQU	_HP_Vars + 012h
; C:\PBP3\REENTERPBP-18.BAS	00036	    R6_SaveH      VAR HP_Vars[10]
_R6_SaveH        		EQU	_HP_Vars + 014h
; C:\PBP3\REENTERPBP-18.BAS	00037	    R7_SaveH      VAR HP_Vars[11]
_R7_SaveH        		EQU	_HP_Vars + 016h
; C:\PBP3\REENTERPBP-18.BAS	00038	    R8_SaveH      VAR HP_Vars[12]
_R8_SaveH        		EQU	_HP_Vars + 018h
; C:\PBP3\REENTERPBP-18.BAS	00039	    Flag_GOP_H    VAR HP_Vars[13]
_Flag_GOP_H      		EQU	_HP_Vars + 01Ah
; C:\PBP3\REENTERPBP-18.BAS	00042	    RM_H          VAR HP_Vars[14]
_RM_H            		EQU	_HP_Vars + 01Ch
; C:\PBP3\REENTERPBP-18.BAS	00045	    RR_H          VAR HP_Vars[15]
_RR_H            		EQU	_HP_Vars + 01Eh
; C:\PBP3\REENTERPBP-18.BAS	00048	    RS_H          VAR HP_Vars[16]
_RS_H            		EQU	_HP_Vars + 020h
; C:\PBP3\REENTERPBP-18.BAS	00051	    T1_SaveH      VAR HP_Vars[17]
_T1_SaveH        		EQU	_HP_Vars + 022h
; C:\PBP3\REENTERPBP-18.BAS	00052	    T2_SaveH      VAR HP_Vars[19]
_T2_SaveH        		EQU	_HP_Vars + 026h
; C:\PBP3\REENTERPBP-18.BAS	00053	    T3_SaveH      VAR HP_Vars[21]
_T3_SaveH        		EQU	_HP_Vars + 02Ah
; C:\PBP3\REENTERPBP-18.BAS	00054	    T4_SaveH      VAR HP_Vars[23]
_T4_SaveH        		EQU	_HP_Vars + 02Eh
; C:\PBP3\REENTERPBP-18.BAS	00055	    T5_SaveH      VAR HP_Vars[25]
_T5_SaveH        		EQU	_HP_Vars + 032h
; C:\PBP3\REENTERPBP-18.BAS	00056	    T6_SaveH      VAR HP_Vars[27]
_T6_SaveH        		EQU	_HP_Vars + 036h
; C:\PBP3\REENTERPBP-18.BAS	00057	    T7_SaveH      VAR HP_Vars[29]
_T7_SaveH        		EQU	_HP_Vars + 03Ah
; C:\PBP3\REENTERPBP-18.BAS	00058	    TBLPTRU_H     VAR HP_Vars[31]
_TBLPTRU_H       		EQU	_HP_Vars + 03Eh
; C:\PBP3\REENTERPBP-18.BAS	00060	    TBLPTR_H      VAR HP_Vars[32]
_TBLPTR_H        		EQU	_HP_Vars + 040h
; C:\PBP3\REENTERPBP-18.BAS	00063	    Product_H     VAR HP_Vars[33]
_Product_H       		EQU	_HP_Vars + 042h
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00271	PORTL   VAR     PORTB
_PORTL           		EQU	 PORTB
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00272	PORTH   VAR     PORTC
_PORTH           		EQU	 PORTC
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00273	TRISL   VAR     TRISB
_TRISL           		EQU	 TRISB
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00274	TRISH   VAR     TRISC
_TRISH           		EQU	 TRISC
; C:\PBP3\REENTERPBP-18.BAS	00040	      Flags_SaveH   VAR Flag_GOP_H.lowbyte
_Flags_SaveH     		EQU	_Flag_GOP_H
; C:\PBP3\REENTERPBP-18.BAS	00041	      GOP_SaveH     VAR Flag_GOP_H.highbyte
_GOP_SaveH       		EQU	_Flag_GOP_H + 001h
; C:\PBP3\REENTERPBP-18.BAS	00043	      RM1_SaveH     VAR RM_H.lowbyte
_RM1_SaveH       		EQU	_RM_H
; C:\PBP3\REENTERPBP-18.BAS	00044	      RM2_SaveH     VAR RM_H.highbyte
_RM2_SaveH       		EQU	_RM_H + 001h
; C:\PBP3\REENTERPBP-18.BAS	00046	      RR1_SaveH     VAR RR_H.lowbyte
_RR1_SaveH       		EQU	_RR_H
; C:\PBP3\REENTERPBP-18.BAS	00047	      RR2_SaveH     VAR RR_H.highbyte
_RR2_SaveH       		EQU	_RR_H + 001h
; C:\PBP3\REENTERPBP-18.BAS	00049	      RS1_SaveH     VAR RS_H.lowbyte
_RS1_SaveH       		EQU	_RS_H
; C:\PBP3\REENTERPBP-18.BAS	00050	      RS2_SaveH     VAR RS_H.highbyte
_RS2_SaveH       		EQU	_RS_H + 001h
; C:\PBP3\REENTERPBP-18.BAS	00059	      TBLPTRU_SaveH VAR TBLPTRU_H.lowbyte
_TBLPTRU_SaveH   		EQU	_TBLPTRU_H
; C:\PBP3\REENTERPBP-18.BAS	00061	      TBLPTRH_SaveH VAR TBLPTR_H.highbyte
_TBLPTRH_SaveH   		EQU	_TBLPTR_H + 001h
; C:\PBP3\REENTERPBP-18.BAS	00062	      TBLPTRL_SaveH VAR TBLPTR_H.lowbyte
_TBLPTRL_SaveH   		EQU	_TBLPTR_H
_Flag_GOP_H??LOWBYTE		EQU	_Flag_GOP_H
_Flag_GOP_H??HIGHBYTE		EQU	_Flag_GOP_H + 001h
_RM_H??LOWBYTE   		EQU	_RM_H
_RM_H??HIGHBYTE  		EQU	_RM_H + 001h
_RR_H??LOWBYTE   		EQU	_RR_H
_RR_H??HIGHBYTE  		EQU	_RR_H + 001h
_RS_H??LOWBYTE   		EQU	_RS_H
_RS_H??HIGHBYTE  		EQU	_RS_H + 001h
_TBLPTRU_H??LOWBYTE		EQU	_TBLPTRU_H
_TBLPTR_H??HIGHBYTE		EQU	_TBLPTR_H + 001h
_TBLPTR_H??LOWBYTE		EQU	_TBLPTR_H
#define _K_Flag          	 PB01, 002h
#define _Debounce        	 PB01, 001h
#define _D_Flag          	 PB01, 000h
#define _Serviced_H      	_INT_Flags??0
#define _Serviced_L      	_INT_Flags??1
#define _InHPint         	_INT_Flags??2
#define _NoPriority      	_INT_Flags??3
#define _VarsSaved_H     	 PB01, 003h
#define _PORTE??7        	 PORTE, 007h
#define _TRISE??0        	 TRISE, 000h
#define _TRISE??1        	 TRISE, 001h
#define _INT_Flags??0    	 INT_Flags, 000h
#define _INT_Flags??1    	 INT_Flags, 001h
#define _INT_Flags??2    	 INT_Flags, 002h
#define _INT_Flags??3    	 INT_Flags, 003h
#define _PORTB??0        	 PORTB, 000h
#define _PORTD??0        	 PORTD, 000h
#define _PORTD??1        	 PORTD, 001h
#define _PORTD??2        	 PORTD, 002h
#define _PORTD??3        	 PORTD, 003h
#define _PORTD??4        	 PORTD, 004h
#define _PORTD??5        	 PORTD, 005h
#define _PORTD??6        	 PORTD, 006h
#define _PORTD??7        	 PORTD, 007h
#define _PORTE??0        	 PORTE, 000h
#define _PORTE??1        	 PORTE, 001h

; Constants.
_USBMEMORYADDRESS		EQU	00400h
_USBMEMORYSIZE   		EQU	00100h
_USBBufferSizeMax		EQU	00008h
_USBBufferSizeTX 		EQU	00008h
_USBBufferSizeRX 		EQU	00008h

; EEPROM data.


	INCLUDE	"CDU_KEYBOARD.MAC"
	INCLUDE	"C:\PBP3\PBPPIC18.LIB"


; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00036	#HEADER
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00062	#CONFIG
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00252	BANKA   $0000, $005F
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00253	BANK0   $0060, $00FF
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00254	BANK1   $0100, $01FF
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00255	BANK2   $0200, $02FF
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00256	BANK3   $0300, $03FF
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00257	BANK4   $0400, $04FF
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00258	BANK5   $0500, $05FF
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00259	BANK6   $0600, $06FF
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00260	BANK7   $0700, $07FF
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00266	    INCLUDE "PBPPI18L.RAM"
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00267	#ELSE
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00268	    LIBRARY  "PBPPIC18"

; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00269	    INCLUDE "PBPPIC18.RAM"
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00270	#ENDIF
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00275	USBMEMORYADDRESS Con	$400	' USB RAM starts here
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00279	#HEADER

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00098	include	"DESCCDU_Keyboard.bas"
; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\DESCCDU_KEYBOARD.BAS	00004	USBMEMORYSIZE	Con	256	' USB RAM size in bytes

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\DESCCDU_KEYBOARD.BAS	00007	goto	hid_desc_end	' Skip over all of the USB assembler code
	GOTO?L	_hid_desc_end

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\DESCCDU_KEYBOARD.BAS	00008	asm

	ASM?


#define	USB_EP0_BUFF_SIZE 	64	; 8, 16, 32, or 64
#define	USB_MAX_NUM_INT		1	; For tracking Alternate Setting
#define	USB_MAX_EP_NUMBER  	1	; UEP1
#define	NUM_CONFIGURATIONS	1
#define	NUM_INTERFACES		1

#define UCFG_VAL	USB_PULLUP_ENABLE|USB_INTERNAL_TRANSCEIVER|USB_FULL_SPEED|USB_PING_PONG__NO_PING_PONG
;#define UCFG_VAL	USB_PULLUP_ENABLE|USB_INTERNAL_TRANSCEIVER|USB_LOW_SPEED|USB_PING_PONG__NO_PING_PONG

;#define USE_SELF_POWER_SENSE_IO
;#define USE_USB_BUS_SENSE_IO

#define USB_POLLING

; HID
; Endpoints Allocation
#define	HID_INTF_ID		  0x00
#define	HID_EP			  1
#define	HID_INT_OUT_EP_SIZE	  64
#define	HID_INT_IN_EP_SIZE	  64
#define	HID_NUM_OF_DSC		  1

   include	"usb_hid.asm"	; Include rest of USB files, starting with HID class code

; ******************************************************************
; This table is polled by the host immediately after USB Reset has been released.
; This table defines the maximum packet size EP0 can take.
; See section 9.6.1 of the Rev 1.0 USB specification.
; These fields are application DEPENDENT. Modify these to meet
; your specifications.
; ******************************************************************
DeviceDescriptor
	retlw	(EndDeviceDescriptor-DeviceDescriptor)/2	; bLength Length of this descriptor
	retlw	USB_DESCRIPTOR_DEVICE ; bDescType This is a DEVICE descriptor
	retlw	0x10		; bcdUSBUSB Revision 1.10 (low byte)
	retlw	0x01		; high byte
	retlw	0x00		; bDeviceClass zero means each interface operates independently
	retlw	0x00		; bDeviceSubClass
	retlw	0x00		; bDeviceProtocol 
	retlw	USB_EP0_BUFF_SIZE ; bMaxPacketSize for EP0

        ; idVendor (low byte, high byte)
	retlw	0x61
	retlw	0x02

        ; idProduct (low byte, high byte)
	retlw	0xDD
	retlw	0x07

        retlw	0x00		; bcdDevice (low byte)
	retlw	0x00		; (high byte)
	retlw	0x01		; iManufacturer (string index)
	retlw	0x02		; iProduct      (string index)

        ; iSerialNumber (string index)
	retlw	0x03
	retlw	NUM_CONFIGURATIONS ; bNumConfigurations
EndDeviceDescriptor

; ******************************************************************
; This table is retrieved by the host after the address has been set.
; This table defines the configurations available for the device.
; See section 9.6.2 of the Rev 1.0 USB specification (page 184).
; These fields are application DEPENDENT. 
; Modify these to meet your specifications.
; ******************************************************************
; Configuration pointer table
USB_CD_Ptr
Configs
	db	low Config1, high Config1
	db	upper Config1, 0

; Configuration Descriptor
Config1
	retlw	(Interface1-Config1)/2	; bLength Length of this descriptor
	retlw	USB_DESCRIPTOR_CONFIGURATION ; bDescType 2=CONFIGURATION
Config1Len
	retlw	low ((EndConfig1 - Config1)/2)	; Length of this configuration
	retlw	high ((EndConfig1 - Config1)/2)
	retlw	0x01		; bNumInterfaces Number of interfaces
	retlw	0x01		; bConfigValue Configuration Value
	retlw	0x00		; iConfig (string index)
	retlw	_DEFAULT|_SELF	; bmAttributes attributes - bus powered

        ; Max power consumption (2X mA)
	retlw	0x32
Interface1
	retlw	(HIDDescriptor1-Interface1)/2	; length of descriptor
	retlw	USB_DESCRIPTOR_INTERFACE
	retlw	0x00		; number of interface, 0 based array
	retlw	0x00		; alternate setting
	retlw	0x02		; number of endpoints used in this interface
	retlw	0x03		; interface class - assigned by the USB
	retlw	0x00		; boot device
	retlw	0x01		; interface protocol
	retlw 	0x00		; index to string descriptor that describes this interface
HIDDescriptor1
	retlw	(Endpoint1In-HIDDescriptor1)/2	; descriptor size (9 bytes)
        retlw	DSC_HID		; descriptor type (HID)
	retlw	0x11		; HID class release number (1.11)
	retlw	0x01
        retlw	0x00		; Localized country code (none)
        retlw	0x01		; # of HID class descriptor to follow (1)
        retlw	0x22		; Report descriptor type (HID)
ReportDescriptor1Len
	retlw	low ((EndReportDescriptor1-ReportDescriptor1)/2)
	retlw	high ((EndReportDescriptor1-ReportDescriptor1)/2)
Endpoint1In
	retlw	(EndPoint1Out-Endpoint1In)/2	; length of descriptor
	retlw	USB_DESCRIPTOR_ENDPOINT
	retlw	HID_EP|_EP_IN		; EP1, In
	retlw	_INT		; Interrupt
	retlw	low (HID_INT_IN_EP_SIZE)		; This should be the size of the endpoint buffer
	retlw	high (HID_INT_IN_EP_SIZE)
	retlw	0x0A                        ; Polling interval
EndPoint1Out
	retlw	(EndConfig1-EndPoint1Out)/2	; Length of this Endpoint Descriptor
	retlw	USB_DESCRIPTOR_ENDPOINT		; bDescriptorType = 5 for Endpoint Descriptor
	retlw	HID_EP|_EP_OUT		; Endpoint number & direction
	retlw	_INT		; Transfer type supported by this Endpoint
	retlw	low (HID_INT_OUT_EP_SIZE)		; This should be the size of the endpoint buffer
	retlw	high (HID_INT_OUT_EP_SIZE)
	retlw	0x0A                        ; Polling interval
EndConfig1

ReportDescriptor1
    retlw 0x05 
    retlw 0x01                    ; USAGE_PAGE (Generic Desktop)
    
    retlw 0x09 
    retlw 0x06                    ; USAGE (Keyboard)
    
    retlw 0xa1
    retlw 0x01                    ; COLLECTION (Application)
    
    retlw 0x05
    retlw 0x07                    ;   USAGE_PAGE (Keyboard)
    
    retlw 0x19
    retlw 0xe0                    ;   USAGE_MINIMUM (Keyboard LeftControl)
    
    retlw 0x29
    retlw 0xe7                    ;   USAGE_MAXIMUM (Keyboard Right GUI)
    
    retlw 0x15
    retlw 0x00                    ;   LOGICAL_MINIMUM (0)
    
    retlw 0x25
    retlw 0x01                    ;   LOGICAL_MAXIMUM (1)
    
    retlw 0x75
    retlw 0x01                    ;   REPORT_SIZE (1)
    
    retlw 0x95
    retlw 0x08                    ;   REPORT_COUNT (8)
    
    retlw 0x81
    retlw 0x02                    ;   INPUT (DataVarAbs)
    
    retlw 0x95
    retlw 0x01                    ;   REPORT_COUNT (1)
    
    retlw 0x75
    retlw 0x08                    ;   REPORT_SIZE (8)
    
    retlw 0x81
    retlw 0x03                    ;   INPUT (CnstVarAbs)
    
    retlw 0x95
    retlw 0x05                    ;   REPORT_COUNT (5)
    
    retlw 0x75
    retlw 0x01                    ;   REPORT_SIZE (1)
    
    retlw 0x05
    retlw 0x08                    ;   USAGE_PAGE (LEDs)
    
    retlw 0x19
    retlw 0x01                    ;   USAGE_MINIMUM (Num Lock)
    
    retlw 0x29
    retlw 0x05                    ;   USAGE_MAXIMUM (Kana)
    
    retlw 0x91
    retlw 0x02                    ;   OUTPUT (DataVarAbs)
    
    retlw 0x95
    retlw 0x01                    ;   REPORT_COUNT (1)
    
    retlw 0x75
    retlw 0x03                    ;   REPORT_SIZE (3)
    
    retlw 0x91
    retlw 0x03                    ;   OUTPUT (CnstVarAbs)
    
    retlw 0x95
    retlw 0x06                    ;   REPORT_COUNT (6)
    
    retlw 0x75
    retlw 0x08                    ;   REPORT_SIZE (8)
    
    retlw 0x15
    retlw 0x00                    ;   LOGICAL_MINIMUM (0)
    
    retlw 0x25
    retlw 0x65                    ;   LOGICAL_MAXIMUM (101)
    
    retlw 0x05
    retlw 0x07                    ;   USAGE_PAGE (Keyboard)
    
    retlw 0x19
    retlw 0x00                    ;   USAGE_MINIMUM (Reserved (no event indicated))
    
    retlw 0x29
    retlw 0x65                    ;   USAGE_MAXIMUM (Keyboard Application)
    
    retlw 0x81
    retlw 0x00                    ;   INPUT (DataAryAbs)
    
    retlw 0xc0                          ; End Collection
EndReportDescriptor1

; String pointer table
USB_SD_Ptr
Strings
	db	low String0, high String0
        db	upper String0, 0
	db	low String1, high String1
        db	upper String1, 0
	db	low String2, high String2
       	db	upper String2, 0
	db	low String3, high String3
	db	upper String3, 0

String0
	retlw	(String1-String0)/2	; Length of string
	retlw	USB_DESCRIPTOR_STRING   ; Descriptor type 3
	retlw	0x09		        ; Language ID (as defined by MS 0x0409)
	retlw	0x04

; company name
String1
	retlw	(String2-String1)/2
	retlw	USB_DESCRIPTOR_STRING
	
        retlw   'D'
        retlw   0x00
        retlw   'L'
        retlw   0x00
        retlw   'C'
        retlw   0x00
        retlw   'i'
        retlw   0x00
        retlw   'n'
        retlw   0x00
        retlw   'c'
        retlw   0x00

	
; product name	
String2
	retlw	(String3-String2)/2
	retlw	USB_DESCRIPTOR_STRING
	
        retlw   'C'
        retlw   0x00
        retlw   'D'
        retlw   0x00
        retlw   'U'
        retlw   0x00
        retlw   '_'
        retlw   0x00
        retlw   'K'
        retlw   0x00
        retlw   'e'
        retlw   0x00
        retlw   'y'
        retlw   0x00
        retlw   'B'
        retlw   0x00
        retlw   'o'
        retlw   0x00
        retlw   'a'
        retlw   0x00
        retlw   'r'
        retlw   0x00
        retlw   'd'
        retlw   0x00


; serial number
String3
	retlw	(String4-String3)/2
	retlw	USB_DESCRIPTOR_STRING
	
        retlw   '1'
        retlw   0x00
        retlw   '0'
        retlw   0x00
        retlw   '0'
        retlw   0x00
        retlw   '1'
        retlw   0x00

String4




	ENDASM?


; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\DESCCDU_KEYBOARD.BAS	00318	hid_desc_end

	LABEL?L	_hid_desc_end	
; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00100	DEFINE OSC 48
; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00101	DEFINE LOADER_USED 1

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00102	ADCON1 = $F       'port A digital
	MOVE?CB	00Fh, ADCON1

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00103	CMCON = 7         'PortA Digital
	MOVE?CB	007h, CMCON

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00104	PortE.7 = 1              'set weak pullups port D
	MOVE?CT	001h, _PORTE??7
; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00106	USBBufferSizeMax   con 8  ' maximum buffer size
; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00107	USBBufferSizeTX    con 8  ' input
; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00108	USBBufferSizeRX    con 8  ' output

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00114	TrisB = %00000000
	MOVE?CB	000h, TRISB

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00115	TrisD = %11111111
	MOVE?CB	0FFh, TRISD

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00116	TrisE.0 = 1
	MOVE?CT	001h, _TRISE??0

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00117	TrisE.1 = 1
	MOVE?CT	001h, _TRISE??1

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00129	D_Flag=0
	MOVE?CT	000h, _D_Flag

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00134	INCLUDE "DT_INTS-18.bas"    ' Base Interrupt System

; C:\PBP3\DT_INTS-18.BAS   	00018	DISABLE DEBUG
	DDISABLE?	
; C:\PBP3\DT_INTS-18.BAS   	00020	DEFINE  INTHAND       INT_ENTRY_H  ' Context saving for High Priority Ints
; C:\PBP3\DT_INTS-18.BAS   	00021	DEFINE  INTLHAND      INT_ENTRY_L  ' Context saving for Low Priority Ints

; C:\PBP3\DT_INTS-18.BAS   	00044	INT_Flags = 0 
	MOVE?CB	000h, INT_Flags

; C:\PBP3\DT_INTS-18.BAS   	00046	goto  OVER_DT_INTS_18
	GOTO?L	_OVER_DT_INTS_18

; C:\PBP3\DT_INTS-18.BAS   	00048	ASM

	ASM?

;____ Check for PBPL (PBP ver. 2.50 and above only)__________________________
PBPLongs_Used = 0
  if (R1 - R0 == 4)
PBPLongs_Used = 1
;    messg PBPL Used = 1
  endif

  nolist
;____ DEFINE available interrupt sources_____________________________________

  #define INT_INT   INTCON, INT0IF  ;-- INT External, 16F compatible
  #define INT0_INT  INTCON, INT0IF  ;-- INT0 External 
  #define INT1_INT  INTCON3,INT1IF  ;-- INT1 External 
  #define INT2_INT  INTCON3,INT2IF  ;-- INT2 External 
  #define INT3_INT  INTCON3,INT3IF  ;-- INT3 External 
  #define RBC_INT   INTCON, RBIF    ;-- RB Port Change 
  #define TMR0_INT  INTCON, TMR0IF  ;-- TMR0 Overflow  18F
  #define TMR1_INT  PIR1, TMR1IF    ;-- TMR1 Overflow 
  #define TMR2_INT  PIR1, TMR2IF    ;-- TMR2 to PR2 Match 
  #define TMR3_INT  PIR2, TMR3IF    ;-- TMR3 Overflow 
  #define TMR4_INT  PIR3, TMR4IF    ;-- TMR4 Overflow 
  #define TX_INT    PIR1, TXIF      ;-- USART Transmit 
  #define TX1_INT   PIR1, TX1IF     ;-- USART1 Transmit 
  #define TX2_INT   PIR3, TX2IF     ;-- USART2 Transmit 
  #define RX_INT    PIR1, RCIF      ;-- USART Receive 
  #define RX1_INT   PIR1, RC1IF     ;-- USART1 Receive 
  #define RX2_INT   PIR3, RC2IF     ;-- USART2 Receive 
  #define CMP_INT   PIR2, CMIF      ;-- Comparator 
  #define EE_INT    PIR2, EEIF      ;-- EEPROM/FLASH Write Operation 
  #define BUS_INT   PIR2, BCLIF     ;-- Bus Collision 
  #define LVD_INT   PIR2, LVDIF     ;-- Low Voltage Detect 
  #define HLVD_INT  PIR2, HLVDIF    ;-- High/Low Voltage Detect 
  #define PSP_INT   PIR1, PSPIF     ;-- Parallel Slave Port Read/Write 
  #define AD_INT    PIR1, ADIF      ;-- A/D Converter 
  #define SSP_INT   PIR1, SSPIF     ;-- Master Synchronous Serial Port 
  #define CCP1_INT  PIR1, CCP1IF    ;-- CCP1 
  #define CCP2_INT  PIR2, CCP2IF    ;-- CCP2 
  #define CCP3_INT  PIR3, CCP3IF    ;-- CCP3 
  #define CCP4_INT  PIR3, CCP4IF    ;-- CCP4 
  #define CCP5_INT  PIR3, CCP5IF    ;-- CCP5 
  #define OSC_INT   PIR2, OSCFIF    ;-- Oscillator Fail 

; -- Added for ver. 3.2 --
  #define SPP_INT   PIR1, SPPIF     ;-- Streaming Parallel Port Read/Write
  #define BUS1_INT  PIR2, BCL1IF    ;-- Bus 1 Collision 
  #define BUS2_INT  PIR3, BCL2IF    ;-- Bus 2 Collision
  #define ECCP1_INT PIR2, ECCP1IF   ;-- ECCP1
  #define LCD_INT   PIR3, LCDIF     ;-- LCD Driver
  #define PMP_INT   PIR1, PMPIF     ;-- Parallel Master Port
  #define SSP1_INT  PIR1, SSP1IF    ;-- Synchronous Serial Port 1
  #define SSP2_INT  PIR3, SSP2IF    ;-- Synchronous Serial Port 2
  #define TMR5_INT  PIR3, TMR5IF    ;-- Timer 5
  #define PT_INT    PIR3, PTIF      ;-- PWM Time Base
  #define IC1IF_INT  PIR3, IC1IF    ;-- Motion Feedback
  #define IC2QEIF_INT  PIR3, IC2QEIF  ;-- Motion Feedback
  #define IC3DRIF_INT  PIR3, IC3DRIF  ;-- Motion Feedback

;_____ Comparators __________________________________________________________
  #define CMP0_INT  PIR1, CMP0IF    ;-- Comparator 0 - 1230/1330 only

CMPIFREG = PIR2                     ;-- Comparator 1
CMPIEREG = PIE2
CMPIPREG = IPR2
    ifdef C1IF                      ;     18F24K20  18F25K20  18F26K20
CM1IFBIT = C1IF                     ;     18F44K20  18F45K20  18F46K20
    endif
    ifdef CM1IF
CM1IFBIT = CM1IF                    ;     several J PICs
    endif
    ifdef CMP1IF
CMPIFREG = PIR1                     ;     1230/1330 only
CM1IFBIT = CMP1IF
CMPIEREG = PIE1
CMPIPREG = IPR1
    endif

    ifdef CM1IFBIT
       #define CMP1_INT  CMPIFREG, CM1IFBIT     
    endif

    ifdef C2IF                      ;-- Comparator 2
CM2IFBIT = C2IF                     ;     18F24K20  18F25K20  18F26K20
    endif                           ;     18F44K20  18F45K20  18F46K20
    ifdef CM2IF
CM2IFBIT = CM2IF                    ;     several J PICs
    endif    
    ifdef CMP2IF
CM2IFBIT = CMP2IF                   ;     1230/1330 only
    endif    

    ifdef CM2IFBIT
      #define CMP2_INT  CMPIFREG, CM2IFBIT     
    endif

;_____ USB Module ___________________________________________________________

  #define USB_INT       PIR2, USBIF   ;-- USB Interrupt (funnel)
  #define USB_ACTV_INT  UIR,  ACTVIF  ;-- Bus Activity Detect 
  #define USB_ERR_INT   UIR,  UERRIF  ;-- USB Error Condition INT (funnel)
  #define USB_RST_INT   UIR,  URSTIF  ;-- USB Reset 
  #define USB_IDLE_INT  UIR,  IDLEIF  ;-- Idle Detect 
  #define USB_STALL_INT UIR,  STALLIF ;-- A STALL Handshake 
  #define USB_TRN_INT   UIR,  TRNIF   ;-- Transaction Complete 
  #define USB_SOF_INT   UIR,  SOFIF   ;-- START-OF-FRAME Token 

; -- USB Error Flags --
  #define USB_BTO_INT   UEIR, BTOEF   ;-- Bus Turnaround Time-out Error
  #define USB_BTS_INT   UEIR, BTSEF   ;-- Bit Stuff Error
  #define USB_CRC16_INT UEIR, CRC16EF ;-- CRC16 Failure
  #define USB_CRC5_INT  UEIR, CRC5EF  ;-- CRC5 Host Error
  #define USB_DFN8_INT  UEIR, DFN8EF  ;-- Data Field Size Error
  #define USB_PID_INT   UEIR, PIDEF   ;-- PID Check Failure
   
;_____ Ethernet Module ______________________________________________________
  #define ETH_INT       PIR2, ETHIF   ;-- Ethernet Module
  #define ETH_DMA_INT    EIR, DMAIF   ;-- DMA Interrupt
  #define ETH_LINK_INT   EIR, LINKIF  ;-- Link Status Change
  #define ETH_PKT_INT    EIR, PKTIF   ;-- Receive Packet Pending
  #define ETH_RXER_INT   EIR, RXERIF  ;-- Receive Error
  #define ETH_TXER_INT   EIR, TXERIF  ;-- Transmit Error
  #define ETH_TX_INT     EIR, TXIF    ;-- Transmit

;_____ CAN Module ___________________________________________________________
  #define CAN_ERR_INT    PIR3, ERRIF    ;-- CAN bus Error
  #define CAN_IRX_INT    PIR3, IRXIF    ;-- Invalid Received Message
  #define CAN_RXB0_INT   PIR3, RXB0IF   ;-* Receive Buffer 0      Mode 0
  #define CAN_FIFOWM_INT PIR3, FIFOWMIF ;-- FIFO Watermark        Mode 1, 2
  #define CAN_RXB1_INT   PIR3, RXB1IF   ;-* Receive Buffer 1      Mode 0
  #define CAN_RXBn_INT   PIR3, RXBnIF   ;-- Any Receive Buffer    Mode 1, 2
  #define CAN_TXB0_INT   PIR3, TXB0IF   ;-- Transmit Buffer 0
  #define CAN_TXB1_INT   PIR3, TXB1IF   ;-- Transmit Buffer 1
  #define CAN_TXB2_INT   PIR3, TXB2IF   ;-* Transmit Buffer 2     Mode 0
  #define CAN_TXBn_INT   PIR3, TXBnIF   ;-- Any Transmit Buffer   Mode 1, 2
  #define CAN_WAKE_INT   PIR3, WAKIF    ;-- CAN bus Activity Wake-up


	ENDASM?


; C:\PBP3\DT_INTS-18.BAS   	00185	asm

	ASM?

; -- macro --
INT_Source  macro  IFR, IFB, IER, IEB, IPR, IPB
    if (IflagReg == IFR) && (IflagBit == IFB)  
  list  
INT_Flag_Reg = IFR
INT_Flag_Bit = IFB
INT_Enable_Reg = IER
INT_Enable_Bit = IEB
INT_Priority_Reg = IPR
INT_Priority_Bit = IPB
Found = 1
    endif
  nolist  
    endm 


	ENDASM?


; C:\PBP3\DT_INTS-18.BAS   	00203	asm

	ASM?

;____________________________________________________________________________
GetIntInfo  macro  IflagReg, IflagBit
  nolist
INT_Flag_Reg = -1
INT_Flag_Bit = -1
INT_Enable_Reg = -1
INT_Enable_Bit = -1
  ifdef  IPR1
INT_Priority_Reg = -1
INT_Priority_Bit = -1
  endif
Found = 0

  ifdef INT0IF  ;----{ INT0 External Interrupt }----------[INTCON, INT0IF]---
      INT_Source  INTCON,INT0IF, INTCON,INT0IE, -1, -1
  endif
  ifdef INT1IF  ;----{ INT1 External Interrupt }---------[INTCON3, INT1IF]---
      INT_Source  INTCON3,INT1IF, INTCON3,INT1IE, INTCON3,INT1IP
  endif
  ifdef INT2IF  ;----{ INT2 External Interrupt }---------[INTCON3, INT2IF]---
      INT_Source  INTCON3,INT2IF, INTCON3,INT2IE, INTCON3,INT2IP
  endif
  ifdef INT3IF  ;----{ INT3 External Interrupt }---------[INTCON3, INT3IF]---
      INT_Source  INTCON3,INT3IF, INTCON3,INT3IE, INTCON2,INT3IP
  endif
  ifdef RBIF    ;----{ RB Port Change Interrupt }-----------[INTCON, RBIF]---
      INT_Source  INTCON,RBIF, INTCON, RBIE,INTCON2,RBIP
  endif
  ifdef TMR0IF  ;----{ TMR0 Overflow Interrupt }----------[INTCON, TMR0IF]---
      INT_Source  INTCON,TMR0IF, INTCON,TMR0IE, INTCON2,TMR0IP
  endif
  ifdef TMR1IF  ;----{ TMR1 Overflow Interrupt }------------[PIR1, TMR1IF]---
      INT_Source  PIR1,TMR1IF, PIE1,TMR1IE, IPR1,TMR1IP
  endif
  ifdef TMR2IF  ;----{ TMR2 to PR2 Match Interrupt }--------[PIR1, TMR2IF]---
      INT_Source  PIR1,TMR2IF, PIE1,TMR2IE, IPR1,TMR2IP
  endif
  ifdef TMR3IF  ;----{ TMR3 Overflow Interrupt }------------[PIR2, TMR3IF]---
      INT_Source  PIR2,TMR3IF, PIE2,TMR3IE, IPR2,TMR3IP
  endif
  ifdef TMR4IF  ;----{ TMR4 Overflow Interrupt }------------[PIR3, TMR4IF]---
      INT_Source  PIR3,TMR4IF, PIE3,TMR4IE, IPR3,TMR4IP
  endif
  ifndef TX1IF  ;----{ USART Transmit Interrupt }-------------[PIR1, TXIF]---
      ifdef TXIF
          INT_Source  PIR1,TXIF, PIE1,TXIE, IPR1,TXIP
      endif
  endif
  ifdef TX1IF   ;----{ USART1 Transmit Interrupt }-----------[PIR1, TX1IF]---
      INT_Source  PIR1,TX1IF, PIE1,TX1IE, IPR1,TX1IP
  endif
  ifdef TX2IF   ;----{ USART2 Transmit Interrupt }-----------[PIR3, TX2IF]---
      INT_Source  PIR3,TX2IF, PIE3,TX2IE, IPR3,TX2IP
  endif
  ifndef RC1IF  ;----{ USART Receive Interrupt }---------------[PIR1 RCIF]---  
    ifdef RCIF
        INT_Source  PIR1,RCIF, PIE1,RCIE, IPR1,RCIP
    endif
  endif
  ifdef RC1IF   ;----{ USART1 Receive Interrupt }------------[PIR1, RC1IF]---
      INT_Source  PIR1,RC1IF, PIE1,RC1IE, IPR1,RC1IP
  endif
  ifdef RC2IF   ;----{ USART2 Receive Interrupt }------------[PIR3, RC2IF]---
      INT_Source  PIR3,RC2IF, PIE3,RC2IE, IPR3,RC2IP
  endif
  ifdef CMIF    ;----{ Comparator Interrupt }-----------------[PIR2, CMIF]---
      INT_Source  PIR2,CMIF, PIE2,CMIE, IPR2,CMIP
  endif
  ifdef EEIF    ;----{ EEPROM/FLASH Write Operation Interrupt [PIR2, EEIF]---
      INT_Source  PIR2,EEIF, PIE2,EEIE, IPR2,EEIP
  endif
  ifdef BCLIF   ;----{ Bus Collision Interrupt }-------------[PIR2, BCLIF]---
      INT_Source  PIR2,BCLIF, PIE2,BCLIE, IPR2,BCLIP
  endif
  ifdef LVDIF   ;----{ Low Voltage Detect Interrupt }--------[PIR2, LVDIF]---
      INT_Source  PIR2,LVDIF, PIE2,LVDIE, IPR2,LVDIP
  endif
  ifdef HLVDIF  ;----{ High/Low Voltage Detect Interrupt }--[PIR2, HLVDIF]---
      INT_Source  PIR2,HLVDIF, PIE2,HLVDIE, IPR2,HLVDIP
  endif
  ifdef PSPIF   ;----{ Parallel Slave Port Interrupt }-------[PIR1, PSPIF]---
      INT_Source  PIR1,PSPIF, PIE1,PSPIE, IPR1,PSPIP
  endif
  ifdef ADIF    ;----{ A/D Converter Interrupt }--------------[PIR1, ADIF]---
      INT_Source  PIR1,ADIF, PIE1,ADIE, IPR1,ADIP
  endif
  ifdef SSPIF   ;----{ Synchronous Serial Port Interrupt }---[PIR1, SSPIF]---
      INT_Source  PIR1,SSPIF, PIE1,SSPIE, IPR1,SSPIP
  endif
  ifdef CCP1IF  ;----{ CCP1 Interrupt }---------------------[PIR1, CCP1IF]---
      INT_Source  PIR1,CCP1IF, PIE1,CCP1IE, IPR1,CCP1IP
  endif
  ifdef CCP2IF  ;----{ CCP2 Interrupt Flag }----------------[PIR2, CCP2IF]---
      INT_Source  PIR2,CCP2IF, PIE2,CCP2IE, IPR2,CCP2IP
  endif
  ifdef CCP3IF  ;----{ CCP3 Interrupt Flag }----------------[PIR3, CCP3IF]---
      INT_Source  PIR3,CCP3IF, PIE3,CCP3IE, IPR3,CCP3IP
  endif
  ifdef CCP4IF  ;----{ CCP4 Interrupt Flag }----------------[PIR3, CCP4IF]---
      INT_Source  PIR3,CCP4IF, PIE3,CCP4IE, IPR3,CCP4IP
  endif
  ifdef CCP5IF  ;----{ CCP5 Interrupt Flag }----------------[PIR3, CCP5IF]---
      INT_Source  PIR3,CCP5IF, PIE3,CCP5IE, IPR3,CCP5IP
  endif
  ifdef OSCFIF  ;----{ Osc Fail  Interrupt Flag }-----------[PIR2, OSCFIF]---
      INT_Source  PIR2,OSCFIF, PIE2,OSCFIE, IPR2,OSCFIP
  endif


	ENDASM?


; C:\PBP3\DT_INTS-18.BAS   	00313	asm

	ASM?

; -- Added for ver. 3.2 --
  ifdef SPPIF   ;----{ Streaming Parallel Port Read/Write }--[PIR1, SPPIF]---
      INT_Source  PIR1,SPPIF, PIE1,SPPIE, IPR1,SPPIP
  endif
  ifdef BCL1IF  ;----{ Bus 1 Collision }--------------------[PIR2, BCL1IF]---
      INT_Source  BUS1_INT, PIE2,BCL1IE, IPR2,BCL1IP
  endif
  ifdef BCL2IF  ;----{ Bus 2 Collision }--------------------[PIR3, BCL2IF]---
      INT_Source  BUS2_INT, PIE3,BCL2IE, IPR3,BCL2IP
  endif
  ifdef CMP0IF  ;----{ Comparator 0 }-----------------------[PIR1, CMP0IF]---
      INT_Source  CMP0_INT, PIE1,CMP0IE, IPR1,CMP0IP
  endif
  ifdef CM1IFBIT  ;--{ Comparator 1 }-----------------------------[varies]---
      INT_Source  CMP1_INT, CMPIEREG,CM1IFBIT, CMPIPREG,CM1IFBIT
  endif
  ifdef CM2IFBIT  ;--{ Comparator 2 }-----------------------------[varies]---
      INT_Source  CMP2_INT, CMPIEREG,CM2IFBIT, CMPIPREG,CM2IFBIT
  endif
  ifdef ECCP1IF  ;---{ ECCP1 }-----------------------------[PIR2, ECCP1IF]---
      INT_Source  ECCP1_INT, PIE2,ECCP1IE, IPR2,ECCP1IP
  endif
  ifdef LCDIF   ;----{ LCD Driver }--------------------------[PIR3, LCDIF]---
      INT_Source  LCD_INT, PIE3,LCDIE, IPR3,LCDIP
  endif
  ifdef PMPIF   ;----{ Parallel Master Port }----------------[PIR1, PMPIF]---
      INT_Source  PMP_INT, PIE1,PMPIE, IPR1,PMPIP
  endif
  ifdef SSP1IF  ;----{ Synchronous Serial Port 1 }----------[PIR1, SSP1IF]---
      INT_Source  SSP1_INT, PIE1,SSP1IE, IPR1,SSP1IP
  endif
  ifdef SSP2IF  ;----{ Synchronous Serial Port 2 }----------[PIR3, SSP2IF]---
      INT_Source  SSP2_INT, PIE3,SSP2IE, IPR3,SSP2IP
  endif
  ifdef TMR5IF  ;----{ Timer 5 }----------------------------[PIR3, TMR5IF]---
      INT_Source  TMR5_INT, PIE3,TMR5IE, IPR3,TMR5IP
  endif
  ifdef PTIF    ;----{ PWM Time Base }------------------------[PIR3, PTIF]---
      INT_Source  PT_INT, PIE3,PTIE, IPR3,PTIP
  endif
  ifdef IC1IF   ;----{ Motion Feedback IC1}------------------[PIR3, IC1IF]---
      INT_Source  IC1IF_INT, PIE3,IC1IE, IPR3,IC1IP
  endif
  ifdef IC2QEIF ;----{ Motion Feedback IC2QE}--------------[PIR3, IC2QEIF]---
      INT_Source  IC2QEIF_INT, PIE3,IC2QEIE, IPR3,IC2QEIP
  endif
  ifdef IC3DRIF ;----{ Motion Feedback IC3DR}--------------[PIR3, IC3DRIF]---
      INT_Source  IC3DRIF_INT, PIE3,IC3DRIE, IPR3,IC3DRIP
  endif
  
;  ifdef   ;----{  }-------------[, ]---
;      INT_Source  , ,, ,
;  endif


	ENDASM?


; C:\PBP3\DT_INTS-18.BAS   	00369	asm  ; -- USB sources --

	ASM?
  ; -- USB sources --
  ifdef USBIF   ;----{ USB  Interrupt funnel }---------------[PIR2, USBIF]---
      INT_Source  PIR2,USBIF, PIE2,USBIE, IPR2,USBIP
          
                ;----{ Bus Activity Detect }-----------------[UIR, ACTVIF]---
      INT_Source  USB_ACTV_INT, UIE,ACTVIE, _NoPriority
  
                ;----{ USB Reset }---------------------------[UIR, URSTIF]---
      INT_Source  USB_RST_INT, UIE,URSTIE, _NoPriority
  
                ;----{ Idle Detect }-------------------------[UIR, IDLEIF]---
      INT_Source  USB_IDLE_INT, UIE,IDLEIE, _NoPriority
  
                ;----{ A STALL Handshake }------------------[UIR, STALLIF]---
      INT_Source  USB_STALL_INT, UIE,STALLIE, _NoPriority
  
                ;----{ Transaction Complete }-----------------[UIR, TRNIF]---
      INT_Source  USB_TRN_INT, UIE,TRNIE, _NoPriority
  
                ;----{ START-OF-FRAME Token }-----------------[UIR, SOFIF]---
      INT_Source  USB_SOF_INT, UIE,SOFIE, _NoPriority
  
; -- USB Error Flags --
                ;----{ USB Error Condition Int funnel }------[UIR, UERRIF]---
      INT_Source  USB_ERR_INT, UIE,UERRIE, _NoPriority
   
                ;----{ Bus Turnaround Time-out Error }-------[UEIR, BTOEF]---
      INT_Source  USB_BTO_INT, UEIE,BTOEE, _NoPriority
   
                ;----{ Bit Stuff Error }---------------------[UEIR, BTSEF]---
      INT_Source  USB_BTS_INT, UEIE,BTSEE, _NoPriority
   
                ;--{ CRC16 Failure }-----------------------[UEIR, CRC16EF]---
      INT_Source  USB_CRC16_INT, UEIE,CRC16EE, _NoPriority
   
                ;---{ CRC5 Host Error }---------------------[UEIR, CRC5EF]---
      INT_Source  USB_CRC5_INT, UEIE,CRC5EE, _NoPriority
   
                ;---{ Data Field Size Error }---------------[UEIR, DFN8EF]---
      INT_Source  USB_DFN8_INT, UEIE,DFN8EE, _NoPriority
   
                ;----{ PID Check Failure }-------------------[UEIR, PIDEF]---
      INT_Source  USB_PID_INT, UEIE,PIDEE, _NoPriority
  endif


	ENDASM?


; C:\PBP3\DT_INTS-18.BAS   	00415	asm  ; -- Ethernet sources --

	ASM?
  ; -- Ethernet sources --
  ifdef ETHIF  ;----{ Ethernet Module }----------------------[PIR2, ETHIF]---
      INT_Source  ETH_INT, PIE2,ETHIE, IPR2,ETHIP
   
               ;----{ DMA Interrupt }-------------------------[EIR, DMAIF]---
      INT_Source  ETH_DMA_INT, EIE,DMAIE, _NoPriority
   
               ;----{ Link Status Change }-------------------[EIR, LINKIF]---
      INT_Source  ETH_LINK_INT, EIE,LINKIE, _NoPriority
   
               ;----{ Receive Packet Pending }----------------[EIR, PKTIF]---
      INT_Source  ETH_PKT_INT, EIE,PKTIE, _NoPriority
   
               ;----{ Receive Error }------------------------[EIR, RXERIF]---
      INT_Source  ETH_RXER_INT, EIE,RXERIE, _NoPriority
              
               ;----{ Transmit Error }-----------------------[EIR, TXERIF]---
      INT_Source  ETH_TXER_INT, EIE,TXERIE, _NoPriority
   
               ;----{ Transmit }-------------------------------[EIR, TXIF]---
      INT_Source  ETH_TX_INT, EIE,TXIE, _NoPriority
  endif


	ENDASM?


; C:\PBP3\DT_INTS-18.BAS   	00439	asm  ; -- CAN Module --

	ASM?
  ; -- CAN Module --
  ifdef WAKIF  
               ;----{ CAN bus Error }------------------------[PIR3, ERRIF]---
      INT_Source  CAN_ERR_INT, PIE3,ERRIE, IPR3,ERRIP
  
               ;----{ Invalid Received Message }-------------[PIR3, IRXIF]---
      INT_Source  CAN_IRX_INT, PIE3,IRXIE, IPR3,IRXIP
  
               ;----{ Receive Buffer 0 }------Mode 0--------[PIR3, RXB0IF]---
      INT_Source  CAN_RXB0_INT, PIE3,RXB0IE, IPR3,RXB0IP
               ;----{ FIFO Watermark }--------Mode 1, 2---[PIR3, FIFOWMIF]---
      INT_Source  CAN_FIFOWM_INT, PIE3,FIFOWMIE, IPR3,FIFOWMIP
  
               ;----{ Receive Buffer 1 }------Mode 0--------[PIR3, RXB1IF]---
      INT_Source  CAN_RXB1_INT, PIE3,RXB1IE, IPR3,RXB1IP
               ;----{ Any Receive Buffer }----Mode 1, 2-----[PIR3, RXBnIF]---
      INT_Source  CAN_RXBn_INT, PIE3,RXBnIE, IPR3,RXBnIP
  
               ;----{ Transmit Buffer 0 }-------------------[PIR3, TXB0IF]---
      INT_Source  CAN_TXB0_INT, PIE3,TXB0IE, IPR3,TXB0IP
  
               ;----{ Transmit Buffer 1 }-------------------[PIR3, TXB1IF]---
      INT_Source  CAN_TXB1_INT, PIE3,TXB1IE, IPR3,TXB1IP
  
               ;----{ Transmit Buffer 2 }-----Mode 0=-------[PIR3, TXB2IF]---
      INT_Source  CAN_TXB2_INT, PIE3,TXB2IE, IPR3,TXB2IP
               ;----{ Any Transmit Buffer }---Mode 1, 2-----[PIR3, TXBnIF]---
      INT_Source  CAN_TXBn_INT, PIE3,TXBnIE, IPR3,TXBnIP
  
               ;----{ CAN bus Activity Wake-up }-------------[PIR3, WAKIF]---
      INT_Source  CAN_WAKE_INT, PIE3,WAKIE, IPR3,WAKIP
  endif
  
  list
    endm
  list  


	ENDASM?


; C:\PBP3\DT_INTS-18.BAS   	00478	ASM

	ASM?

    ifndef  USE_LOWPRIORITY
INT_ENTRY_L
        retfie
    else
        if (USE_LOWPRIORITY != 1)
INT_ENTRY_L
            retfie
        endif
    endif        


	ENDASM?


; C:\PBP3\DT_INTS-18.BAS   	00491	Asm

	ASM?

asm = 0    ; Assembly language Interrupts
ASM = 0
Asm = 0
pbp = 1    ; Basic language interrupts
PBP = 1
Pbp = 1
YES = 1
yes = 1
Yes = 1
NO = 0
no = 0
No = 0
H equ 'H'  ; High Priority
h equ 'H'
L equ 'L'  ; Low Priority
l equ 'L'

  nolist
  
;_____________________________________________________________________________
SaveFSR  macro  F, Pr
  list
    if (F >= 0) && (F <= 2)
        if (Pr == H) || (Pr == L)
            movff    FSR#v(F)L, fsave#v(F)Pr
            movff    FSR#v(F)H, fsave#v(F)Pr + 1
          nolist
        else
            ERROR "SaveFSR - Invalid Priority"
        endif
    else
        ERROR "SaveFSR - Invalid FSR number"
    endif
    list
  endm


	ENDASM?


; C:\PBP3\DT_INTS-18.BAS   	00530	Asm

	ASM?

RestFSR  macro  F, Pr
  list
    if (F >= 0) && (F <= 2)
        if (Pr == H) || (Pr == L)
            movff    fsave#v(F)Pr , FSR#v(F)L
            movff    fsave#v(F)Pr + 1 , FSR#v(F)H 
          nolist
        else
            ERROR "RestFSR - Invalid Priority"
        endif
    else
        ERROR "RestFSR - Invalid FSR number"
    endif
    list
  endm


	ENDASM?


; C:\PBP3\DT_INTS-18.BAS   	00549	Asm

	ASM?

INT_FINISH_H   macro
  endm


	ENDASM?


; C:\PBP3\DT_INTS-18.BAS   	00555	ASM

	ASM?

INT_CREATE_H  macro
  local OverCREATE
    goto OverCREATE
Priority = H    
INT_ENTRY_H  
    movff   PCLATU, psaveUH
    movff   PCLATH, psaveH
    SaveFSR  0, H
    SaveFSR  1, H
    SaveFSR  2, H
    bsf      _InHPint, 0
List_Start_H
    bcf      _Serviced_H, 0         ; Clear Serviced flag
    clrf  BSR
PREV_BANK = 0
    ifdef INT_LIST_H
        INT_LIST_H                  ; Expand the users list of HP INT handlers
    else
        ifdef INT_LIST
            INT_LIST                ; Expand the 16F Compatible List
        else
            error "INT_CREATE_H - INT_LIST or INT_LIST_H not found"
        endif
    endif
    btfsc    _Serviced_H,0          ; if anything was serviced
    goto     List_Start_H           ; go around, and check again

    ifdef ReEnterHPused             ; was ReEnterPBP-18.bas included
        GetAddress21  INT_EXIT_H, RetAddrH
        L?GOTO   _RestorePBP_H      ; Restore PBP system Vars
    endif

INT_EXIT_H
PREV_BANK = 0
    bcf      _InHPint, 0
    RestFSR  0, H                   ; Restore FSR0, if it was saved?
    RestFSR  1, H                   ; Restore FSR1, if it was saved?
    RestFSR  2, H                   ; Restore FSR2, if it was saved?
    movff    psaveH, PCLATH
    movff    psaveUH, PCLATU
    retfie    FAST                  ; Return from Interrupt
OverCREATE
    bsf   INTCON,GIE, 0             ; Enable High Priority Interrupts
    bsf   INTCON,PEIE, 0            ; Enable Peripheral Interrupts
  endm

;---[Stay compatible with the 14-bit version]---------------------------------
INT_CREATE  macro
    INT_CREATE_H
  endm


	ENDASM?


; C:\PBP3\DT_INTS-18.BAS   	00609	ASM

	ASM?

INT_CREATE_L  macro
  local OverCREATE
    goto OverCREATE
    ifdef USE_LOWPRIORITY
        if (USE_LOWPRIORITY != 1)
       error "'DEFINE USE_LOWPRIORITY 1' required for Low Priority Interrupts"
        endif
    else
       error "'DEFINE USE_LOWPRIORITY 1' required for Low Priority Interrupts"
    endif
Priority = L
INT_ENTRY_L  
    movff   WREG, wsave             ; Wreg
    movff   STATUS, ssave           ; STATUS
    movff   BSR, bsave              ; BSR
    movff   PCLATU, psaveUL
    movff   PCLATH, psaveL
    SaveFSR  0, L                   ; FSR0
    SaveFSR  1, L                   ; FSR1
    SaveFSR  2, L                   ; FSR2
    bcf      _InHPint, 0    
List_Start_L
  clrf  BSR
PREV_BANK = 0
    bcf      _Serviced_L, 0
    ifdef INT_LIST_L
        INT_LIST_L                  ; Expand the users list of HP INT handlers
    else
        error "INT_CREATE_L - INT_LIST_L not defined, can not create"
    endif
    btfsc    _Serviced_L, 0         ; if anything was serviced
    goto     List_Start_L           ; go around, and check again

    ifdef ReEnterLPused             ; was ReEnterPBP-18LP.bas included
        GetAddress21  INT_EXIT_L, RetAddrL
        L?GOTO   _RestorePBP_L      ; Restore PBP system Vars
    endif

INT_EXIT_L
PREV_BANK = 0
    RestFSR  0, L                   ; Restore saved vars
    RestFSR  1, L
    RestFSR  2, L                
    movff   psaveUL, PCLATU
    movff   psaveL, PCLATH
    movff   bsave, BSR              ; BSR
    movff   wsave, WREG             ; WREG
    movff   ssave, STATUS           ; STATUS
    retfie                          ; Return from Interrupt
OverCREATE
    bsf   RCON,IPEN, 0              ; Enable Interrupt Priorities
    bsf   INTCON,GIEL, 0            ; Enable Low Priority Interrupts
  endm


	ENDASM?


; C:\PBP3\DT_INTS-18.BAS   	00665	ASM

	ASM?

;---[Returns the Address of a Label as a Word]--(under 64K)------------------
GetAddress macro Label, Wout
    CHK?RP Wout
    movlw low Label          ; get low byte
    movwf Wout
    movlw High Label         ; get high byte
    movwf Wout + 1
    endm

;---[Returns the Address of a Label as a 3 byte array]---(under/over 64k)-----
GetAddress21 macro Label, Aout
    CHK?RP Aout
    movlw low Label          ; get low byte
    movwf Aout
    movlw high Label         ; get high byte
    movwf Aout + 1
    movlw upper Label        ; get upper byte
    movwf Aout + 2
    endm

;---[find correct bank for a PBP BIT variable]-------------------------------
CHKRP?T  macro reg, bit
        CHK?RP  reg
    endm
    


;---[find Assigned Priority for specified INT Source]------------------------
INT_Count = 0

FindIntPriority  macro IntFlagReg, IntFlagBit
  local LoopCount
    nolist
Pfound = 0
LoopCount = 1
      while LoopCount <= INT_Count
          if  (IntFlagReg == PrList#v(LoopCount)R)
             if (IntFlagBit == PrList#v(LoopCount)B)
  list
Priority =  PrList#v(LoopCount)Priority
Pfound = 1
             endif
          endif
LoopCount += 1
      endw
  endm  


	ENDASM?


; C:\PBP3\DT_INTS-18.BAS   	00714	ASM

	ASM?


;---[Add an Interrupt Source to the user's list of INT Handlers]--------------
INT_Handler  macro  IntFlagReg, IntFlagBit, Label, Type, Reset
  list
    local AfterSave, AfterUser, NoInt
INT_Count += 1
PrList#v(INT_Count)R = IntFlagReg
PrList#v(INT_Count)B = IntFlagBit
PrList#v(INT_Count)Priority = Priority
        GetIntInfo   IntFlagReg, IntFlagBit
        if (Found == YES)
            btfss    INT_Enable_Reg, INT_Enable_Bit, 0  ; if INT is enabled
            goto   NoInt
            btfss    INT_Flag_Reg, INT_Flag_Bit, 0      ; and the Flag set?
            goto     NoInt
            if (Priority == H)
                bsf      _Serviced_H, 0
            else
                bsf      _Serviced_L, 0
            endif
            ifdef NO_CLRWDT
                if  (NO_CLRWDT != 1)
                    CLRWDT
                endif
            else
                CLRWDT
            endif
                
            if (Type == PBP)                         ; If INT handler is PBP
              if (Priority == H)
                ifdef ReEnterHPused
                    GetAddress21  AfterSave, RetAddrH  
                    L?GOTO  _SavePBP_H        ; Save PBP system Vars in HP INT
                else
    error "ReEnterPBP-18 must be INCLUDEd to use High Priority PBP interrupts"
                endif
              else ; Priority = L
                ifdef ReEnterLPused
                    GetAddress21  AfterSave, RetAddrL  
                    L?GOTO  _SavePBP_L        ; Save PBP system Vars in LP INT
                else
   error "ReEnterPBP-18LP must be INCLUDEd to use Low Priority PBP interrupts"
                endif
              endif
            endif
AfterSave
PREV_BANK = 0
            if (Priority == H)
                  GetAddress21  AfterUser, RetAddrH  
            else ; Priority = L
                  GetAddress21  AfterUser, RetAddrL
            endif  
            L?GOTO   Label                        ; goto the users INT handler
                    
AfterUser
PREV_BANK = 0
            if (Reset == YES)                      ; reset flag (if specified)
                bcf      INT_Flag_Reg, INT_Flag_Bit, 0 
            endif
        else
            error Interrupt Source (IntFlagReg,IntFlagBit) not found
        endif
NoInt
    clrf  BSR
PREV_BANK = 0
    endm


	ENDASM?


; C:\PBP3\DT_INTS-18.BAS   	00783	asm

	ASM?

;---[Returns from a "goto" subroutine]--(21-bit RetAddr? must be set first)---
INT_RETURN  macro
  local Ret2LP, Ret2HP
      btfsc   _InHPint, 0
      goto    Ret2HP
Ret2LP
      movff   RetAddrL + 2, PCLATU  ; Load PC buffers with return address
      movff   RetAddrL + 1, PCLATH
      movf    RetAddrL, W, 0
    clrf  BSR                    ; Set to BANK0 before returning
PREV_BANK = 0                    ; Tell PBP about the BANK change
      movwf   PCL, 0             ; Go back to where we were
      
Ret2HP       
      movff   RetAddrH + 2, PCLATU ; Load PC buffers with return address
      movff   RetAddrH + 1, PCLATH
      movf    RetAddrH, W, 0
    clrf  BSR                    ; Set to BANK0 before returning
PREV_BANK = 0                    ; Tell PBP about the BANK change
      movwf   PCL, 0             ; Go back to where we were
    endm    
    
;---[Enable an interrupt source]----------------------------------------------
INT_ENABLE  macro  IntFlagReg, IntFlagBit
      GetIntInfo   IntFlagReg, IntFlagBit
      if (Found == YES)
          FindIntPriority  IntFlagReg, IntFlagBit
          if (Pfound == 1)
              if (INT_Priority_Reg != -1)
                  if (Priority == H)
                      bsf  INT_Priority_Reg, INT_Priority_Bit, 0
                  else
                      if (Priority == L)
                          bcf  INT_Priority_Reg, INT_Priority_Bit, 0
                      else
                          error "INT_ENABLE - Invalid Priority Specified"
                      endif
                  endif
              else
                  if (Priority == L)
                      error "INT0_INT can NOT be assigned to Low Priority"
                  endif
              endif
          else
              error "INT_ENABLE - Priority State Not Found"
          endif
;          bcf     INT_Flag_Reg, INT_Flag_Bit, 0        ; clear the flag first 
          bsf     INT_Enable_Reg, INT_Enable_Bit, 0    ; enable the INT source  
      else
          error  "INT_ENABLE - Interrupt Source not found!"
      endif
    endm    

;---[Disable an interrupt source]---------------------------------------------
INT_DISABLE  macro  IntFlagReg, IntFlagBit
      GetIntInfo   IntFlagReg, IntFlagBit
      if (Found == YES)
          bcf     INT_Enable_Reg, INT_Enable_Bit, 0   ; disable the INT source  
      else
          error "INT_DISABLE - Interrupt Source not found!"
      endif
    endm    

;---[Clear an interrupt Flag]-------------------------------------------------
INT_CLEAR  macro  IntFlagReg, IntFlagBit
      GetIntInfo   IntFlagReg, IntFlagBit
      if (Found == YES)
          bcf     INT_Flag_Reg, INT_Flag_Bit, 0       ; clear the INT flag
      else
          error "INT_CLEAR -  Interrupt Source not found!"
      endif
    endm



	ENDASM?


; C:\PBP3\DT_INTS-18.BAS   	00860	ASM

	ASM?

Save_TBLPTR = 0

    ifdef SIN_USED
Save_TBLPTR = 1
    endif
    ifdef DTMFOUT_USED
Save_TBLPTR = 1
    endif
    ifdef SERDELAY_USED
Save_TBLPTR = 1
    endif
    ifdef CONVBIT_USED
Save_TBLPTR = 1
    endif
    ifdef ERASECODE_USED
Save_TBLPTR = 1
    endif
    ifdef READCODE_USED
Save_TBLPTR = 1
    endif
    ifdef WRITECODE_USED
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?BCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?BCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?BCLW
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?CCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?CCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?CCLW
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?WCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?WCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?WCLW
Save_TBLPTR = 1
    endif
    ifdef LOOK2_USED 
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?BCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?BCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?BCLW
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?CCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?CCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?CCLW
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?TCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?TCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?TCLW
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?WCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?WCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?WCLW
Save_TBLPTR = 1
    endif


	ENDASM?


; C:\PBP3\DT_INTS-18.BAS   	00952	OVER_DT_INTS_18:

	LABEL?L	_OVER_DT_INTS_18	

; C:\PBP3\DT_INTS-18.BAS   	00954	ENABLE DEBUG
	DENABLE?	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00135	INCLUDE "ReEnterPBP-18.bas"     ' Include if using PBP interrupts

; C:\PBP3\REENTERPBP-18.BAS	00020	DISABLE DEBUG
	DDISABLE?	
; C:\PBP3\REENTERPBP-18.BAS	00022	DEFINE   ReEnterHPused  1

; C:\PBP3\REENTERPBP-18.BAS	00024	VarsSaved_H = 0
	MOVE?CT	000h, _VarsSaved_H

; C:\PBP3\REENTERPBP-18.BAS	00026	goto OverReEnterH
	GOTO?L	_OverReEnterH

; C:\PBP3\REENTERPBP-18.BAS	00065	SavePBP_H:               ' Save all PBP system Vars High Priority

	LABEL?L	_SavePBP_H	

; C:\PBP3\REENTERPBP-18.BAS	00066	  if VarsSaved_H = 0 then
	CMPNE?TCL	_VarsSaved_H, 000h, L00002

; C:\PBP3\REENTERPBP-18.BAS	00067	    R0_SaveH = R0
	MOVE?WW	R0, _R0_SaveH

; C:\PBP3\REENTERPBP-18.BAS	00068	    R1_SaveH = R1
	MOVE?WW	R1, _R1_SaveH

; C:\PBP3\REENTERPBP-18.BAS	00069	    R2_SaveH = R2
	MOVE?WW	R2, _R2_SaveH

; C:\PBP3\REENTERPBP-18.BAS	00070	    R3_SaveH = R3
	MOVE?WW	R3, _R3_SaveH

; C:\PBP3\REENTERPBP-18.BAS	00071	    asm

	ASM?

        if (PBPLongs_Used == 1)
            MOVE?WW  R0+2, _R0_SaveH+2
            MOVE?WW  R1+2, _R1_SaveH+2
            MOVE?WW  R2+2, _R2_SaveH+2
            MOVE?WW  R3+2, _R3_SaveH+2
        endif
    

	ENDASM?


; C:\PBP3\REENTERPBP-18.BAS	00079	    R4_SaveH = R4
	MOVE?WW	R4, _R4_SaveH

; C:\PBP3\REENTERPBP-18.BAS	00080	    R5_SaveH = R5
	MOVE?WW	R5, _R5_SaveH

; C:\PBP3\REENTERPBP-18.BAS	00081	    R6_SaveH = R6
	MOVE?WW	R6, _R6_SaveH

; C:\PBP3\REENTERPBP-18.BAS	00082	    R7_SaveH = R7
	MOVE?WW	R7, _R7_SaveH

; C:\PBP3\REENTERPBP-18.BAS	00083	    R8_SaveH = R8
	MOVE?WW	R8, _R8_SaveH

; C:\PBP3\REENTERPBP-18.BAS	00084	    Flags_SaveH = FLAGS
	MOVE?BB	FLAGS, _Flags_SaveH

; C:\PBP3\REENTERPBP-18.BAS	00085	    GOP_SaveH = GOP
	MOVE?BB	GOP, _GOP_SaveH

; C:\PBP3\REENTERPBP-18.BAS	00086	    RM1_SaveH = RM1
	MOVE?BB	RM1, _RM1_SaveH

; C:\PBP3\REENTERPBP-18.BAS	00087	    RM2_SaveH = RM2
	MOVE?BB	RM2, _RM2_SaveH

; C:\PBP3\REENTERPBP-18.BAS	00088	    RR1_SaveH = RR1
	MOVE?BB	RR1, _RR1_SaveH

; C:\PBP3\REENTERPBP-18.BAS	00089	    RR2_SaveH = RR2
	MOVE?BB	RR2, _RR2_SaveH

; C:\PBP3\REENTERPBP-18.BAS	00090	@ if Save_TBLPTR == 1

	ASM?
 if Save_TBLPTR == 1

	ENDASM?


; C:\PBP3\REENTERPBP-18.BAS	00091	    TBLPTRU_SaveH = TBLPTRU
	MOVE?BB	TBLPTRU, _TBLPTRU_SaveH

; C:\PBP3\REENTERPBP-18.BAS	00092	    TBLPTRH_SaveH = TBLPTRH
	MOVE?BB	TBLPTRH, _TBLPTRH_SaveH

; C:\PBP3\REENTERPBP-18.BAS	00093	    TBLPTRL_SaveH = TBLPTRL
	MOVE?BB	TBLPTRL, _TBLPTRL_SaveH

; C:\PBP3\REENTERPBP-18.BAS	00094	@ endif

	ASM?
 endif

	ENDASM?


; C:\PBP3\REENTERPBP-18.BAS	00095	    ASM

	ASM?

        ifdef RS1
            MOVE?BB    RS1, _RS1_SaveH
        endif
        ifdef RS2
            MOVE?BB    RS2, _RS2_SaveH
        endif
        ifdef MUL_USED
            MOVE?WW    PRODL, _Product_H
        endif
        ifdef T1
            MOVE?WW    T1, _T1_SaveH
            if (PBPLongs_Used == 1)
                MOVE?WW  T1+2, _T1_SaveH+2
            endif
        endif
        ifdef T2
            MOVE?WW    T2, _T2_SaveH
            if (PBPLongs_Used == 1)
                MOVE?WW  T2+2, _T2_SaveH+2
            endif
        endif
        ifdef T3
            MOVE?WW    T3, _T3_SaveH
            if (PBPLongs_Used == 1)
                MOVE?WW  T3+2, _T3_SaveH+2
            endif
        endif
        ifdef T4
            MOVE?WW    T4, _T4_SaveH
            if (PBPLongs_Used == 1)
                MOVE?WW  T4+2, _T4_SaveH+2
            endif
        endif
        ifdef T5
            MOVE?WW    T5, _T5_SaveH
            if (PBPLongs_Used == 1)
                MOVE?WW  T5+2, _T5_SaveH+2
            endif
        endif
        ifdef T6
            MOVE?WW    T6, _T6_SaveH
            if (PBPLongs_Used == 1)
                MOVE?WW  T6+2, _T6_SaveH+2
            endif
        endif
        ifdef T7
            MOVE?WW    T7, _T7_SaveH
            if (PBPLongs_Used == 1)
                MOVE?WW  T7+2, _T7_SaveH+2
            endif
        endif
    

	ENDASM?


; C:\PBP3\REENTERPBP-18.BAS	00148	    VarsSaved_H = 1
	MOVE?CT	001h, _VarsSaved_H

; C:\PBP3\REENTERPBP-18.BAS	00149	  endif
	LABEL?L	L00002	

; C:\PBP3\REENTERPBP-18.BAS	00150	@ INT_RETURN

	ASM?
 INT_RETURN

	ENDASM?


; C:\PBP3\REENTERPBP-18.BAS	00152	RestorePBP_H:

	LABEL?L	_RestorePBP_H	

; C:\PBP3\REENTERPBP-18.BAS	00153	  if VarsSaved_H = 1 then
	CMPNE?TCL	_VarsSaved_H, 001h, L00004

; C:\PBP3\REENTERPBP-18.BAS	00154	    R0 = R0_SaveH
	MOVE?WW	_R0_SaveH, R0

; C:\PBP3\REENTERPBP-18.BAS	00155	    R1 = R1_SaveH
	MOVE?WW	_R1_SaveH, R1

; C:\PBP3\REENTERPBP-18.BAS	00156	    R2 = R2_SaveH
	MOVE?WW	_R2_SaveH, R2

; C:\PBP3\REENTERPBP-18.BAS	00157	    R3 = R3_SaveH
	MOVE?WW	_R3_SaveH, R3

; C:\PBP3\REENTERPBP-18.BAS	00158	    asm

	ASM?

        if (PBPLongs_Used == 1)
            MOVE?WW  _R0_SaveH+2, R0+2
            MOVE?WW  _R1_SaveH+2, R1+2 
            MOVE?WW  _R2_SaveH+2, R2+2 
            MOVE?WW  _R3_SaveH+2, R3+2 
        endif
    

	ENDASM?


; C:\PBP3\REENTERPBP-18.BAS	00166	    R4 = R4_SaveH
	MOVE?WW	_R4_SaveH, R4

; C:\PBP3\REENTERPBP-18.BAS	00167	    R5 = R5_SaveH
	MOVE?WW	_R5_SaveH, R5

; C:\PBP3\REENTERPBP-18.BAS	00168	    R6 = R6_SaveH
	MOVE?WW	_R6_SaveH, R6

; C:\PBP3\REENTERPBP-18.BAS	00169	    R7 = R7_SaveH
	MOVE?WW	_R7_SaveH, R7

; C:\PBP3\REENTERPBP-18.BAS	00170	    R8 = R8_SaveH
	MOVE?WW	_R8_SaveH, R8

; C:\PBP3\REENTERPBP-18.BAS	00171	    FLAGS = Flags_SaveH
	MOVE?BB	_Flags_SaveH, FLAGS

; C:\PBP3\REENTERPBP-18.BAS	00172	    GOP = GOP_SaveH
	MOVE?BB	_GOP_SaveH, GOP

; C:\PBP3\REENTERPBP-18.BAS	00173	    RM1 = RM1_SaveH
	MOVE?BB	_RM1_SaveH, RM1

; C:\PBP3\REENTERPBP-18.BAS	00174	    RM2 = RM2_SaveH
	MOVE?BB	_RM2_SaveH, RM2

; C:\PBP3\REENTERPBP-18.BAS	00175	    RR1 = RR1_SaveH
	MOVE?BB	_RR1_SaveH, RR1

; C:\PBP3\REENTERPBP-18.BAS	00176	    RR2 = RR2_SaveH
	MOVE?BB	_RR2_SaveH, RR2

; C:\PBP3\REENTERPBP-18.BAS	00177	@ if Save_TBLPTR == 1

	ASM?
 if Save_TBLPTR == 1

	ENDASM?


; C:\PBP3\REENTERPBP-18.BAS	00178	    TBLPTRU = TBLPTRU_SaveH
	MOVE?BB	_TBLPTRU_SaveH, TBLPTRU

; C:\PBP3\REENTERPBP-18.BAS	00179	    TBLPTRH = TBLPTRH_SaveH
	MOVE?BB	_TBLPTRH_SaveH, TBLPTRH

; C:\PBP3\REENTERPBP-18.BAS	00180	    TBLPTRL = TBLPTRL_SaveH
	MOVE?BB	_TBLPTRL_SaveH, TBLPTRL

; C:\PBP3\REENTERPBP-18.BAS	00181	@ endif

	ASM?
 endif

	ENDASM?


; C:\PBP3\REENTERPBP-18.BAS	00182	    ASM

	ASM?

        ifdef RS1
            MOVE?BB    _RS1_SaveH, RS1
        endif
        ifdef RS2
            MOVE?BB    _RS2_SaveH, RS2
        endif
        ifdef MUL
            MOVE?WW    _Product_H, PRODL
        endif
        ifdef T1
            MOVE?WW    _T1_SaveH, T1
            if (PBPLongs_Used == 1)
                MOVE?WW  _T1_SaveH+2, T1+2 
            endif
        endif
        ifdef T2
            MOVE?WW    _T2_SaveH, T2
            if (PBPLongs_Used == 1)
                MOVE?WW  _T2_SaveH+2, T2+2 
            endif
        endif
        ifdef T3
            MOVE?WW    _T3_SaveH, T3
            if (PBPLongs_Used == 1)
                MOVE?WW  _T3_SaveH+2, T3+2 
            endif
        endif
        ifdef T4
            MOVE?WW    _T4_SaveH, T4
            if (PBPLongs_Used == 1)
                MOVE?WW  _T4_SaveH+2, T4+2 
            endif
        endif
        ifdef T5
            MOVE?WW    _T5_SaveH, T5
            if (PBPLongs_Used == 1)
                MOVE?WW  _T5_SaveH+2, T5+2 
            endif
        endif
        ifdef T6
            MOVE?WW    _T6_SaveH, T6
            if (PBPLongs_Used == 1)
                MOVE?WW  _T6_SaveH+2, T6+2 
            endif
        endif
        ifdef T7
            MOVE?WW    _T7_SaveH, T7
            if (PBPLongs_Used == 1)
                MOVE?WW  _T7_SaveH+2, T7+2 
            endif
        endif
        ifdef T8
            ifndef NO_T7_WARNING
                messg "Temp variables exceeding T7"
            endif
        endif
    

	ENDASM?


; C:\PBP3\REENTERPBP-18.BAS	00240	    VarsSaved_H = 0
	MOVE?CT	000h, _VarsSaved_H

; C:\PBP3\REENTERPBP-18.BAS	00241	  ENDIF
	LABEL?L	L00004	

; C:\PBP3\REENTERPBP-18.BAS	00242	@ INT_RETURN

	ASM?
 INT_RETURN

	ENDASM?


; C:\PBP3\REENTERPBP-18.BAS	00244	OverReEnterH:

	LABEL?L	_OverReEnterH	

; C:\PBP3\REENTERPBP-18.BAS	00245	ENABLE DEBUG
	DENABLE?	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00137	ASM

	ASM?

INT_LIST  macro    ; IntSource,         Label,  Type, ResetFlag?
        INT_Handler    USB_INT,  _DoUSBService,   ASM,  yes

    endm
    INT_CREATE               ; Creates the interrupt processor


	ENDASM?


; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00144	usbinit ' initialise USB...
	USBINIT?	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00145	USBService                                    ' keep connection alive
	USBSERVICE?	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00146	UIE = $7F
	MOVE?CB	07Fh, UIE

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00147	UEIE = $9F
	MOVE?CB	09Fh, UEIE

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00149	@   INT_ENABLE  USB_INT

	ASM?
   INT_ENABLE  USB_INT

	ENDASM?


; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00150	goto ProgramStart
	GOTO?L	_ProgramStart

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00154	DoUSBService:    'Keeps USB alive

	LABEL?L	_DoUSBService	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00155	    usbservice
	USBSERVICE?	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00156	@   INT_RETURN

	ASM?
   INT_RETURN

	ENDASM?


; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00161	DoUSBIn:

	LABEL?L	_DoUSBIn	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00162	   USBBufferCount = USBBufferSizeRX              ' RX buffer size
	MOVE?CB	_USBBufferSizeRX, _USBBufferCount

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00163	   USBIn 1, USBBuffer, USBBufferCount, DoUSBIn   ' read data, if available
	USBIN?CBBL	001h, _USBBuffer, _USBBufferCount, _DoUSBIn

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00164	   return
	RETURN?	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00169	DoUSBOut:

	LABEL?L	_DoUSBOut	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00170	   USBBufferCount = USBBufferSizeTX              ' TX buffer size
	MOVE?CB	_USBBufferSizeTX, _USBBufferCount

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00171	   USBOut 1, USBBuffer, USBBufferCount, DoUSBOut ' if bus available, transmit data
	USBOUT?CBBL	001h, _USBBuffer, _USBBufferCount, _DoUSBOut

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00172	   return
	RETURN?	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00180	Keyscan:

	LABEL?L	_Keyscan	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00181		Debounce=1				' Setup the initial value for Debounce
	MOVE?CT	001h, _Debounce

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00182		Key=0					' Clear the variable KEY, prior to scanning
	MOVE?CB	000h, _Key

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00183	    Portb=%11111110				' Pull the fourth row line LOW
	MOVE?CB	0FEh, PORTB

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00184		Gosub Scancol				' Scan the columns
	GOSUB?L	_Scancol

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00185		If K_Flag=1 then goto Map		' If a key is pressed then map it 
	CMPNE?TCL	_K_Flag, 001h, L00006
	GOTO?L	_Map
	LABEL?L	L00006	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00186		key=10
	MOVE?CB	00Ah, _Key

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00187	    Portb=%11111101				' Pull the third row line LOW
	MOVE?CB	0FDh, PORTB

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00188		Gosub Scancol				' Scan the columns
	GOSUB?L	_Scancol

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00189		If K_Flag=1 then goto Map		' If a key is pressed then map it 
	CMPNE?TCL	_K_Flag, 001h, L00008
	GOTO?L	_Map
	LABEL?L	L00008	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00190		key=20
	MOVE?CB	014h, _Key

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00191	    Portb=%11111011				' Pull the second row line LOW
	MOVE?CB	0FBh, PORTB

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00192		Gosub Scancol				' Scan the columns
	GOSUB?L	_Scancol

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00193		If K_Flag=1 then goto Map		' If a key is pressed then map it 
	CMPNE?TCL	_K_Flag, 001h, L00010
	GOTO?L	_Map
	LABEL?L	L00010	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00194		key=30
	MOVE?CB	01Eh, _Key

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00195	    Portb=%11110111				' Pull the first row line LOW
	MOVE?CB	0F7h, PORTB

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00196		Gosub Scancol				' Scan the columns
	GOSUB?L	_Scancol

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00197		If K_Flag=1 then goto Map		' If a key is pressed then map it 
	CMPNE?TCL	_K_Flag, 001h, L00012
	GOTO?L	_Map
	LABEL?L	L00012	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00198		key=40
	MOVE?CB	028h, _Key

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00199	    Portb=%11101111				' Pull the fourth row line LOW
	MOVE?CB	0EFh, PORTB

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00200		Gosub Scancol				' Scan the columns
	GOSUB?L	_Scancol

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00201		If K_Flag=1 then goto Map		' If a key is pressed then map it 
	CMPNE?TCL	_K_Flag, 001h, L00014
	GOTO?L	_Map
	LABEL?L	L00014	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00202		key=50
	MOVE?CB	032h, _Key

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00203	    Portb=%11011111				' Pull the third row line LOW
	MOVE?CB	0DFh, PORTB

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00204		Gosub Scancol				' Scan the columns
	GOSUB?L	_Scancol

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00205		If K_Flag=1 then goto Map		' If a key is pressed then map it 
	CMPNE?TCL	_K_Flag, 001h, L00016
	GOTO?L	_Map
	LABEL?L	L00016	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00206		key=60
	MOVE?CB	03Ch, _Key

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00207	    Portb=%10111111				' Pull the second row line LOW
	MOVE?CB	0BFh, PORTB

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00208		Gosub Scancol				' Scan the columns
	GOSUB?L	_Scancol

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00209		If K_Flag=1 then goto Map		' If a key is pressed then map it 
	CMPNE?TCL	_K_Flag, 001h, L00018
	GOTO?L	_Map
	LABEL?L	L00018	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00210		key=70
	MOVE?CB	046h, _Key

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00211	    Portb=%01111111				' Pull the first row line LOW
	MOVE?CB	07Fh, PORTB

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00212		Gosub Scancol				' Scan the columns
	GOSUB?L	_Scancol

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00213		If K_Flag=1 then goto Map		' If a key is pressed then map it 
	CMPNE?TCL	_K_Flag, 001h, L00020
	GOTO?L	_Map
	LABEL?L	L00020	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00214		Portb=%11111111	
	MOVE?CB	0FFh, PORTB

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00224	    If K_Flag=1 then goto Map		' If a key is pressed then m
	CMPNE?TCL	_K_Flag, 001h, L00022
	GOTO?L	_Map
	LABEL?L	L00022	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00227	    D_Flag=0				' No key pressed, so Reset debounce flag
	MOVE?CT	000h, _D_Flag

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00228		Debounce=0 			        ' No key pressed, so Reset key Debounce flag
	MOVE?CT	000h, _Debounce

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00229		Goto Exit1				' Exit from the subroutine
	GOTO?L	_Exit1

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00231	Map:	portb.0 = 0

	LABEL?L	_Map	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00231	Map:	portb.0 = 0
	MOVE?CT	000h, _PORTB??0

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00238	        If D_Flag=1 then exit1 		' Already responded to this press, so exit
	CMPEQ?TCL	_D_Flag, 001h, _Exit1

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00239		  D_Flag=1				' Set Debounce flag
	MOVE?CT	001h, _D_Flag

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00240		  Debounce=0 				' Reset key Debounce flag
	MOVE?CT	000h, _Debounce

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00243	 Exit1:	Lookup Key,[39,76,56,58,64,87,29,42,55,46,_               '0-9

	LABEL?L	_Exit1	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00252	                    0,0,0,0,0,0,0,0,0,0],Keyout       '90-99 Map of the keypad legends
	LOOKUP?BCLB	_Key, 064h, L00001, _keyout
	LURET?C	027h
	LURET?C	04Ch
	LURET?C	038h
	LURET?C	03Ah
	LURET?C	040h
	LURET?C	057h
	LURET?C	01Dh
	LURET?C	02Ah
	LURET?C	037h
	LURET?C	02Eh
	LURET?C	04Ah
	LURET?C	000h
	LURET?C	02Fh
	LURET?C	000h
	LURET?C	000h
	LURET?C	052h
	LURET?C	000h
	LURET?C	034h
	LURET?C	049h
	LURET?C	02Bh
	LURET?C	025h
	LURET?C	01Bh
	LURET?C	01Ah
	LURET?C	03Bh
	LURET?C	041h
	LURET?C	026h
	LURET?C	018h
	LURET?C	01Ch
	LURET?C	024h
	LURET?C	019h
	LURET?C	030h
	LURET?C	000h
	LURET?C	033h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	05Eh
	LURET?C	000h
	LURET?C	02Ch
	LURET?C	05Ch
	LURET?C	04Eh
	LURET?C	00Ch
	LURET?C	00Bh
	LURET?C	03Eh
	LURET?C	044h
	LURET?C	000h
	LURET?C	009h
	LURET?C	00Dh
	LURET?C	04Bh
	LURET?C	00Ah
	LURET?C	036h
	LURET?C	007h
	LURET?C	006h
	LURET?C	03Fh
	LURET?C	045h
	LURET?C	000h
	LURET?C	004h
	LURET?C	008h
	LURET?C	02Dh
	LURET?C	005h
	LURET?C	01Fh
	LURET?C	011h
	LURET?C	010h
	LURET?C	03Dh
	LURET?C	043h
	LURET?C	020h
	LURET?C	00Eh
	LURET?C	012h
	LURET?C	01Eh
	LURET?C	00Fh
	LURET?C	022h
	LURET?C	016h
	LURET?C	015h
	LURET?C	03Ch
	LURET?C	042h
	LURET?C	023h
	LURET?C	013h
	LURET?C	017h
	LURET?C	021h
	LURET?C	014h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h

	LABEL?L	L00001	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00255	    Return					' Exit from the subroutine
	RETURN?	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00260	Scancol:

	LABEL?L	_Scancol	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00261		K_Flag=1				' Set K_Flag initially to 1
	MOVE?CT	001h, _K_Flag

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00262		If Portd.0=0 then S_Exit		' Return if a key on the first column is pressed
	CMPEQ?TCL	_PORTD??0, 000h, _S_Exit

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00263		Key=Key+1				' Else increment KEY, and try another row
	ADD?BCB	_Key, 001h, _Key

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00264		If Portd.1=0 then S_Exit		' Return if a key on the second column is pressed
	CMPEQ?TCL	_PORTD??1, 000h, _S_Exit

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00265		Key=Key+1				' Else increment KEY, and try another row
	ADD?BCB	_Key, 001h, _Key

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00266		If Portd.2=0 then S_Exit		' Return if a key on the third column is pressed
	CMPEQ?TCL	_PORTD??2, 000h, _S_Exit

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00267		Key=Key+1				' Else increment KEY, and try another row
	ADD?BCB	_Key, 001h, _Key

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00268		If Portd.3=0 then S_Exit		' Return if a key on the fourth column is pressed
	CMPEQ?TCL	_PORTD??3, 000h, _S_Exit

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00269		Key=Key+1				' Else increment KEY, KEY now equals 16
	ADD?BCB	_Key, 001h, _Key

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00271		If Portd.4=0 then S_Exit		' Return if a key on the first column is pressed
	CMPEQ?TCL	_PORTD??4, 000h, _S_Exit

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00272		Key=Key+1				' Else increment KEY, and try another row
	ADD?BCB	_Key, 001h, _Key

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00273		If Portd.5=0 then S_Exit		' Return if a key on the second column is pressed
	CMPEQ?TCL	_PORTD??5, 000h, _S_Exit

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00274		Key=Key+1				' Else increment KEY, and try another row
	ADD?BCB	_Key, 001h, _Key

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00275		If Portd.6=0 then S_Exit		' Return if a key on the third column is pressed
	CMPEQ?TCL	_PORTD??6, 000h, _S_Exit

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00276		Key=Key+1				' Else increment KEY, and try another row
	ADD?BCB	_Key, 001h, _Key

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00277		If Portd.7=0 then S_Exit		' Return if a key on the fourth column is pressed
	CMPEQ?TCL	_PORTD??7, 000h, _S_Exit

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00278		Key=Key+1				' Else increment KEY, KEY now equals 16
	ADD?BCB	_Key, 001h, _Key

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00279		If Porte.0=0 then S_Exit		' Return if a key on the third column is pressed
	CMPEQ?TCL	_PORTE??0, 000h, _S_Exit

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00280		Key=Key+1				' Else increment KEY, and try another row
	ADD?BCB	_Key, 001h, _Key

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00281		If Porte.1=0 then S_Exit		' Return if a key on the fourth column is pressed
	CMPEQ?TCL	_PORTE??1, 000h, _S_Exit

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00282		Key=Key+1				' Else increment KEY, KEY now equals 16	
	ADD?BCB	_Key, 001h, _Key

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00285	    K_Flag=0				' Set the K_Flag to indicate no key pressed
	MOVE?CT	000h, _K_Flag

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00289	S_Exit:	Return					' And exit the subroutine

	LABEL?L	_S_Exit	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00289	S_Exit:	Return					' And exit the subroutine
	RETURN?	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00292	Make:

	LABEL?L	_Make	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00293	usbbuffer(0)= ModKey
	MOVE?BB	_ModKey, _USBBuffer

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00294	usbbuffer(1)= 0
	MOVE?CB	000h, _USBBuffer + 00001h

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00295	usbbuffer(2)= pKey
	MOVE?BB	_pKey, _USBBuffer + 00002h

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00296	gosub Dousbout
	GOSUB?L	_DoUSBOut

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00297	modkey = 0
	MOVE?CB	000h, _ModKey

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00298	key = 0                                                             
	MOVE?CB	000h, _Key

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00301	usbbuffer(0)= 0     'Clear buffer to stop multible key outputs
	MOVE?CB	000h, _USBBuffer

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00302	usbbuffer(1)= 0
	MOVE?CB	000h, _USBBuffer + 00001h

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00303	usbbuffer(2)= 0
	MOVE?CB	000h, _USBBuffer + 00002h

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00305	gosub Dousbout
	GOSUB?L	_DoUSBOut

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00306	return
	RETURN?	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00314	ProgramStart: 

	LABEL?L	_ProgramStart	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00315	Again:	gosub Keyscan			  ' Go and scan the keypad

	LABEL?L	_Again	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00315	Again:	gosub Keyscan			  ' Go and scan the keypad
	GOSUB?L	_Keyscan

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00316		If K_Flag = 0 then	  ' If no key is pressed then do the following: -
	CMPNE?TCL	_K_Flag, 000h, L00024

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00318		Goto Again			  ' And look again when woken up.
	GOTO?L	_Again

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00319		Endif
	LABEL?L	L00024	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00322	        Pause 200			  ' Delay for 50ms after strobe pin is set HIGH
	PAUSE?C	0C8h

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00326	        if keyold != key then
	CMPEQ?BBL	_keyold, _Key, L00026

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00327	        pKey = Keyout	  	  ' Transmit the KEY byte
	MOVE?BB	_keyout, _pKey

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00328	  	    gosub Make
	GOSUB?L	_Make

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00329	        endif
	LABEL?L	L00026	

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00330	        keyold = keyout
	MOVE?BB	_keyout, _keyold

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00332		Goto again			  ' Do it all again!
	GOTO?L	_Again

; C:\PBP3\USB18\CDU_KEYBOARD\PICBASICPRO\CDU_KEYBOARD.PBP	00333	   goto ProgramStart  
	GOTO?L	_ProgramStart

	END
