'****************************************************************
'*  Name    : Neo_PIC_xelType12.bas                              *
'*  Author  : Original Idea From :Michel Jasmin					*
'*  Notice  : NO Copyright (c) 2014 Michel Jasmin  ;)           *
'*          : No Rights Reserved                                *
'*			: Major rewrite by: David Purola (N8NTA)			*
'*			: Please incorporate this header if reusing			*
'*  Date    : 2014-12-05                                        *
'*  Version : 2.0                                               *
'*  Notes   : Demo how to use WS2812B (NeoPixels) on            *
'*          :a PIC18F26K22 @64 MHz DUE TO AVAILABILITY OF MORE	*
'*			:RAM FOR PIXEL DATA and FRILLS.						*
'****************************************************************
'	WRITTEN FOR USE W/18F26K22 E/P @ 64 Mhz.
'	FIRST PASS TEST OF STRING MANIPULATION.(12/06/2014)
'   ADDED UART CAPABILITY FOR SERIAL ENTRY OF STRING DATA AS WELL AS
'SOME OPTION CODES.(12/06/2014)
'	ADDED NEW CONTROL KEYS TO SET COLOR OF FORGROUND and BACKGROUND
'PIXELS.
'	ADDED STORAGE CAPABILITY FOR 10 MESSAGES AND COLOR SCHEMES.(12/06/2014)
'	TESTED COMM USING HC-03 BLUE TOOTH MODULE FOR DATA ENTRY WITH ALL
'GOING WELL. NO BUGS FOUND EXCEPT THAT THERE ARE NOT TO MANY TERMINAL
'PROGRAMS or APP'S WRITTEN FOR PHONES or TABLETS THAT HAVE THE "Ctrl" KEY
'AVAILABLE TO THE USER. IT IS KIND OF SAD TO THINK IN THIS DAY AND AGE
'THAT THIS IS OUR FUTURE MOVING FORWARD?(12/08/2014)
'	ADDED GAMMA CORRECTION LOOKUP TABLE TO CODE.(12/08/2014)
'	VERIFIED OPERATION TO 1008 PIXELS MAX. DUE TO RAM AVAILABILITY, REWROTE THE
'ASM32 ROUTINE TO NOW BE ASM64 FOR OPERATION @64Mhz. ALSO MADE NEOPIN A
'VARIABLE TO BE CHANGED IN MAIN CODE ONLY INSTEAD OF HARDCODING IT
'IN THE ASM ROUTINE. ADDED AN A/D ROUTINE ALLOW ONE TO TRYOUT DIFFERENT COLORS
'FOR THE BACKGROUND AND FORGROUND TEXT (DEVELOPMENT). ALSO ADDED (Ctrl D)
'COMMAND TO SET SCROLL DELAY FOR TEXT.(12/10/2014)
'	OPTIMIZED SOME OF THE LOOPS TO ELIMINATE USING COMPARE STATEMENTS FOR
'TIMING REASONS, THIS IS ESPECIALLY TRUE WHEN COMPARE IS USED ON WORD SIZED
'VARIABLES. THIS ELIMINATED OVER 1uS. BETWEEN PIXELS (EACH 24 BITS) DURING DUMP
' AND 300uS DURING PROGRAM LOOP, (INTERESTING).(12/11/2014)
'	ADDED ALL COLOR TEST MODE TO THE MIX (Ctrl O).(12/11/2014)
'   ADDED ANOTHER TEST PATTERN TO (Ctrl O).(12/12/2014)
'	ADDED SECOND COMM PORT TO FACILITATE BLUE TOOTH COMM WHILE BEING
'CONNECTED TO COMM 1 FOR BOOTLOADER OPERATION.(12/12/2014)
'	ADDED TOGGLE LOOPING MESSAGE COMMAND (Ctrl L)
'	ADDED ANOTHER TEST MODE TO (Ctrl O).(12/16/2014)
'
'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
'			OH WELL IT'S TIME FOR SOME DOCUMENTATION I SUPPOSE:
'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
'	Well the jist of this code is to make something similar to a project I saw
'using a duino for the controller. This guy made a hat with a scrolling display
'using some of the Adafruit NeoPixel strips. Well me not being an expert at the
'C language unless I'm at work, I decided to try my hand designing a similar
'project with the exception of using a PIC for the controller. I could not find
'a low pin count device with at least 2K of ram so, I ended up using an 18F26K22.
'	When I originally saw the project on the pic forum that someone used an 12F683
'I reproduced the project. I was somewhat disapointed that the software encoding
'for the bit stream was not dynamic in nature. That meant that if you wanted to
'change a message you would have to hardcode that into program memory and re-compile.
'	That got me inspired, so I decided to use an 12F1840 running @ 32Mhz. and develope
'am assembly routine to dynamicly encode the bit stream from a buffered message
'on demand. Well I was successful in getting the encoder asm. code to work
'as well as the duino code available on the web. Now I needed to add some frills
'but the small 8 pin processor was running a bit low on resources so, here I am
'with an 18F26K22 processor with a BUTT LOAD of extra pins and enough ram as the
'code stands today to support 24 6x7 characters. I only need 3 pins, 1 for the
'NeoPixels, and 2 for the communications. I opted to use the internal oscillator
'to eliminate the external xtal for parts count. The communication port is
'connected to an JY-MCU Blue Tooth Module HC-03 for data entry and retrieval.
'	That way I can program new messages with anything that has a blue tooth
'connection like a smart phone or tablet or PC. I have been working non stop
'on this project for the last 2 days and it's time for a data dump before I forget.
'	The software is working flawlessly at this point and all looks good on the
'scope as that is all I have to hook up to it at the moment. I have a reel of
'NeoPixels on the way but won't be here till Tuesday 12/09. So on with the
'documentation......

'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
'						SERIAL COMMAND SUMMARY
'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
'
'-	UPTO 3 DIGITS FOLLOWED BY (Ctrl B) CR = 3 DIGIT NUMBER REPRESENTING BACKGROUND
'BLUE INTENSITY 0-255 THEN (Ctrl B) FOLLOWED BY CARRAGE RETURN. (FORGROUND/BACKGROUND
'SELECTION DEFAULTS TO FORGROUNG AFTER ENTRY)

'-	UPTO 3 DIGITS FOLLOWED BY (Ctrl G) CR = 3 DIGIT NUMBER REPRESENTING BACKGROUND
'GREEN INTENSITY 0-255 THEN (Ctrl G) FOLLOWED BY CARRAGE RETURN. (FORGROUND/BACKGROUND
'SELECTION DEFAULTS TO FORGROUNG AFTER ENTRY)

'-	UPTO 3 DIGITS FOLLOWED BY (Ctrl R) CR = 3 DIGIT NUMBER REPRESENTING BACKGROUND
'RED INTENSITY 0-255 THEN (Ctrl R) FOLLOWED BY CARRAGE RETURN. (FORGROUND/BACKGROUND
'SELECTION DEFAULTS TO FORGROUNG AFTER ENTRY)

'-	(Ctrl A) TOGGLES A/D ENTRY OF COLORS GREEN, BLUE, and RED BY READING POT VALUES
'FROM AN0,AN1,AN2 RESPECTIVLY.

'-	UPTO 4 DIGITS FOLLOWED BY (Ctrl D) CR = 4 DIGIT NUMBER REPRESENTING SCROLLING
'DELAY IN Milliseconds WITH A MAXIMUM OF 1000 (1 SECOND) AND A MINIMUM OF 1. THIS
'VALUE IS STORED ONCE FOR EACH MODE OF OPERATION AND RECALLED DEPENDING ON MODE.

'-	(Ctrl E) PRECEEDING ANY OF THE ABOVE COMMANDS SETS THE BACKGROUND COLORS (PIXELS
'ILLUMINATED). IF THIS COMMAND IS LEFT OUT OF COLOR SELECTION PROCESS, DEFAULT IS FORGROUND.

'-	(Ctrl F) PRECEEDING ANY OF THE ABOVE COMMANDS SETS THE FORGROUND COLORS (PIXELS
'ILLUMINATED). IF THIS COMMAND IS LEFT OUT OF COLOR SELECTION PROCESS, DEFAULT IS FORGROUND.

'-	(Ctrl T) IS THE START OF TEXT STRING COMMAND.

'-	(Ctrl X) IS THE END OF TEXT STRING COMMAND.
'THE USAGE WOULD LOOK LIKE: (Ctrl T) THEN A STRING OF UPTO 39 CHARACTERS or NUMBERS
'FOLLOWED BY (Ctrl X) THEN CARRAGE RETURN

'-	(Ctrl Z) CR = READBACK OF CURRENTLY DISPLAYED TEXT MESSAGE.

'-	1 DIGIT (Ctrl W) CR = WRITING CURRENTLY DISPLAYED TEXT STRING TO MEMORY LOCATION
'PRESEEDING THE (Ctrl W) COMMAND. LOCATIONS ARE 0 THRU 9 DECIMAL. (COLORS ARE ALSO STORED)

'-	1 DIGIT (Ctrl S) CR = RETRIEVING TEXT STRING FROM THE MEMORY LOCATION PRESEEDING
'THE (Ctrl S) COMMAND. LOCATIONS ARE 0 THRU 9 DECIMAL. (COLORS ARE ALSO RETRIEVED)

'-	(Ctrl Q) CR = RECALL OF CURRENT FORGROUND GREEN, BLUE, RED INTENSITY VALUES ON ONE LINE
'FOLLOWED BY BACKGROUND GREEN, BLUE, RED INTENSITY VALUES ON ONE LINE.
'
'-	(Ctrl L) CR = TOGGLE LOOPING OF ALL STORED MESSDAGES 0-9.
'
'-	(Ctrl O) CR = TOGGLE ALL COLOR TEST and OPERATION MODEs FOR ENTIRE STRIP.
'DEFAULT POWER-ON MODE IS 0.
'
'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
'						AND NOW ON WITH THE CODE......
'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

DEFINE OSC 64
DEFINE NO_CLRWDT 1
DEFINE LOADER_USED 1	    
DEFINE WRITE_INT 1

DEFINE DEBUG_REG PORTC
DEFINE DEBUG_BIT 0
DEFINE DEBUG_BAUD 38400
DEFINE DEBUG_MODE 0	'0 = TRUE 1 = INVERTED

'DEFINE DEBUGIN_REG PORTC
'DEFINE DEBUGIN_BIT 1
'DEFINE DEBUGIN_BAUD 38400
'DEFINE DEBUGIN_MODE 0	'0 = TRUE 1 = INVERTED


INCLUDE "C:\PBP\INCLUDES\DT_INTS-18.bas"      	' Interrupt Control routines	
INCLUDE "C:\PBP\INCLUDES\ReEnterPBP-18.bas"     ' Interrupt Control routines	

#CONFIG
;----- CONFIG1H Options --------------------------------------------------
  __config _CONFIG1H, _FOSC_INTIO7_1H & _PLLCFG_ON_1H & _PRICLKEN_ON_1H & _FCMEN_ON_1H & _IESO_OFF_1H
;----- CONFIG2L Options --------------------------------------------------
  __config _CONFIG2L, _PWRTEN_ON_2L & _BOREN_ON_2L & _BORV_190_2L
;----- CONFIG2H Options --------------------------------------------------
  __config _CONFIG2H, _WDTEN_OFF_2H & _WDTPS_32768_2H
;----- CONFIG3H Options --------------------------------------------------
  __config _CONFIG3H, _CCP2MX_PORTB3_3H & _PBADEN_OFF_3H & _HFOFST_OFF_3H & _T3CMX_PORTB5_3H & _MCLRE_EXTMCLR_3H
;----- CONFIG4L Options --------------------------------------------------
  __config _CONFIG4L, _STVREN_ON_4L & _LVP_OFF_4L & _XINST_OFF_4L & _DEBUG_OFF_4L
#ENDCONFIG

' ********************************************************************
'				Declare Port Variables
' ********************************************************************
ANALOG_0	VAR	PORTA.0	'1-GREEN COLOR ADJUSTMENT POT (DEVELOPMENT ONLY)
ANALOG_1	VAR	PORTA.1	'1-BLUE COLOR ADJUSTMENT POT (DEVELOPMENT ONLY)
ANALOG_2	VAR	PORTA.2	'1-RED COLOR ADJUSTMENT POT (DEVELOPMENT ONLY)
NEOPIN	    VAR	LATA.3	'0-OUTPUT TO NEO_PIXEL STRIP                      `	
TESTPIN		VAR	LATA.4	'0-OUTPUT TO TEST CODE WITH (DEVELOPMENT ONLY)
TX2_232		VAR	PORTB.6	'0-OUTPUT COMMUNICATIONS PORT PIN RS-232 (BLUE TOOTH)
RX2_232		VAR	PORTB.7	'1-INPUT COMMUNICATIONS PORT PIN RS-232 (BLUE TOOTH)
TX1_232		VAR	PORTC.6	'0-OUTPUT COMMUNICATIONS PORT PIN RS-232 (USB)
RX1_232		VAR	PORTC.7	'1-INPUT COMMUNICATIONS PORT PIN RS-232 (USB)

'------------ Const -------------------------

BAUD		CON	416		'TX/RX BAUD RATE (32000000/4/38400) - 1 HIGH BAUD/16 BIT
INSIZE		CON	63		'INPUT ARRAY SIZE FOR COMMUNICATIONS
OUTSIZE		CON	15		'OUTPUT ARRAY SIZE FOR COMMUNICATIONS
RXTIMEOUT	CON	1000	'TIMEOUT FOR DATA COMMUNICATIONS (BUFFER CLEAR, 10s. BETWEEN CHARACTERS)
ONESIXTH	CON	OUTSIZE / 6	'BUFFER EMPTY POINT
FIVESIXTH	CON	ONESIXTH * 5	'BUFFER FULL POINT
TIMESEG     CON 39536   '65536 - INT(.01 / ((1/20000000) * 4 * 2)) 10.0Ms. - 1000 COUNTS

'||||||||||||||||| THIS YEILDS ~6, 6 x 7 CHARACTERS |||||||||||||||||||||||||||||
FULLSTRING	CON	240	'TOTAL NUMBER OF PIXELS IN ATTACHED STRING (4 METER REEL UNCUT)
MATRIXNUM	CON	238	'TOTAL NUMBER OF PIXELS IN CONFIGURED MATRIX (5.66 CHARACTERS)
COL_P_CHR	CON	6	'COLLUMS PER CHARACTER
ROW_P_CHR	CON	7	'ROWS PER CHARACTER
PIX_P_ROW	CON	MATRIXNUM / ROW_P_CHR		'PIXELS PER HORIZONTAL ROW
COLORMAX 	CON 63	'INTENSITY TO REDUCE POWER (ON BATTERIES)
'|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

COLORSIZE	CON	6		'TOTAL NUMBER OF COLOR STORAGE CELLS
BUFSIZE		CON	40		'MAXUMUM INPUT MESSAGE LENGTH
MAXMESS		CON	10		'TOTAL NUMBER OF STORED MESSAGES
TOTALTEXT	CON	MAXMESS * BUFSIZE

E_DELAY		CON 0		'STARTING LOCATION OF SCROLLING DELAY VARIABLE
INTRO		CON	10		'STARTING LOCATION FOR SPLASH SCREEN TEXT
E_TEXT		CON	100		'STARTING LOCATION FOR TEXT MESSAGE STORAGE
E_COLORS	CON	E_TEXT + TOTALTEXT	'STARTING LOCATION FOR MESSAGE COLOR STORAGE
DATA	@INTRO,"Neo_PIC_xelType12.BAS(12/16/2014)",0	'FIRST 100 BYTES OF EEPROM

'------------------- ALIASES ----------------------
ON_			CON	1
OFF_		CON	0
UP			CON	1
DOWN		CON	0

'*********************** USART # 1 *********************************
TX_BYTES2   VAR BYTE(OUTSIZE + 1)   'DATA TO HSEROUT TRANSMITIONS
TX_INPUT2   VAR BYTE BANK0	'TRANSMIT CHARACTER POINTER (INTERRUPT)
TX_OUTPUT2  VAR BYTE BANK0	'TRANSMIT CHARACTER POINTER (MAINCODE)
TX_DAVAIL2  VAR BYTE BANK0	'TRANSMITTER DATA AVAILABLE

RX_BYTES2   VAR BYTE(INSIZE + 1)	'DATA FROM HSERIN TRANSMITIONS
RX_OUTPUT2  VAR BYTE BANK0 	'RECEIVED CHARACTER POINTER (INTERRUPT)
RX_INPUT2   VAR BYTE BANK0    'RECEIVED CHARACTER POINTER (MAINCODE)
RX_DAVAIL2  VAR BYTE BANK0    'RECEIVER DATA AVAILABLE
JUNKRX2     VAR BYTE BANK0    'SCRATCH VARIABLE FOR RECEIVER
RXTIMER2    VAR WORD BANK0    'RECEIVED MESSAGE TIMER

'------------ Variables -------------------------
BITSWORD	VAR	WORD BANK0	'BITS FOR STORAGE
TX_EMPTY2   VAR BITSWORD.0	'TRANSMIT BUFFER EMPTY FLAG
RX_BUFFULL2 VAR BITSWORD.1  'RECEIVER BUFFER FULL FLAG
RX_MESSAGE2	VAR BITSWORD.2	'MESSAGE RECEIVED FLAG
COWS_HOME	VAR BITSWORD.3	'LOOP FLAG
TX2PAR		VAR	BITSWORD.4	'PARITY ENABLE FLAG
PARITYTYPE2	VAR BITSWORD.5	'PARITY TYPE (1=ODD/0=EVEN)
CLEARINPT	VAR BITSWORD.6	'INPUT FLAG
TXTENAB		VAR BITSWORD.7	'INPUT BUFFER ENABLE FLAG
FOR_BAK		VAR BITSWORD.8	'FORGROUND/BACKGROUND COLOR DESTINATION FLAG
LZB			VAR BITSWORD.9	'LEADING ZERO BLANKING FLAG
ADENABLE	VAR BITSWORD.10	'A/D ENABLE FLAG
DIR			VAR BITSWORD.11	'PIXEL TEST DIRECTION FLAG
FIRSTPASS   VAR BITSWORD.12	'1 TIME LOAD FLAG
ROTATEMESS	VAR BITSWORD.13	'ROTATE MESSAGE FLAG

LOOPCNTR	VAR	WORD BANK0	'LOOP TIMER WORD DELAY ROUTINE
ININDEX		VAR	BYTE	'INPUT BUFFER POINTER
INBUF		VAR	BYTE(BUFSIZE)'INPUT CHARACTER BUFFER
INCHAR		VAR	BYTE	'WORKING INPUT CHARACTER
JUNK	    VAR	BYTE	'SCRATCH VARIABLE
JUNK1	    VAR	BYTE	'SCRATCH VARIABLE
SCRATCH	    VAR	WORD	'SCRATCH VARIABLE
DIGITS		VAR	BYTE	'DIGITS TO SEND SERIALLY
TARGETEMP	VAR	WORD	'SERIAL NUMERIC ACCUMULATOR
VOLTS		VAR	WORD[3]	'A/D RESULT ARRAY
CHANNEL		VAR	BYTE	'A/D CHANNEL BEING SELECTED

NEO_NUM     VAR WORD	'TOTAL Number of pixels (1008 W/AVAILABLE MEMORY FOR 24 CHARACTERS, TESTED!)
NeoPixel    VAR WORD BANK0	'Looping variable
NeoPixValue VAR BYTE BANK0	'Value to be bit-banged
NeoGreen    VAR BYTE[FULLSTRING]	'Green intensity array
NeoBlue     VAR BYTE[FULLSTRING]	'Blue intensity array
NeoRed      VAR BYTE[FULLSTRING]	'Red intensity array
FOR_GREEN	VAR	BYTE		'FORGROUND GREEN INTENSITY
FOR_BLUE	VAR	BYTE		'FORGROUND BLUE INTENSITY
FOR_RED		VAR	BYTE		'FORGROUND RED INTENSITY
BAK_GREEN	VAR	BYTE		'BACKGROUND GREEN INTENSITY
BAK_BLUE	VAR	BYTE		'BACKGROUND BLUE INTENSITY
BAK_RED		VAR	BYTE		'BACKGROUND RED INTENSITY
GAMMAIN		VAR	BYTE		'INTENSITY VALUE TO BE LOOKED UP FROM GAMMA CORRECTION TABLE
GAMMAOUT	VAR	BYTE		'INTENSITY VALUE FROM GAMMA CORRECTION TABLE

ROW_DAT		VAR	BYTE[7]		'CHARACTER PIXEL ARRAY FOR 5 X 7 DOT MATRIX
CHARACTER	VAR	BYTE		'ASCII CHARACTER REPRESENTATION
CHARCNTR	VAR	BYTE		'CHARACTER TABLE POINTER
POINTER		VAR	WORD BANK0		'POINTER USED FOR PIXEL BUFFER
DOT			VAR	BYTE		'HORIZONTAL PIXEL POINTER
ROW			VAR	BYTE		'CHARACTER ROW POINTER

INTENSITY	VAR	BYTE		'NEOPIXEL INTENSITY LEVEL
COLOR		VAR	BYTE		'COLOR CYCLING POINTER
NEW_NeoGreen	VAR	BYTE	'new colors to be added to highest element in array
NEW_NeoBlue	VAR	BYTE
NEW_NeoRed	VAR	BYTE
oldGreen	VAR	BYTE	'recovered from location 0 of array before rotating
oldBlue		VAR	BYTE
oldRed		VAR	BYTE
TESTMODE	VAR BYTE	'test mode selector value
OLDTESTMODE	VAR BYTE	'test mode selector value HISTORY
DELAYTIME	VAR	WORD	'delay variable to be used for delay routine
MESSNUM		VAR BYTE	'MESSAGE NUMBER value

'-----------  Initialization -------------------------------
	clear
	LATA = %00000000    'PRESET PORT VALUES BEFORE ENABLING THEM AS OUTPUTS
	LATB = %11000000
	LATC = %11000000

	TRISA = %00000111	'INITIALIZE PORT DIRECTIONS
	TRISB = %10000000	'INITIALIZE PORT DIRECTIONS
	TRISC = %10000111	'INITIALIZE PORT DIRECTIONS

	PMD0 = %00111100	'ENABLE UART 2,1, AND TIMR 2,1
	PMD1 = %11111111	'DISABLE MSSP2,1, AND CCPM 5,4,3,2,CCP1
	PMD2 = %11111110	'DISABLE CTMUMD,CMP2,CMP1 AND NOT ADC

	ANSELA = %00000111	'PORTS A2,A1,A0 NOT DIGITAL
	ANSELB = %00000000	'PORTS B5,B4,B3,B2,B1,B0 DIGITAL BUFFERED	
	ANSELC = %00000000	'PORTS C7,C6,C5,C4,C3,C2 DIGITAL BUFFERED

	WPUB = %00000000	'WEAK PULLUP'S DISABLED
	IOCB = %00000000	'INTERRUPT ON CHANGE BIT'S DISABLED
	SLRCON = %00000000	'SLEW RATE CONTROL OFF FOR ALL PORTS
    SRCON0 = %00000000	'SR LATCH CONTROL

	OSCCON = %01110000	'ENTER SLEEP MODE ON SLEEP INSTRUCTION/ 16 MHZ
	OSCTUNE = %01000000	'ENABLE PLL FOR OSC.
   	INTCON2 = %10000000 'CLEAR ALL PULL-UPS,ALL FALLING EDGE, LOW PRIORITY
   	INTCON3.7 = 0		'INT2 TO LOW PRIORITY
   	INTCON3.6 = 0		'INT1 TO LOW PRIORITY
	RCON = %00000000	'ENABLE PRIORITY LEVELS
	IPR1 = %00000000	'ALL PRIORITYS TO LOW
	IPR2 = %00000000	'ALL PRIORITYS TO LOW
   	PIR1 = %00000000    'CLEAR ALL INTERRUPT FLAGS
  	PIR2 = %00000000    'CLEAR ALL INTERRUPT FLAGS

  	ADCON0 = %00000000  'GO/DONE,ADOFF
  	ADCON1 = %00000000  'TRIGGER CCP5,+VREF=VDD,-VREF=VSS, ANALOG
  	ADCON2 = %10000110	'RIGHT JUSTIFIED,0 TAD,FOSC/64

	CM1CON0 = %00000000	'COMPARATORS OFF
	CM2CON0 = %00000000	'COMPARATORS OFF
	CM2CON1 = %00000000	'COMPARATORS OFF

	VREFCON0 = %00000000	'COMPARATOR VOLT REF.OFF
	VREFCON1 = %00000000	'COMPARATOR VOLT REF.OFF
	VREFCON2 = %00000000	'COMPARATOR VOLT REF.OFF
	HLVDCON = %00001110		'LOW VOLT DETECT,OFF,4.5-4.77 VOLTS

	CTMUCONL = %00000000    'COUNTER/TIMER MODULE
	CTMUCONH = %00000000    'COUNTER/TIMER MODULE
	CTMUICON = %00000000	'COUNTER/TIMER MODULE

	T0CON = %00000000	'OFF,16 BIT,T0CS=CLKO,T0SE=0>1,BYPASS PSA,PS = 1:2
	T1GCON = %00000000	'TIMER1 GATE
	T1CON = %00010010	'INTERNAL OSC/4,PRESCALER 1/2,16 BIT R/W OPERATION,STOP TIMER 1
  	T2CON = %00000000	'POSTSCALER 1/1,START,PRESCALER 1/4
	T3GCON = %00000000  'TIMER3 GATE
	T3CON = %00000000	'INTERNAL OSC/4,PRESCALER 1/8,16 BIT R/W OPERATION,STOP TIMER 3
	T4CON = %00000000	'POSTSCALE 1:1,STOP TIMER 4,PRESCALER 1/1
	T5GCON = %00000000	'TIMER5 GATE
	T5CON = %00000000	'INTERNAL OSC/4,PRESCALER 1/8,16 BIT R/W OPERATION,STOP TIMER 5
	T6CON = %00000000	'POSTSCALE 1:1,STOP TIMER 6,PRESCALER 1/1

	CCPTMRS0= %00000000 'PWM TIMER CCP3,CCP2,CCP1 USE TIMER 2
	CCPTMRS1= %00000000	'PWM TIMER CCP5,CCP4 USE TIMER 2

	ECCP1AS= %00000000	'CCPX AUTO-SHUTDOWN CONTROL REGISTER 1
	ECCP2AS= %00000000	'CCPX AUTO-SHUTDOWN CONTROL REGISTER 2
	ECCP3AS= %00000000	'CCPX AUTO-SHUTDOWN CONTROL REGISTER 3

	PSTR1CON = %00000000	'DISABLE PWM OUTPUT
	PSTR2CON = %00000000	'PWM STEERING CONTROL REGISTER 2
	PSTR3CON = %00000000	'PWM STEERING CONTROL REGISTER 3

	PWM1CON = %00000000		'ENHANCED PWM CONTROL REGISTER 1
	PWM2CON = %00000000		'ENHANCED PWM CONTROL REGISTER 2
	PWM3CON = %00000000		'ENHANCED PWM CONTROL REGISTER 3
		
   	TMR2 = 0			'CLEAR TMR2 MODULE REGISTER
   	PR2 = 255			'SET PERIOD ((((1 / 20,000,000) * 4) * PRESCALE) * (1 + PR2))  = 1.22 KHz.
   	CCP1CON = %00000000	'PLACE CCP1 INTO DISABLE MODE
   	CCPR1L = $00		'CLEAR CCP1 LOWER 8 BITS
   	CCPR1H = $00		'CLEAR CCP1 UPPER 2 BITS

   	CCP2CON = %00000000	'PLACE CCP2 INTO DISABLE MODE
   	CCPR2L = $00		'CLEAR CCP2 LOWER 8 BITS
   	CCPR2H = $00		'CLEAR CCP2 UPPER 2 BITS

  	SSP1STAT = %00000000	'SAMPLE @ MID,TX FROM IDLE TO ACTIVE
  	SSP1CON1 = %00000000	'ENABLE SSP,IDLE STATE HIGH,MASTER FOSC/4

 	BAUDCON2	= %00001000	'SET FOR 16 BIT BAUDRATE
	SCRATCH = BAUD
	SPBRG2 = SCRATCH.LOWBYTE		'SET LOW BYTE OF BAUD GENERATOR
	SPBRGH2 = SCRATCH.HIGHBYTE	'SET HIGH BYTE OF BAUD GENERATOR
	RCSTA2 = %10010000   'ENABLE RECEIVER,CONTINUOUS
	TXSTA2 = %00100100   'ENABLE TRANSMIT,HIGH BAUD

	NeoPin = 0

INCLUDE "C:\PBP\NeoPixel\NeoPixelASM64.bas"

'*********************************************************************
asm
INT_LIST  macro    ; IntSource,       Label,  Type, ResetFlag?
		INT_Handler     TX2_INT,	_UARTTX2,	PBP,  no
		INT_Handler     RX2_INT,	_UARTRX2,	PBP,  no
	endm
	INT_CREATE               ; Creates the High Priority interrupt processor
ENDASM

@	INT_ENABLE  RX2_INT     ; Enable RX UART Interrupts

	GOTO Main
	
'*********************************************************************
UARTRX2:		'INTERRUPT SERVICE ROUTINE FOR UART RECEIVER
'*********************************************************************
	IF RCSTA2.1 = ON_ THEN	'IF OVERRUN BIT SET THEN
		RCSTA2.4 = OFF_	'CLEAR CREN
		RCSTA2.4 = ON_	'SET CREN
		RX_DAVAIL2 = 0   'TELL MAIN NO DATA IS AVAILABLE        
		RX_OUTPUT2 = 0	'RESET POINTER FOR MINIMUM ROLLOVER
		RX_INPUT2 = RX_OUTPUT2
		RXTIMER2 = 0		'CLEAR CHARACTER RECEIVED TIMER
	ENDIF
	WHILE PIR3.5 = ON_	'UNLOAD ANY RECEIVED CHARACTERS
		IF (RX_OUTPUT2 + 1) <> RX_INPUT2 THEN
			RX_BYTES2(RX_OUTPUT2) = RCREG2	'GET THE CHARACTER
			SELECT CASE RX_BYTES2(RX_OUTPUT2)
				CASE $0D,$0A	'CR or LF
					RX_MESSAGE2 = 1  'TELL MAIN DATA BUFFER HAS MESSAGE AVAILABLE
				CASE IS < $01		'NULL CONTROL CHARACTER
					GOTO DONERX2
				CASE IS > $7E		'CONTROL CHARACTERS
					GOTO DONERX2
				CASE ELSE
					RX_OUTPUT2 = RX_OUTPUT2 + 1	'INCREMENT BUFFER POINTER
					RX_OUTPUT2 = RX_OUTPUT2 & INSIZE
					RX_BUFFULL2 = OFF_  'CLEAR DATA BUFFER FULL
					RX_DAVAIL2 = RX_DAVAIL2 + 1   'TELL MAIN DATA IS AVAILABLE
			END SELECT
		ELSE
			RX_BUFFULL2 = ON_  'TELL MAIN DATA BUFFER IS FULL
			JUNKRX2 = RCREG2
		ENDIF
DONERX2:
	RXTIMER2 = 0		'CLEAR CHARACTER RECEIVED TIMER
	WEND
@	INT_RETURN

'*********************************************************************
UARTTX2:		'INTERRUPT SERVICE ROUTINE FOR UART TRANSMITTER
'*********************************************************************
	IF TX_INPUT2 <> TX_OUTPUT2 THEN   'DATA TO BE SENT
		TXREG2 = TX_BYTES2(TX_INPUT2)
		TX_INPUT2 = TX_INPUT2 + 1
		TX_INPUT2 = TX_INPUT2 & OUTSIZE
		TX_EMPTY2 = ON_  'TELL MAIN DATA TO BE SENT
		TX_DAVAIL2 = TX_DAVAIL2 - 1
	ELSE
		TX_EMPTY2 = 0'TELL MAIN ALL DATA IS SENT
		TX_DAVAIL2 = 0
@		INT_DISABLE  TX2_INT     ; Disable TX UART Interrupts
	ENDIF
@	INT_RETURN

'------------------------- SUBROUTINES -------------------------------
'*********************************************************************
CLRREC:     'CLEAR THE SERIAL PORT BUFFER
'*********************************************************************
    RX_OUTPUT2 = 0       'RESET POINTER FOR MINIMUM ROLLOVER
    RX_INPUT2 = RX_OUTPUT2
    RX_DAVAIL2 = 0
	RX_BUFFULL2 = 0  'CLEAR DATA BUFFER FULL
	RX_MESSAGE2 = 0  'TELL MAIN DATA BUFFER HAS MESSAGE
	TARGETEMP = 0
    RETURN

'*********************************************************************
DELAYSTAT:	'SEND SCROLL DELAY STATUS & CARRIAGE RETURN & LINE FEED
'*********************************************************************
	TX_BYTES2(TX_OUTPUT2) = "D"
	gosub SNDCHAR		'INCREMENT BUFFER POINTERS
	TX_BYTES2(TX_OUTPUT2) = "E"
	GOSUB SNDCHAR		'INCREMENT BUFFER POINTERS
	TX_BYTES2(TX_OUTPUT2) = "L"
	GOSUB SNDCHAR		'INCREMENT BUFFER POINTERS
	TX_BYTES2(TX_OUTPUT2) = "A"
	gosub SNDCHAR		'INCREMENT BUFFER POINTERS
	TX_BYTES2(TX_OUTPUT2) = "Y"
	GOSUB SNDCHAR		'INCREMENT BUFFER POINTERS
	GOSUB EQUALS
	SCRATCH = DELAYTIME
	GOSUB BUILDSTRINGLZB:	'BUILD ASCII STRING FROM NUMBER VARIABLE W/LZB
	GOTO CRLF		'CARRIAGE RETURN & LINE FEED
		
'*********************************************************************
ADSTATE:	'SEND A/D STATUS & CARRIAGE RETURN & LINE FEED
'*********************************************************************
	TX_BYTES2(TX_OUTPUT2) = "A"
	gosub SNDCHAR		'INCREMENT BUFFER POINTERS
	TX_BYTES2(TX_OUTPUT2) = "D"
	GOSUB SNDCHAR		'INCREMENT BUFFER POINTERS
	TX_BYTES2(TX_OUTPUT2) = "-"
	GOSUB SNDCHAR		'INCREMENT BUFFER POINTERS
	TX_BYTES2(TX_OUTPUT2) = "O"
	gosub SNDCHAR		'INCREMENT BUFFER POINTERS
	IF ADENABLE = 1 THEN	'IF COLOR'S ARE FROM ANALOG POTS
		TX_BYTES2(TX_OUTPUT2) = "N"
		GOSUB SNDCHAR		'INCREMENT BUFFER POINTERS
	ELSE
		TX_BYTES2(TX_OUTPUT2) = "F"
		GOSUB SNDCHAR		'INCREMENT BUFFER POINTERS
		TX_BYTES2(TX_OUTPUT2) = "F"
		gosub SNDCHAR		'INCREMENT BUFFER POINTERS
	ENDIF
	GOTO CRLF		'CARRIAGE RETURN & LINE FEED
		
'*********************************************************************
FORGROUND:		'SEND FORGROUND & CARRIAGE RETURN & LINE FEED
'*********************************************************************
	TX_BYTES2(TX_OUTPUT2) = " "
	gosub SNDCHAR		'INCREMENT BUFFER POINTERS
	TX_BYTES2(TX_OUTPUT2) = "F"
	gosub SNDCHAR		'INCREMENT BUFFER POINTERS
	TX_BYTES2(TX_OUTPUT2) = "O"
	gosub SNDCHAR		'INCREMENT BUFFER POINTERS
	TX_BYTES2(TX_OUTPUT2) = "R"
	GOSUB SNDCHAR		'INCREMENT BUFFER POINTERS
	TX_BYTES2(TX_OUTPUT2) = "G"
	GOSUB SNDCHAR		'INCREMENT BUFFER POINTERS
	GOTO CRLF		'CARRIAGE RETURN & LINE FEED
	
'*********************************************************************
BACKGROUND:		'SEND BACKGROUND & CARRIAGE RETURN & LINE FEED
'*********************************************************************
	TX_BYTES2(TX_OUTPUT2) = " "
	gosub SNDCHAR		'INCREMENT BUFFER POINTERS
	TX_BYTES2(TX_OUTPUT2) = "B"
	gosub SNDCHAR		'INCREMENT BUFFER POINTERS
	TX_BYTES2(TX_OUTPUT2) = "A"
	GOSUB SNDCHAR		'INCREMENT BUFFER POINTERS
	TX_BYTES2(TX_OUTPUT2) = "C"
	gosub SNDCHAR		'INCREMENT BUFFER POINTERS
	TX_BYTES2(TX_OUTPUT2) = "K"
	GOSUB SNDCHAR		'INCREMENT BUFFER POINTERS
	GOTO CRLF		'CARRIAGE RETURN & LINE FEED
	
'*********************************************************************
ACK:		'SEND ACKNOWLAGEMENT & CARRIAGE RETURN & LINE FEED
'*********************************************************************
	TX_BYTES2(TX_OUTPUT2) = "O"
	gosub SNDCHAR		'INCREMENT BUFFER POINTERS
	TX_BYTES2(TX_OUTPUT2) = "K"
	GOSUB SNDCHAR		'INCREMENT BUFFER POINTERS
	
'*********************************************************************
CRLF:		'CARRIAGE RETURN & LINE FEED
'*********************************************************************
	TX_BYTES2(TX_OUTPUT2) = 10
	gosub SNDCHAR		'INCREMENT BUFFER POINTERS
	TX_BYTES2(TX_OUTPUT2) = 13
	GOTO SNDCHAR		'INCREMENT BUFFER POINTERS & RETURN
	
'*********************************************************************
COMMA:			'SEND COMMA TO TERMINAL DISPLAY
'*********************************************************************
	TX_BYTES2(TX_OUTPUT2) = ","
	goTO SNDCHAR		'INCREMENT BUFFER POINTERS

'*********************************************************************
EQUALS:			'SEND EQUALS SIGN TO TERMINAL DISPLAY
'*********************************************************************
	TX_BYTES2(TX_OUTPUT2) = "="

'*********************************************************************
SNDCHAR:		'INCREMENT BUFFER POINTERS
'*********************************************************************
    TX_OUTPUT2 = TX_OUTPUT2 + 1
    TX_OUTPUT2 = TX_OUTPUT2 & OUTSIZE
	TX_DAVAIL2 = TX_DAVAIL2 + 1
@	INT_ENABLE  TX2_INT     ; Enable TX UART Interrupts
	IF  TX_DAVAIL2 > FIVESIXTH THEN		'> 5/6 TH
		WHILE TX_DAVAIL2 > ONESIXTH		'1/6 TH
		WEND
	ENDIF
	RETURN
	
' ********************************************************************
BUILDSTRINGLZB:	'BUILD ASCII STRING FROM NUMBER VARIABLE W/LZB
' ********************************************************************
	LZB = 1		'SET LEADING ZERO BLANKING BIT
	DIGITS = 5	'SET FOR ALL 5 DIGITS DISPLAYED
' ********************************************************************
BUILDSTRING:	'BUILD ASCII STRING FROM NUMBER VARIABLE
' ********************************************************************
	JUNK = DIGITS - 1	'BASE 0
	WHILE JUNK < 255	'CHECK EACH POSITION
		IF SCRATCH DIG JUNK <> 0 OR LZB = 0 THEN	'IF INFO FOUND NOW or PREVIOUSLY
			TX_BYTES2(TX_OUTPUT2) = $30 + SCRATCH DIG JUNK	'PRINT IT...
			gosub SNDCHAR		'INCREMENT BUFFER POINTERS
			LZB = 0		'CLEAR LEADING ZERO BLANKING FLAG
		ENDIF
		JUNK = JUNK - 1	'NEXT DIGIT
		IF JUNK = 0 THEN LZB = 0	'ALWAYS DISPLAY LAST DIGIT TO RIGHT, EVEN IF ZERO
	WEND
	RETURN

'*********************************************************************
CHKSERIAL:
'*********************************************************************
	WHILE RX_DAVAIL2 <> 0
		INCHAR = RX_BYTES2(RX_INPUT2)
		RX_INPUT2 = (RX_INPUT2 + 1) & INSIZE
		RX_DAVAIL2 = RX_DAVAIL2 - 1
		SELECT CASE INCHAR
'*********************************************************************
			CASE $01	'CTRL (A) SET ALL COLORS BY USE OF A/D
				ADENABLE = ~ADENABLE
				GOSUB ADSTATE:	'SEND A/D STATUS & CARRIAGE RETURN & LINE FEED
'				GOSUB ACK
				
'*********************************************************************
			CASE $04	'CTRL (D) SET SCROLLING DELAY FOR TEXT
				DELAYTIME = ((TARGETEMP MIN 1000) MAX 1)	'1 SECOND MAXIMUM
				WRITE E_DELAY + (TESTMODE * 2) + 0,DELAYTIME.LOWBYTE
				WRITE E_DELAY + (TESTMODE * 2) + 1,DELAYTIME.HIGHBYTE
				GOSUB DELAYSTAT
				
'*********************************************************************
			CASE $02	'CTRL (B) SET BLUE INTENSITY
				GAMMAIN = TARGETEMP MIN 255		'FORGROUND BLUE INTENSITY
				GOSUB GAMMACORR:		' Gamma correction table, 256 values
				IF TXTENAB = OFF_ THEN	'IF NOT IN TEXT ENTRY MODE
					IF FOR_BAK = ON_ THEN	'COLOR IS FOR FORGROUND
						FOR_BLUE = GAMMAOUT				'FORGROUND BLUE INTENSITY
					ELSE	'COLOR IS FOR BACKGROUND
						BAK_BLUE = GAMMAOUT				'BACKGROUND BLUE INTENSITY
					ENDIF
				ENDIF
				FOR_BAK = ON_	'DEFAULT COLOR IS FOR FORGROUND
				GOSUB ACK
											
'*********************************************************************
			CASE $07	'CTRL (G) SET GREEN INTENSITY
				GAMMAIN = TARGETEMP MIN 255		'FORGROUND BLUE INTENSITY
				GOSUB GAMMACORR:		' Gamma correction table, 256 values
				IF TXTENAB = OFF_ THEN  'IF NOT IN TEXT ENTRY MODE
					IF FOR_BAK = ON_ THEN	'COLOR IS FOR FORGROUND
						FOR_GREEN = GAMMAOUT		'FORGROUND GREEN INTENSITY
					ELSE	'COLOR IS FOR BACKGROUND
						BAK_GREEN = GAMMAOUT		'BACKGROUND GREEN INTENSITY
					ENDIF
				ENDIF
				FOR_BAK = ON_	'DEFAULT COLOR IS FOR FORGROUND
				GOSUB ACK
											
'*********************************************************************
			CASE $12	'CTRL (R) SET RED INTENSITY
				GAMMAIN = TARGETEMP MIN 255		'FORGROUND BLUE INTENSITY
				GOSUB GAMMACORR:		' Gamma correction table, 256 values
				IF TXTENAB = OFF_ THEN	'IF NOT IN TEXT ENTRY MODE
					IF FOR_BAK = ON_ THEN	'COLOR IS FOR FORGROUND
						FOR_RED = GAMMAOUT			'FORGROUND RED INTENSITY
					ELSE	'COLOR IS FOR BACKGROUND
						BAK_RED = GAMMAOUT			'BACKGROUND RED INTENSITY
					ENDIF
				ENDIF
				FOR_BAK = ON_	'DEFAULT COLOR IS FOR FORGROUND
				GOSUB ACK
											
'*********************************************************************
			CASE $05	'CTRL (E) SET BACKROUND COLOR DESTINATION
				IF TXTENAB = OFF_ THEN	'IF NOT IN TEXT ENTRY MODE
					FOR_BAK = OFF_	'COLOR IS FOR BACKGROUND
				ENDIF
				GOSUB BACKGROUND:		'SEND BACKGROUND & CARRIAGE RETURN & LINE FEED
'				GOSUB ACK
											
'*********************************************************************
			CASE $0C	'CTRL (L) TOGGLE LOOP MESSAGES
				ROTATEMESS = ~ROTATEMESS
				GOSUB ACK
											
'*********************************************************************
			CASE $06	'CTRL (F) SET FORGROUND COLOR DESTINATION
				IF TXTENAB = OFF_ THEN	'IF NOT IN TEXT ENTRY MODE
					FOR_BAK = ON_	'COLOR IS FOR FORGROUND
				ENDIF
				GOSUB FORGROUND:		'SEND FORGROUND & CARRIAGE RETURN & LINE FEED
'				GOSUB ACK

'*********************************************************************
			CASE $0F	'CTRL (O) TOGGLE TEST MODE
				TESTMODE = (TESTMODE + 1) & 3
				GOSUB ACK
				
'*********************************************************************
			CASE $13	'CTRL (S) RECALL STORED MESSAGE BUFFER and COLOR VALUES FROM EEPROM
				MESSNUM = TARGETEMP MIN (MAXMESS - 1)
				GOSUB READMEM:	'UPDATE CURRENT TEXT and COLORS FROM MEMORY
				GOSUB SENDBUFF:	'REPORT/DUMP MESSAGE IN BUFFER
'				GOSUB ACK

'*********************************************************************
			CASE $17	'CTRL (W) WRITE MESSAGE BUFFER and COLOR VALUES TO EEPROM
				MESSNUM = TARGETEMP MIN (MAXMESS - 1)
				SCRATCH = (MESSNUM * BUFSIZE)	'CALCULATE THE ADDRESS
				CHARCNTR = 0
				WHILE CHARCNTR < (BUFSIZE - 1)	'LIMIT TO BUFFER SIZE - 1
					WRITE E_TEXT + SCRATCH + CHARCNTR,INBUF(CHARCNTR)	'STORE VARIABLE TEXT
					CHARCNTR = CHARCNTR + 1
				WEND
				WRITE E_TEXT + SCRATCH + CHARCNTR,$18	'SET LAST CHARACTER FOR END OF MESSAGE
				SCRATCH = (MESSNUM * COLORSIZE)	'CALCULATE THE ADDRESS
				WRITE E_COLORS + (SCRATCH + 0),FOR_GREEN	'SAVE THE COLORS
				WRITE E_COLORS + (SCRATCH + 1),FOR_BLUE
				WRITE E_COLORS + (SCRATCH + 2),FOR_RED
				WRITE E_COLORS + (SCRATCH + 3),BAK_GREEN
				WRITE E_COLORS + (SCRATCH + 4),BAK_BLUE
				WRITE E_COLORS + (SCRATCH + 5),BAK_RED
				GOSUB ACK

'*********************************************************************
			CASE $11	'CTRL (Q) SEND VARIABLE STATUS
				TX_BYTES2(TX_OUTPUT2) = "G"
				gosub SNDCHAR		'INCREMENT BUFFER POINTERS
				GOSUB EQUALS
				SCRATCH = FOR_GREEN
				GOSUB BUILDSTRINGLZB	'BUILD ASCII STRING FROM NUMBER VARIABLE
				GOSUB COMMA
				TX_BYTES2(TX_OUTPUT2) = "B"
				gosub SNDCHAR		'INCREMENT BUFFER POINTERS
				GOSUB EQUALS
				SCRATCH = FOR_BLUE
				GOSUB BUILDSTRINGLZB	'BUILD ASCII STRING FROM NUMBER VARIABLE
				GOSUB COMMA
				TX_BYTES2(TX_OUTPUT2) = "R"
				gosub SNDCHAR		'INCREMENT BUFFER POINTERS
				GOSUB EQUALS
				SCRATCH = FOR_RED
				GOSUB BUILDSTRINGLZB	'BUILD ASCII STRING FROM NUMBER VARIABLE
				GOSUB FORGROUND:		'SEND FORGROUND & CARRIAGE RETURN & LINE FEED
				TX_BYTES2(TX_OUTPUT2) = "G"
				gosub SNDCHAR		'INCREMENT BUFFER POINTERS
				GOSUB EQUALS
				SCRATCH = BAK_GREEN
				GOSUB BUILDSTRINGLZB	'BUILD ASCII STRING FROM NUMBER VARIABLE
				GOSUB COMMA
				TX_BYTES2(TX_OUTPUT2) = "B"
				gosub SNDCHAR		'INCREMENT BUFFER POINTERS
				GOSUB EQUALS
				SCRATCH = BAK_BLUE
				GOSUB BUILDSTRINGLZB	'BUILD ASCII STRING FROM NUMBER VARIABLE
				GOSUB COMMA
				TX_BYTES2(TX_OUTPUT2) = "R"
				gosub SNDCHAR		'INCREMENT BUFFER POINTERS
				GOSUB EQUALS
				SCRATCH = BAK_RED
				GOSUB BUILDSTRINGLZB	'BUILD ASCII STRING FROM NUMBER VARIABLE
				GOSUB BACKGROUND:		'SEND BACKGROUND & CARRIAGE RETURN & LINE FEED
				GOSUB ACK
				
'*********************************************************************
			CASE $14	'CTRL (T) START OF TEXT
				IF TXTENAB = OFF_ THEN	'IF NOT IN TEXT ENTRY MODE
					TXTENAB = ON_ 	'SET FLAG FOR IT
					ININDEX = 0		'ZERO BUFFER POINTER
				ENDIF
											
'*********************************************************************
			CASE $18	'CTRL (X) END OF TEXT
				IF TXTENAB = ON_ THEN	'IF IN TEXT ENTRY MODE
'					INBUF(ININDEX) = "."'ADD NEW CHARACTER TO BUFFER
'					ININDEX = (ININDEX + 1) MIN (BUFSIZE - 1)
					INBUF(ININDEX) = INCHAR	'ADD END OF FUFFER CHARACTER
					ININDEX = (ININDEX + 1) MIN (BUFSIZE - 1)
				ENDIF
				TXTENAB = OFF_	'DISABLE IT WHEN DONE
				GOSUB ACK
			
'*********************************************************************
			CASE $1A	'CTRL Z	(REPORT/DUMP MESSAGE IN BUFFER)
				GOSUB SENDBUFF:	'REPORT/DUMP MESSAGE IN BUFFER
'				GOSUB ACK
												
'*********************************************************************
			CASE $30,$31,$32,$33,$34,$35,$36,$37,$38,$39	'0,1,2,3,4,5,6,7,8,9
				IF TXTENAB = ON_ THEN	'IF IN TEXT ENTRY MODE
					INBUF(ININDEX) = INCHAR	'ADD NEW CHARACTER TO BUFFER
					ININDEX = (ININDEX + 1) MIN (BUFSIZE - 1)
				ELSE
					TARGETEMP = TARGETEMP * 10	'NUMERIC KEY JUST RELEASED SO ADD TO VALUE
					TARGETEMP = TARGETEMP + (INCHAR - $30)
        		ENDIF
        		
'*********************************************************************
			CASE IS > $7E	'MUST NOT BE AN ASCII CHARACTER
				'YOU ARE OUT OF LUCK... START ALL OVER AGAIN....			

'*********************************************************************
			CASE IS > $1F	'MUST BE AN ASCII CHARACTER
				IF TXTENAB = ON_ THEN	'IF IN TEXT ENTRY MODE
					INBUF(ININDEX) = INCHAR	'ADD NEW CHARACTER TO BUFFER
					ININDEX = (ININDEX + 1) MIN (BUFSIZE - 1)
				ENDIF
					
'*********************************************************************
			CASE ELSE
				'YOU ARE OUT OF LUCK... START ALL OVER AGAIN....			
				
'*********************************************************************

		END SELECT
	WEND
	GOSUB CLRREC	'CLEANUP RECEIVER BUFFER POINTERS....
	RETURN	

' ********************************************************************	
SENDBUFF:	'REPORT/DUMP MESSAGE IN BUFFER
' ********************************************************************	
	IF TXTENAB = OFF_ THEN	'IF NOT IN TEXT ENTRY MODE
		ININDEX = 0
		WHILE INBUF(ININDEX) <> $18 AND ININDEX < BUFSIZE
			TX_BYTES2(TX_OUTPUT2) = INBUF(ININDEX)
			gosub SNDCHAR		'INCREMENT BUFFER POINTERS
			ININDEX = ININDEX + 1
		WEND
		GOSUB CRLF:		'CARRIAGE RETURN & LINE FEED
	ENDIF
	RETURN
	
' ********************************************************************	
READMEM:	'UPDATE CURRENT TEXT and COLORS FROM MEMORY
' ********************************************************************	
	SCRATCH = (MESSNUM * BUFSIZE)	'CALCULATE ADDRESS
	CHARCNTR = 0
	WHILE CHARCNTR < BUFSIZE	'LIMIT TO BUFFER SIZE
		READ E_TEXT + SCRATCH + CHARCNTR,INBUF(CHARCNTR)	'RESTORE VARIABLE TEXT
		CHARCNTR = CHARCNTR + 1
	WEND
	SCRATCH = (MESSNUM * COLORSIZE)	'CALCULATE ADDRESS
	READ E_COLORS + (SCRATCH + 0),FOR_GREEN	'RESTORE THE COLORS
	READ E_COLORS + (SCRATCH + 1),FOR_BLUE
	READ E_COLORS + (SCRATCH + 2),FOR_RED
	READ E_COLORS + (SCRATCH + 3),BAK_GREEN
	READ E_COLORS + (SCRATCH + 4),BAK_BLUE
	READ E_COLORS + (SCRATCH + 5),BAK_RED
	RETURN
	
' ********************************************************************	
CHARTABLR:		'CHARACTER LOOK-UP TABLE FOR ROWS (LSB=RIGHT) (ROW0 = TOP)
' ********************************************************************
'             76543210-BIT VALUE POSITIONS
'ROW_DAT(0) = 000XXXXX \
'ROW_DAT(1) = 000XXXXX  \
'ROW_DAT(2) = 000XXXXX   \
'ROW_DAT(3) = 000XXXXX    \ 5 X 7 CHARACTER REPRESENTED BY X's
'ROW_DAT(4) = 000XXXXX   /
'ROW_DAT(5) = 000XXXXX  /
'ROW_DAT(6) = 000XXXXX /
	IF CHARACTER > 31 THEN	'ONLY DECODE ASCII PRINTABLE CHARACTER's
						 ' " ","!",""","#","$","%","&","'","(",")","*","+",",",
   '"-",".","/","0","1","2","3","4","5","6","7","8","9",":",";","<","=",">","?",
   '"@","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R",
   '"S","T","U","V","W","X","Y","Z","[","\","]","^","_","`","a","b","c","d","e",
   '"f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x",
   '"y","z","{","|","}","~"]	
ROW1:
	LOOKUP CHARACTER - 32,[$00,$04,$0A,$0A,$04,$18,$0C,$0C,$04,$04,$00,$00,$00,_
	$00,$00,$00,$0E,$04,$0E,$1F,$02,$1F,$06,$1F,$0E,$0E,$00,$00,$02,$00,$08,$0E,_
	$0E,$0E,$1E,$0E,$1C,$1F,$1F,$0E,$11,$0E,$07,$11,$10,$11,$11,$0E,$1E,$0E,$1E,_
	$0F,$1F,$11,$11,$11,$11,$11,$1F,$1C,$00,$07,$04,$00,$08,$00,$10,$00,$01,$00,_
	$06,$00,$10,$04,$01,$10,$0C,$00,$00,$00,$00,$00,$00,$00,$08,$00,$00,$00,$00,_
	$00,$00,$04,$04,$04,$00],ROW_DAT(0)
ROW2:
	LOOKUP CHARACTER - 32,[$00,$04,$0A,$0A,$0F,$19,$12,$04,$08,$02,$04,$04,$00,_
	$00,$00,$01,$11,$0C,$11,$02,$06,$10,$08,$01,$11,$11,$0C,$0C,$04,$00,$04,$11,_
	$11,$11,$11,$11,$12,$10,$10,$11,$11,$04,$02,$12,$10,$1B,$11,$11,$11,$11,$11,_
	$10,$04,$11,$11,$11,$11,$11,$01,$10,$10,$01,$0A,$00,$04,$00,$10,$00,$01,$00,_
	$09,$0F,$10,$00,$00,$10,$04,$00,$00,$00,$00,$00,$00,$00,$08,$00,$00,$00,$00,_
	$00,$00,$08,$04,$02,$00],ROW_DAT(1)
ROW3:
	LOOKUP CHARACTER - 32,[$00,$04,$0A,$1F,$14,$02,$14,$08,$10,$01,$15,$04,$00,_
	$00,$00,$02,$13,$04,$01,$04,$0A,$1E,$10,$02,$11,$11,$0C,$0C,$08,$1F,$02,$01,_
	$01,$11,$11,$10,$11,$10,$10,$10,$11,$04,$02,$14,$10,$15,$19,$11,$11,$11,$11,_
	$10,$04,$11,$11,$11,$0A,$11,$02,$10,$08,$01,$11,$00,$02,$0E,$16,$0E,$0D,$0E,_
	$08,$11,$16,$0C,$03,$12,$04,$1A,$16,$0E,$1E,$0D,$16,$0E,$1C,$11,$11,$11,$11,_
	$11,$1F,$08,$04,$02,$05],ROW_DAT(2)
ROW4:
	LOOKUP CHARACTER - 32,[$00,$04,$00,$0A,$0E,$04,$08,$00,$10,$01,$0E,$1F,$00,_
	$1F,$00,$04,$15,$04,$02,$02,$12,$01,$1E,$04,$0E,$0F,$00,$00,$10,$00,$01,$02,_
	$0D,$11,$1E,$10,$11,$1E,$1E,$17,$1F,$04,$02,$18,$10,$15,$15,$11,$1E,$11,$1E,_
	$0E,$04,$11,$11,$15,$04,$0A,$04,$10,$04,$01,$00,$00,$00,$01,$19,$10,$13,$11,_
	$1C,$11,$19,$04,$01,$14,$04,$15,$19,$11,$11,$13,$19,$10,$08,$11,$11,$11,$0A,_
	$11,$02,$10,$04,$01,$0A],ROW_DAT(3)
ROW5
	LOOKUP CHARACTER - 32,[$00,$00,$00,$1F,$05,$08,$15,$00,$10,$01,$15,$04,$0C,_
	$00,$00,$08,$19,$04,$04,$01,$1F,$01,$11,$08,$11,$01,$0C,$0C,$08,$1F,$02,$04,_
	$15,$1F,$11,$10,$11,$10,$10,$11,$11,$04,$02,$14,$10,$11,$13,$11,$10,$15,$14,_
	$01,$04,$11,$11,$15,$0A,$04,$08,$10,$02,$01,$00,$00,$00,$0F,$11,$10,$11,$1F,_
	$08,$0F,$11,$04,$01,$18,$04,$15,$11,$11,$1E,$0F,$10,$0E,$08,$11,$11,$15,$04,_
	$0F,$04,$08,$04,$02,$00],ROW_DAT(4)
ROW6
	LOOKUP CHARACTER - 32,[$00,$00,$00,$0A,$1E,$13,$12,$00,$08,$02,$04,$04,$04,_
	$00,$0C,$10,$11,$04,$08,$11,$02,$11,$11,$08,$11,$01,$0C,$04,$04,$00,$04,$00,_
	$15,$11,$11,$11,$12,$10,$10,$11,$11,$04,$12,$12,$10,$11,$11,$11,$10,$12,$12,_
	$01,$04,$11,$0A,$15,$11,$04,$10,$10,$01,$01,$00,$00,$00,$11,$11,$11,$11,$10,_
	$08,$01,$11,$04,$09,$14,$04,$11,$11,$11,$10,$01,$10,$01,$09,$13,$0A,$15,$0A,_
	$01,$08,$08,$04,$02,$00],ROW_DAT(5)
ROW7:
	LOOKUP CHARACTER - 32,[$00,$04,$00,$0A,$04,$03,$0D,$00,$04,$04,$00,$00,$08,_
	$00,$0C,$00,$0E,$0E,$1F,$0E,$02,$0E,$0E,$08,$0E,$0E,$00,$08,$02,$00,$08,$04,_
	$0E,$11,$1E,$0E,$1C,$1F,$10,$0F,$11,$0E,$0C,$11,$1F,$11,$11,$0E,$10,$0D,$11,_
	$1E,$04,$0E,$04,$0A,$11,$04,$1F,$1C,$00,$07,$00,$1F,$00,$0F,$1E,$0E,$0F,$0E,_
	$08,$0E,$11,$0E,$06,$12,$0E,$11,$11,$0E,$10,$01,$10,$1E,$06,$0D,$04,$0A,$11,_
	$0E,$1F,$04,$04,$04,$00],ROW_DAT(6)
	ENDIF
	RETURN

' ********************************************************************	
GAMMACORR:		' Gamma correction table, 256 values
' ********************************************************************	
	LOOKUP GAMMAIN,[_
	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,_
	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$01,$01,$01,$01,_
	$01,$01,$01,$01,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$02,$02,_
	$02,$03,$03,$03,$03,$03,$03,$03,$04,$04,$04,$04,$04,$05,$05,$05,_
	$05,$06,$06,$06,$06,$07,$07,$07,$07,$08,$08,$08,$09,$09,$09,$0A,_
	$0A,$0A,$0B,$0B,$0B,$0C,$0C,$0D,$0D,$0D,$0E,$0E,$0F,$0F,$10,$10,_
	$11,$11,$12,$12,$13,$13,$14,$14,$15,$15,$16,$16,$17,$18,$18,$19,_
	$19,$1A,$1B,$1B,$1C,$1D,$1D,$1E,$1F,$20,$20,$21,$22,$23,$23,$24,_
	$25,$26,$27,$27,$28,$29,$2A,$2B,$2C,$2D,$2E,$2F,$30,$31,$32,$32,_
	$33,$34,$36,$37,$38,$39,$3A,$3B,$3C,$3D,$3E,$3F,$40,$42,$43,$44,_
	$45,$46,$48,$49,$4A,$4B,$4D,$4E,$4F,$51,$52,$53,$55,$56,$57,$59,_
	$5A,$5C,$5D,$5F,$60,$62,$63,$65,$66,$68,$69,$6B,$6D,$6E,$70,$72,_
	$73,$75,$77,$78,$7A,$7C,$7E,$7F,$81,$83,$85,$87,$89,$8A,$8C,$8E,_
	$90,$92,$94,$96,$98,$9A,$9C,$9E,$A0,$A2,$A4,$A7,$A9,$AB,$AD,$AF,_
	$B1,$B4,$B6,$B8,$BA,$BD,$BF,$C1,$C4,$C6,$C8,$CB,$CD,$D0,$D2,$D5,_
	$D7,$DA,$DC,$DF,$E1,$E4,$E7,$E9,$EC,$EF,$F1,$F4,$F7,$F9,$FC,$FF_
	],GAMMAOUT
	GAMMAOUT = GAMMAIN	'BYPASS THIS ROUTINE FOR NOW....
	RETURN
	
' ********************************************************************	
NeoPixelRotate:	'ROTATE ALL PIXELS FROM RIGHT TO LEFT (HIGHEST tO LOWEST)
'				'PROGRESSIVE CONNECTION (1 SINGLE STRING)
' ********************************************************************	
	POINTER = NEO_NUM - 1	'THIS SCHEME USED TO ELIMINATE USING "< or >" COMPARE STATEMENTS
	oldGreen = NeoGreen[0]	'remember location 0 if needed for looping
	oldBlue = NeoBlue[0]
	oldRed = NeoRed[0]
NXTPIXEL:
	NeoPixel = (NEO_NUM - 1) - POINTER
	NeoGreen[NeoPixel] = NeoGreen[NeoPixel + 1]
	NeoBlue[NeoPixel] = NeoBlue[NeoPixel + 1]
	NeoRed[NeoPixel] = NeoRed[NeoPixel + 1]
	POINTER = POINTER - 1	'next pixel in the string
	IF POINTER.15 = 0 THEN NXTPIXEL
	'WHEN DONE,THE LAST PIXEL IN EACH HORIZONTAL ROW (FAR RIGHT) WILL
	' HAVE INCORRECT DATA SO, WE WILL TAKE CARE OF THAT UPDATING IN THE MAIN ROUTINE.
    RETURN

' ********************************************************************	
PIXEL_ON:	'SET PIXEL COLOR TO FORGROUND
' ********************************************************************	
    NeoGreen[POINTER] = FOR_GREEN	'FORGROUND GREEN INTENSITY
    NeoBlue[POINTER] = FOR_BLUE		'FORGROUND BLUE INTENSITY
    NeoRed[POINTER] = FOR_RED		'FORGROUND RED INTENSITY
	RETURN

' ********************************************************************	
PIXEL_OFF:   'SET PIXEL COLOR TO BACKGROUND
' ********************************************************************	
    NeoGreen[POINTER] = BAK_GREEN	'BACKGROUND GREEN INTENSITY
    NeoBlue[POINTER] = BAK_BLUE		'BACKGROUND BLUE INTENSITY
    NeoRed[POINTER] = BAK_RED		'BACKGROUND RED INTENSITY
	RETURN

' ********************************************************************	
CLR_ARRAY:	'SET PIXELS COLOR ARRAY TO BLACK (OFF)
' ********************************************************************
	POINTER = FULLSTRING - 1
NXTCLR:
    NeoGreen[POINTER] = OFF_
    NeoBlue[POINTER] = OFF_
    NeoRed[POINTER] = OFF_
	POINTER = POINTER - 1
	IF POINTER.15 = 0 THEN NXTCLR
	RETURN

'*********************************************************************
READAD:	'READ SYSTEM A/D VOLTAGES (AVERAGE 8 READINGS)
'*********************************************************************
	CHANNEL = 2
NXTCHAN:
	ADCON0 = $01 | (CHANNEL << 2)		' Set A/D to Channel X, On
	PAUSEUS 40
	VOLTS(CHANNEL) = 0     'CLEAR A/D READINGS
	ADCON0.1 = ON_		' START CONVERSION
	JUNK = 7		'TAKE 8 READINGS
NXTAD:
	IF ADCON0.1 = ON_ THEN NXTAD	'WAIT FOR A/D TO FINISH	
	VOLTS(CHANNEL) = VOLTS(CHANNEL) + (((ADRESH & $3) << 8) + ADRESL)	'BUILD SENSOR WORD (RIGHT JUSTIFIED)
	JUNK = JUNK - 1
	IF JUNK.7 = 0 THEN NXTAD
	VOLTS(CHANNEL) = VOLTS(CHANNEL) >> 5	'DIVIDE BY 32 TO GENERATE 0-255
	GAMMAIN = VOLTS(JUNK)
	GOSUB GAMMACORR		' Gamma correction table, 256 values
	VOLTS(JUNK) = GAMMAOUT
	CHANNEL = CHANNEL - 1
	IF CHANNEL.7 = 0 THEN NXTCHAN:
	RETURN
'*********************************************************************
PAUSDELAY: 		'PAUSE BASED ON DELAY VARIABLE
'*********************************************************************
	LOOPCNTR = (DELAYTIME MAX 1) - 1	'PIXEL SCROLLING DELAY
NXT1MS:		PAUSEUS 1000
	LOOPCNTR = LOOPCNTR - 1
	IF RX_MESSAGE2 = 1 THEN GOSUB CHKSERIAL	'CHECK FOR MESSAGE AVAILABLE
	IF LOOPCNTR // 10 = 0 THEN RXTIMER2 = RXTIMER2 + 1	'INCREMENT RECEIVE TIMEOUT TIMER
	IF RX_DAVAIL2 <> 0 AND RXTIMER2 > RXTIMEOUT THEN	'IF RANDOM CHARACTERS
		GOSUB CLRREC		'THEN FLUSH
	ENDIF					
	IF LOOPCNTR.15 = 0 THEN NXT1MS
	RETURN
	
'*********************************************************************

'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
'XXXXXXXXXXXXXXXXXXXXXXXXX Main program XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
Main:
	CHARACTER = 255
	SCRATCH = 0
	GOSUB CRLF		'CARRIAGE RETURN & LINE FEED
	WHILE (CHARACTER <> 0) AND (SCRATCH < 255)	'DISPLAY INTRO SPLASH SCREEN
		READ (INTRO + SCRATCH),CHARACTER
		TX_BYTES2(TX_OUTPUT2) = CHARACTER
		gosub SNDCHAR		'INCREMENT BUFFER POINTERS
		SCRATCH = SCRATCH + 1
	WEND
	GOSUB CRLF		'CARRIAGE RETURN & LINE FEED

	FOR_BAK = ON_	'DEFAULT TO FORGROUND COLOR
	GOSUB CLR_ARRAY:	'SET PIXELS COLOR ARRAY TO BACKGROUNG (OFF)
	NEO_NUM = FULLSTRING	'TOTAL NUMBER OF PIXELS IN ATTACHED STRING

	gosub NeoPixelASM64	'PUSH NEW PIXEL DATA TO NEOPIXEL STRING
	'DO IT AGAIN INCASE OF NOISE.....
	gosub NeoPixelASM64	'PUSH NEW PIXEL DATA TO NEOPIXEL STRING

	MESSNUM = 0	'DEFAULT MESSAGE and COLORS TO BE DISPLAYED IS IN MESSAGE -0-
	GOSUB READMEM:	'UPDATE CURRENT TEXT and COLORS FROM MEMORY

	CHARCNTR = 0	'INITIAL CHARACTER IN BUFFER
	NEO_NUM = MATRIXNUM		'SET FOR TEXT MODE (DEFAULT)
	
	TESTMODE = 0	'DEFAULT MODE
	OLDTESTMODE = 255	'INITIALIZE

	REPEAT		'UNTIL COWS COME HOME.....

		IF OLDTESTMODE <> TESTMODE THEN	 'CHECK THAT MODE HAS NOT CHANGED
			OLDTESTMODE = TESTMODE
			SELECT CASE TESTMODE	'imitialization for mode change
				CASE 0
					NEO_NUM = MATRIXNUM		'SET FOR TEXT MODE (DEFAULT)
					CHARCNTR = 0	'INITIAL CHARACTER IN BUFFER
				CASE 1
					NEO_NUM = FULLSTRING'	CON	240	'TOTAL NUMBER OF PIXELS IN ATTACHED STRING
					DIR = 1
					INTENSITY = COLORMAX / 2
					COLOR = 0
				CASE 2
					NEO_NUM = FULLSTRING'	CON	240	'TOTAL NUMBER OF PIXELS IN ATTACHED STRING
					INTENSITY = COLORMAX / 2
		            FIRSTPASS = 1
				CASE 3
					NEO_NUM = MATRIXNUM		'SET FOR TEXT MODE (DEFAULT)
			END SELECT
			GOSUB CLR_ARRAY:	'SET PIXELS COLOR ARRAY TO BLACK (OFF)
			gosub NeoPixelASM64	'PUSH NEW PIXEL DATA TO NEOPIXEL STRING
		ENDIF

		READ E_DELAY + (TESTMODE * 2) + 0,DELAYTIME.LOWBYTE
		READ E_DELAY + (TESTMODE * 2) + 1,DELAYTIME.HIGHBYTE
	
		SELECT CASE TESTMODE	'now.... what mode to be in?
			CASE 0		'SCROLLING TEXT MODE
				IF ADENABLE = 1 THEN	'IF COLOR'S ARE FROM ANALOG POTS
					GOSUB READAD	'READ SYSTEM A/D VOLTAGES (AVERAGE 8 READINGS)
					DEBUG "G=",DEC3 VOLTS(0),",B=",DEC3 VOLTS(1),",R=",DEC3 VOLTS(2),10,13
					IF FOR_BAK = OFF_ THEN	'COLOR IS FOR BACKGROUND
					    BAK_GREEN = VOLTS(0)	'BACKGROUND GREEN INTENSITY
					    BAK_BLUE = VOLTS(1)		'BACKGROUND BLUE INTENSITY
					    BAK_RED = VOLTS(2)		'BACKGROUND RED INTENSITY
					ELSE
					    FOR_GREEN = VOLTS(0)	'FORGROUND GREEN INTENSITY
					    FOR_BLUE = VOLTS(1)		'FORGROUND BLUE INTENSITY
					    FOR_RED = VOLTS(2)		'FORGROUND RED INTENSITY
					ENDIF
				ENDIF			
		
				CHARACTER = INBUF(CHARCNTR)	'READ BUFFERED CHARACTER STRING
				IF CHARACTER <> $18 AND CHARCNTR < BUFSIZE THEN	'CHECK FOR END OF STRING
					GOSUB CHARTABLR:		'CHARACTER LOOK-UP TABLE FOR ROWS (LSB=RIGHT) (ROW0 = TOP)
					DOT = COL_P_CHR - 1		'COLLUM POSITION, START WITH 1 BLANK COLLUM TO LEFT OF 5 X 7
NXTDOT:				GOSUB NeoPixelRotate:	'ROTATE ALL PIXEL COLLUMS FROM RIGHT TO LEFT, IN PREP FOR NEW DATA
					JUNK1 = ROW_P_CHR - 1	'CYCLE THRU TILL ALL 7 ROWS READ
NXTROW:				ROW = (ROW_P_CHR - 1) - JUNK1	'CYCLE THRU TILL ALL 7 ROWS READ
					POINTER = ((PIX_P_ROW * (ROW + 1)) - 1)	'CALCULATE PIXEL ARRAY POSITION
					'HERE WE NEED TO UPDATE THE LAST PIXEL (FAR RIGHT) IN EACH HORIZONTAL ROW
					JUNK = ROW_DAT(ROW)	'TRANSFER ROW DATA FROM TABLE
					IF JUNK.0(DOT) = 1 THEN	'CHECK PIXEL FOR ILLUMINATION
						GOSUB PIXEL_ON		'SET COLOR OF PIXEL IF ILLUMINATED
			        ELSE
			        	GOSUB PIXEL_OFF		'SET COLOR OF BACKGROUND IF OFF
		        	ENDIF
					JUNK1 = JUNK1 - 1	'INCREMENT ROW COUNTER (VERTICAL)
					IF JUNK1.7 = 0 THEN NXTROW
					gosub NeoPixelASM64	'PUSH NEW PIXEL DATA TO NEOPIXEL STRING
					GOSUB PAUSDELAY
					DOT = DOT - 1	'DECREMENT COLLUM POINTER
					IF DOT.7 = 0 THEN NXTDOT		'CYCLE THRU TILL ALL 6 COLLUMS READ
					CHARCNTR = CHARCNTR + 1	'NEXT CHARACTER IN BUFFER
				ELSE
					IF ROTATEMESS = 1 THEN	'IF REQUESTED TO LOOP MESSAGES THEN SELECT NEXT
						MESSNUM = (MESSNUM + 1)
						IF MESSNUM > MAXMESS - 1 THEN
							MESSNUM = 1
						ENDIF
						GOSUB READMEM:	'UPDATE CURRENT TEXT and COLORS FROM MEMORY
					ENDIF
					CHARCNTR = 0	'END OF STRING FOUND, START ALL OVER
				ENDIF
				
			CASE 1,3		'TEST PATTERN FOR ALL COLORS (THIS SAME CODE FOR MODES 1,3)
				IF DIR = UP THEN	'CHECK DIRECTION
					INTENSITY = INTENSITY + 1	
					IF INTENSITY = COLORMAX THEN
						DIR = DOWN
						COLOR = COLOR + 1
					ENDIF
				ELSE	'MUST BE DOWN
					INTENSITY = INTENSITY - 1	
					IF INTENSITY = 0 THEN
						DIR = UP
						COLOR = COLOR + 1
					ENDIF
				ENDIF
				IF COLOR > 5 THEN COLOR = 0
				SELECT CASE COLOR
					CASE 0	'GREEN-UP/RED-DOWN			
				        NEW_NeoGreen = INTENSITY  'POSITIVE
					    NEW_NeoBlue = 0
				    	NEW_NeoRed = ~INTENSITY & COLORMAX
				
					CASE 1	'GREEN-DOWN/BLUE-UP			
				        NEW_NeoGreen = INTENSITY  'NEGATIVE
					    NEW_NeoBlue = ~INTENSITY & COLORMAX
				    	NEW_NeoRed = 0
					
					CASE 2	'BLUE-DOWn/RED-UP			
				        NEW_NeoGreen = 0
					    NEW_NeoBlue = ~INTENSITY & COLORMAX
				    	NEW_NeoRed = INTENSITY    'POSITIVE
					
					CASE 3	'GREEN-UP/RED-DOWN			
				        NEW_NeoGreen = ~INTENSITY & COLORMAX
					    NEW_NeoBlue = 0
				    	NEW_NeoRed = INTENSITY		'NEGATIVE
				
					CASE 4	'GREEN-DOWN/BLUE-UP			
				        NEW_NeoGreen = ~INTENSITY & COLORMAX
					    NEW_NeoBlue = INTENSITY		'POSITIVE
				    	NEW_NeoRed = 0
					
					CASE 5	'BLUE-DOWN/RED-UP			
				        NEW_NeoGreen = 0
					    NEW_NeoBlue = INTENSITY		'NEGATIVE
				    	NEW_NeoRed = ~INTENSITY & COLORMAX
				END SELECT	
				SELECT CASE TESTMODE	'CODE SPECIFIC TO MODES 1,3
					CASE 1
						GOSUB NeoPixelRotate:	'ROTATE ALL PIXEL COLLUMS FROM RIGHT TO LEFT, IN PREP FOR NEW DATA
					    NeoGreen[NEO_NUM - 1] = NEW_NeoGreen	'add new color to ms pixel
					    NeoBlue[NEO_NUM - 1] = NEW_NeoBlue
					    NeoRed[NEO_NUM - 1] = NEW_NeoRed
						gosub NeoPixelASM64	'PUSH NEW PIXEL DATA TO NEOPIXEL STRING
						GOSUB PAUSDELAY
					CASE 3
						JUNK1 = ROW_P_CHR - 1	'CYCLE THRU TILL ALL 7 ROWS READ
NXTTSTROW:				ROW = (ROW_P_CHR - 1) - JUNK1	'CYCLE THRU TILL ALL 7 ROWS READ
						'HERE WE NEED TO UPDATE THE FIRST PIXEL (FAR LEFT) IN EACH HORIZONTAL ROW W/0
						POINTER = PIX_P_ROW * ROW	'CALCULATE PIXEL ARRAY POSITION TO CLEAR
					    NeoGreen[POINTER] = OFF_
					    NeoBlue[POINTER] = OFF_
					    NeoRed[POINTER] = OFF_
						POINTER = ((PIX_P_ROW * (ROW + 1)) - 1)	'CALCULATE PIXEL ARRAY POSITION
						'HERE WE NEED TO UPDATE THE LAST PIXEL (FAR RIGHT) IN EACH HORIZONTAL ROW
					    NeoGreen[POINTER] = NEW_NeoGreen	'add new color to ms pixel
					    NeoBlue[POINTER] = NEW_NeoBlue
					    NeoRed[POINTER] = NEW_NeoRed
						JUNK1 = JUNK1 - 1	'INCREMENT ROW COUNTER (VERTICAL)
						IF JUNK1.7 = 0 THEN NXTTSTROW
						gosub NeoPixelASM64	'PUSH NEW PIXEL DATA TO NEOPIXEL STRING
						GOSUB PAUSDELAY
						DOT = PIX_P_ROW - 1
NXTCOL:					GOSUB NeoPixelRotate:	'ROTATE ALL PIXEL COLLUMS FROM RIGHT TO LEFT, IN PREP FOR NEW DATA
						gosub NeoPixelASM64	'PUSH NEW PIXEL DATA TO NEOPIXEL STRING
						GOSUB PAUSDELAY
						DOT = DOT - 1
    					IF DOT.7 = 0 THEN NXTCOL
				END SELECT

			CASE 2                           
                IF FIRSTPASS = 1 THEN   'PRE-LOAD PIXEL ARRAY
                    FIRSTPASS = 0
                    NEOPIXEL = NEO_NUM - 1
NXTPXL:             IF NeoPixel // 6 = 0 THEN		'ORANGE
                        NeoGreen[NeoPixel] = INTENSITY / 2
                        NeoBlue[NeoPixel] = 0
                        NeoRed[NeoPixel] = INTENSITY / 2
                    ELSEIF NeoPixel // 6 = 1 THEN	'GREEN
                        NeoGreen[NeoPixel] = INTENSITY
                        NeoBlue[NeoPixel] = 0
                        NeoRed[NeoPixel] = 0
                    ELSEIF NeoPixel // 6 = 2 THEN	'CYAN
                        NeoGreen[NeoPixel] = INTENSITY / 2
                        NeoBlue[NeoPixel] = INTENSITY / 2
                        NeoRed[NeoPixel] = 0
                    ELSEIF NeoPixel // 6 = 3 THEN	'BLUE
                        NeoGreen[NeoPixel] = 0
                        NeoBlue[NeoPixel] = INTENSITY
                        NeoRed[NeoPixel] = 0
                    ELSEIF NeoPixel // 6 = 4 THEN	'MANGENTA	
                        NeoGreen[NeoPixel] = 0
                        NeoBlue[NeoPixel] = INTENSITY / 2
                        NeoRed[NeoPixel] = INTENSITY / 2
                    ELSEIF NeoPixel // 6 = 5 THEN	'RED
                        NeoGreen[NeoPixel] = 0
                        NeoBlue[NeoPixel] = 0
                        NeoRed[NeoPixel] = INTENSITY
                    ENDIF
                	NEOPIXEL = NEOPIXEL - 1
                	IF NEOPIXEL.15 = 0 THEN NXTPXL
                ENDIF
				GOSUB NeoPixelRotate:	'ROTATE ALL PIXEL COLLUMS FROM RIGHT TO LEFT, IN PREP FOR NEW DATA

				NeoGreen[NEO_NUM - 1] = oldGreen	'replace highest location with lowest for looping
				NeoBlue[NEO_NUM - 1] = oldBlue
				NeoRed[NEO_NUM - 1] = oldRed

				gosub NeoPixelASM64	'PUSH NEW PIXEL DATA TO NEOPIXEL STRING
				GOSUB PAUSDELAY
				
		END SELECT
	UNTIL COWS_HOME		'I DON'T THINK THEY ARE HOME YET?

END
STOP
	
