VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MsComCtl.ocx"
Begin VB.Form MainForm 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "EasyHID Template"
   ClientHeight    =   4650
   ClientLeft      =   5490
   ClientTop       =   4080
   ClientWidth     =   9120
   Icon            =   "FormMain.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4650
   ScaleWidth      =   9120
   ShowInTaskbar   =   0   'False
   StartUpPosition =   2  'CenterScreen
   Begin MSComctlLib.Slider sPWMDuty1 
      Height          =   2175
      Left            =   1920
      TabIndex        =   23
      Top             =   2040
      Width           =   675
      _ExtentX        =   1191
      _ExtentY        =   3836
      _Version        =   393216
      Orientation     =   1
      Max             =   1000
      TickStyle       =   2
      TickFrequency   =   50
   End
   Begin MSComctlLib.ProgressBar pAN1 
      Height          =   255
      Left            =   5280
      TabIndex        =   16
      Top             =   1080
      Width           =   2775
      _ExtentX        =   4895
      _ExtentY        =   450
      _Version        =   393216
      Appearance      =   1
      Max             =   255
   End
   Begin MSComctlLib.ProgressBar pAN0 
      Height          =   255
      Left            =   5280
      TabIndex        =   15
      Top             =   600
      Width           =   2775
      _ExtentX        =   4895
      _ExtentY        =   450
      _Version        =   393216
      Appearance      =   1
      Max             =   255
   End
   Begin VB.CheckBox Check1 
      Caption         =   "B.7"
      Height          =   255
      Index           =   7
      Left            =   600
      TabIndex        =   14
      Top             =   3720
      Width           =   620
   End
   Begin VB.CheckBox Check1 
      Caption         =   "B.6"
      Height          =   255
      Index           =   6
      Left            =   600
      TabIndex        =   13
      Top             =   3480
      Width           =   620
   End
   Begin VB.CheckBox Check1 
      Caption         =   "B.5"
      Height          =   255
      Index           =   5
      Left            =   600
      TabIndex        =   12
      Top             =   3240
      Width           =   620
   End
   Begin VB.CheckBox Check1 
      Caption         =   "B.4"
      Height          =   255
      Index           =   4
      Left            =   600
      TabIndex        =   11
      Top             =   3000
      Width           =   620
   End
   Begin VB.CheckBox Check1 
      Caption         =   "B.3"
      Height          =   255
      Index           =   3
      Left            =   600
      TabIndex        =   10
      Top             =   2760
      Width           =   620
   End
   Begin VB.CheckBox Check1 
      Caption         =   "B.2"
      Height          =   255
      Index           =   2
      Left            =   600
      TabIndex        =   9
      Top             =   2520
      Width           =   620
   End
   Begin VB.CheckBox Check1 
      Caption         =   "B.1"
      Height          =   255
      Index           =   1
      Left            =   600
      TabIndex        =   8
      Top             =   2280
      Width           =   620
   End
   Begin VB.CheckBox Check1 
      Caption         =   "B.0"
      Height          =   255
      Index           =   0
      Left            =   600
      TabIndex        =   7
      Top             =   2040
      Width           =   620
   End
   Begin VB.CommandButton cClearUSBRx 
      Caption         =   "Clear RX"
      Height          =   495
      Left            =   4920
      TabIndex        =   6
      Top             =   3960
      Width           =   1215
   End
   Begin VB.TextBox tUSBRx 
      CausesValidation=   0   'False
      Height          =   2415
      Left            =   6960
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   0
      TabStop         =   0   'False
      Text            =   "FormMain.frx":0442
      Top             =   2040
      Width           =   1695
   End
   Begin MSComctlLib.Slider SPWMDuty2 
      Height          =   2175
      Left            =   3360
      TabIndex        =   25
      Top             =   2040
      Width           =   675
      _ExtentX        =   1191
      _ExtentY        =   3836
      _Version        =   393216
      Orientation     =   1
      Max             =   1000
      TickStyle       =   2
      TickFrequency   =   50
   End
   Begin VB.Label lRXWindow 
      Alignment       =   2  'Center
      Caption         =   "RX window"
      Height          =   255
      Left            =   6960
      TabIndex        =   34
      Top             =   1800
      Width           =   1695
   End
   Begin VB.Label lValAN1 
      Alignment       =   2  'Center
      BorderStyle     =   1  'Fixed Single
      Caption         =   "lValAN1"
      Height          =   255
      Left            =   8040
      TabIndex        =   33
      Top             =   1080
      Width           =   675
   End
   Begin VB.Label lValAN0 
      Alignment       =   2  'Center
      BorderStyle     =   1  'Fixed Single
      Caption         =   "lValAN0"
      Height          =   255
      Left            =   8040
      TabIndex        =   32
      Top             =   600
      Width           =   675
   End
   Begin VB.Label lPWM 
      Alignment       =   2  'Center
      Caption         =   "PWM duty cycle"
      Height          =   255
      Left            =   2280
      TabIndex        =   31
      Top             =   1320
      Width           =   1215
   End
   Begin VB.Label lCCP2 
      Alignment       =   2  'Center
      Caption         =   "CCP2"
      Height          =   255
      Left            =   3000
      TabIndex        =   30
      Top             =   1680
      Width           =   1215
   End
   Begin VB.Label lCCP1 
      Alignment       =   2  'Center
      Caption         =   "CCP1"
      Height          =   255
      Left            =   1560
      TabIndex        =   29
      Top             =   1680
      Width           =   1215
   End
   Begin VB.Label lUSBTx 
      Alignment       =   2  'Center
      Appearance      =   0  'Flat
      BackColor       =   &H0000C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "USB data to the PIC"
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   120
      TabIndex        =   28
      Top             =   840
      Width           =   4005
   End
   Begin VB.Image PORTA3ON 
      Height          =   420
      Left            =   5640
      Picture         =   "FormMain.frx":044B
      Top             =   2160
      Width           =   420
   End
   Begin VB.Label lPORTB 
      Alignment       =   2  'Center
      Caption         =   "PORTB"
      Height          =   255
      Left            =   120
      TabIndex        =   27
      Top             =   1680
      Width           =   1215
   End
   Begin VB.Image PORTA4ON 
      Height          =   420
      Left            =   5640
      Picture         =   "FormMain.frx":05B2
      Top             =   2640
      Width           =   420
   End
   Begin VB.Image PORTA5ON 
      Height          =   420
      Left            =   5640
      Picture         =   "FormMain.frx":0719
      Top             =   3120
      Width           =   420
   End
   Begin VB.Image PORTA2ON 
      Height          =   420
      Left            =   5640
      Picture         =   "FormMain.frx":0880
      Top             =   1680
      Width           =   420
   End
   Begin VB.Label Lport 
      Alignment       =   1  'Right Justify
      Caption         =   "PORTA.5"
      Height          =   255
      Index           =   3
      Left            =   4560
      TabIndex        =   22
      Top             =   3240
      Width           =   855
   End
   Begin VB.Label Lport 
      Alignment       =   1  'Right Justify
      Caption         =   "PORTA.4"
      Height          =   255
      Index           =   2
      Left            =   4560
      TabIndex        =   21
      Top             =   2760
      Width           =   855
   End
   Begin VB.Label Lport 
      Alignment       =   1  'Right Justify
      Caption         =   "PORTA.3"
      Height          =   255
      Index           =   1
      Left            =   4560
      TabIndex        =   20
      Top             =   2280
      Width           =   855
   End
   Begin VB.Label Lport 
      Alignment       =   1  'Right Justify
      Caption         =   "PORTA.2"
      Height          =   255
      Index           =   0
      Left            =   4680
      TabIndex        =   19
      Top             =   1800
      Width           =   735
   End
   Begin VB.Label lAN1 
      Alignment       =   1  'Right Justify
      Caption         =   "AN1"
      Height          =   255
      Left            =   4680
      TabIndex        =   18
      Top             =   1080
      Width           =   375
   End
   Begin VB.Label lAN0 
      Alignment       =   1  'Right Justify
      Caption         =   "AN0"
      Height          =   255
      Left            =   4680
      TabIndex        =   17
      Top             =   600
      Width           =   375
   End
   Begin VB.Label lDuty2 
      Alignment       =   2  'Center
      BorderStyle     =   1  'Fixed Single
      Caption         =   "lDuty2"
      Height          =   255
      Left            =   3330
      TabIndex        =   26
      Top             =   4200
      Width           =   675
   End
   Begin VB.Label lDuty 
      Alignment       =   2  'Center
      BorderStyle     =   1  'Fixed Single
      Caption         =   "lDuty"
      Height          =   255
      Left            =   1890
      TabIndex        =   24
      Top             =   4200
      Width           =   675
   End
   Begin VB.Image PORTA5OFF 
      Height          =   420
      Left            =   5640
      Picture         =   "FormMain.frx":09E7
      Top             =   3120
      Width           =   420
   End
   Begin VB.Image PORTA4OFF 
      Height          =   420
      Left            =   5640
      Picture         =   "FormMain.frx":0B6D
      Top             =   2640
      Width           =   420
   End
   Begin VB.Image PORTA3OFF 
      Height          =   420
      Left            =   5640
      Picture         =   "FormMain.frx":0CF3
      Top             =   2160
      Width           =   420
   End
   Begin VB.Image PORTA2OFF 
      Height          =   420
      Left            =   5640
      Picture         =   "FormMain.frx":0E79
      Top             =   1680
      Width           =   420
   End
   Begin VB.Label lUSBRx 
      Alignment       =   2  'Center
      Appearance      =   0  'Flat
      BackColor       =   &H0000C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "USB data from the PIC"
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   4485
      TabIndex        =   5
      Top             =   120
      Width           =   4485
   End
   Begin VB.Label lProductName 
      Caption         =   "lProductName"
      Height          =   255
      Left            =   2280
      TabIndex        =   4
      Top             =   360
      Width           =   1215
   End
   Begin VB.Label lVendorName 
      Caption         =   "lVendorName"
      Height          =   255
      Left            =   2280
      TabIndex        =   3
      Top             =   120
      Width           =   1215
   End
   Begin VB.Label lpn 
      Caption         =   "ProductName:"
      Height          =   255
      Left            =   1080
      TabIndex        =   2
      Top             =   360
      Width           =   1095
   End
   Begin VB.Label lvn 
      Caption         =   "VendorName:"
      Height          =   255
      Left            =   1080
      TabIndex        =   1
      Top             =   120
      Width           =   1095
   End
   Begin VB.Image imgON 
      Height          =   420
      Left            =   480
      Picture         =   "FormMain.frx":0FFF
      Top             =   120
      Width           =   420
   End
   Begin VB.Image imgOFF 
      Height          =   420
      Left            =   480
      Picture         =   "FormMain.frx":1166
      Top             =   120
      Width           =   420
   End
End
Attribute VB_Name = "MainForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
    '
    '   USBDemo
    '   =======
    '
    '   File name  : USBDemo.vbp
    '   Company    : Mister E
    '   Programmer : Steve Monfette
    '   Date       : December 30,2006
    '
    '
    '   Short and sweet demo to send and read from USB bus and interfacing a PIC18F4550.
    '
    '   The interface allow:
    '       1. Modify status of the target PORTB I/Os using check boxs
    '       2. Modify the PWM duty cycle of the two CCP channels using scroll bars
    '       3. Display status of push-button attach to PORTA<5:2> on 'fake' LEDs
    '       4. Display results of ADC convesion of channel AN<1:0> on progress bars
    '       5. Display incomming text string
    '       6. Display VendorName and ProductName of the target USB device
    '       7. Display the status of the target USB device (online or not) with fake LED
    '
    '   Enjoy!
    '
    '
    Option Explicit
    '
    '   vendor and product IDs
    '   ======================
    Private Const VendorID = 6017
    Private Const ProductID = 2000
    '
    '   In and Out buffers
    '   ==================
    Private Const BufferInSize = 8
    Private Const BufferOutSize = 8
    Dim BufferIn(0 To BufferInSize) As Byte
    Dim BufferOut(0 To BufferOutSize) As Byte

Private Sub cClearUSBRx_Click()
    tUSBRx.Text = ""    ' Clear RX Text box content
End Sub

Private Sub Check1_Click(index As Integer)
    '
    '   Convert PORTB check box to decimal value before sending it
    '   to USB bus.  Result is store in BufferOut(1)
    '
    Dim LoopCheck, PORTB As Byte
    PORTB = 0
    For LoopCheck = 0 To 7
        PORTB = PORTB + (Check1(LoopCheck).Value * (2 ^ LoopCheck))
        Next
    BufferOut(1) = PORTB
    WriteSomeData
End Sub

Private Sub Form_Load()
    '
    '   Unusual to me, but most proprieties have been set at design time...
    '                           sorry :o(
    '
    ConnectToHID (Me.hwnd)          ' connect to HID
    Me.Caption = "Mister E USBDemo" ' Form title
    '
    '   Clear labels and Text boxes
    '   ===========================
    lVendorName.Caption = ""
    lProductName.Caption = ""
    tUSBRx.Text = ""
    lDuty.Caption = "0"
    lDuty2.Caption = "0"
    lValAN0.Caption = "0"
    lValAN1.Caption = "0"
    '
    '   Set initial status of the form LEDs (PORTA buttons and Device connection)
    '   =========================================================================
    imgON.Visible = False       ' Connect/Disconnect LED set of disconnect
    PORTA2ON.Visible = False    ' All PORTA
    PORTA3ON.Visible = False    '   LEDS
    PORTA4ON.Visible = False    '       Set to
    PORTA5ON.Visible = False    '           OFF
    '
    '   Clear BufferOut and send initial data to the USB device
    '   =======================================================
    Dim index As Byte
    For index = 0 To 8          '
        BufferOut(index) = 0    ' set all array to '0'
        Next                    '
        
    WriteSomeData               ' Send initial data (leds off, CCPs duty=0)
End Sub

Private Sub Form_Unload(Cancel As Integer)
    DisconnectFromHID   ' disconnect from the HID controller...
End Sub

Public Sub OnPlugged(ByVal pHandle As Long)
    '
    '   A HID device has been plugged in,
    '   check if it's the right one, and enable the form LED (top left)
    '
    Dim DeviceHandle As Long
    Dim VendorName As String * 15
    Dim ProductName As String * 15
    
    If hidGetVendorID(pHandle) = VendorID And hidGetProductID(pHandle) = ProductID Then ' Good one?
        '
        '   get the device handle
        '   =====================
        DeviceHandle = hidGetHandle(VendorID, ProductID)
        '
        '   Get the vendor and product name from the handle
        '   ===============================================
        hidGetVendorName DeviceHandle, VendorName, 255
        hidGetProductName DeviceHandle, ProductName, 255
        '
        '   Enable the LED and display device information
        '   VendorName and ProductName
        '   =============================================
        imgON.Visible = True
        lVendorName.Caption = VendorName
        lProductName.Caption = ProductName
        End If
End Sub

Public Sub OnUnplugged(ByVal pHandle As Long)
    '
    '   A HID device has been unplugged,
    '   check if it's the right one and clear all related LEDs, Labels, ProgressBar..etc
    '
    If hidGetVendorID(pHandle) = VendorID And hidGetProductID(pHandle) = ProductID Then ' good one?
        lVendorName.Caption = ""
        lProductName.Caption = ""
        imgON.Visible = False
        PORTA2ON.Visible = False
        PORTA3ON.Visible = False
        PORTA4ON.Visible = False
        PORTA5ON.Visible = False
        pAN0.Value = 0
        pAN1.Value = 0
        lValAN0.Caption = "0"
        lValAN1.Caption = "0"
        End If
End Sub

Public Sub OnChanged()
    '
    '   Something happen!
    '   Controller changed notification - called
    '   after ALL HID devices are plugged or unplugged
    '
    '   Get the handle of the device we are interested in, then set
    '   its read notify flag to true - this ensures you get a read
    '   notification message when there is some data to read...
    '
    '   Deuh??? still there?
    '
    Dim DeviceHandle As Long
    DeviceHandle = hidGetHandle(VendorID, ProductID)
    hidSetReadNotify DeviceHandle, True
End Sub

Public Sub OnRead(ByVal pHandle As Long)
    '
    '   There's some incomming data here :o)
    '   read it and have fun.
    '   Don't forget Bufferin(0) is the ReportID
    '
    '   When BufferIn(7) and BufferIn(8) = 0 we receive the PORTA pins
    '   Status and the ADCs value, case else (for now) it's a text string to be display
    '   in the TUSBRx TextBox.
    '
    Dim index As Byte
        
    If hidRead(pHandle, BufferIn(0)) Then   ' valid ReportID?
        If BufferIn(7) = 0 And BufferIn(8) = 0 Then
            '
            '   incomming ADC reading and PORTA status
            '   --------------------------------------
            pAN0.Value = BufferIn(1)            ' Display ADC results to
            pAN1.Value = BufferIn(2)            '     the progress bars
                                                '
            lValAN0.Caption = Val(BufferIn(1))  ' Display Progress bars
            lValAN1.Caption = Val(BufferIn(2))  '     Values
                                                '
            PORTA2ON.Visible = BufferIn(3)      ' Display PORTA
            PORTA3ON.Visible = BufferIn(4)      '     status to
            PORTA4ON.Visible = BufferIn(5)      '         the according
            PORTA5ON.Visible = BufferIn(6)      '             LEDs
            Else
                '
                '   Incomming data is a text string
                '   -------------------------------
                For index = 1 To BufferInSize               ' pass the whole array but skip (0)
                    If Chr(BufferIn(index)) <> 0 Then       ' valid data?
                        tUSBRx.Text = tUSBRx.Text & Chr(BufferIn(index)) ' Yes, send it to the TextBox
                        End If
                    Next
                tUSBRx.Text = (tUSBRx.Text) & vbCr & vbLf   ' point to the next line
                tUSBRx.SelStart = Len(tUSBRx.Text)          ' point to the end... better effect
                                                            '      and avoid to scroll all the time.
            End If
        End If
End Sub

Public Sub WriteSomeData()
    '
    '   Use to send data to the USB bus.
    '   data must be store in BufferOut array
    '
    '   Actual structure:
    '   -----------------
    '       BufferOut(0) = Report id => always 0
    '       BufferOut(1) = PORTB  ' first data item, etc etc
    '       BufferOut(2) = HPWM slider1 MSB
    '       BufferOut(3) = HPWM slider1 LSB
    '       BufferOut(4) = HPWM slider2 MSB
    '       BufferOut(5) = HPWM slider2 LSB
    '       BufferOut(6) = n/a = 0
    '       BufferOut(7) = n/a = 0
    '       BufferOut(8) = n/a = 0
    '
    BufferOut(0) = 0   ' first by is always the report ID
    BufferOut(6) = 0
    BufferOut(7) = 0
    BufferOut(8) = 0

    hidWriteEx VendorID, ProductID, BufferOut(0)    ' send it
End Sub

    '
    '   PWM scroll bar have been moved.  Read the scroll value (0-1000),
    '   split it in 2 bytes, LSB first, store it to the BufferOut array,
    '   display the value at the bottom of the scroll bar, then...
    '   send it to the USB bus.
    '
    '   Structure:
    '   ----------
    '       BufferOut(2) CCP1 LSB
    '       BufferOut(3) CCP1 MSB
    '       BufferOut(4) CCP2 LSB
    '       BufferOut(5) CCP2 MSB
    '
Private Sub sPWMDuty1_Scroll()
    BufferOut(2) = (sPWMDuty1.Value) And 255    ' keep only 8 LSB
    BufferOut(3) = Int(sPWMDuty1.Value / 256)   ' keep only 8 MSB
    lDuty.Caption = sPWMDuty1.Value             ' display it
    WriteSomeData                               ' send it
End Sub

Private Sub SPWMDuty2_Scroll()
    BufferOut(4) = (SPWMDuty2.Value) And 255    ' keep only 8 LSB
    BufferOut(5) = Int(SPWMDuty2.Value / 256)   ' keep only 8 MSB
    lDuty2.Caption = SPWMDuty2.Value            ' display it
    WriteSomeData                               ' send it
End Sub
