;****************************************************************
;*  Name    : RTconfig.inc                                      *
;*  Author  : Darrel Taylor                                     *
;*  Notice  : Copyright (c) 2006 - 2994                         *
;*          : All Rights Relinguished-free-nada-yours to use    *
;*  Date    : 3/28/2006                                         *
;*  Version : 1.0                                               *
;*  Notes   : Allows you to Read and Write to the CONFIG reg's  *
;*          : of an 18F PIC at "Run-Time"                       *
;****************************************************************
;*  Usage   : ReadConfig?CB  _CONFIG3H, tempbyte                *
;*          : ReadConfig?BB   AddrByte, tempbyte                *
;*          : WriteConfig?CB _CONFIG1L, tempbyte                *
;*          : WriteConfig?BB  AddrByte, tempbyte                *
;*          : WriteConfig?CC _CONFIG5L, 0Fh                     *
;*  All Writes, will first read the config reg and test if the  *
;*  existing byte is different. If they are the same, no write  *
;*  to the config register will be executed                     *
;****************************************************************
;*  for more information, see this web page                     *
;*  http://www.picbasic.co.uk/forum/showthread.php?t=4093       *
;****************************************************************

WriteConfigCodeExpanded = 0

    ifndef CFGS
        error "Config.inc - This chip can not access it's own CONFIG regs"
    endif

;-----------------------------------------------------------------------------
ReadConfig?BB  macro  Breg, Bout         ; example Bin value = 5 for _CONFIG3H
        movlw    upper(_CONFIG1H)
        movwf    TBLPTRU, A
        movlw    high(_CONFIG1H)
        movwf    TBLPTRH, A
        movff    Breg, TBLPTRL
        TBLRD*                            ; read the config byte
        movff    TABLAT, Bout
    endm

ReadConfig?CB  macro  Creg, Bout             ; example Creg = _CONFIG3H
        movlw    upper(Creg)
        movwf    TBLPTRU, A
        movlw    high(Creg)
        movwf    TBLPTRH, A
        movlw    low(Creg)
        movwf    TBLPTRL, A
        TBLRD*                            ; read the config byte
        movff    TABLAT, Bout
    endm


;-----------------------------------------------------------------------------
ExpandWriteConfigCode  macro
  local OverWriteConfig
    if (WriteConfigCodeExpanded == 0)
WriteConfigCodeExpanded = 1
        goto     OverWriteConfig          ; skip over the code
WriteConfigCode
        btfsc    INTCON, GIE            ; Save the state of GIE/GIEH
        bsf      PRODH,  7
        btfss    INTCON, GIE
        bcf      PRODH,  7
        btfsc    INTCON, PEIE           ; Save the State of PEIE/GIEL
        bsf      PRODH,  6
        btfss    INTCON, PEIE
        bcf      PRODH,  6
        bcf      INTCON, GIE            ; disable high priority interrupts
        bcf      INTCON, PEIE           ; disable low priority interrupts
      ;---------------------------
        bsf      EECON1, CFGS           ; select config memory
        bsf      EECON1, WREN           ; enable write to memory
        TBLWT*                            ; load the registers
        movlw    55h                      ; unlock write protect
        movwf    EECON2                 ; write 55H
        movlw    0AAh
        movwf    EECON2                 ; write AAH
        bsf      EECON1, WR             ; write the data
        nop
        bcf      EECON1, WREN           ; disable writes
      ;---------------------------
        btfsc    PRODH, 6               ; restore PEIE/GIEL state
        bsf      INTCON, PEIE
        btfss    PRODH, 6
        bcf      INTCON, PEIE

        btfsc    PRODH, 7               ; restore GIE/GIEL state
        bsf      INTCON, GIE
        btfss    PRODH, 7
        bcf      INTCON, GIE
        return
OverWriteConfig
    endif
  endm

;-----------------------------------------------------------------------------
WriteConfig?CB  macro  Creg, Bin
  local   WriteConfigDone                 ; uses PROD as Temp variables
        ExpandWriteConfigCode
        ReadConfig?CB  Creg, PRODL        ; read the current reg value
        movff    Bin, WREG                ; compare it to the new byte (Bin)
        subwf    PRODL,  W
        btfsc    STATUS, Z                ; Is the byte Different...
        goto     WriteConfigDone          ; No, no need to write again, exit
        movff    Bin, TABLAT              ; yes, load the new byte
        call     WriteConfigCode          ; execute the Write
WriteConfigDone
  endm


;--------------------------------
WriteConfig?BB  macro  Breg, Bin
  local   WriteConfigDone
        ExpandWriteConfigCode
        ReadConfig?BB  Breg, PRODL        ; read the current reg value
        movff    Bin, WREG                ; compare it to the new byte (Bin)
        subwf    PRODL,  W
        btfsc    STATUS, Z                ; Is the byte Different...
        goto     WriteConfigDone          ; No, no need to write again, exit
        movff    Bin, TABLAT              ; yes, load the new byte
        call     WriteConfigCode          ; execute the Write
WriteConfigDone
  endm

;--------------------------------
WriteConfig?CC  macro  Creg, Cin
  local   WriteConfigDone
        ExpandWriteConfigCode
        ReadConfig?CB  Creg, PRODL        ; read the current reg value
        movlw    Cin                      ; compare it to the new byte (Cin)
        subwf    PRODL,  W
        btfsc    STATUS, Z                ; Is the byte Different...
        goto     WriteConfigDone          ; No, no need to write again, exit
        movlw    Cin
        movwf    TABLAT                   ; yes, load the new byte
        call     WriteConfigCode          ; execute the Write
WriteConfigDone
  endm

