
; PICBASIC PRO(TM) Compiler 2.60C, (c) 1998, 2011 microEngineering Labs, Inc. All Rights Reserved. 
_USED			EQU	1

	INCLUDE	"E:\PBP\18F4550.INC"


; Define statements.
#define		OSC		 48          
#define		LCD_DREG		      PORTD         
#define		LCD_DBIT		      4             
#define		LCD_RSREG		     PORTE         
#define		LCD_RSBIT		     0             
#define		LCD_EREG		      PORTE         
#define		LCD_EBIT		      1             
#define		LCD_BITS		      4             
#define		LCD_LINES		     2             
#define		LCD_COMMANDUS		 2000          
#define		LCD_DATAUS		    50            
#define		INTHAND		       INT_ENTRY_H  
#define		INTLHAND		      INT_ENTRY_L  
#define		ReEnterHPused		  1

RAM_START       		EQU	00000h
RAM_END         		EQU	007FFh
RAM_BANKS       		EQU	00008h
BANK0_START     		EQU	00060h
BANK0_END       		EQU	000FFh
BANK1_START     		EQU	00100h
BANK1_END       		EQU	001FFh
BANK2_START     		EQU	00200h
BANK2_END       		EQU	002FFh
BANK3_START     		EQU	00300h
BANK3_END       		EQU	003FFh
BANK4_START     		EQU	00400h
BANK4_END       		EQU	004FFh
BANK5_START     		EQU	00500h
BANK5_END       		EQU	005FFh
BANK6_START     		EQU	00600h
BANK6_END       		EQU	006FFh
BANK7_START     		EQU	00700h
BANK7_END       		EQU	007FFh
BANKA_START     		EQU	00000h
BANKA_END       		EQU	0005Fh

FLAGS           		EQU	RAM_START + 000h
R0              		EQU	RAM_START + 001h
R1              		EQU	RAM_START + 003h
R2              		EQU	RAM_START + 005h
R3              		EQU	RAM_START + 007h
R4              		EQU	RAM_START + 009h
R5              		EQU	RAM_START + 00Bh
R6              		EQU	RAM_START + 00Dh
R7              		EQU	RAM_START + 00Fh
R8              		EQU	RAM_START + 011h
T1              		EQU	RAM_START + 013h
GOP             		EQU	RAM_START + 015h
INT_Flags       		EQU	RAM_START + 016h
RM1             		EQU	RAM_START + 017h
RM2             		EQU	RAM_START + 018h
RR1             		EQU	RAM_START + 019h
RR2             		EQU	RAM_START + 01Ah
RS1             		EQU	RAM_START + 01Bh
RS2             		EQU	RAM_START + 01Ch
wsave           		EQU	RAM_START + 01Dh
RetAddrH        		EQU	RAM_START + 01Eh
RetAddrL        		EQU	RAM_START + 021h
PB01            		EQU	RAM_START + 024h
_USBBufferCount  		EQU	RAM_START + 025h
_DataToSend      		EQU	RAM_START + 026h
_String1         		EQU	RAM_START + 02Eh
_USBBufferIn     		EQU	RAM_START + 036h
_USBBufferOut    		EQU	RAM_START + 03Eh
fsave0H         		EQU	RAM_START + 060h
fsave0L         		EQU	RAM_START + 062h
fsave1H         		EQU	RAM_START + 064h
fsave1L         		EQU	RAM_START + 066h
fsave2H         		EQU	RAM_START + 068h
fsave2L         		EQU	RAM_START + 06Ah
bsave           		EQU	RAM_START + 06Ch
psaveH          		EQU	RAM_START + 06Dh
psaveL          		EQU	RAM_START + 06Eh
psaveUH         		EQU	RAM_START + 06Fh
psaveUL         		EQU	RAM_START + 070h
ssave           		EQU	RAM_START + 071h
_HP_Vars         		EQU	RAM_START + 072h
_USBReservedMemory		EQU	RAM_START + 00400h
_R0_SaveH        		EQU	_HP_Vars
_R1_SaveH        		EQU	_HP_Vars + 004h
_R2_SaveH        		EQU	_HP_Vars + 008h
_R3_SaveH        		EQU	_HP_Vars + 00Ch
_R4_SaveH        		EQU	_HP_Vars + 010h
_R5_SaveH        		EQU	_HP_Vars + 012h
_R6_SaveH        		EQU	_HP_Vars + 014h
_R7_SaveH        		EQU	_HP_Vars + 016h
_R8_SaveH        		EQU	_HP_Vars + 018h
_Flag_GOP_H      		EQU	_HP_Vars + 01Ah
_RM_H            		EQU	_HP_Vars + 01Ch
_RR_H            		EQU	_HP_Vars + 01Eh
_RS_H            		EQU	_HP_Vars + 020h
_T1_SaveH        		EQU	_HP_Vars + 022h
_T2_SaveH        		EQU	_HP_Vars + 026h
_T3_SaveH        		EQU	_HP_Vars + 02Ah
_T4_SaveH        		EQU	_HP_Vars + 02Eh
_T5_SaveH        		EQU	_HP_Vars + 032h
_T6_SaveH        		EQU	_HP_Vars + 036h
_T7_SaveH        		EQU	_HP_Vars + 03Ah
_TBLPTRU_H       		EQU	_HP_Vars + 03Eh
_TBLPTR_H        		EQU	_HP_Vars + 040h
_Product_H       		EQU	_HP_Vars + 042h
_PORTL           		EQU	 PORTB
_PORTH           		EQU	 PORTC
_TRISL           		EQU	 TRISB
_TRISH           		EQU	 TRISC
_Flags_SaveH     		EQU	_Flag_GOP_H
_GOP_SaveH       		EQU	_Flag_GOP_H + 001h
_RM1_SaveH       		EQU	_RM_H
_RM2_SaveH       		EQU	_RM_H + 001h
_RR1_SaveH       		EQU	_RR_H
_RR2_SaveH       		EQU	_RR_H + 001h
_RS1_SaveH       		EQU	_RS_H
_RS2_SaveH       		EQU	_RS_H + 001h
_TBLPTRU_SaveH   		EQU	_TBLPTRU_H
_TBLPTRH_SaveH   		EQU	_TBLPTR_H + 001h
_TBLPTRL_SaveH   		EQU	_TBLPTR_H
_Flag_GOP_H??LOWBYTE		EQU	_Flag_GOP_H
_Flag_GOP_H??HIGHBYTE		EQU	_Flag_GOP_H + 001h
_RM_H??LOWBYTE   		EQU	_RM_H
_RM_H??HIGHBYTE  		EQU	_RM_H + 001h
_RR_H??LOWBYTE   		EQU	_RR_H
_RR_H??HIGHBYTE  		EQU	_RR_H + 001h
_RS_H??LOWBYTE   		EQU	_RS_H
_RS_H??HIGHBYTE  		EQU	_RS_H + 001h
_TBLPTRU_H??LOWBYTE		EQU	_TBLPTRU_H
_TBLPTR_H??HIGHBYTE		EQU	_TBLPTR_H + 001h
_TBLPTR_H??LOWBYTE		EQU	_TBLPTR_H
#define _Serviced_H      	_INT_Flags??0
#define _Serviced_L      	_INT_Flags??1
#define _InHPint         	_INT_Flags??2
#define _NoPriority      	_INT_Flags??3
#define _VarsSaved_H     	 PB01, 000h
#define _TMR0IF          	_INTCON??2
#define _TMR0ON          	_T0CON??7
#define _TMR0IE          	_INTCON??5
#define _GoDone          	_ADCON0??1
#define _INT_Flags??0    	 INT_Flags, 000h
#define _INT_Flags??1    	 INT_Flags, 001h
#define _INT_Flags??2    	 INT_Flags, 002h
#define _INT_Flags??3    	 INT_Flags, 003h
#define _INTCON??2       	 INTCON, 002h
#define _T0CON??7        	 T0CON, 007h
#define _INTCON??5       	 INTCON, 005h
#define _ADCON0??1       	 ADCON0, 001h
#define _ADCON0??2       	 ADCON0, 002h
#define _PORTA??2        	 PORTA, 002h
#define _PORTA??3        	 PORTA, 003h
#define _PORTA??4        	 PORTA, 004h
#define _PORTA??5        	 PORTA, 005h
#define _CCP1CON??5      	 CCP1CON, 005h
#define _Duty1??1        	 Duty1, 001h
#define _CCP1CON??4      	 CCP1CON, 004h
#define _Duty1??0        	 Duty1, 000h
#define _CCP2CON??5      	 CCP2CON, 005h
#define _Duty2??1        	 Duty2, 001h
#define _CCP2CON??4      	 CCP2CON, 004h
#define _Duty2??0        	 Duty2, 000h

; Constants.
_USBMEMORYADDRESS		EQU	00400h
_USBMEMORYSIZE   		EQU	00100h
_USBBufferSizeTX 		EQU	00008h
_USBBufferSizeRX 		EQU	00008h

; EEPROM data.


	INCLUDE	"USBDEMO.MAC"
	INCLUDE	"E:\PBP\PBPPIC18.LIB"


	ASM?
   __CONFIG   _CONFIG1L, _PLLDIV_5_1L & _CPUDIV_OSC1_PLL2_1L & _USBDIV_2_1L

	ENDASM?


	ASM?
   __CONFIG   _CONFIG1H, _FOSC_HSPLL_HS_1H

	ENDASM?


	ASM?
   __CONFIG   _CONFIG2L, _PWRT_OFF_2L & _BOR_ON_2L & _VREGEN_OFF_2L

	ENDASM?


	ASM?
   __CONFIG   _CONFIG2H, _WDT_ON_2H & _WDTPS_512_2H

	ENDASM?


	ASM?
   __CONFIG   _CONFIG3H, _CCP2MX_ON_3H & _PBADEN_OFF_3H & _LPT1OSC_OFF_3H & _MCLRE_ON_3H

	ENDASM?


	ASM?
   __CONFIG   _CONFIG4L, _STVREN_ON_4L & _LVP_OFF_4L & _ICPRT_OFF_4L & _XINST_OFF_4L

	ENDASM?

	GOTO?L	_hid_desc_end

	ASM?


#define USB_EP0_BUFF_SIZE	8	; 8, 16, 32, or 64
#define USB_MAX_NUM_INT		1
#define USB_MAX_EP_NUMBER	1
#define NUM_CONFIGURATIONS	1
#define NUM_INTERFACES		1

#define UCFG_VAL	USB_PULLUP_ENABLE|USB_INTERNAL_TRANSCEIVER|USB_FULL_SPEED|USB_PING_PONG__NO_PING_PONG
;#define UCFG_VAL	USB_PULLUP_ENABLE|USB_INTERNAL_TRANSCEIVER|USB_LOW_SPEED|USB_PING_PONG__NO_PING_PONG

;#define USE_SELF_POWER_SENSE_IO
;#define USE_USB_BUS_SENSE_IO

#define USB_POLLING

; HID
; Endpoints Allocation
#define HID_INTF_ID		0x00
#define HID_EP			1
#define HID_INT_OUT_EP_SIZE	8
#define HID_INT_IN_EP_SIZE	8
#define HID_NUM_OF_DSC		1

	include	"usb_hid.asm"	; Include rest of USB files, starting with HID class code

; ******************************************************************
; This table is polled by the host immediately after USB Reset has been released.
; This table defines the maximum packet size EP0 can take.
; See section 9.6.1 of the Rev 1.0 USB specification.
; These fields are application DEPENDENT. Modify these to meet
; your specifications.
; ******************************************************************
DeviceDescriptor
	retlw	(EndDeviceDescriptor-DeviceDescriptor)/2	; Size of this descriptor in bytes
	retlw	USB_DESCRIPTOR_DEVICE	; DEVICE descriptor type
	retlw	0x10		; USB Spec Release Number in BCD format - 1.10 (low byte)
	retlw	0x01		; (high byte)
	retlw	0x00		; Class Code
	retlw	0x00		; Subclass code
	retlw	0x00		; Protocol code
	retlw	USB_EP0_BUFF_SIZE	; Max packet size for EP0
	retlw	0x81		; Vendor ID (low byte)
	retlw	0x17		; (high byte)
	retlw	0xD0		; Product ID: Jan Axelson demo (low byte)
	retlw	0x07		; (high byte)
	retlw	0x01		; Device release number in BCD format (low byte)
	retlw	0x00		; (high byte)
	retlw	0x01		; Manufacturer string index
	retlw	0x02		; Product string index
	retlw	0x00		; Device serial number string index
	retlw	NUM_CONFIGURATIONS	; Number of possible configurations
EndDeviceDescriptor

; ******************************************************************
; This table is retrieved by the host after the address has been set.
; This table defines the configurations available for the device.
; See section 9.6.2 of the Rev 1.0 USB specification (page 184).
; These fields are application DEPENDENT. 
; Modify these to meet your specifications.
; ******************************************************************
; Configuration pointer table
USB_CD_Ptr
Configs
	db	low Config1, high Config1
	db	upper Config1, 0

; Configuration Descriptor
Config1
	retlw	(Interface1-Config1)/2	; Size of this descriptor in bytes
	retlw	USB_DESCRIPTOR_CONFIGURATION	; CONFIGURATION descriptor type
Config1Len
	retlw	low ((EndConfig1-Config1)/2)	; Total length of data for this cfg
	retlw	high ((EndConfig1-Config1)/2)
	retlw	NUM_INTERFACES	; Number of interfaces in this cfg
	retlw	0x01		; Index value of this configuration
	retlw	0x00		; Configuration string index
	retlw	_DEFAULT|_SELF	; Attributes
	retlw	50		; Max power consumption (2X mA)
Interface1
	retlw	(HIDDescriptor1-Interface1)/2	; Size of this descriptor in bytes
	retlw	USB_DESCRIPTOR_INTERFACE	; INTERFACE descriptor type
	retlw	0x00		; Interface Number
	retlw	0x00		; Alternate Setting Number
	retlw	0x02		; Number of endpoints in this intf
	retlw	HID_INTF	; Class code
	retlw	0x00		; Subclass code
	retlw	0x00		; Protocol code
	retlw	0x00		; Interface string index
HIDDescriptor1
	retlw	(Endpoint1Out-HIDDescriptor1)/2	; Size of this descriptor in bytes
	retlw	DSC_HID		; HID descriptor type
	retlw	0x11		; HID Spec Release Number in BCD format - 1.11 (low byte)
	retlw	0x01		; (high byte)
	retlw	0x00		; Country Code (0x00 for Not supported)
	retlw	HID_NUM_OF_DSC	; Number of class descriptors
	retlw	DSC_RPT		; Report descriptor type (HID)
ReportDescriptor1Len
	retlw	low ((EndReportDescriptor1-ReportDescriptor1)/2)
	retlw	high ((EndReportDescriptor1-ReportDescriptor1)/2)
Endpoint1Out
	retlw	(Endpoint1In-Endpoint1Out)/2		; Size of this descriptor in bytes
	retlw	USB_DESCRIPTOR_ENDPOINT	; ENDPOINT descriptor type
	retlw	HID_EP|_EP_OUT	; Endpoint Address
	retlw	_INT		; Attributes
	retlw	low (HID_INT_OUT_EP_SIZE)	; Size of the endpoint buffer in bytes (low byte)
	retlw	high (HID_INT_OUT_EP_SIZE)	; (high byte)
	retlw	0x0A		; Polling interval (10ms)
Endpoint1In
	retlw	(EndConfig1-Endpoint1In)/2	; Size of this descriptor in bytes
	retlw	USB_DESCRIPTOR_ENDPOINT	; ENDPOINT descriptor type
	retlw	HID_EP|_EP_IN	; Endpoint Address
	retlw	_INT		; Attributes
	retlw	low (HID_INT_IN_EP_SIZE)	; Size of the endpoint buffer in bytes (low byte)
	retlw	high (HID_INT_IN_EP_SIZE)	; (high byte)
	retlw	0x0A		; Polling interval (10ms)
EndConfig1

ReportDescriptor1
        retlw	0x06		; usage page (Vendor Defined)
	retlw	0xA0
        retlw	0xFF
	retlw	0x09		; usage (Vendor Defined)
        retlw	0x01
	retlw	0xA1		; collection (application)
        retlw	0x01
	retlw	0x09		; usage (Vendor Defined)
        retlw	0x02
	retlw	0xA1		; collection (linked)
        retlw	0x00
	retlw	0x06		; usage page (buttons)
        retlw	0xa1
	retlw	0xFF
	retlw	0x09		; usage vendor defined
        retlw	0x03
	retlw	0x09		; usage vendor defined
        retlw	0x04
	retlw	0x15		; logical minimum (-128)
        retlw	0x80
	retlw	0x25		; logical maximum (127)
        retlw	0x7F
	retlw	0x35		; Physical Minimum (0)
        retlw	0x00
	retlw	0x45		; Physical Maximum (255)
        retlw	0xFF
        retlw	0x75		; report size (8) (bits)
	retlw	0x08
        retlw	0x95		; report count (2) (fields)
	retlw	0x08 ; 0x02
        retlw	0x81		; input (Data, Variable, Absolute)
	retlw	0x02
        retlw	0x09		; usage (Vendor Defined)
	retlw	0x05
        retlw	0x09		; useage (Vendor Defined)
	retlw	0x06
	retlw	0x15		; logical minimum (-128)
	retlw	0x80
        retlw	0x25		; logical maximum (127)
	retlw	0x7F
        retlw	0x35		; Physical Minimum (0)
	retlw	0x00
        retlw	0x45		; Physical Maximum (255)
	retlw	0xFF
        retlw	0x75		; report size (8) (bits)
	retlw	0x08
        retlw	0x95		; report Count (2) (fields)
	retlw	0x08 ; 0x02
        retlw	0x91		; Output (Data, Variable, Absolute)
	retlw	0x02
	retlw   0xC0		; end collection
	retlw   0xC0		; end collection
EndReportDescriptor1

; String pointer table
USB_SD_Ptr
Strings
	db	low String0, high String0
	db	upper String0, 0
	db	low String1, high String1
	db	upper String1, 0
	db	low String2, high String2
	db	upper String2, 0

; Language code string descriptor
String0
	retlw   (String1-String0)/2	; Size of this descriptor in bytes
	retlw   USB_DESCRIPTOR_STRING	; STRING descriptor type
	retlw   0x09		; Language ID as defined by MS - 0x0409 (low byte)
	retlw   0x04		; (high byte)

; Manufacturer string descriptor
String1
	retlw   (String2-String1)/2	; Size of this descriptor in bytes
	retlw   USB_DESCRIPTOR_STRING	; STRING descriptor type
        retlw   'M'
        retlw   0x00
        retlw   'i'
        retlw   0x00
        retlw   's'
        retlw   0x00
        retlw   't'
        retlw   0x00
        retlw   'e'
        retlw   0x00
        retlw   'r'
        retlw   0x00
        retlw   ' '
        retlw   0x00
        retlw   'E'
        retlw   0x00

; Product string descriptor
String2
	retlw   (EndStringDescriptors-String2)/2	; Size of this descriptor in bytes
	retlw   USB_DESCRIPTOR_STRING	; STRING descriptor type
        retlw   'U'
        retlw   0x00
        retlw   'S'
        retlw   0x00
        retlw   'B'
        retlw   0x00
        retlw   'D'
        retlw   0x00
        retlw   'e'
        retlw   0x00
        retlw   'm'
        retlw   0x00
        retlw   'o'
        retlw   0x00
EndStringDescriptors

	

	ENDASM?


	LABEL?L	_hid_desc_end	
	MOVE?CB	00Fh, TRISB
	MOVE?CB	000h, TRISD
	MOVE?CB	000h, TRISE
	MOVE?CB	084h, INTCON2
	PAUSE?C	003E8h
	LCDOUT?C	0FEh
	LCDOUT?C	001h
	LCDOUT?C	04Ch
	LCDOUT?C	061h
	LCDOUT?C	062h
	LCDOUT?C	02Dh
	LCDOUT?C	058h
	LCDOUT?C	031h
	LCDOUT?C	020h
	LCDOUT?C	055h
	LCDOUT?C	053h
	LCDOUT?C	042h
	LCDOUT?C	064h
	LCDOUT?C	065h
	LCDOUT?C	06Dh
	LCDOUT?C	06Fh
	LCDOUT?C	020h
	LCDOUT?C	076h
	LCDOUT?C	032h
	LCDOUT?C	02Eh
	LCDOUT?C	036h
	LCDOUT?C	030h
	DDISABLE?	
	MOVE?CB	000h, INT_Flags
	GOTO?L	_OVER_DT_INTS_18

	ASM?

;____ Check for PBPL (PBP ver. 2.50 and above only)__________________________
PBPLongs_Used = 0
  if (R1 - R0 == 4)
PBPLongs_Used = 1
;    messg PBPL Used = 1
  endif

  nolist
;____ DEFINE available interrupt sources_____________________________________

  #define INT_INT   INTCON, INT0IF  ;-- INT External, 16F compatible
  #define INT0_INT  INTCON, INT0IF  ;-- INT0 External 
  #define INT1_INT  INTCON3,INT1IF  ;-- INT1 External 
  #define INT2_INT  INTCON3,INT2IF  ;-- INT2 External 
  #define INT3_INT  INTCON3,INT3IF  ;-- INT3 External 
  #define RBC_INT   INTCON, RBIF    ;-- RB Port Change 
  #define TMR0_INT  INTCON, TMR0IF  ;-- TMR0 Overflow  18F
  #define TMR1_INT  PIR1, TMR1IF    ;-- TMR1 Overflow 
  #define TMR2_INT  PIR1, TMR2IF    ;-- TMR2 to PR2 Match 
  #define TMR3_INT  PIR2, TMR3IF    ;-- TMR3 Overflow 
  #define TMR4_INT  PIR3, TMR4IF    ;-- TMR4 Overflow 
  #define TX_INT    PIR1, TXIF      ;-- USART Transmit 
  #define TX1_INT   PIR1, TX1IF     ;-- USART1 Transmit 
  #define TX2_INT   PIR3, TX2IF     ;-- USART2 Transmit 
  #define RX_INT    PIR1, RCIF      ;-- USART Receive 
  #define RX1_INT   PIR1, RC1IF     ;-- USART1 Receive 
  #define RX2_INT   PIR3, RC2IF     ;-- USART2 Receive 
  #define CMP_INT   PIR2, CMIF      ;-- Comparator 
  #define EE_INT    PIR2, EEIF      ;-- EEPROM/FLASH Write Operation 
  #define BUS_INT   PIR2, BCLIF     ;-- Bus Collision 
  #define LVD_INT   PIR2, LVDIF     ;-- Low Voltage Detect 
  #define HLVD_INT  PIR2, HLVDIF    ;-- High/Low Voltage Detect 
  #define PSP_INT   PIR1, PSPIF     ;-- Parallel Slave Port Read/Write 
  #define AD_INT    PIR1, ADIF      ;-- A/D Converter 
  #define SSP_INT   PIR1, SSPIF     ;-- Master Synchronous Serial Port 
  #define CCP1_INT  PIR1, CCP1IF    ;-- CCP1 
  #define CCP2_INT  PIR2, CCP2IF    ;-- CCP2 
  #define CCP3_INT  PIR3, CCP3IF    ;-- CCP3 
  #define CCP4_INT  PIR3, CCP4IF    ;-- CCP4 
  #define CCP5_INT  PIR3, CCP5IF    ;-- CCP5 
  #define OSC_INT   PIR2, OSCFIF    ;-- Oscillator Fail 

; -- Added for ver. 3.2 --
  #define SPP_INT   PIR1, SPPIF     ;-- Streaming Parallel Port Read/Write
  #define BUS1_INT  PIR2, BCL1IF    ;-- Bus 1 Collision 
  #define BUS2_INT  PIR3, BCL2IF    ;-- Bus 2 Collision
  #define ECCP1_INT PIR2, ECCP1IF   ;-- ECCP1
  #define LCD_INT   PIR3, LCDIF     ;-- LCD Driver
  #define PMP_INT   PIR1, PMPIF     ;-- Parallel Master Port
  #define SSP1_INT  PIR1, SSP1IF    ;-- Synchronous Serial Port 1
  #define SSP2_INT  PIR3, SSP2IF    ;-- Synchronous Serial Port 2
  #define TMR5_INT  PIR3, TMR5IF    ;-- Timer 5
  #define PT_INT    PIR3, PTIF      ;-- PWM Time Base
  #define IC1IF_INT  PIR3, IC1IF    ;-- Motion Feedback
  #define IC2QEIF_INT  PIR3, IC2QEIF  ;-- Motion Feedback
  #define IC3DRIF_INT  PIR3, IC3DRIF  ;-- Motion Feedback

;_____ Comparators __________________________________________________________
  #define CMP0_INT  PIR1, CMP0IF    ;-- Comparator 0 - 1230/1330 only

CMPIFREG = PIR2                     ;-- Comparator 1
CMPIEREG = PIE2
CMPIPREG = IPR2
    ifdef C1IF                      ;     18F24K20  18F25K20  18F26K20
CM1IFBIT = C1IF                     ;     18F44K20  18F45K20  18F46K20
    endif
    ifdef CM1IF
CM1IFBIT = CM1IF                    ;     several J PICs
    endif
    ifdef CMP1IF
CMPIFREG = PIR1                     ;     1230/1330 only
CM1IFBIT = CMP1IF
CMPIEREG = PIE1
CMPIPREG = IPR1
    endif

    ifdef CM1IFBIT
       #define CMP1_INT  CMPIFREG, CM1IFBIT     
    endif

    ifdef C2IF                      ;-- Comparator 2
CM2IFBIT = C2IF                     ;     18F24K20  18F25K20  18F26K20
    endif                           ;     18F44K20  18F45K20  18F46K20
    ifdef CM2IF
CM2IFBIT = CM2IF                    ;     several J PICs
    endif    
    ifdef CMP2IF
CM2IFBIT = CMP2IF                   ;     1230/1330 only
    endif    

    ifdef CM2IFBIT
      #define CMP2_INT  CMPIFREG, CM2IFBIT     
    endif

;_____ USB Module ___________________________________________________________

  #define USB_INT       PIR2, USBIF   ;-- USB Interrupt (funnel)
  #define USB_ACTV_INT  UIR,  ACTVIF  ;-- Bus Activity Detect 
  #define USB_ERR_INT   UIR,  UERRIF  ;-- USB Error Condition INT (funnel)
  #define USB_RST_INT   UIR,  URSTIF  ;-- USB Reset 
  #define USB_IDLE_INT  UIR,  IDLEIF  ;-- Idle Detect 
  #define USB_STALL_INT UIR,  STALLIF ;-- A STALL Handshake 
  #define USB_TRN_INT   UIR,  TRNIF   ;-- Transaction Complete 
  #define USB_SOF_INT   UIR,  SOFIF   ;-- START-OF-FRAME Token 

; -- USB Error Flags --
  #define USB_BTO_INT   UEIR, BTOEF   ;-- Bus Turnaround Time-out Error
  #define USB_BTS_INT   UEIR, BTSEF   ;-- Bit Stuff Error
  #define USB_CRC16_INT UEIR, CRC16EF ;-- CRC16 Failure
  #define USB_CRC5_INT  UEIR, CRC5EF  ;-- CRC5 Host Error
  #define USB_DFN8_INT  UEIR, DFN8EF  ;-- Data Field Size Error
  #define USB_PID_INT   UEIR, PIDEF   ;-- PID Check Failure
   
;_____ Ethernet Module ______________________________________________________
  #define ETH_INT       PIR2, ETHIF   ;-- Ethernet Module
  #define ETH_DMA_INT    EIR, DMAIF   ;-- DMA Interrupt
  #define ETH_LINK_INT   EIR, LINKIF  ;-- Link Status Change
  #define ETH_PKT_INT    EIR, PKTIF   ;-- Receive Packet Pending
  #define ETH_RXER_INT   EIR, RXERIF  ;-- Receive Error
  #define ETH_TXER_INT   EIR, TXERIF  ;-- Transmit Error
  #define ETH_TX_INT     EIR, TXIF    ;-- Transmit

;_____ CAN Module ___________________________________________________________
  #define CAN_ERR_INT    PIR3, ERRIF    ;-- CAN bus Error
  #define CAN_IRX_INT    PIR3, IRXIF    ;-- Invalid Received Message
  #define CAN_RXB0_INT   PIR3, RXB0IF   ;-* Receive Buffer 0      Mode 0
  #define CAN_FIFOWM_INT PIR3, FIFOWMIF ;-- FIFO Watermark        Mode 1, 2
  #define CAN_RXB1_INT   PIR3, RXB1IF   ;-* Receive Buffer 1      Mode 0
  #define CAN_RXBn_INT   PIR3, RXBnIF   ;-- Any Receive Buffer    Mode 1, 2
  #define CAN_TXB0_INT   PIR3, TXB0IF   ;-- Transmit Buffer 0
  #define CAN_TXB1_INT   PIR3, TXB1IF   ;-- Transmit Buffer 1
  #define CAN_TXB2_INT   PIR3, TXB2IF   ;-* Transmit Buffer 2     Mode 0
  #define CAN_TXBn_INT   PIR3, TXBnIF   ;-- Any Transmit Buffer   Mode 1, 2
  #define CAN_WAKE_INT   PIR3, WAKIF    ;-- CAN bus Activity Wake-up


	ENDASM?


	ASM?

; -- macro --
INT_Source  macro  IFR, IFB, IER, IEB, IPR, IPB
    if (IflagReg == IFR) && (IflagBit == IFB)  
  list  
INT_Flag_Reg = IFR
INT_Flag_Bit = IFB
INT_Enable_Reg = IER
INT_Enable_Bit = IEB
INT_Priority_Reg = IPR
INT_Priority_Bit = IPB
Found = 1
    endif
  nolist  
    endm 


	ENDASM?


	ASM?

;____________________________________________________________________________
GetIntInfo  macro  IflagReg, IflagBit
  nolist
INT_Flag_Reg = -1
INT_Flag_Bit = -1
INT_Enable_Reg = -1
INT_Enable_Bit = -1
  ifdef  IPR1
INT_Priority_Reg = -1
INT_Priority_Bit = -1
  endif
Found = 0

  ifdef INT0IF  ;----{ INT0 External Interrupt }----------[INTCON, INT0IF]---
      INT_Source  INTCON,INT0IF, INTCON,INT0IE, -1, -1
  endif
  ifdef INT1IF  ;----{ INT1 External Interrupt }---------[INTCON3, INT1IF]---
      INT_Source  INTCON3,INT1IF, INTCON3,INT1IE, INTCON3,INT1IP
  endif
  ifdef INT2IF  ;----{ INT2 External Interrupt }---------[INTCON3, INT2IF]---
      INT_Source  INTCON3,INT2IF, INTCON3,INT2IE, INTCON3,INT2IP
  endif
  ifdef INT3IF  ;----{ INT3 External Interrupt }---------[INTCON3, INT3IF]---
      INT_Source  INTCON3,INT3IF, INTCON3,INT3IE, INTCON2,INT3IP
  endif
  ifdef RBIF    ;----{ RB Port Change Interrupt }-----------[INTCON, RBIF]---
      INT_Source  INTCON,RBIF, INTCON, RBIE,INTCON2,RBIP
  endif
  ifdef TMR0IF  ;----{ TMR0 Overflow Interrupt }----------[INTCON, TMR0IF]---
      INT_Source  INTCON,TMR0IF, INTCON,TMR0IE, INTCON2,TMR0IP
  endif
  ifdef TMR1IF  ;----{ TMR1 Overflow Interrupt }------------[PIR1, TMR1IF]---
      INT_Source  PIR1,TMR1IF, PIE1,TMR1IE, IPR1,TMR1IP
  endif
  ifdef TMR2IF  ;----{ TMR2 to PR2 Match Interrupt }--------[PIR1, TMR2IF]---
      INT_Source  PIR1,TMR2IF, PIE1,TMR2IE, IPR1,TMR2IP
  endif
  ifdef TMR3IF  ;----{ TMR3 Overflow Interrupt }------------[PIR2, TMR3IF]---
      INT_Source  PIR2,TMR3IF, PIE2,TMR3IE, IPR2,TMR3IP
  endif
  ifdef TMR4IF  ;----{ TMR4 Overflow Interrupt }------------[PIR3, TMR4IF]---
      INT_Source  PIR3,TMR4IF, PIE3,TMR4IE, IPR3,TMR4IP
  endif
  ifndef TX1IF  ;----{ USART Transmit Interrupt }-------------[PIR1, TXIF]---
      ifdef TXIF
          INT_Source  PIR1,TXIF, PIE1,TXIE, IPR1,TXIP
      endif
  endif
  ifdef TX1IF   ;----{ USART1 Transmit Interrupt }-----------[PIR1, TX1IF]---
      INT_Source  PIR1,TX1IF, PIE1,TX1IE, IPR1,TX1IP
  endif
  ifdef TX2IF   ;----{ USART2 Transmit Interrupt }-----------[PIR3, TX2IF]---
      INT_Source  PIR3,TX2IF, PIE3,TX2IE, IPR3,TX2IP
  endif
  ifndef RC1IF  ;----{ USART Receive Interrupt }---------------[PIR1 RCIF]---  
    ifdef RCIF
        INT_Source  PIR1,RCIF, PIE1,RCIE, IPR1,RCIP
    endif
  endif
  ifdef RC1IF   ;----{ USART1 Receive Interrupt }------------[PIR1, RC1IF]---
      INT_Source  PIR1,RC1IF, PIE1,RC1IE, IPR1,RC1IP
  endif
  ifdef RC2IF   ;----{ USART2 Receive Interrupt }------------[PIR3, RC2IF]---
      INT_Source  PIR3,RC2IF, PIE3,RC2IE, IPR3,RC2IP
  endif
  ifdef CMIF    ;----{ Comparator Interrupt }-----------------[PIR2, CMIF]---
      INT_Source  PIR2,CMIF, PIE2,CMIE, IPR2,CMIP
  endif
  ifdef EEIF    ;----{ EEPROM/FLASH Write Operation Interrupt [PIR2, EEIF]---
      INT_Source  PIR2,EEIF, PIE2,EEIE, IPR2,EEIP
  endif
  ifdef BCLIF   ;----{ Bus Collision Interrupt }-------------[PIR2, BCLIF]---
      INT_Source  PIR2,BCLIF, PIE2,BCLIE, IPR2,BCLIP
  endif
  ifdef LVDIF   ;----{ Low Voltage Detect Interrupt }--------[PIR2, LVDIF]---
      INT_Source  PIR2,LVDIF, PIE2,LVDIE, IPR2,LVDIP
  endif
  ifdef HLVDIF  ;----{ High/Low Voltage Detect Interrupt }--[PIR2, HLVDIF]---
      INT_Source  PIR2,HLVDIF, PIE2,HLVDIE, IPR2,HLVDIP
  endif
  ifdef PSPIF   ;----{ Parallel Slave Port Interrupt }-------[PIR1, PSPIF]---
      INT_Source  PIR1,PSPIF, PIE1,PSPIE, IPR1,PSPIP
  endif
  ifdef ADIF    ;----{ A/D Converter Interrupt }--------------[PIR1, ADIF]---
      INT_Source  PIR1,ADIF, PIE1,ADIE, IPR1,ADIP
  endif
  ifdef SSPIF   ;----{ Synchronous Serial Port Interrupt }---[PIR1, SSPIF]---
      INT_Source  PIR1,SSPIF, PIE1,SSPIE, IPR1,SSPIP
  endif
  ifdef CCP1IF  ;----{ CCP1 Interrupt }---------------------[PIR1, CCP1IF]---
      INT_Source  PIR1,CCP1IF, PIE1,CCP1IE, IPR1,CCP1IP
  endif
  ifdef CCP2IF  ;----{ CCP2 Interrupt Flag }----------------[PIR2, CCP2IF]---
      INT_Source  PIR2,CCP2IF, PIE2,CCP2IE, IPR2,CCP2IP
  endif
  ifdef CCP3IF  ;----{ CCP3 Interrupt Flag }----------------[PIR3, CCP3IF]---
      INT_Source  PIR3,CCP3IF, PIE3,CCP3IE, IPR3,CCP3IP
  endif
  ifdef CCP4IF  ;----{ CCP4 Interrupt Flag }----------------[PIR3, CCP4IF]---
      INT_Source  PIR3,CCP4IF, PIE3,CCP4IE, IPR3,CCP4IP
  endif
  ifdef CCP5IF  ;----{ CCP5 Interrupt Flag }----------------[PIR3, CCP5IF]---
      INT_Source  PIR3,CCP5IF, PIE3,CCP5IE, IPR3,CCP5IP
  endif
  ifdef OSCFIF  ;----{ Osc Fail  Interrupt Flag }-----------[PIR2, OSCFIF]---
      INT_Source  PIR2,OSCFIF, PIE2,OSCFIE, IPR2,OSCFIP
  endif


	ENDASM?


	ASM?

; -- Added for ver. 3.2 --
  ifdef SPPIF   ;----{ Streaming Parallel Port Read/Write }--[PIR1, SPPIF]---
      INT_Source  PIR1,SPPIF, PIE1,SPPIE, IPR1,SPPIP
  endif
  ifdef BCL1IF  ;----{ Bus 1 Collision }--------------------[PIR2, BCL1IF]---
      INT_Source  BUS1_INT, PIE2,BCL1IE, IPR2,BCL1IP
  endif
  ifdef BCL2IF  ;----{ Bus 2 Collision }--------------------[PIR3, BCL2IF]---
      INT_Source  BUS2_INT, PIE3,BCL2IE, IPR3,BCL2IP
  endif
  ifdef CMP0IF  ;----{ Comparator 0 }-----------------------[PIR1, CMP0IF]---
      INT_Source  CMP0_INT, PIE1,CMP0IE, IPR1,CMP0IP
  endif
  ifdef CM1IFBIT  ;--{ Comparator 1 }-----------------------------[varies]---
      INT_Source  CMP1_INT, CMPIEREG,CM1IFBIT, CMPIPREG,CM1IFBIT
  endif
  ifdef CM2IFBIT  ;--{ Comparator 2 }-----------------------------[varies]---
      INT_Source  CMP2_INT, CMPIEREG,CM2IFBIT, CMPIPREG,CM2IFBIT
  endif
  ifdef ECCP1IF  ;---{ ECCP1 }-----------------------------[PIR2, ECCP1IF]---
      INT_Source  ECCP1_INT, PIE2,ECCP1IE, IPR2,ECCP1IP
  endif
  ifdef LCDIF   ;----{ LCD Driver }--------------------------[PIR3, LCDIF]---
      INT_Source  LCD_INT, PIE3,LCDIE, IPR3,LCDIP
  endif
  ifdef PMPIF   ;----{ Parallel Master Port }----------------[PIR1, PMPIF]---
      INT_Source  PMP_INT, PIE1,PMPIE, IPR1,PMPIP
  endif
  ifdef SSP1IF  ;----{ Synchronous Serial Port 1 }----------[PIR1, SSP1IF]---
      INT_Source  SSP1_INT, PIE1,SSP1IE, IPR1,SSP1IP
  endif
  ifdef SSP2IF  ;----{ Synchronous Serial Port 2 }----------[PIR3, SSP2IF]---
      INT_Source  SSP2_INT, PIE3,SSP2IE, IPR3,SSP2IP
  endif
  ifdef TMR5IF  ;----{ Timer 5 }----------------------------[PIR3, TMR5IF]---
      INT_Source  TMR5_INT, PIE3,TMR5IE, IPR3,TMR5IP
  endif
  ifdef PTIF    ;----{ PWM Time Base }------------------------[PIR3, PTIF]---
      INT_Source  PT_INT, PIE3,PTIE, IPR3,PTIP
  endif
  ifdef IC1IF   ;----{ Motion Feedback IC1}------------------[PIR3, IC1IF]---
      INT_Source  IC1IF_INT, PIE3,IC1IE, IPR3,IC1IP
  endif
  ifdef IC2QEIF ;----{ Motion Feedback IC2QE}--------------[PIR3, IC2QEIF]---
      INT_Source  IC2QEIF_INT, PIE3,IC2QEIE, IPR3,IC2QEIP
  endif
  ifdef IC3DRIF ;----{ Motion Feedback IC3DR}--------------[PIR3, IC3DRIF]---
      INT_Source  IC3DRIF_INT, PIE3,IC3DRIE, IPR3,IC3DRIP
  endif
  
;  ifdef   ;----{  }-------------[, ]---
;      INT_Source  , ,, ,
;  endif


	ENDASM?


	ASM?
  ; -- USB sources --
  ifdef USBIF   ;----{ USB  Interrupt funnel }---------------[PIR2, USBIF]---
      INT_Source  PIR2,USBIF, PIE2,USBIE, IPR2,USBIP
          
                ;----{ Bus Activity Detect }-----------------[UIR, ACTVIF]---
      INT_Source  USB_ACTV_INT, UIE,ACTVIE, _NoPriority
  
                ;----{ USB Reset }---------------------------[UIR, URSTIF]---
      INT_Source  USB_RST_INT, UIE,URSTIE, _NoPriority
  
                ;----{ Idle Detect }-------------------------[UIR, IDLEIF]---
      INT_Source  USB_IDLE_INT, UIE,IDLEIE, _NoPriority
  
                ;----{ A STALL Handshake }------------------[UIR, STALLIF]---
      INT_Source  USB_STALL_INT, UIE,STALLIE, _NoPriority
  
                ;----{ Transaction Complete }-----------------[UIR, TRNIF]---
      INT_Source  USB_TRN_INT, UIE,TRNIE, _NoPriority
  
                ;----{ START-OF-FRAME Token }-----------------[UIR, SOFIF]---
      INT_Source  USB_SOF_INT, UIE,SOFIE, _NoPriority
  
; -- USB Error Flags --
                ;----{ USB Error Condition Int funnel }------[UIR, UERRIF]---
      INT_Source  USB_ERR_INT, UIE,UERRIE, _NoPriority
   
                ;----{ Bus Turnaround Time-out Error }-------[UEIR, BTOEF]---
      INT_Source  USB_BTO_INT, UEIE,BTOEE, _NoPriority
   
                ;----{ Bit Stuff Error }---------------------[UEIR, BTSEF]---
      INT_Source  USB_BTS_INT, UEIE,BTSEE, _NoPriority
   
                ;--{ CRC16 Failure }-----------------------[UEIR, CRC16EF]---
      INT_Source  USB_CRC16_INT, UEIE,CRC16EE, _NoPriority
   
                ;---{ CRC5 Host Error }---------------------[UEIR, CRC5EF]---
      INT_Source  USB_CRC5_INT, UEIE,CRC5EE, _NoPriority
   
                ;---{ Data Field Size Error }---------------[UEIR, DFN8EF]---
      INT_Source  USB_DFN8_INT, UEIE,DFN8EE, _NoPriority
   
                ;----{ PID Check Failure }-------------------[UEIR, PIDEF]---
      INT_Source  USB_PID_INT, UEIE,PIDEE, _NoPriority
  endif


	ENDASM?


	ASM?
  ; -- Ethernet sources --
  ifdef ETHIF  ;----{ Ethernet Module }----------------------[PIR2, ETHIF]---
      INT_Source  ETH_INT, PIE2,ETHIE, IPR2,ETHIP
   
               ;----{ DMA Interrupt }-------------------------[EIR, DMAIF]---
      INT_Source  ETH_DMA_INT, EIE,DMAIE, _NoPriority
   
               ;----{ Link Status Change }-------------------[EIR, LINKIF]---
      INT_Source  ETH_LINK_INT, EIE,LINKIE, _NoPriority
   
               ;----{ Receive Packet Pending }----------------[EIR, PKTIF]---
      INT_Source  ETH_PKT_INT, EIE,PKTIE, _NoPriority
   
               ;----{ Receive Error }------------------------[EIR, RXERIF]---
      INT_Source  ETH_RXER_INT, EIE,RXERIE, _NoPriority
              
               ;----{ Transmit Error }-----------------------[EIR, TXERIF]---
      INT_Source  ETH_TXER_INT, EIE,TXERIE, _NoPriority
   
               ;----{ Transmit }-------------------------------[EIR, TXIF]---
      INT_Source  ETH_TX_INT, EIE,TXIE, _NoPriority
  endif


	ENDASM?


	ASM?
  ; -- CAN Module --
  ifdef WAKIF  
               ;----{ CAN bus Error }------------------------[PIR3, ERRIF]---
      INT_Source  CAN_ERR_INT, PIE3,ERRIE, IPR3,ERRIP
  
               ;----{ Invalid Received Message }-------------[PIR3, IRXIF]---
      INT_Source  CAN_IRX_INT, PIE3,IRXIE, IPR3,IRXIP
  
               ;----{ Receive Buffer 0 }------Mode 0--------[PIR3, RXB0IF]---
      INT_Source  CAN_RXB0_INT, PIE3,RXB0IE, IPR3,RXB0IP
               ;----{ FIFO Watermark }--------Mode 1, 2---[PIR3, FIFOWMIF]---
      INT_Source  CAN_FIFOWM_INT, PIE3,FIFOWMIE, IPR3,FIFOWMIP
  
               ;----{ Receive Buffer 1 }------Mode 0--------[PIR3, RXB1IF]---
      INT_Source  CAN_RXB1_INT, PIE3,RXB1IE, IPR3,RXB1IP
               ;----{ Any Receive Buffer }----Mode 1, 2-----[PIR3, RXBnIF]---
      INT_Source  CAN_RXBn_INT, PIE3,RXBnIE, IPR3,RXBnIP
  
               ;----{ Transmit Buffer 0 }-------------------[PIR3, TXB0IF]---
      INT_Source  CAN_TXB0_INT, PIE3,TXB0IE, IPR3,TXB0IP
  
               ;----{ Transmit Buffer 1 }-------------------[PIR3, TXB1IF]---
      INT_Source  CAN_TXB1_INT, PIE3,TXB1IE, IPR3,TXB1IP
  
               ;----{ Transmit Buffer 2 }-----Mode 0=-------[PIR3, TXB2IF]---
      INT_Source  CAN_TXB2_INT, PIE3,TXB2IE, IPR3,TXB2IP
               ;----{ Any Transmit Buffer }---Mode 1, 2-----[PIR3, TXBnIF]---
      INT_Source  CAN_TXBn_INT, PIE3,TXBnIE, IPR3,TXBnIP
  
               ;----{ CAN bus Activity Wake-up }-------------[PIR3, WAKIF]---
      INT_Source  CAN_WAKE_INT, PIE3,WAKIE, IPR3,WAKIP
  endif
  
  list
    endm
  list  


	ENDASM?


	ASM?

    ifndef  USE_LOWPRIORITY
INT_ENTRY_L
        retfie
    else
        if (USE_LOWPRIORITY != 1)
INT_ENTRY_L
            retfie
        endif
    endif        


	ENDASM?


	ASM?

asm = 0    ; Assembly language Interrupts
ASM = 0
Asm = 0
pbp = 1    ; Basic language interrupts
PBP = 1
Pbp = 1
YES = 1
yes = 1
Yes = 1
NO = 0
no = 0
No = 0
H equ 'H'  ; High Priority
h equ 'H'
L equ 'L'  ; Low Priority
l equ 'L'

  nolist
  
;_____________________________________________________________________________
SaveFSR  macro  F, Pr
  list
    if (F >= 0) && (F <= 2)
        if (Pr == H) || (Pr == L)
            movff    FSR#v(F)L, fsave#v(F)Pr
            movff    FSR#v(F)H, fsave#v(F)Pr + 1
          nolist
        else
            ERROR "SaveFSR - Invalid Priority"
        endif
    else
        ERROR "SaveFSR - Invalid FSR number"
    endif
    list
  endm


	ENDASM?


	ASM?

RestFSR  macro  F, Pr
  list
    if (F >= 0) && (F <= 2)
        if (Pr == H) || (Pr == L)
            movff    fsave#v(F)Pr , FSR#v(F)L
            movff    fsave#v(F)Pr + 1 , FSR#v(F)H 
          nolist
        else
            ERROR "RestFSR - Invalid Priority"
        endif
    else
        ERROR "RestFSR - Invalid FSR number"
    endif
    list
  endm


	ENDASM?


	ASM?

INT_FINISH_H   macro
  endm


	ENDASM?


	ASM?

INT_CREATE_H  macro
  local OverCREATE
    goto OverCREATE
Priority = H    
INT_ENTRY_H  
    movff   PCLATU, psaveUH
    movff   PCLATH, psaveH
    SaveFSR  0, H
    SaveFSR  1, H
    SaveFSR  2, H
    bsf      _InHPint, 0
List_Start_H
    bcf      _Serviced_H, 0         ; Clear Serviced flag
    clrf  BSR
PREV_BANK = 0
    ifdef INT_LIST_H
        INT_LIST_H                  ; Expand the users list of HP INT handlers
    else
        ifdef INT_LIST
            INT_LIST                ; Expand the 16F Compatible List
        else
            error "INT_CREATE_H - INT_LIST or INT_LIST_H not found"
        endif
    endif
    btfsc    _Serviced_H,0          ; if anything was serviced
    goto     List_Start_H           ; go around, and check again

    ifdef ReEnterHPused             ; was ReEnterPBP-18.bas included
        GetAddress21  INT_EXIT_H, RetAddrH
        L?GOTO   _RestorePBP_H      ; Restore PBP system Vars
    endif

INT_EXIT_H
PREV_BANK = 0
    bcf      _InHPint, 0
    RestFSR  0, H                   ; Restore FSR0, if it was saved?
    RestFSR  1, H                   ; Restore FSR1, if it was saved?
    RestFSR  2, H                   ; Restore FSR2, if it was saved?
    movff    psaveH, PCLATH
    movff    psaveUH, PCLATU
    retfie    FAST                  ; Return from Interrupt
OverCREATE
    bsf   INTCON,GIE, 0             ; Enable High Priority Interrupts
    bsf   INTCON,PEIE, 0            ; Enable Peripheral Interrupts
  endm

;---[Stay compatible with the 14-bit version]---------------------------------
INT_CREATE  macro
    INT_CREATE_H
  endm


	ENDASM?


	ASM?

INT_CREATE_L  macro
  local OverCREATE
    goto OverCREATE
    ifdef USE_LOWPRIORITY
        if (USE_LOWPRIORITY != 1)
       error "'DEFINE USE_LOWPRIORITY 1' required for Low Priority Interrupts"
        endif
    else
       error "'DEFINE USE_LOWPRIORITY 1' required for Low Priority Interrupts"
    endif
Priority = L
INT_ENTRY_L  
    movff   WREG, wsave             ; Wreg
    movff   STATUS, ssave           ; STATUS
    movff   BSR, bsave              ; BSR
    movff   PCLATU, psaveUL
    movff   PCLATH, psaveL
    SaveFSR  0, L                   ; FSR0
    SaveFSR  1, L                   ; FSR1
    SaveFSR  2, L                   ; FSR2
    bcf      _InHPint, 0    
List_Start_L
  clrf  BSR
PREV_BANK = 0
    bcf      _Serviced_L, 0
    ifdef INT_LIST_L
        INT_LIST_L                  ; Expand the users list of HP INT handlers
    else
        error "INT_CREATE_L - INT_LIST_L not defined, can not create"
    endif
    btfsc    _Serviced_L, 0         ; if anything was serviced
    goto     List_Start_L           ; go around, and check again

    ifdef ReEnterLPused             ; was ReEnterPBP-18LP.bas included
        GetAddress21  INT_EXIT_L, RetAddrL
        L?GOTO   _RestorePBP_L      ; Restore PBP system Vars
    endif

INT_EXIT_L
PREV_BANK = 0
    RestFSR  0, L                   ; Restore saved vars
    RestFSR  1, L
    RestFSR  2, L                
    movff   psaveUL, PCLATU
    movff   psaveL, PCLATH
    movff   bsave, BSR              ; BSR
    movff   wsave, WREG             ; WREG
    movff   ssave, STATUS           ; STATUS
    retfie                          ; Return from Interrupt
OverCREATE
    bsf   RCON,IPEN, 0              ; Enable Interrupt Priorities
    bsf   INTCON,GIEL, 0            ; Enable Low Priority Interrupts
  endm


	ENDASM?


	ASM?

;---[Returns the Address of a Label as a Word]--(under 64K)------------------
GetAddress macro Label, Wout
    CHK?RP Wout
    movlw low Label          ; get low byte
    movwf Wout
    movlw High Label         ; get high byte
    movwf Wout + 1
    endm

;---[Returns the Address of a Label as a 3 byte array]---(under/over 64k)-----
GetAddress21 macro Label, Aout
    CHK?RP Aout
    movlw low Label          ; get low byte
    movwf Aout
    movlw high Label         ; get high byte
    movwf Aout + 1
    movlw upper Label        ; get upper byte
    movwf Aout + 2
    endm

;---[find correct bank for a PBP BIT variable]-------------------------------
CHKRP?T  macro reg, bit
        CHK?RP  reg
    endm
    


;---[find Assigned Priority for specified INT Source]------------------------
INT_Count = 0

FindIntPriority  macro IntFlagReg, IntFlagBit
  local LoopCount
    nolist
Pfound = 0
LoopCount = 1
      while LoopCount <= INT_Count
          if  (IntFlagReg == PrList#v(LoopCount)R)
             if (IntFlagBit == PrList#v(LoopCount)B)
  list
Priority =  PrList#v(LoopCount)Priority
Pfound = 1
             endif
          endif
LoopCount += 1
      endw
  endm  


	ENDASM?


	ASM?


;---[Add an Interrupt Source to the user's list of INT Handlers]--------------
INT_Handler  macro  IntFlagReg, IntFlagBit, Label, Type, Reset
  list
    local AfterSave, AfterUser, NoInt
INT_Count += 1
PrList#v(INT_Count)R = IntFlagReg
PrList#v(INT_Count)B = IntFlagBit
PrList#v(INT_Count)Priority = Priority
        GetIntInfo   IntFlagReg, IntFlagBit
        if (Found == YES)
            btfss    INT_Enable_Reg, INT_Enable_Bit, 0  ; if INT is enabled
            goto   NoInt
            btfss    INT_Flag_Reg, INT_Flag_Bit, 0      ; and the Flag set?
            goto     NoInt
            if (Priority == H)
                bsf      _Serviced_H, 0
            else
                bsf      _Serviced_L, 0
            endif
            ifdef NO_CLRWDT
                if  (NO_CLRWDT != 1)
                    CLRWDT
                endif
            else
                CLRWDT
            endif
                
            if (Type == PBP)                         ; If INT handler is PBP
              if (Priority == H)
                ifdef ReEnterHPused
                    GetAddress21  AfterSave, RetAddrH  
                    L?GOTO  _SavePBP_H        ; Save PBP system Vars in HP INT
                else
    error "ReEnterPBP-18 must be INCLUDEd to use High Priority PBP interrupts"
                endif
              else ; Priority = L
                ifdef ReEnterLPused
                    GetAddress21  AfterSave, RetAddrL  
                    L?GOTO  _SavePBP_L        ; Save PBP system Vars in LP INT
                else
   error "ReEnterPBP-18LP must be INCLUDEd to use Low Priority PBP interrupts"
                endif
              endif
            endif
AfterSave
PREV_BANK = 0
            if (Priority == H)
                  GetAddress21  AfterUser, RetAddrH  
            else ; Priority = L
                  GetAddress21  AfterUser, RetAddrL
            endif  
            L?GOTO   Label                        ; goto the users INT handler
                    
AfterUser
PREV_BANK = 0
            if (Reset == YES)                      ; reset flag (if specified)
                bcf      INT_Flag_Reg, INT_Flag_Bit, 0 
            endif
        else
            error Interrupt Source (IntFlagReg,IntFlagBit) not found
        endif
NoInt
    clrf  BSR
PREV_BANK = 0
    endm


	ENDASM?


	ASM?

;---[Returns from a "goto" subroutine]--(21-bit RetAddr? must be set first)---
INT_RETURN  macro
  local Ret2LP, Ret2HP
      btfsc   _InHPint, 0
      goto    Ret2HP
Ret2LP
      movff   RetAddrL + 2, PCLATU  ; Load PC buffers with return address
      movff   RetAddrL + 1, PCLATH
      movf    RetAddrL, W, 0
    clrf  BSR                    ; Set to BANK0 before returning
PREV_BANK = 0                    ; Tell PBP about the BANK change
      movwf   PCL, 0             ; Go back to where we were
      
Ret2HP       
      movff   RetAddrH + 2, PCLATU ; Load PC buffers with return address
      movff   RetAddrH + 1, PCLATH
      movf    RetAddrH, W, 0
    clrf  BSR                    ; Set to BANK0 before returning
PREV_BANK = 0                    ; Tell PBP about the BANK change
      movwf   PCL, 0             ; Go back to where we were
    endm    
    
;---[Enable an interrupt source]----------------------------------------------
INT_ENABLE  macro  IntFlagReg, IntFlagBit
      GetIntInfo   IntFlagReg, IntFlagBit
      if (Found == YES)
          FindIntPriority  IntFlagReg, IntFlagBit
          if (Pfound == 1)
              if (INT_Priority_Reg != -1)
                  if (Priority == H)
                      bsf  INT_Priority_Reg, INT_Priority_Bit, 0
                  else
                      if (Priority == L)
                          bcf  INT_Priority_Reg, INT_Priority_Bit, 0
                      else
                          error "INT_ENABLE - Invalid Priority Specified"
                      endif
                  endif
              else
                  if (Priority == L)
                      error "INT0_INT can NOT be assigned to Low Priority"
                  endif
              endif
          else
              error "INT_ENABLE - Priority State Not Found"
          endif
;          bcf     INT_Flag_Reg, INT_Flag_Bit, 0        ; clear the flag first 
          bsf     INT_Enable_Reg, INT_Enable_Bit, 0    ; enable the INT source  
      else
          error  "INT_ENABLE - Interrupt Source not found!"
      endif
    endm    

;---[Disable an interrupt source]---------------------------------------------
INT_DISABLE  macro  IntFlagReg, IntFlagBit
      GetIntInfo   IntFlagReg, IntFlagBit
      if (Found == YES)
          bcf     INT_Enable_Reg, INT_Enable_Bit, 0   ; disable the INT source  
      else
          error "INT_DISABLE - Interrupt Source not found!"
      endif
    endm    

;---[Clear an interrupt Flag]-------------------------------------------------
INT_CLEAR  macro  IntFlagReg, IntFlagBit
      GetIntInfo   IntFlagReg, IntFlagBit
      if (Found == YES)
          bcf     INT_Flag_Reg, INT_Flag_Bit, 0       ; clear the INT flag
      else
          error "INT_CLEAR -  Interrupt Source not found!"
      endif
    endm



	ENDASM?


	ASM?

Save_TBLPTR = 0

    ifdef SIN_USED
Save_TBLPTR = 1
    endif
    ifdef DTMFOUT_USED
Save_TBLPTR = 1
    endif
    ifdef SERDELAY_USED
Save_TBLPTR = 1
    endif
    ifdef CONVBIT_USED
Save_TBLPTR = 1
    endif
    ifdef ERASECODE_USED
Save_TBLPTR = 1
    endif
    ifdef READCODE_USED
Save_TBLPTR = 1
    endif
    ifdef WRITECODE_USED
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?BCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?BCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?BCLW
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?CCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?CCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?CCLW
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?WCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?WCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?WCLW
Save_TBLPTR = 1
    endif
    ifdef LOOK2_USED 
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?BCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?BCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?BCLW
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?CCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?CCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?CCLW
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?TCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?TCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?TCLW
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?WCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?WCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?WCLW
Save_TBLPTR = 1
    endif


	ENDASM?


	LABEL?L	_OVER_DT_INTS_18	
	DENABLE?	
	DDISABLE?	
	MOVE?CT	000h, _VarsSaved_H
	GOTO?L	_OverReEnterH

	LABEL?L	_SavePBP_H	
	CMPNE?TCL	_VarsSaved_H, 000h, L00002
	MOVE?WW	R0, _R0_SaveH
	MOVE?WW	R1, _R1_SaveH
	MOVE?WW	R2, _R2_SaveH
	MOVE?WW	R3, _R3_SaveH

	ASM?

        if (PBPLongs_Used == 1)
            MOVE?WW  R0+2, _R0_SaveH+2
            MOVE?WW  R1+2, _R1_SaveH+2
            MOVE?WW  R2+2, _R2_SaveH+2
            MOVE?WW  R3+2, _R3_SaveH+2
        endif
    

	ENDASM?

	MOVE?WW	R4, _R4_SaveH
	MOVE?WW	R5, _R5_SaveH
	MOVE?WW	R6, _R6_SaveH
	MOVE?WW	R7, _R7_SaveH
	MOVE?WW	R8, _R8_SaveH
	MOVE?BB	FLAGS, _Flags_SaveH
	MOVE?BB	GOP, _GOP_SaveH
	MOVE?BB	RM1, _RM1_SaveH
	MOVE?BB	RM2, _RM2_SaveH
	MOVE?BB	RR1, _RR1_SaveH
	MOVE?BB	RR2, _RR2_SaveH

	ASM?
 if Save_TBLPTR == 1

	ENDASM?

	MOVE?BB	TBLPTRU, _TBLPTRU_SaveH
	MOVE?BB	TBLPTRH, _TBLPTRH_SaveH
	MOVE?BB	TBLPTRL, _TBLPTRL_SaveH

	ASM?
 endif

	ENDASM?


	ASM?

        ifdef RS1
            MOVE?BB    RS1, _RS1_SaveH
        endif
        ifdef RS2
            MOVE?BB    RS2, _RS2_SaveH
        endif
        ifdef MUL_USED
            MOVE?WW    PRODL, _Product_H
        endif
        ifdef T1
            MOVE?WW    T1, _T1_SaveH
            if (PBPLongs_Used == 1)
                MOVE?WW  T1+2, _T1_SaveH+2
            endif
        endif
        ifdef T2
            MOVE?WW    T2, _T2_SaveH
            if (PBPLongs_Used == 1)
                MOVE?WW  T2+2, _T2_SaveH+2
            endif
        endif
        ifdef T3
            MOVE?WW    T3, _T3_SaveH
            if (PBPLongs_Used == 1)
                MOVE?WW  T3+2, _T3_SaveH+2
            endif
        endif
        ifdef T4
            MOVE?WW    T4, _T4_SaveH
            if (PBPLongs_Used == 1)
                MOVE?WW  T4+2, _T4_SaveH+2
            endif
        endif
        ifdef T5
            MOVE?WW    T5, _T5_SaveH
            if (PBPLongs_Used == 1)
                MOVE?WW  T5+2, _T5_SaveH+2
            endif
        endif
        ifdef T6
            MOVE?WW    T6, _T6_SaveH
            if (PBPLongs_Used == 1)
                MOVE?WW  T6+2, _T6_SaveH+2
            endif
        endif
        ifdef T7
            MOVE?WW    T7, _T7_SaveH
            if (PBPLongs_Used == 1)
                MOVE?WW  T7+2, _T7_SaveH+2
            endif
        endif
    

	ENDASM?

	MOVE?CT	001h, _VarsSaved_H
	LABEL?L	L00002	

	ASM?
 INT_RETURN

	ENDASM?


	LABEL?L	_RestorePBP_H	
	CMPNE?TCL	_VarsSaved_H, 001h, L00004
	MOVE?WW	_R0_SaveH, R0
	MOVE?WW	_R1_SaveH, R1
	MOVE?WW	_R2_SaveH, R2
	MOVE?WW	_R3_SaveH, R3

	ASM?

        if (PBPLongs_Used == 1)
            MOVE?WW  _R0_SaveH+2, R0+2
            MOVE?WW  _R1_SaveH+2, R1+2 
            MOVE?WW  _R2_SaveH+2, R2+2 
            MOVE?WW  _R3_SaveH+2, R3+2 
        endif
    

	ENDASM?

	MOVE?WW	_R4_SaveH, R4
	MOVE?WW	_R5_SaveH, R5
	MOVE?WW	_R6_SaveH, R6
	MOVE?WW	_R7_SaveH, R7
	MOVE?WW	_R8_SaveH, R8
	MOVE?BB	_Flags_SaveH, FLAGS
	MOVE?BB	_GOP_SaveH, GOP
	MOVE?BB	_RM1_SaveH, RM1
	MOVE?BB	_RM2_SaveH, RM2
	MOVE?BB	_RR1_SaveH, RR1
	MOVE?BB	_RR2_SaveH, RR2

	ASM?
 if Save_TBLPTR == 1

	ENDASM?

	MOVE?BB	_TBLPTRU_SaveH, TBLPTRU
	MOVE?BB	_TBLPTRH_SaveH, TBLPTRH
	MOVE?BB	_TBLPTRL_SaveH, TBLPTRL

	ASM?
 endif

	ENDASM?


	ASM?

        ifdef RS1
            MOVE?BB    _RS1_SaveH, RS1
        endif
        ifdef RS2
            MOVE?BB    _RS2_SaveH, RS2
        endif
        ifdef MUL
            MOVE?WW    _Product_H, PRODL
        endif
        ifdef T1
            MOVE?WW    _T1_SaveH, T1
            if (PBPLongs_Used == 1)
                MOVE?WW  _T1_SaveH+2, T1+2 
            endif
        endif
        ifdef T2
            MOVE?WW    _T2_SaveH, T2
            if (PBPLongs_Used == 1)
                MOVE?WW  _T2_SaveH+2, T2+2 
            endif
        endif
        ifdef T3
            MOVE?WW    _T3_SaveH, T3
            if (PBPLongs_Used == 1)
                MOVE?WW  _T3_SaveH+2, T3+2 
            endif
        endif
        ifdef T4
            MOVE?WW    _T4_SaveH, T4
            if (PBPLongs_Used == 1)
                MOVE?WW  _T4_SaveH+2, T4+2 
            endif
        endif
        ifdef T5
            MOVE?WW    _T5_SaveH, T5
            if (PBPLongs_Used == 1)
                MOVE?WW  _T5_SaveH+2, T5+2 
            endif
        endif
        ifdef T6
            MOVE?WW    _T6_SaveH, T6
            if (PBPLongs_Used == 1)
                MOVE?WW  _T6_SaveH+2, T6+2 
            endif
        endif
        ifdef T7
            MOVE?WW    _T7_SaveH, T7
            if (PBPLongs_Used == 1)
                MOVE?WW  _T7_SaveH+2, T7+2 
            endif
        endif
        ifdef T8
            ifndef NO_T7_WARNING
                messg "Temp variables exceeding T7"
            endif
        endif
    

	ENDASM?

	MOVE?CT	000h, _VarsSaved_H
	LABEL?L	L00004	

	ASM?
 INT_RETURN

	ENDASM?


	LABEL?L	_OverReEnterH	
	DENABLE?	

	ASM?

INT_LIST  macro    ; IntSource,        Label,  Type, ResetFlag?
        INT_Handler    INT_INT,  _SendString,   PBP,  yes
    endm
    INT_CREATE                  ; Creates the interrupt processor


	ENDASM?


	ASM?
   INT_ENABLE   INT_INT        ; enable external (INT) interrupts

	ENDASM?

	MOVE?CB	000h, PORTC
	MOVE?CB	000h, TRISC
	MOVE?CB	0FFh, TRISA
	MOVE?CB	001h, ADCON0
	MOVE?CB	00Dh, ADCON1
	MOVE?CB	096h, ADCON2
	MOVE?CB	00Ch, CCP1CON
	MOVE?CB	00Ch, CCP2CON
	MOVE?CB	0F9h, PR2
	MOVE?CB	005h, T2CON
	MOVE?CB	014h, UCFG
	MOVE?CB	0A0h, INTCON
	MOVE?CB	080h, T0CON
	MOVE?CB	055h, _String1
	MOVE?CB	053h, _String1 + 00001h
	MOVE?CB	042h, _String1 + 00002h
	MOVE?CB	020h, _String1 + 00003h
	MOVE?CB	044h, _String1 + 00004h
	MOVE?CB	045h, _String1 + 00005h
	MOVE?CB	04Dh, _String1 + 00006h
	MOVE?CB	04Fh, _String1 + 00007h

	ASM?
ADRead = ADRESL                 ; use to read both ADCs register in one shot

	ENDASM?


	ASM?
Duty1=_USBBufferIn+1            ; use to read both Duty bytes from specifics

	ENDASM?


	ASM?
Duty2=_USBBufferIn+3            ;     USBBufferIn locations in one shot

	ENDASM?

	GOTO?L	_SwHwInit

	ASM?
 
Reload_TMR0 macro
    ;   Use to stop, reload, clear overflow flag and restart TMR0
    BCF     _TMR0ON         ; stop timer
    MOVE?CW d'65000',TMR0L  ; reload for timebase ~100uSec
    BCF     _TMR0IF         ; clear overflow flag
    BSF     _TMR0ON         ; start timer
    ENDM

SendUSB macro array
    ;   Use to Copy an specific array to USBBufferOut AND send it
    ;   to USB bus
    variable i=0
    while i<8
        MOVE?BB (array+i),(_USBBufferOut+i)
i+=1
    endw
    L?CALL _DoUSBOut
    endm
    

	ENDASM?


	LABEL?L	_SwHwInit	
	PAUSE?C	001F4h
	USBINIT?	

	ASM?
   Reload_TMR0             ; Reload timer0

	ENDASM?

	ONINT?LL	_DoUSBService, L00001

	LABEL?L	_Start	
	ICALL?L	L00001
	MOVE?CB	000h, PORTB
	ICALL?L	L00001
	XOR?TCT	_ADCON0??2, 001h, _ADCON0??2
	ICALL?L	L00001
	PAUSEUS?C	00Ah
	ICALL?L	L00001
	MOVE?CT	001h, _GoDone
	ICALL?L	L00001
	LABEL?L	L00006	
	CMPF?TL	_GoDone, L00007
	ICALL?L	L00001
	GOTO?L	L00006
	LABEL?L	L00007	
	ICALL?L	L00001
	SHIFTR?WCW	ADRead, 002h, T1
	AIN?WBT	T1, _DataToSend, _ADCON0??2
	ICALL?L	L00001
	MOVE?TB	_PORTA??2, _DataToSend + 00002h
	ICALL?L	L00001
	MOVE?TB	_PORTA??3, _DataToSend + 00003h
	ICALL?L	L00001
	MOVE?TB	_PORTA??4, _DataToSend + 00004h
	ICALL?L	L00001
	MOVE?TB	_PORTA??5, _DataToSend + 00005h
	ICALL?L	L00001
	MOVE?CB	000h, _DataToSend + 00006h
	ICALL?L	L00001
	MOVE?CB	000h, _DataToSend + 00007h

	ASM?
   SendUSB _DataToSend 

	ENDASM?

	ICALL?L	L00001
	GOSUB?L	_dousbin
	ICALL?L	L00001
	GOTO?L	_Start

	LABEL?L	_dousbin	
	ICALL?L	L00001
	MOVE?CT	000h, _TMR0IE
	ICALL?L	L00001
	MOVE?CB	_USBBufferSizeRX, _USBBufferCount
	ICALL?L	L00001
	USBSERVICE?	
	ICALL?L	L00001
	USBIN?CBBL	001h, _USBBufferIn, _USBBufferCount, _Timeout

	LABEL?L	_Timeout	

	ASM?
   Reload_TMR0            

	ENDASM?

	ICALL?L	L00001
	MOVE?CT	001h, _TMR0IE
	ICALL?L	L00001
	MOVE?BB	_USBBufferIn, PORTD
	ICALL?L	L00001
	MOVE?TT	_Duty1??1, _CCP1CON??5
	ICALL?L	L00001
	MOVE?TT	_Duty1??0, _CCP1CON??4
	ICALL?L	L00001
	SHIFTR?WCB	Duty1, 002h, CCPR1L
	ICALL?L	L00001
	MOVE?TT	_Duty2??1, _CCP2CON??5
	ICALL?L	L00001
	MOVE?TT	_Duty2??0, _CCP2CON??4
	ICALL?L	L00001
	SHIFTR?WCB	Duty2, 002h, CCPR2L
	ICALL?L	L00001
	RETURN?	

	LABEL?L	_DoUSBOut	
	ICALL?L	L00001
	MOVE?CT	000h, _TMR0IE

	LABEL?L	_WaitPC	
	ICALL?L	L00001
	MOVE?CB	_USBBufferSizeTX, _USBBufferCount
	ICALL?L	L00001
	USBSERVICE?	
	ICALL?L	L00001
	USBOUT?CBBL	001h, _USBBufferOut, _USBBufferCount, _WaitPC

	ASM?
   Reload_TMR0                                     

	ENDASM?

	ICALL?L	L00001
	MOVE?CT	001h, _TMR0IE
	ICALL?L	L00001
	RETURN?	
	DISABLE?	

	LABEL?L	_DoUSBService	
	USBSERVICE?	

	ASM?
   Reload_TMR0 ; reload timer

	ENDASM?

	RESUME?	
	ENABLE?	

	LABEL?L	_SendString	

	ASM?
       SendUSB _String1               

	ENDASM?


	ASM?
 INT_RETURN

	ENDASM?

	ICALL?L	L00001
	END?	

	END
