' USBDEMOdesc.bas
' USB descriptors for mister-e's USBDEMO
' 9/16/08 microEngineering Labs, Inc.

'USBMEMORYADDRESS Con	$400	' USB RAM starts here (set in device header file)
USBMEMORYSIZE	Con	256	' USB RAM size in bytes
USBReservedMemory Var Byte[USBMEMORYSIZE] USBMEMORYADDRESS	' Reserve memory used by USB assembler code

	Goto	hid_desc_end	' Skip over all of the USB assembler code

	Asm

#define USB_EP0_BUFF_SIZE	8	; 8, 16, 32, or 64
#define USB_MAX_NUM_INT		1
#define USB_MAX_EP_NUMBER	1
#define NUM_CONFIGURATIONS	1
#define NUM_INTERFACES		1

#define UCFG_VAL	USB_PULLUP_ENABLE|USB_INTERNAL_TRANSCEIVER|USB_FULL_SPEED|USB_PING_PONG__NO_PING_PONG
;#define UCFG_VAL	USB_PULLUP_ENABLE|USB_INTERNAL_TRANSCEIVER|USB_LOW_SPEED|USB_PING_PONG__NO_PING_PONG

;#define USE_SELF_POWER_SENSE_IO
;#define USE_USB_BUS_SENSE_IO

#define USB_POLLING

; HID
; Endpoints Allocation
#define HID_INTF_ID		0x00
#define HID_EP			1
#define HID_INT_OUT_EP_SIZE	8
#define HID_INT_IN_EP_SIZE	8
#define HID_NUM_OF_DSC		1

	include	"usb_hid.asm"	; Include rest of USB files, starting with HID class code

; ******************************************************************
; This table is polled by the host immediately after USB Reset has been released.
; This table defines the maximum packet size EP0 can take.
; See section 9.6.1 of the Rev 1.0 USB specification.
; These fields are application DEPENDENT. Modify these to meet
; your specifications.
; ******************************************************************
DeviceDescriptor
	retlw	(EndDeviceDescriptor-DeviceDescriptor)/2	; Size of this descriptor in bytes
	retlw	USB_DESCRIPTOR_DEVICE	; DEVICE descriptor type
	retlw	0x10		; USB Spec Release Number in BCD format - 1.10 (low byte)
	retlw	0x01		; (high byte)
	retlw	0x00		; Class Code
	retlw	0x00		; Subclass code
	retlw	0x00		; Protocol code
	retlw	USB_EP0_BUFF_SIZE	; Max packet size for EP0
	retlw	0x81		; Vendor ID (low byte)
	retlw	0x17		; (high byte)
	retlw	0xD0		; Product ID: Jan Axelson demo (low byte)
	retlw	0x07		; (high byte)
	retlw	0x01		; Device release number in BCD format (low byte)
	retlw	0x00		; (high byte)
	retlw	0x01		; Manufacturer string index
	retlw	0x02		; Product string index
	retlw	0x00		; Device serial number string index
	retlw	NUM_CONFIGURATIONS	; Number of possible configurations
EndDeviceDescriptor

; ******************************************************************
; This table is retrieved by the host after the address has been set.
; This table defines the configurations available for the device.
; See section 9.6.2 of the Rev 1.0 USB specification (page 184).
; These fields are application DEPENDENT. 
; Modify these to meet your specifications.
; ******************************************************************
; Configuration pointer table
USB_CD_Ptr
Configs
	db	low Config1, high Config1
	db	upper Config1, 0

; Configuration Descriptor
Config1
	retlw	(Interface1-Config1)/2	; Size of this descriptor in bytes
	retlw	USB_DESCRIPTOR_CONFIGURATION	; CONFIGURATION descriptor type
Config1Len
	retlw	low ((EndConfig1-Config1)/2)	; Total length of data for this cfg
	retlw	high ((EndConfig1-Config1)/2)
	retlw	NUM_INTERFACES	; Number of interfaces in this cfg
	retlw	0x01		; Index value of this configuration
	retlw	0x00		; Configuration string index
	retlw	_DEFAULT|_SELF	; Attributes
	retlw	50		; Max power consumption (2X mA)
Interface1
	retlw	(HIDDescriptor1-Interface1)/2	; Size of this descriptor in bytes
	retlw	USB_DESCRIPTOR_INTERFACE	; INTERFACE descriptor type
	retlw	0x00		; Interface Number
	retlw	0x00		; Alternate Setting Number
	retlw	0x02		; Number of endpoints in this intf
	retlw	HID_INTF	; Class code
	retlw	0x00		; Subclass code
	retlw	0x00		; Protocol code
	retlw	0x00		; Interface string index
HIDDescriptor1
	retlw	(Endpoint1Out-HIDDescriptor1)/2	; Size of this descriptor in bytes
	retlw	DSC_HID		; HID descriptor type
	retlw	0x11		; HID Spec Release Number in BCD format - 1.11 (low byte)
	retlw	0x01		; (high byte)
	retlw	0x00		; Country Code (0x00 for Not supported)
	retlw	HID_NUM_OF_DSC	; Number of class descriptors
	retlw	DSC_RPT		; Report descriptor type (HID)
ReportDescriptor1Len
	retlw	low ((EndReportDescriptor1-ReportDescriptor1)/2)
	retlw	high ((EndReportDescriptor1-ReportDescriptor1)/2)
Endpoint1Out
	retlw	(Endpoint1In-Endpoint1Out)/2		; Size of this descriptor in bytes
	retlw	USB_DESCRIPTOR_ENDPOINT	; ENDPOINT descriptor type
	retlw	HID_EP|_EP_OUT	; Endpoint Address
	retlw	_INT		; Attributes
	retlw	low (HID_INT_OUT_EP_SIZE)	; Size of the endpoint buffer in bytes (low byte)
	retlw	high (HID_INT_OUT_EP_SIZE)	; (high byte)
	retlw	0x0A		; Polling interval (10ms)
Endpoint1In
	retlw	(EndConfig1-Endpoint1In)/2	; Size of this descriptor in bytes
	retlw	USB_DESCRIPTOR_ENDPOINT	; ENDPOINT descriptor type
	retlw	HID_EP|_EP_IN	; Endpoint Address
	retlw	_INT		; Attributes
	retlw	low (HID_INT_IN_EP_SIZE)	; Size of the endpoint buffer in bytes (low byte)
	retlw	high (HID_INT_IN_EP_SIZE)	; (high byte)
	retlw	0x0A		; Polling interval (10ms)
EndConfig1

ReportDescriptor1
        retlw	0x06		; usage page (Vendor Defined)
	retlw	0xA0
        retlw	0xFF
	retlw	0x09		; usage (Vendor Defined)
        retlw	0x01
	retlw	0xA1		; collection (application)
        retlw	0x01
	retlw	0x09		; usage (Vendor Defined)
        retlw	0x02
	retlw	0xA1		; collection (linked)
        retlw	0x00
	retlw	0x06		; usage page (buttons)
        retlw	0xa1
	retlw	0xFF
	retlw	0x09		; usage vendor defined
        retlw	0x03
	retlw	0x09		; usage vendor defined
        retlw	0x04
	retlw	0x15		; logical minimum (-128)
        retlw	0x80
	retlw	0x25		; logical maximum (127)
        retlw	0x7F
	retlw	0x35		; Physical Minimum (0)
        retlw	0x00
	retlw	0x45		; Physical Maximum (255)
        retlw	0xFF
        retlw	0x75		; report size (8) (bits)
	retlw	0x08
        retlw	0x95		; report count (2) (fields)
	retlw	0x08 ; 0x02
        retlw	0x81		; input (Data, Variable, Absolute)
	retlw	0x02
        retlw	0x09		; usage (Vendor Defined)
	retlw	0x05
        retlw	0x09		; useage (Vendor Defined)
	retlw	0x06
	retlw	0x15		; logical minimum (-128)
	retlw	0x80
        retlw	0x25		; logical maximum (127)
	retlw	0x7F
        retlw	0x35		; Physical Minimum (0)
	retlw	0x00
        retlw	0x45		; Physical Maximum (255)
	retlw	0xFF
        retlw	0x75		; report size (8) (bits)
	retlw	0x08
        retlw	0x95		; report Count (2) (fields)
	retlw	0x08 ; 0x02
        retlw	0x91		; Output (Data, Variable, Absolute)
	retlw	0x02
	retlw   0xC0		; end collection
	retlw   0xC0		; end collection
EndReportDescriptor1

; String pointer table
USB_SD_Ptr
Strings
	db	low String0, high String0
	db	upper String0, 0
	db	low String1, high String1
	db	upper String1, 0
	db	low String2, high String2
	db	upper String2, 0

; Language code string descriptor
String0
	retlw   (String1-String0)/2	; Size of this descriptor in bytes
	retlw   USB_DESCRIPTOR_STRING	; STRING descriptor type
	retlw   0x09		; Language ID as defined by MS - 0x0409 (low byte)
	retlw   0x04		; (high byte)

; Manufacturer string descriptor
String1
	retlw   (String2-String1)/2	; Size of this descriptor in bytes
	retlw   USB_DESCRIPTOR_STRING	; STRING descriptor type
        retlw   'M'
        retlw   0x00
        retlw   'i'
        retlw   0x00
        retlw   's'
        retlw   0x00
        retlw   't'
        retlw   0x00
        retlw   'e'
        retlw   0x00
        retlw   'r'
        retlw   0x00
        retlw   ' '
        retlw   0x00
        retlw   'E'
        retlw   0x00

; Product string descriptor
String2
	retlw   (EndStringDescriptors-String2)/2	; Size of this descriptor in bytes
	retlw   USB_DESCRIPTOR_STRING	; STRING descriptor type
        retlw   'U'
        retlw   0x00
        retlw   'S'
        retlw   0x00
        retlw   'B'
        retlw   0x00
        retlw   'D'
        retlw   0x00
        retlw   'e'
        retlw   0x00
        retlw   'm'
        retlw   0x00
        retlw   'o'
        retlw   0x00
EndStringDescriptors

	Endasm

hid_desc_end			' End of skipped over USB assembler code
